#include "lcd_drv.h"

// #include <avr/delay.h>		// hier avr eingefgt

static void lcd_byte( u8 d )
{
  u8 i;

  LCD_CS = 0;
  for( i = 8; i; i-- ){
    LCD_SCK = 0;
    LCD_DI = 0;
    if( d & 0x80 )
      LCD_DI = 1;
    d <<= 1;
    LCD_SCK = 1;
  }
  LCD_CS = 1;
  _delay_us( 45 );			// 45us
}


void lcd_command( u8 d )
{
  LCD_RS = 0;
  lcd_byte( d );
  switch( d ){
    case 1:
    case 2:
    case 3: _delay_ms( 2 );		// wait 2ms
  }
}


void lcd_data( u8 d )
{
  LCD_RS = 1;
  lcd_byte( d );
}


void lcd_text_( u8 *t )
{
  while( *t ){
    lcd_data( *t );
    t++;
  }
}


void lcd_init( void )
{
  LCD_DDR_RS = 1;
  LCD_DDR_DI = 1;
  LCD_DDR_SCK = 1;
  LCD_DDR_CS = 1;
  LCD_CS = 1;
  _delay_ms( 15 );			// wait 15ms

 
#ifdef			EA_DOGM081
  lcd_command( 0x31 );
  lcd_command( 0x1C );
  lcd_command( 0x51 );
  lcd_command( 0x6A );
  lcd_command( 0x74 );
#elif defined		EA_DOGM162
  lcd_command( 0x39 );		
  lcd_command( 0x14 );		//1C	gendert auf 3,3 V gem datasheet
  lcd_command( 0x55 );		//52	gendert auf 3,3 V gem datasheet
  lcd_command( 0x6D );		//69	gendert auf 3,3 V gem datasheet
  lcd_command( 0x78 );		//74	gendert auf 3,3 V gem datasheet
#else
#error No LCD type defined !!!
#endif
  lcd_command( 0x0F );
  lcd_command( 0x01 );
  lcd_command( 0x06 );
  lcd_command( 0x0C );			// on, no cursor, no blink
}


void lcd_pos( u8 line, u8 column )
{
  switch( line ){
    case 1: column += 0x40;
  }
  lcd_command( 0x80 + column );
}

void lcd_clear( void )
{
	lcd_command( 0x01 );	// clear display
	lcd_pos(0,0);			// start position for cursor
}
