.cseg
; ***********************************************************************************************
; Unterroutinen
; ***********************************************************************************************


; -----------------------------------------------------------------------------------------------
; Bitmuster in (blinkmuster) alle 200ms mit (musterbit) abfragen und neu ausgeben:
; -----------------------------------------------------------------------------------------------

LED_MANAGER:	sbrs	blinker,BIT0		; 200ms abgelaufen?
		rjmp	led_m0			; nein...
		sbic	flags,LASTBLINK		; Blinkzhler vorher auf 0?
		ret				; nein
		sbi	flags,LASTBLINK		; Blinkzhler hat von 0->1 gewechselt
;
; 200ms sind abgelaufen, Testposition verschieben:
;
		clc				; 0 fr MS-Bit vorladen
		sbrc	musterbit,BIT0		; Bit0 im alten Muster auf 1?
		sec				; ja, dann 1 ins MS-Bit des neuen Musters einschieben
		ror	musterbit		; Testmuster um eine Position nach rechts schieben
;
; Abfrage des auszugebenden LED-Zustands:
;
		mov	buffer,blinkmuster	; Arbeitskopie des auszugebendes Musters machen
		and	buffer,musterbit	; 1-Bit gefunden?
		brne	led_ein			; ja...
LED_AUS:	cbi	PORTB,ERRORLED		; ja: --> LED ausschalten
		ret
;
LED_EIN:	sbi	PORTB,ERRORLED		; ja: --> LED einschalten
		ret
; -------------
LED_M0:		cbi	flags,LASTBLINK		; letzten Zustand des Blinzhlers merken
		ret



; -----------------------------------------------------------------------------------------------
; Alle 1ms-Timer:
; -----------------------------------------------------------------------------------------------

TIMER1MS:	dec	irq1ms			; 10ms vorbei?
		brne	timer1_end		; nein...
		ldi	irq1ms,10		; 10ms-Zhler auf Anfang setzen
		sbi	flags,TIMER		; 10ms-Marke fr "main" setzen
		rcall	timer10ms		; ...und Timer bearbeiten
; -------------
TIMER1_END:	ret



; -----------------------------------------------------------------------------------------------
; Alle 10ms-Timer:
; -----------------------------------------------------------------------------------------------

TIMER10MS:	decram	tim100			; 100ms abgelaufen?
		brne	timer10_end		; nein...
		ldi	temp,DELAY100MS		; Timer nach Ablauf
		sts	tim100,temp		; ...wieder neu starten
		rcall	timer100ms		; 100ms-Timer bearbeiten
; -------------
TIMER10_END:	ret



; -----------------------------------------------------------------------------------------------
; Alle 100ms-Timer:
; -----------------------------------------------------------------------------------------------

TIMER100MS:	inc	blinker			; durchlaufender Blinkzhler
; -------------
		decram	tim100wait		; allgemeiner Wartezhler
; -------------
		ret



; -----------------------------------------------------------------------------------------------
; Sprungtabelle auslesen Z = (Z + temp)		***Indexgrenzen werden NICHT berprft***
; -----------------------------------------------------------------------------------------------

SELECT:		push	YL
		push	YH
; -------------
		add	ZL,temp			; Index zu Tabellenanfang addieren
		brcc	load			; berlauf-
		inc	ZH			; ...korrektur
LOAD:		lsl	ZL			; Wort-Pointer in
		rol	ZH			; ...Byte-Pointer umwandeln
		lpm	YL,Z+			; L-Byte der Sprungadresse aus Tabelle laden
		lpm	YH,Z			; H-Byte der Sprungadresse aus Tabelle laden
		movw	Z,Y			; ...und ins Z-Register fr  icall  laden
; -------------
		pop	YH
		pop	YL
		ret



; -----------------------------------------------------------------------------------------------
; AD-Wert in (akku1,0) nach 8Bit mit Runden konvertieren:
; -----------------------------------------------------------------------------------------------

CONV10TO8:	lsr	akku1			; AD-Wert
		ror	akku0			; ...von 10 Bit
		lsr	akku1			; ...auf 8 Bit
		ror	akku0			; ...in (akku0) reduieren
		brcc	conv10to8end		; kein Overflow...
		inc	akku0			; runden
		brcc	conv10to8end		; kein Overflow...
		dec	akku0			; Maximum zurck holen
CONV10TO8END:	ret



; -----------------------------------------------------------------------------------------------
; *** DEBUG-Funktion *** Byte in <temp> an PB0 (Pin5 Attiny45) seriell ausgeben:
; -----------------------------------------------------------------------------------------------

PB0OUT:		push	temp
		push	counter
		ldi	counter,8		; Bitzhler
PB0SHIFT:	rol	temp
		brcc	pb0aus
		nop				; Ausgleich fr bcc
		sbi	PORTB,PB0		; Start einer
		cbi	PORTB,PB0		; ...Bitzelle markieren
		sbi	PORTB,PB0		; (2) Bitstart
		rjmp	pb0end			; (2) 1 ausgeben

PB0AUS:		sbi	PORTB,PB0		; (2) Bitstart
		cbi	PORTB,PB0		; (2) 0 ausgeben
		cbi	PORTB,PB0		; (2) Ausgleich
		cbi	PORTB,PB0		; (2) Ausgleich
PB0END:		dec	counter			; alle Bits ausgegeben?
		brne	pb0shift		; nein...
		nop
		nop
		nop
		nop
		cbi	PORTB,PB0		; Ruhezustand setzen
		sbi	PORTB,PB0		; Ende der letzten
		cbi	PORTB,PB0		; ...Bitzelle markieren
		pop	counter
		pop	temp
		ret