;***********************************************************************
;	Macrodefinitionen
;***********************************************************************

.MACRO	PUSHSR
		push	temp		; Hilfsregister retten
		in	temp,SREG	; Statusregister retten!
		push	temp
.ENDMACRO

; --------------------------------------

.MACRO	POPSR
		pop	temp
		out	SREG,temp	; Statusregister zurckladen
		pop	temp		; Hilfsregister zurck laden
.ENDMACRO

; --------------------------------------

.MACRO	ADDI
		subi	@0,-(@1)	; Addition einer Konstanten
.ENDMACRO

; --------------------------------------

.MACRO	EXGW
		push	@0H
		push	@0L
		movw	@0,@1
		pop	@1L
		pop	@1H
.ENDMACRO

; --------------------------------------

.MACRO	LDIW
		ldi	@0L,low(@1)
		ldi	@0H,high(@1)
.ENDMACRO

; --------------------------------------

.MACRO	LDSW
		lds	@0L,(@1)
		lds	@0H,(@1)+1
.ENDMACRO

; --------------------------------------

.MACRO	STSW
		sts	(@0),@1L
		sts	(@0)+1,@1H
.ENDMACRO

; --------------------------------------

.MACRO	ADDW
		add	@0L,@1	
		brcc	exit		; kein berlauf...
		inc	@0H		; Korrektur des H-Bytes
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	CPIW
		cpi	@0H,high(@1)	
		brcs	exit		; Konstante > Wortregister
		brne	exit		; Konstante < Wortregister
		cpi	@0L,low(@1)
EXIT:
.ENDMACRO
; --------------------------------------

.MACRO	INCW
		inc	@0L	
		brne	exit		; kein berlauf
		inc	@0H		; berlaufkorrektur machen
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	DECW
		dec	@0L	
		brne	exit		; kein berlauf
		dec	@0H		; berlaufkorrektur machen
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	INCRAM
		lds	temp,@0		; Byte aus RAM laden
		inc	temp		; ...erhhen
		sts	@0,temp		; ...und zurck speichern
.ENDMACRO

; --------------------------------------

.MACRO	DECRAM
		lds	temp,@0		; Byte aus RAM laden
		tst	temp		; Zhler schon abgelaufen?
		breq	exit		; ja, nichts ndern
		dec	temp		; Zhler vermindern
		sts	@0,temp		; ...und zurck speichern
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	CBRAM
		pushsr			; rette Status, machte (temp) frei
		cli			;; ****	EXKLUSIV
		lds	temp,@0		;;	Byte aus RAM laden
		cbr	temp,@1		;;	lsche Bits
		sts	@0,temp		;;	...und speichere Byte zurck
		popsr			;  ****	EXKLUSIV Ende	
.ENDMACRO

; --------------------------------------

.MACRO	SBRAM
		pushsr			; rette Status, machte (temp) frei
		cli			;; ****	EXKLUSIV
		lds	temp,@0		;;	Byte aus RAM laden
		sbr	temp,@1		;;	setze Bits
		sts	@0,temp		;;	...und speichere Byte zurck
		popsr			;  ****	EXKLUSIV Ende	
.ENDMACRO

; --------------------------------------

.MACRO	XBRAM
		pushsr			; rette Status, machte (temp) frei
		push	buffer		; Hilfsregister zum Bit-Change
		ldi	buffer,@1	; zu ndernde Bist laden
		cli			;; ****	EXKLUSIV
		lds	temp,@0		;;	Byte aus RAM laden
		eor	temp,buffer	;;	ndere Bits
		sts	@0,temp		;;	...und speichere Byte zurck
		pop	buffer		;;	altes Register restaurieren
		popsr			;  ****	EXKLUSIV Ende	
		lds	temp,@0		; Byte erneut aus RAM laden
.ENDMACRO
