.cseg
; ***********************************************************************************************
; Interruptroutinen
; ***********************************************************************************************

; ---------------------------------------------------------------------------------------------
; Systemtakt (1ms):								(@ 8MHz)
; ---------------------------------------------------------------------------------------------

TIM1_COMPA:	pushsr
; -------------
		sei				; Interrupt erlauben
		sbi	ADCSRA,ADSC		; AD-Wandler starten
		rcall	timer1ms		; Timervariablen bearbeiten
; -------------
		popsr
		reti



; ---------------------------------------------------------------------------------------------
; A/D-Ready-Interrupt (alle 1ms):						(@ 8MHz)
; ---------------------------------------------------------------------------------------------

ADC_CONV:	pushsr
		push	const
		push	YL
		push	YH
		push	ZL
		push	ZH

; Interrupt-Service Anfang - - - - - - - - - - - - - - - - - - - - - - - -

		in	akku0,ADCL		;; aktuellen A/D-Wert
		in	akku1,ADCH		;; ...laden
; -------------
		ldiw	Z,(2*ADCJUMP)		;; Sprungtabelle
		lds	temp,adstate		;; AD-Sequenzerzustand laden
		inc	temp			;; ...nchsten
		andi	temp,0b00000001		;; ...Folgezustand
		sts	adstate,temp		;; ...einstellen
		lsl	temp			;; 4 Bytes pro 
		lsl	temp			;; ...Tabelleneintrag
		clr	const			;; ...auf 16Bit erweitern
		add	ZL,temp			;; Zeiger auf Sprungadresse aus
		adc	ZH,const		;; ...dem Index erzeugen
		lpm	YL,Z+			;; lower Byte aus Tabelle laden
		lpm	YH,Z+			;; higher Byte aus Tabelle laden
		lpm	temp,Z			;; nchste ADMUX-Einstellung laden
		movw	Z,Y			;; Sprungadresse laden,
		ijmp				;; ...anspringen und AD-Wert verarbeiten...
; ----------------------------------------------
; gerade: Strommessung (alle 2ms)
; ----------------------------------------------
ADCI:		out	ADMUX,temp		;; nchste Messung: Ausgangsspannung
		rcall	conv10to8		;; (akku1,0) -> 8Bit konvertieren
		lds	temp,adbuffer		;; letztes I-Sample
		add	temp,akku0		;; ...mit neuem Sample
		ror	temp			;; ...mitteln
		sts	adbuffer,temp		;; neues I-Sample speichern
.ifdef	_DEBUG
		rcall	pb0out			;; Stromwert ausgeben
.endif
		rjmp	adc_end
; ----------------------------------------------
; ungerade: Spannungsmessung (alle 2ms)
; ----------------------------------------------
ADCU:		out	ADMUX,temp		;; nchste Messung: Ausgangsstrom
		rcall	conv10to8		;; (akku1,0) -> 8Bit konvertieren
		lds	temp,adbuffer+1		;; letztes U-Sample
		add	temp,akku0		;; ...mit neuem Sample
		ror	temp			;; ...mitteln
		sts	adbuffer+1,temp		;; neues U-Sample speichern

; Interrupt-Service Ende - - - - - - - - - - - - - - - - - - - - - - - - -

ADC_END:	pop	ZH
		pop	ZL
		pop	YH
		pop	YL
		pop	const
		popsr
		reti



; -----------------------------------------------------------------------------------------------
; Sprungvektoren fr den 250us ADC/Timer-Interrupt mit AVCC-Referenz:
; -----------------------------------------------------------------------------------------------

ADCJUMP:	.dw	ADCU, 0b10001011		; (0) U-Wert verarbeiten, next: I-Messung (ADC0-ADC1)  
		.dw	ADCI, 0b10000010		; (1) I-Wert verarbeiten, next: U-Messung ADC2 
