//*****************************************************************************
// Attenuator.c       Hardware: ATtiny85, DAT-31R5A-SN+, 74HC164, SC36-11SYKWA
// Dipl.-Ing. Peter-Christian Carstens 14.11.2016
//*****************************************************************************
#define Taste_down_bm (1 << PB0)
#define Latch_enable_bm (1 << PB1)
#define Taste_up_bm (1 << PB2)
#define Data_bm (1 << PB3)
#define CLK_bm (1 << PB4)
#define F_CPU 8000000
#include <avr/io.h>
#include <avr/eeprom.h>
#include <util/delay.h>
enum{Leerzeichen = 0x00,max_attenuation = 0x3F,Dezimalpunkt = 0x80};
void Seriell_out(uint8_t);
uint8_t EEprom_Zahl EEMEM;
//*****************************************************************************
int main(void)
{
	uint8_t Font[12]={0x7B,0x41,0x5E,0x4F,0x65,0x2F,0x3F,0x63,0x7F,0x6F};//0..9
	uint8_t change_counter = 0;
	uint8_t Wert_alt = 0xFF;
	uint8_t Wert_neu = eeprom_read_byte(&EEprom_Zahl) & max_attenuation;
	DDRB = Latch_enable_bm | Data_bm | CLK_bm; // Diese Portleitungen sind jetzt Output
    while(1)
	{
		uint8_t Taste = (~PINB) & (Taste_up_bm | Taste_down_bm);
		if((Taste == Taste_up_bm)   && (Wert_neu < max_attenuation)) Wert_neu++;
		if((Taste == Taste_down_bm) && (Wert_neu != 0))              Wert_neu--;
		if( Taste == (Taste_up_bm | Taste_down_bm))  Wert_neu = max_attenuation;
		if(Wert_neu != Wert_alt)
		{
			Seriell_out(Wert_neu);                // DAT-31R5A-SN+ aktualisieren
			PORTB |= Latch_enable_bm;
			_delay_us(5);
			PORTB &= ~Latch_enable_bm;            // DAT-31R5A-SN+  aktualisiert
			Seriell_out((Wert_neu < 20)?Leerzeichen:Font[Wert_neu/20]); //  10dB
			Seriell_out(Font[(Wert_neu % 20) / 2]|Dezimalpunkt);        //   1dB
			Seriell_out(Font[(Wert_neu & 0x01)*5]);                     // 0.5dB
			Wert_alt = Wert_neu;
			change_counter = 100;
			_delay_ms(200);
		}
		if(change_counter != 0)
		{
			change_counter--; // runterzhlen von 100 auf 0 dann abspeichern
			if(change_counter == 0) eeprom_write_byte(&EEprom_Zahl,Wert_neu);
		}
		_delay_ms(50);
	}
}
//*****************************************************************************
void Seriell_out(uint8_t Byte) // Ausgabe an DAT-31R5A-SN+ oder 74HC164
{
	for(uint8_t n = 0;n < 8;n++)
	{
		if(Byte & 0x80) PORTB |= Data_bm; else PORTB &= ~Data_bm;
		_delay_us(5);
		PORTB |= CLK_bm;
		_delay_us(5);
		PORTB &= ~CLK_bm;
		Byte <<= 1;
	}
}
//********************    F        I        N    ******************************
