
;**************************************************************************
;*                    LED Strip driver with IR control                    *
;**************************************************************************
;**************************************************************************
;*          v 1.14 - 01.11.2015                                           *
;*                                                                        *
;**************************************************************************
;*          Hardw.: PIC16F1829 used                                       *
;*          OSC.......: Internal osc. used     POWER.....:   5V extern.   *
;**************************************************************************


 INCLUDE "P16F1829.INC"



_U001			     EQU     B'00100110000100'		;see Page 48 of Datasheet
_U002			     EQU     B'01100011111111'		;see Page 49 of Datasheet


	__CONFIG	_CONFIG1, _U001
	__CONFIG	_CONFIG2, _U002



;==========================================================================
;       Variable Definition
;==========================================================================
TIMER1		EQU	H'20'		;delay routine
TIMER2		EQU	H'21'		; "	"	"

v_ttt		EQU	H'22'
v_cnt1		EQU	H'23'
v_cnt2		EQU	H'24'
kbd_buffer	EQU	H'25'
v_tst1		EQU	H'26'
v_tst2		EQU	H'27'
v_tst3		EQU	H'28'
disp_pos	EQU	H'29'

v_ir_bit	EQU	H'2A'
v_itimer1	EQU	H'2B'
v_itimer2	EQU	H'2C'
v_ir_tmp	EQU	H'2D'
v_ir_new	EQU	H'2E'
v_ir_byte	EQU	H'2F'

v_ir_byte1	EQU	H'30'
v_ir_byte2	EQU	H'31'
v_ir_byte3	EQU	H'32'
v_ir_byte4	EQU	H'33'
v_ir_byte5	EQU	H'34'
v_ir_byte6	EQU	H'35'
v_ir_byte7	EQU	H'36'
v_ir_byte8	EQU	H'37'

v_ir_byte1_s	EQU	H'38'
v_ir_byte2_s	EQU	H'39'
v_ir_byte3_s	EQU	H'3A'
v_ir_byte4_s	EQU	H'3B'
v_ir_byte5_s	EQU	H'3C'
v_ir_byte6_s	EQU	H'3D'
v_ir_byte7_s	EQU	H'3E'
v_ir_byte8_s	EQU	H'3F'

v_ph1d_m	EQU	H'40'
v_ph1d_l	EQU	H'41'
v_ph2d_m	EQU	H'42'
v_ph2d_l	EQU	H'43'

;--------------------------------------------------------------------------
v_ir_code	EQU	H'44'		;selected IR-code (pulse width)

	;01 = Philips RC6
	;02 = Sharp
;--------------------------------------------------------------------------

v_stage		EQU	H'45'

v_poti_1	EQU	H'46'		;Blue   / AN0 = RA0
v_poti_2	EQU	H'47'		;Red    / AN1 = RA1
v_poti_3	EQU	H'48'		;Green  / AN3 = RA4
v_mode		EQU	H'49'		;Mode Selection - Poti on AN6 = RC2

c_tmp		EQU	H'4A'
v_loop_cnt	EQU	H'4B'
;--------------------------------------------------------------------------
;==========================================================================

		ORG	0		;Reset vector address
		GOTO	init_main	;goto RESET routine when boot.

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;
;	       **********************************
;              **  RESET :  main boot routine  **
;              **********************************
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; initialization
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

init_main	nop

		clrf	BSR
;
		clrf	INTCON		;disable interrupts

		banksel	OPTION_REG	;BANK 1
		movlw	B'00111111'
		movwf	OPTION_REG	;see datasheet Page 176

		movlw	H'03'
		movwf	BSR		;select BANK 3
		clrf	ANSELA
		clrf	ANSELB

		movlw	H'01'
		movwf	BSR		;select BANK 1
		movlw	B'11111111'
		movwf	TRISA

		movlw	B'11111111'
		movwf	TRISB
		movwf	TRISC

		movf	OSCCON,0
		andlw	B'11111111'
		iorlw	B'01111000'
		movwf	OSCCON		;set 16MHz internal clock (bit 6:3 = 1111) - Datasheet Page 68

		movlw	H'04'
		movwf	BSR		;select BANK 4
		movlw	B'11101100'
		movwf	WPUA		;enable weak pull-ups
		movwf	WPUB		;enable weak pull-ups

		clrf	BSR		;select BANK 0

		clrf	PORTA
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

		clrf	INTCON

		clrf	v_mode

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;                      Set-up PWM & A/D conversion
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

		nop

;---------------------------------------------------------------------------
;PWM set-up
;set-up PWM1 (output = RC5) for Blue channel
;set-up PWM2 (output = RC3) for Red channel

;1. disable output
		banksel	TRISC
		bsf	TRISC,D'005'		;Blue  - CCP1
		bsf	TRISC,D'003'		;Red   - CCP2
		bsf	TRISC,D'006'		;Green - CCP4

;2 set-up PRx register
		banksel	PR2
		movlw	H'FF'
		movwf	PR2

		banksel	T2CON
		movlw	B'0000111'
		movwf	T2CON		;prescaler = 1 --> see Page 190 of the Datasheet
					;PWM Frequency = 15.625 kHz @ 16MHz internal clock


;3 set-up CCP1CON
		banksel	CCP1CON
		movlw	B'00001100'
		movwf	CCP1CON
		movwf	CCP2CON

		banksel CCP4CON
		movwf	CCP4CON

;4 set-up duty cycle
		bcf	CCP1CON,D'005'		;LSb of duty cycle
		bcf	CCP1CON,D'004'		;LSb2 of duty cycle
		bcf	CCP2CON,D'005'		;LSb of duty cycle
		bcf	CCP2CON,D'004'		;LSb2 of duty cycle
		movlw	B'10000000'		;Duty cycle = 50%
		movwf	CCPR1L			;Duty cycle = 50%
		movwf	CCPR2L			;Duty cycle = 50%

		banksel	CCPR4L
		movwf	CCPR4L
		bcf	CCP4CON,D'005'		;LSb of duty cycle
		bcf	CCP4CON,D'004'		;LSb2 of duty cycle

;5 select timer as an input for PWM
		banksel	CCPTMRS
		movlw	B'00000000'
		movwf	CCPTMRS			;for all PWMs the TIMER2 is selected (see Page 225 of the Datasheet)

;6. clear PIR1 register
		banksel	PIR1
		clrf	PIR1

;7. enable output
		banksel	TRISC
		bcf	TRISC,D'005'	;enable output
		bcf	TRISC,D'003'	;enable output
		bcf	TRISC,D'006'	;enable output
		clrf	BSR		;select bank 0
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;set-up the A/D converter module
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
		banksel	TRISA
		bsf	TRISA,D'000'
		bsf	TRISA,D'001'
;
		banksel	ANSELA
		bsf	ANSELA,D'000'
		bsf	ANSELA,D'001'
		bsf	ANSELA,D'004'
		bsf	ANSELC,D'002'
;
		banksel	ADCON0
		movlw	B'00000001'
;			CHS<4:0>  = 00000 --> AN0 (= RA0)
;			GO        = 0     --> no start now
;			ADON      = 1     --> switch the module ON
		movwf	ADCON0
;-----------------------------------------
		movlw	B'00010000'
;			ADFM      = 0   --> result is left justified
;			ADCS<2:0> = 001 --> A/D Conversion Clock = FOSC/8
;			ADNREF    = 0   --> Vref- = Vss
;			ADPREF    = 00  --> Vref- = Vdd
		movwf	ADCON1
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;                      Main Loop
;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
main_loop	clrf	BSR

		call	read_mode

		movf	v_mode,0
		xorlw	H'00'
		btfsc	STATUS,Z
		goto	m_mode_0		;manual

		movf	v_mode,0
		xorlw	H'10'
		btfsc	STATUS,Z
		goto	m_mode_1

		movf	v_mode,0
		xorlw	H'20'
		btfsc	STATUS,Z
		goto	m_mode_2		;red 50 %

		movf	v_mode,0
		xorlw	H'30'
		btfsc	STATUS,Z
		goto	m_mode_3

		movf	v_mode,0
		xorlw	H'40'
		btfsc	STATUS,Z
		goto	m_mode_4		;green 50 %

		movf	v_mode,0
		xorlw	H'50'
		btfsc	STATUS,Z
		goto	m_mode_5

		movf	v_mode,0
		xorlw	H'60'
		btfsc	STATUS,Z
		goto	m_mode_6		;blue 50 %

;not used mode - eferything off
		clrf	v_poti_1
		clrf	v_poti_2
		clrf	v_poti_3
		call	set_duty_c

		goto	main_loop
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; MODE 0
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
m_mode_0	call	read_poti_1
		call	read_poti_2
		call	read_poti_3

		call	set_duty_c
		call	read_mode
		movf	v_mode,0
		xorlw	H'00'
		btfss	STATUS,Z
		goto	main_loop
		goto	m_mode_0
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; MODE 1
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
m_mode_1	movlw	H'FF'
		movwf	v_poti_1
		movlw	H'FF'
		movwf	v_poti_2
		movlw	H'FF'
		movwf	v_poti_3

		call	set_duty_c
		call	dr2
		call	read_mode
		movf	v_mode,0
		xorlw	H'10'
		btfss	STATUS,Z
		goto	main_loop
		goto	m_mode_1
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; MODE 2 - Red 50%
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
m_mode_2	movlw	H'00'
		movwf	v_poti_1		;Blue
		movlw	H'80'
		movwf	v_poti_2		;Red
		movlw	H'00'
		movwf	v_poti_3		;Green

		call	set_duty_c
		call	d2
		call	read_mode
		movf	v_mode,0
		xorlw	H'20'
		btfss	STATUS,Z
		goto	main_loop

		goto	m_mode_2
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; MODE 3
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
m_mode_3	call	f_get_addr2

		movlw	D'017'
		movwf	v_loop_cnt

mm3_loop	call	f_get_next
		call	set_duty_c
		call	dr2
		call	read_mode
		movf	v_mode,0
		xorlw	H'30'
		btfss	STATUS,Z
		goto	main_loop

		decfsz	v_loop_cnt,1
		goto	mm3_loop

		goto	m_mode_3

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; MODE 4 - Green 50%
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
m_mode_4	movlw	H'00'
		movwf	v_poti_1		;Blue
		movlw	H'00'
		movwf	v_poti_2		;Red
		movlw	H'80'
		movwf	v_poti_3		;Green

		call	set_duty_c
		call	d2
		call	read_mode
		movf	v_mode,0
		xorlw	H'40'
		btfss	STATUS,Z
		goto	main_loop

		goto	m_mode_4
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; MODE 5
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
m_mode_5	call	f_get_addr2

		movlw	D'017'
		movwf	v_loop_cnt

mm5_loop	call	f_get_next
		call	set_duty_c
		call	d2c
		call	read_mode
		movf	v_mode,0
		xorlw	H'50'
		btfss	STATUS,Z
		goto	main_loop

		decfsz	v_loop_cnt,1
		goto	mm5_loop

		goto	m_mode_5
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; MODE 6 - Blue 50%
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
m_mode_6	movlw	H'80'
		movwf	v_poti_1		;Blue
		movlw	H'00'
		movwf	v_poti_2		;Red
		movlw	H'00'
		movwf	v_poti_3		;Green

		call	set_duty_c
		call	d2
		call	read_mode
		movf	v_mode,0
		xorlw	H'60'
		btfss	STATUS,Z
		goto	main_loop

		goto	m_mode_6
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

set_duty_c	clrf	BSR
;set the duty cycle Blue
		movf	v_poti_1,0
		banksel	CCPR1L
		movwf	CCPR1L
		clrf	BSR

;set the duty cycle Red
		movf	v_poti_2,0
		banksel	CCPR2L
		movwf	CCPR2L
		clrf	BSR

;set the duty cycle Green
		movf	v_poti_3,0
		banksel	CCPR4L
		movwf	CCPR4L
		clrf	BSR

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;get the RA0 poti-value
;------------------------------------------------------------------------------
read_poti_1	nop
;----------------------------------------------------------------
		banksel	ADCON0
		movlw	B'00000001'
;			CHS<4:0>  = 00000 --> AN0 (= RA0)
;			GO        = 0     --> no start now
;			ADON      = 1     --> switch the module ON
		movwf	ADCON0
;----------------------------------------------------------------

		clrf	BSR

		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv1	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv1
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	v_poti_1

		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv1b	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv1b
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	v_poti_1

		return
;------------------------------------------------------------------------------
;get the RA1 poti-value
;------------------------------------------------------------------------------
read_poti_2	nop
;----------------------------------------------------------------
		banksel	ADCON0
		movlw	B'00000101'
;			CHS<4:0>  = 00001 --> AN1 (= RA1)
;			GO        = 0     --> no start now
;			ADON      = 1     --> switch the module ON
		movwf	ADCON0
;----------------------------------------------------------------

		clrf	BSR

		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv2	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv2
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	v_poti_2


		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv2b	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv2b
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	v_poti_2

		return
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;get the RA4 poti-value (AN3)
;------------------------------------------------------------------------------
read_poti_3	nop
;----------------------------------------------------------------
		banksel	ADCON0
		movlw	B'00001101'
;			CHS<4:0>  = 00011 --> AN3 (= RA4)
;			GO        = 0     --> no start now
;			ADON      = 1     --> switch the module ON
		movwf	ADCON0
;----------------------------------------------------------------

		clrf	BSR

		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv3	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv3
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	v_poti_3


		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv3b	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv3b
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	v_poti_3

		return
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;get the RC2 poti-value (AN6)
;------------------------------------------------------------------------------
read_mode	nop
;----------------------------------------------------------------
		banksel	ADCON0
		movlw	B'00011001'
;			CHS<4:0>  = 00110 --> AN6 (= RC2)
;			GO        = 0     --> no start now
;			ADON      = 1     --> switch the module ON
		movwf	ADCON0
;----------------------------------------------------------------

		clrf	BSR

		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv4	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv4
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	v_mode


		banksel	ADCON0
		bsf	ADCON0,D'001'		;GO = 1
wait_conv4b	nop
		btfsc	ADCON0,D'001'
		goto	wait_conv4b
		movf	ADRESH,0		;highest 8 bits of the conversion
		clrf	BSR
		movwf	c_tmp

		bcf	c_tmp,D'000'
		bcf	c_tmp,D'001'
		bcf	c_tmp,D'002'
		bcf	c_tmp,D'003'

		movf	c_tmp,0
		movwf	v_mode
;v_mode is now the selected mode:
;	00h	- manual
;	10h 	- Effect 1
;	20h 	- Effect 2
;	others	- off
		return
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; delay routines
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
d2		MOVLW   D'255'
		MOVWF   TIMER2
DEL_LOOP1	MOVLW   D'255'
		MOVWF   TIMER1

DEL_LOOP2	DECFSZ  TIMER1,F
		GOTO    DEL_LOOP2
		DECFSZ  TIMER2,F
		GOTO    DEL_LOOP1
		return
;------------------------------------------------------------------------------
d2c		MOVLW   D'090'
		MOVWF   TIMER2
cDEL_LOOP1	MOVLW   D'255'
		MOVWF   TIMER1

cDEL_LOOP2	DECFSZ  TIMER1,F
		GOTO    cDEL_LOOP2
		DECFSZ  TIMER2,F
		GOTO    cDEL_LOOP1
		return
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

;------------------------------------
dr2		call	d2
		call	d2
		call	d2
		return
;------------------------------------
dr4		call	dr2
		call	dr2
		call	dr2
		return


;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------
f_get_addr2	clrf	BSR
		movlw	LOW c_eff_2
		movwf	FSR1L
		movlw	HIGH c_eff_2
		movwf	FSR1H
		return
;----------------------------------------------------------------------------------------
f_get_next	clrf	BSR
		moviw	FSR1++
		movwf	v_poti_1
		moviw	FSR1++
		movwf	v_poti_2
		moviw	FSR1++
		movwf	v_poti_3

		return
;-----------------------------------------------------------------------------------------
c_eff_2		da	H'80', H'00', H'00'
		da	H'FF', H'00', H'00'
		da	H'80', H'00', H'00'
		da	H'40', H'20', H'00'
		da	H'20', H'40', H'00'
		da	H'00', H'80', H'00'
		da	H'00', H'FF', H'00'
		da	H'00', H'80', H'00'
		da	H'00', H'FF', H'00'
		da	H'00', H'80', H'00'
		da	H'00', H'40', H'20'
		da	H'00', H'20', H'40'
		da	H'00', H'00', H'80'
		da	H'00', H'00', H'FF'
		da	H'00', H'00', H'80'
		da	H'20', H'00', H'40'
		da	H'40', H'00', H'20'
;-----------------------------------------------------------------------------------------
;-----------------------------------------------------------------------------------------


		END