#!/usr/bin/python
import socket, sys

# AA7AS - SdrDx sample TCP client

host = "192.168.1.100"	# IP of server (very likely you need to change this)
port = 58085 			# Default port of SdrDx TCP server

# parse() creates an array that contains from zero
# to n messages and returns that to the caller
# ------------------------------------------------
def parse(msg):
	try:
		msgs = msg.split('|')		# can be more than one message in packet
	except:							# failed to split
		msgs = []					# on the other hand, can just be one. :)
		msgs.append(msg)			# so build array with that one.
	# also possible messages separated by null:
	ms2 = []
	for m in msgs:
		try:
			ms = m.split(chr(0))
		except:
			ms2.append(m)
		else:
			for mm in ms:
				if mm != '':
					ms2.append(mm)
	return ms2						# hand back assembled list

# process() takes a single message, breaks it into cmd
# and data, then deals with the data as appropriate
# ----------------------------------------------------
def process(content):
	cmd,data = m.split(':')
	if cmd == 'closing':
		return 0 # stop right now
	return 1 # keep going

# Create socket
# -------------
try:
	s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
except socket.error, msg:
	sys.stderr.write("[ERROR] %s\n" % msg[1])
	sys.exit(1)

# Attempt to connect to SdrDx's TCP server
# ----------------------------------------
try:
	s.connect((host,port))
except socket.error, msg:
	sys.stderr.write("[ERROR] %s\n" % msg[1])
	sys.exit(2)

s.send("poll:0"+chr(0)) # ask SdrDx for freq, mode

# This is the main program loop, where we watch for messages
# from SdrDx, and optionally send commands to it (see process(),
# above for example of sending a command, it's very easy)
#
# The structure of the system requires that SdrDx be running
# before the client is, so that the TCP server will "be there"
# when the attempt to connect is made.
# ------------------------------------------------------------
data = ''
looping = 1
while looping:
	try:
		data = s.recv(4096)
	except KeyboardInterrupt: # you can safely stop with control-C
		s.send("close:0"+chr(0))
		print '\nclient aborted by user'
		looping = 0 # stop running
		data = '' # prevent any pending data from being handled
	except socket.error, msg: # something went wrong:
		sys.stderr.write("[ERROR] %s\n" % msg[1]) # say so
		looping = 0 # stop running
		data = '' # prevent any pending data from being handled
	ll = len(data) # how much data do we have?
	if ll > 0: # if we have any at all, then:
		msgs = parse(data) # break packets into a list of messages
		if len(msgs): # if we actually got some messages
			counter = 1
			for m in msgs:
				looping = process(m) # do whatever needs to be done
				sys.stdout.write(str(counter)+': '+m+'\n') # log
				sys.stdout.flush() # force print
				counter += 1 # counter for log
s.close() # close the TCP socket, disconnect from server

sys.exit(0) # quit with no error
