#!/usr/bin/python

# AA7AS - Python example for SdrDx UDP commanding
# -----------------------------------------------

from socket import *

port = 58084 		# port we want to send a message to

# Create socket to send with
# --------------------------
s = socket(AF_INET, SOCK_DGRAM)
s.setsockopt(SOL_SOCKET,SO_BROADCAST,1)

# Simple method to send 0-terminated cmd, the idea
# being to abstract the socket and 0-termination
# details away from the process of commanding the app
# ---------------------------------------------------
def sendcmd(cmd):
	global s,port
	s.sendto(cmd + '\0',('<broadcast>',port))

# Send messages
# -------------
sendcmd('mode:0')		# Select AM Demod
sendcmd('gimme:9')	# Tune 540.000 kHz
