#!/usr/bin/perl -w

use Cwd;
use CGI;

# Preinitialisation
my $LogFile     = "example.ADI";
my $CountryFile	= "country.csv";
my $HomeLocator	= "JO40HF";
my $CallSign    = "";
my $CSLog		= "logsearch.log";

my $OldestQSO	= 99999999;
my $LatestQSO	= 0;
my $TotalQSOs	= 0;
my $FoundQSOs	= 0;
my @QSOs;
my @PrefixDB;
my @CountryDB;

# Get callsign, which has to be searched
my $page = new CGI;
if(!($CallSign = $page->param("callsign"))) { $CallSign = ""; }
$CallSign =~ tr/[a-z]/[A-Z]/;      # Change characters to upper case

# Store searched call
my @LocTime  = localtime();
my $Year     = $LocTime[5] + 1900;
my $Month    = $LocTime[4] + 1;
my $TimeDate = sprintf("%02d:%02d:%02d %02d-%02d-%d", $LocTime[2], $LocTime[1], $LocTime[0], $LocTime[3], $Month, $Year);
open(CSLOG_, ">>$CSLog") || die "Content-type: text/plain\n\nERR (logsearch.cgi): Could not open output file '$CSLog'. Please contact the administrator.";
print CSLOG_ "$TimeDate '".$ENV{REMOTE_ADDR}."': Callsign searched: '$CallSign'\n"; 
close(CSLOG_);

if(open(COUNTRYLIST_, "$CountryFile"))
{
	$InputLine = <COUNTRYLIST_>;	# Skip first line
	while(defined($InputLine = <COUNTRYLIST_>))
	{
		my $CurrPrefix    = (split(/;/,$InputLine))[0];
		my $CurrCountry   = (split(/;/,$InputLine))[1];
		my $CurrContinent = (split(/;/,$InputLine))[2];
		push(@PrefixDB,    $CurrPrefix);	# Copy list into memory
		push(@CountryDB,   $CurrCountry);	# Copy list into memory
	}
}
close(COUNTRYLIST_);
	
if(open(LOGLIST_, "$LogFile"))
{
	my %CurrQSO = ( 'Call'=>"",'Name'=>"",'Date'=>"",'Time'=>"",'QTH'=>"",'RSTs'=>"",'RSTr'=>"",'Band'=>"",'Mode'=>"",'Locator'=>"" );
	my $HomeLat = 0;
	my $HomeLon = 0;
	
	Locator2LatLong($HomeLocator, \$HomeLat, \$HomeLon);
	
	while(defined($InputLine = <LOGLIST_>))
	{
		if($InputLine =~ /<call:[0-9]+>/)       {  GetADIFContent("call",       \$CurrQSO{Call}, $InputLine); } 
		if($InputLine =~ /<name:[0-9]+>/)       {  GetADIFContent("name",       \$CurrQSO{Name}, $InputLine); }
        if($InputLine =~ /<qso_date:[0-9]+>/)   {  GetADIFContent("qso_date",   \$CurrQSO{Date}, $InputLine); }
		if($InputLine =~ /<time_on:[0-9]+>/)   	{  GetADIFContent("time_on",    \$CurrQSO{Time}, $InputLine); }
        if($InputLine =~ /<qth:[0-9]+>/)        {  GetADIFContent("qth",        \$CurrQSO{QTH},  $InputLine); }
		if($InputLine =~ /<rst_sent:[0-9]+>/)   {  GetADIFContent("rst_sent",   \$CurrQSO{RSTs}, $InputLine); }
		if($InputLine =~ /<rst_rcvd:[0-9]+>/)   {  GetADIFContent("rst_rcvd",   \$CurrQSO{RSTr}, $InputLine); }
        if($InputLine =~ /<band:[0-9]+>/)       {  GetADIFContent("band",       \$CurrQSO{Band}, $InputLine); }
		if($InputLine =~ /<mode:[0-9]+>/)       {  GetADIFContent("mode",       \$CurrQSO{Mode}, $InputLine); }
        if($InputLine =~ /<gridsquare:[0-9]+>/) 
		{  
			GetADIFContent("gridsquare", \$CurrQSO{Locator}, $InputLine);			
			$TotalQSOs++;
			
			if($CurrQSO{Date} < $OldestQSO) { $OldestQSO = $CurrQSO{Date}; }
			if($CurrQSO{Date} > $LatestQSO) { $LatestQSO = $CurrQSO{Date}; }
			if(($CurrQSO{Call} =~ /$CallSign/) && ($FoundQSOs < 20))	# Find QSOs and limit number
			{
				my $Distance = GetDistance($HomeLat, $HomeLon, $CurrQSO{Locator});
				if($Distance == -1) { $Distance = "N/A"; }

				# Point to corresponding Continent
				my $CurrCountry = "";
				if($#PrefixDB > 0)
				{
					my $j = 0;
					while($j <= $#PrefixDB)
					{
						if($CurrQSO{Call} =~ /^$PrefixDB[$j]/)
						{
							$CurrCountry = $j;
							last;
						}
						$j++;
					}
				}
				
				$FoundQSOs++;
				push(@QSOs, "$CurrQSO{Call}\t$CurrQSO{Name}\t$CurrQSO{Date}\t$CurrQSO{Time}\t$CurrQSO{QTH}\t$CountryDB[$CurrCountry]\t$CurrQSO{RSTs}\t$CurrQSO{RSTr}\t$CurrQSO{Band}\t$CurrQSO{Mode}\t$Distance");		
			}
			
			%CurrQSO = ( 'Call'=>"",'Name'=>"",'Date'=>"",'Time'=>"",'QTH'=>"",'RSTs'=>"",'RSTr'=>"",'Band'=>"",'Mode'=>"",'Locator'=>"" );
		}
	}
	close(LOGLIST_);
}
else { print "Content-type: text/plain\n\nERR (logsearch.cgi): Could not open the logfile. Please contact the administrator"; die; }

# HTML webside
my $D1 = $OldestQSO;
my $D2 = $LatestQSO;
if(length($D1) == 8) { $D1 = substr($D1,6,2)."/".substr($D1,4,2)."/".substr($D1,0,4); }
if(length($D2) == 8) { $D2 = substr($D2,6,2)."/".substr($D2,4,2)."/".substr($D2,0,4); }
print   $page->header(),
        $page->start_html(-title=>"Online Log Search",-bgcolor=>"grey"),
	"<center>\n",
	$page->h1("Online Log Search"),"\n",
	$page->p("Database with <b>$TotalQSOs</b> QSOs from <b>$D1</b> to <b>$D2</b>."),"\n", 
	$page->start_form(-method=>"POST",-action=>"/cgi-bin/logsearch.cgi"),
		"Callsign: ",
		$page->textfield(-name=>"callsign", -default=>""),
		$page->submit(-value=>"Search"),"\n";

if(($CallSign ne "") && ($CallSign =~ /^[A-Z0-9]*$/))
{
	print	$page->h1("Results"),"\n";	
	if($FoundQSOs == 0) { print	$page->p("Sorry, no QSOs found for <b>'$CallSign'</b>."),"\n"; }	
	else
	{	
		print	$page->p("Found $FoundQSOs QSOs for '<b>$CallSign</b>' (maximum result limit: 20 QSOs)."),"\n",
				$page->start_table({-border=>"1",-width=>"1300px"}),"\n",
				$page->TR({-align=>"center", -bgcolor=>"#B5D0D0"},"\n",
					$page->td($page->b("Call")),"\n",
					$page->td($page->b("Name")),"\n",
					$page->td($page->b("Date")),"\n",
					$page->td($page->b("Time UTC")),"\n",
					$page->td($page->b("QTH")),"\n",
					$page->td($page->b("Country")),"\n",
					$page->td($page->b("RSTr")),"\n",
					$page->td($page->b("RSTs")),"\n",
					$page->td($page->b("Band")),"\n",
					$page->td($page->b("Mode")),"\n",
					$page->td($page->b("Distance")),"\n"
				),"\n";			
		for($i=0; $i<$FoundQSOs; $i++)
		{
			my @CurrQSOData = split(/\t/, pop(@QSOs));
			
			#print "$i: @CurrQSOData\n";
			
			# Change date format
			my $D = $CurrQSOData[2];
			if(length($D) == 8) { $D = substr($D,6,2)."/".substr($D,4,2)."/".substr($D,0,4); }
			
			# Change time format
			my $T = $CurrQSOData[3];
			if(length($T) == 4) { $T = substr($T,0,2).":".substr($T,2,2); }
			
			# Change distance format
			my $Distance = $CurrQSOData[10];
			if ($Distance ne "N/A") { $Distance = "$Distance km"; }
			
			print	$page->TR({-align=>"center", -bgcolor=>"#B5D0D0"},"\n",
						$page->td($CurrQSOData[0]),"\n",
						$page->td($CurrQSOData[1]),"\n",
						$page->td($D),"\n",
						$page->td($T),"\n",
						$page->td($CurrQSOData[4]),"\n",
						$page->td($CurrQSOData[5]),"\n",
						$page->td($CurrQSOData[6]),"\n",
						$page->td($CurrQSOData[7]),"\n",
						$page->td($CurrQSOData[8]),"\n",
						$page->td($CurrQSOData[9]),"\n",
						$page->td($Distance),"\n"
					),"\n";
		}
		print	$page->end_table,"\n";
	}
}

print 	"</center>",
	$page->end_html;			

	
# Calculate distance
sub GetDistance
{
	my $Lat1   		= shift;
	my $Lon1   		= shift;
	my $CurrLocator = shift;
	
	my $Radius   = 6371; # km
	my $Lat2     = 0;
	my $Lon2     = 0;
	my $Distance = -1;
		
	if(Locator2LatLong($CurrLocator, \$Lat2, \$Lon2))
	{	
		$Lat1		 = $Lat1/180*3.14159; # To rad
		$Lat2		 = $Lat2/180*3.14159; # To rad
		
		my $dLat     = abs($Lat2-$Lat1)/180*3.14159; # To rad
		my $dLon     = abs($Lon2-$Lon1)/180*3.14159; # To rad
		my $a        = sin($dLat/2) * sin($dLat/2) + sin($dLon/2) * sin($dLon/2) * cos($Lat1) * cos($Lat2); 
		my $b        = 2 * atan2(sqrt($a), sqrt(1-$a));
		
		$Distance = int($Radius * $b);
	}
	
	return($Distance);
}


# Subfunction evaluates the content of the field (Params: Field name, Pointer: Field content, Input line)
sub GetADIFContent
{
  my $FieldName  = shift;  
  my $FieldCont  = shift;  
  my $InLine     = shift;  
  my $ChrNo = 0;

  $ChrNo      = ($InLine =~ /<$FieldName:([0-9]+)>/)[0];
  $$FieldCont = ($InLine =~ /<$FieldName:[0-9]+>([\w\/ ,()?]{$ChrNo})/)[0];
  if(!defined($$FieldCont)) { $$FieldCont = ""; }
}


# Calculation from the qridsquare to the lat and long values ##
sub Locator2LatLong
{
  my $Loc    = shift;
  my $Lat    = shift;
  my $Long   = shift;
  my $RetVal = 0;		# 0: wrong format

  $Loc =~ tr/[a-z]/[A-Z]/;      # Change everything to upper case
  if($Loc =~ /[A-Z][A-Z][0-9][0-9][A-Z][A-Z]/)
  {
    $$Lat   = -90  + 10*(ord(substr($Loc, 1, 1))-65) +   substr($Loc, 3, 1) + (ord(substr($Loc, 5, 1))-65+0.5)/24;
    $$Long  = -180 + 20*(ord(substr($Loc, 0, 1))-65) + 2*substr($Loc, 2, 1) + (ord(substr($Loc, 4, 1))-65+0.5)/12;
    $RetVal = 1;		# 1: correct format
  }

  return ($RetVal);
}
