#!/usr/bin/perl -w

use Cwd;
use CGI;

# Gerenal settings
my $LogFile	    = "example.ADI";
my $CountryFile	= "country.csv";
my $HomeLocator	= "JO40HF";

my $OldestQSO	= 99999999;
my $LatestQSO	= 0;
my @Bands		= ( "160 m","80 m","40 m","30 m","20 m","17 m","15 m","12 m","10 m","6 m","2 m","70 cm");
my @Contacts    = ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @FMMode 		= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @SSBMode 	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @CWMode		= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @OtherModes  = ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiAF  	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiAN  	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiAS  	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiEU  	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiOC  	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiNA  	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiSA  	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @ContiTotal 	= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @MaxDist		= ( 0,0,0,0,0,0,0,0,0,0,0,0 );
my @MostDistLoc	= ( "N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A" );
my @Date		= ( "N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A","N/A" );
my %Total		= ( 'FM'=>0,'SSB'=>0,'CW'=>0,'OTHER'=>0,'QSOs'=>0,'EU'=>0,'NA'=>0,'SA'=>0,'AF'=>0,'AS'=>0,'OC'=>0,'AN'=>0 );
my @PrefixDB;
my @ContinentDB;

if(open(COUNTRYLIST_, "$CurrPath/$CountryFile"))
{
	$InputLine = <COUNTRYLIST_>;	# Skip first line
	while(defined($InputLine = <COUNTRYLIST_>))
	{
		my $CurrPrefix    = (split(/;/,$InputLine))[0];
		my $CurrContinent = (split(/;/,$InputLine))[2];
		push(@PrefixDB,    $CurrPrefix);	# Copy list into memory
		push(@ContinentDB, $CurrContinent);	# Copy list into memory
	}
}
close(COUNTRYLIST_);
	
if(open(LOGLIST_, "$LogFile"))
{
	my %CurrQSO = ( 'Call'=>"",'Date'=>"",'Band'=>"",'Mode'=>"",'Locator'=>"" );
	my $HomeLat = 0;
	my $HomeLon = 0;
	
	Locator2LatLong($HomeLocator, \$HomeLat, \$HomeLon);
	
	while(defined($InputLine = <LOGLIST_>))
	{
		if($InputLine =~ /<call:[0-9]+>/)       	{  GetADIFContent("call",     \$CurrQSO{Call}, $InputLine); } 
        	if($InputLine =~ /<qso_date:[0-9]+>/)   {  GetADIFContent("qso_date", \$CurrQSO{Date}, $InputLine); }
        	if($InputLine =~ /<band:[0-9]+>/)       {  GetADIFContent("band",     \$CurrQSO{Band}, $InputLine); }
		if($InputLine =~ /<mode:[0-9]+>/)       	{  GetADIFContent("mode",     \$CurrQSO{Mode}, $InputLine); }
        	if($InputLine =~ /<gridsquare:[0-9]+>/) 
		{  
			GetADIFContent("gridsquare", \$CurrQSO{Locator}, $InputLine);
			
			# Point to corresponding Continent
			my $CurrConti = -1;
			if($#PrefixDB > 0)
			{
				my $j = 0;
				while($j <= $#PrefixDB)
				{
					if($CurrQSO{Call} =~ /^$PrefixDB[$j]/)
					{
						$CurrConti = $j;
						last;
					}
					$j++;
				}
			}
			
			# Band statistics
			for($i=0; $i<=$#Bands; $i++)
			{
				my $Band = $Bands[$i];
				$Band =~ tr/a-z/A-Z/;
				$Band =~ s/ //;
				if($CurrQSO{Band} =~ /^$Band/)
				{ 
					$Contacts[$i]++; 
					$Total{QSOs}++;
					
					# Modes
					if   ($CurrQSO{Mode} =~ /FM/)  { $FMMode[$i]++;     $Total{FM}++;    }
					elsif($CurrQSO{Mode} =~ /SSB/) { $SSBMode[$i]++;    $Total{SSB}++;   }
					elsif($CurrQSO{Mode} =~ /CW/)  { $CWMode[$i]++;     $Total{CW}++;    }
					else 	    		       { $OtherModes[$i]++; $Total{OTHER}++; }
					
					# Continent
					if($#PrefixDB > 0)
					{
						if($ContinentDB[$CurrConti] =~ /AF/) { $ContiAF[$i]++; $Total{AF}++; }
						if($ContinentDB[$CurrConti] =~ /AN/) { $ContiAN[$i]++; $Total{AN}++; }
						if($ContinentDB[$CurrConti] =~ /AS/) { $ContiAS[$i]++; $Total{AS}++; }
						if($ContinentDB[$CurrConti] =~ /EU/) { $ContiEU[$i]++; $Total{EU}++; }
						if($ContinentDB[$CurrConti] =~ /NA/) { $ContiNA[$i]++; $Total{NA}++; }
						if($ContinentDB[$CurrConti] =~ /OC/) { $ContiOC[$i]++; $Total{OC}++; }
						if($ContinentDB[$CurrConti] =~ /SA/) { $ContiSA[$i]++; $Total{SA}++; }
					}
					
					# Longest Distance
					my $Distance = GetDistance($HomeLat, $HomeLon, $CurrQSO{Locator});
					if($Distance > $MaxDist[$i]) { $MaxDist[$i] = $Distance; $MostDistLoc[$i] = $CurrQSO{Locator}; $Date[$i] = $CurrQSO{Date}; }
				}
				if($CurrQSO{Date} < $OldestQSO) { $OldestQSO = $CurrQSO{Date}; }
				if($CurrQSO{Date} > $LatestQSO) { $LatestQSO = $CurrQSO{Date}; }				
			}
			
			%CurrQSO = ( 'Call'=>"",'Date'=>"",'Band'=>"",'Mode'=>"",'Locator'=>"" );
		}
	}
	close(LOGLIST_);
}
else { print "Content-type: text/plain\n\nERR (loganalysis.cgi): Could not open the logfile. Please contact the administrator"; die; }

# HTML webside
my $page = new CGI;

my $D1 = $OldestQSO;
my $D2 = $LatestQSO;
if(length($D1) == 8) { $D1 = substr($D1,6,2)."/".substr($D1,4,2)."/".substr($D1,0,4); }
if(length($D2) == 8) { $D2 = substr($D2,6,2)."/".substr($D2,4,2)."/".substr($D2,0,4); }
print   $page->header(),
        $page->start_html(-title=>"Log Analysis",-bgcolor=>"grey"),
		"<center>",
		$page->h1("Statistics"),"\n",
		$page->p("The database contains QSOs from <b>$D1</b> to <b>$D2</b>."),"\n",
		$page->start_table({-border=>"1",-width=>"1300px"}),"\n",
		$page->TR({-align=>"center", -bgcolor=>"#B5D0D0"},"\n",
			$page->td($page->b("Band")),"\n",
			$page->td($page->b("FM")),"\n",
			$page->td($page->b("SSB")),"\n",
			$page->td($page->b("CW")),"\n",
			$page->td($page->b("Other modes")),"\n",
			$page->td($page->b("Number of QSOs")),"\n",
			$page->td($page->b("Europe")),"\n",
			$page->td($page->b("North America")),"\n",
			$page->td($page->b("South America")),"\n",
			$page->td($page->b("Africa")),"\n",
			$page->td($page->b("Asia")),"\n",
			$page->td($page->b("Oceania")),"\n",
			$page->td($page->b("Antartica")),"\n",
			$page->td($page->b("Maximum distance")),"\n"
		),"\n";
for($i=0; $i<=$#Bands; $i++)
{
	my $D = $Date[$i];
	if(length($D) == 8) { $D = substr($D,6,2)."/".substr($D,4,2)."/".substr($D,0,4); }
	print	$page->TR({-align=>"center", -bgcolor=>"#B5D0D0"},"\n",
				$page->td($Bands[$i]),"\n",
				$page->td($FMMode[$i]),"\n",
				$page->td($SSBMode[$i]),"\n",
				$page->td($CWMode[$i]),"\n",
				$page->td($OtherModes[$i]),"\n",
				$page->td("$Contacts[$i] (".int($Contacts[$i]/$Total{QSOs}*100)." %)"),"\n",
				$page->td($ContiEU[$i]),"\n",
				$page->td($ContiNA[$i]),"\n",
				$page->td($ContiSA[$i]),"\n",
				$page->td($ContiAF[$i]),"\n",
				$page->td($ContiAS[$i]),"\n",
				$page->td($ContiOC[$i]),"\n",
				$page->td($ContiAN[$i]),"\n",
				$page->td("$MaxDist[$i] km ($HomeLocator < > $MostDistLoc[$i] on $D)"),"\n"
			),"\n";
}
print	$page->TR({-align=>"center", -bgcolor=>"#D0D0B5"},"\n",
			$page->td($page->b("Total:")),"\n",
			$page->td($Total{FM}),"\n",
			$page->td($Total{SSB}),"\n",
			$page->td($Total{CW}),"\n",
			$page->td($Total{OTHER}),"\n",
			$page->td("$Total{QSOs} (100%)"),"\n",
			$page->td($Total{EU}),"\n",
			$page->td($Total{NA}),"\n",
			$page->td($Total{SA}),"\n",
			$page->td($Total{AF}),"\n",
			$page->td($Total{AS}),"\n",
			$page->td($Total{OC}),"\n",
			$page->td($Total{AN}),"\n",
			$page->td("-"),"\n"
		),"\n",
	$page->end_table,"\n";
print   "    </script>";
print $page->end_html;


# Calculate distance
sub GetDistance
{
	my $Lat1   		= shift;
	my $Lon1   		= shift;
	my $CurrLocator = shift;
	
	my $Radius   = 6371; # km
	my $Lat2     = 0;
	my $Lon2     = 0;
	my $Distance = -1;
		
	if(Locator2LatLong($CurrLocator, \$Lat2, \$Lon2))
	{	
		$Lat1		 = $Lat1/180*3.14159; # To rad
		$Lat2		 = $Lat2/180*3.14159; # To rad
		
		my $dLat     = abs($Lat2-$Lat1)/180*3.14159; # To rad
		my $dLon     = abs($Lon2-$Lon1)/180*3.14159; # To rad
		my $a        = sin($dLat/2) * sin($dLat/2) + sin($dLon/2) * sin($dLon/2) * cos($Lat1) * cos($Lat2); 
		my $b        = 2 * atan2(sqrt($a), sqrt(1-$a));
		
		$Distance = int($Radius * $b);
	}
	
	return($Distance);
}


# Subfunction evaluates the content of the field (Params: Field name, Pointer: Field content, Input line)
sub GetADIFContent
{
  my $FieldName  = shift;  
  my $FieldCont  = shift;  
  my $InLine     = shift;  
  my $ChrNo = 0;

  $ChrNo      = ($InLine =~ /<$FieldName:([0-9]+)>/)[0];
  $$FieldCont = ($InLine =~ /<$FieldName:[0-9]+>([\w\/ ,()?]{$ChrNo})/)[0];
  if(!defined($$FieldCont)) { $$FieldCont = ""; }
}


# HTML code for the markers
sub GetMarkersHTML
{
  my $Counter	= shift;
  my $Locator   = shift;
  my $Long		= 0;
  my $Lat		= 0;
  my $MakerHTML = "";

  $Counter++;
  if(Locator2LatLong($Locator,\$Lat,\$Long))
  { 
	  $MarkerHTML =   "      // $Counter: $Locator\n".
					  "      var lonLat = new OpenLayers.LonLat( $Long, $Lat )\n".
					  "        .transform(\n".
					  "           new OpenLayers.Projection(\"EPSG:4326\"),\n".
					  "           map.getProjectionObject()\n".
					  "         );\n".
					  "      markers.addMarker(new OpenLayers.Marker(lonLat));\n\n";
  }

  return($MarkerHTML);
}


# Calculation from the qridsquare to the lat and long values ##
sub Locator2LatLong
{
  my $Loc    = shift;
  my $Lat    = shift;
  my $Long   = shift;
  my $RetVal = 0;		# 0: wrong format

  $Loc =~ tr/[a-z]/[A-Z]/;      # Change everything to upper case
  if($Loc =~ /[A-Z][A-Z][0-9][0-9][A-Z][A-Z]/)
  {
    $$Lat   = -90  + 10*(ord(substr($Loc, 1, 1))-65) +   substr($Loc, 3, 1) + (ord(substr($Loc, 5, 1))-65+0.5)/24;
    $$Long  = -180 + 20*(ord(substr($Loc, 0, 1))-65) + 2*substr($Loc, 2, 1) + (ord(substr($Loc, 4, 1))-65+0.5)/12;
    $RetVal = 1;		# 1: correct format
  }

  return ($RetVal);
}
