package com.de_80m_android_skineffectcalculator;	 

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
 
public class ScinEffectCalculatorActivity extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }

 // Programm zur Berechnung der äquivalenten Skin-Tiefe und des daraus resultierenden Widerstandes
 // eines Rundleiters
    
    public void calculateClickHandler(View view) {
     // Reaktion auf den "Berechnen" Button

     if (view.getId() == R.id.calculateButton) {

      // Referenzzuordnung zu den Widgets
      EditText frequencyText = (EditText)findViewById(R.id.frequencyText);
      EditText diameterText = (EditText)findViewById(R.id.diameterText);
      TextView resultText1 = (TextView)findViewById(R.id.resultLabel1);
      TextView resultText2 = (TextView)findViewById(R.id.resultLabel2);
      TextView resultText3 = (TextView)findViewById(R.id.resultLabel3);
 
      // Einlesen der Eingabewerte von den Widget-Referenzen
      // Umwandlung der Eingabewerte: MHz in Hz und mm in m
      double frequency = 1e6 * Double.parseDouble(frequencyText.getText().toString());
      double diameter = 1e-3 * Double.parseDouble(diameterText.getText().toString());
 
      // Spezifischer Widerstand verschiedener Materialien in Ohm*m
      double resistivityAg = 1.587*1e-8;
      double resistivityCu = 1.678*1e-8;
      double resistivityV4a = 74*1e-8;
      
      // Relative Permeabilität verschiedener Materialien
      double permeabilityAg = 0.999975;
      double permeabilityCu = 0.9999936;
      double permeabilityV4a = 1.008;
      
      
      // Berechnung der Skin-Tiefe für Silber, Kupfer und Edelstahl (V4A)
     
      double skinValueAg = calculateSkin(frequency, resistivityAg, permeabilityAg);
      double skinValueCu = calculateSkin(frequency, resistivityCu, permeabilityCu);
      double skinValueV4a = calculateSkin(frequency, resistivityV4a, permeabilityV4a);
      
      // Der Widerstandsbeleg wird nur berechnet, wenn der Skin-Effekt nennenswert auftritt,
      // d.h wenn die Skin-Tiefe für V4A kleiner ist als der Radius des Rundleiters:
      if (skinValueV4a < diameter/2) {
      
      double resistancePerMeterAg = calculateRes (skinValueAg, diameter, resistivityAg);
      double resistancePerMeterCu = calculateRes (skinValueCu, diameter, resistivityCu);
      double resistancePerMeterV4a = calculateRes (skinValueV4a, diameter, resistivityV4a);
      
      
      // Ergebnisausgabe auf dem Display in den 3 definierten Feldern
      // Die Ausgabe erfolgt in Mikrometer bzw. Millimeter
      if (skinValueAg < 1e-3) {
    	  resultText1.setText("Skin-Tiefe und Widerstand/m:\n\n"+ "Silber (Ag) \n" + ZahlenFormat(skinValueAg*1e6) + " μm   " + ZahlenFormat(resistancePerMeterAg) + " Ohm/m \n"); 
      } else {
          resultText1.setText("Skin-Tiefe und Widerstand/m:\n\n"+ "Silber (Ag) \n" + ZahlenFormat(skinValueAg*1000) + " mm   " + ZahlenFormat(resistancePerMeterAg) + " Ohm/m \n");
      }
      if (skinValueCu < 1e-3) {
    	  resultText2.setText("Kupfer (Cu) \n" + ZahlenFormat(skinValueCu*1e6) + " μm   " + ZahlenFormat(resistancePerMeterCu) + " Ohm/m \n"); 
      } else {
          resultText2.setText("Kupfer (Cu) \n" + ZahlenFormat(skinValueCu*1000) + " mm   " + ZahlenFormat(resistancePerMeterCu) + " Ohm/m \n");
      }
      if (skinValueV4a < 1e-3) {
    	  resultText3.setText("Edelstahl (V4A) \n" + ZahlenFormat(skinValueV4a*1e6) + " μm   " + ZahlenFormat(resistancePerMeterV4a) + " Ohm/m \n"); 
      } else {
          resultText3.setText("Edelstahl (V4A) \n" + ZahlenFormat(skinValueV4a*1000) + " mm   " + ZahlenFormat(resistancePerMeterV4a) + " Ohm/m \n");
      }
     // wenn die Skin-Tiefe in V4A größer ist als der Radius erfolgt keine Ausgabe des Widerstandes
      } else  {
    	  resultText1.setText("Skin-Tiefe in Silber: "+ ZahlenFormat(skinValueAg*1000) + " mm \n");
          resultText2.setText("Skin-Tiefe in Kupfer: "+ ZahlenFormat(skinValueCu*1000) + " mm \n");
          resultText3.setText("Skin-Tiefe in V4A: "+ ZahlenFormat(skinValueV4a*1000) + " mm");
      } 
   // Soft Keybord aus - erforderlich, damit das Soft Keyboard die Ergebnisse nicht abdeckt
      InputMethodManager imm = (InputMethodManager) getSystemService(Activity.INPUT_METHOD_SERVICE);
      imm.toggleSoftInput(InputMethodManager.HIDE_IMPLICIT_ONLY, 0);  
     }
    }
 
	// Formel zur Berechnung der Skin-Tiefe
    // siehe http://en.wikipedia.org/wiki/skin_effect
    private double calculateSkin (double frequencyLocal, double resistivity, double permeability) {
     double permVacuum = 4 * Math.PI * 1e-7; 
     return (Math.sqrt( resistivity / Math.PI / frequencyLocal / permVacuum / permeability));
    }
   
    // Berechnung des Widerstandsbelages in Ohm pro m
    private double calculateRes (double skinDepth, double dia, double resistivity){
    	return (resistivity / ((dia*dia/4) - (dia/2 - skinDepth)*(dia/2 - skinDepth))/Math.PI);
    }
       
    // Formatiert Zahl auf 2 Stellen hinter dem Komma
    private double ZahlenFormat (double Zahl) {
    	 double factor = 1e2; // = 1 * 10^2 = 100
         return Math.round(Zahl * factor) / factor;    		
    }
}

