'PIN-Configuration:
'------------------
'INPUT:
'PC0 = Pin 23 = ADC0 = Poti 0...5V
'PC1 = Pin 24 = Taster "-" mit Pullup eingeschaltet
'PC2 = Pin 25 = Taster "+" mit Pullup eingeschaltet

'OUTPUT:
'PD0...PD7 = Pin 3-6,11-13 = Segmente A-F, "-"-Zeichen
'PB6,PB7   = Pin 9,10      = Common Einer, Common Zehner
'PB0...PB5 = Pin 14-19     = Schaltausgnge 0db,-4dB,-6dB,-12dB,-16dB,-32dB

$regfile = "m168pdef.dat"                                                       'ATMEGA 168P: 16kB Flash, 1kB RAM, 512 Byte EEPROM
$framesize = 64
$swstack = 64
$hwstack = 64
$crystal = 8000000                                                              '8MHz interner RC-Oszillator

$programmer = 1                                                                 'STK-200
$prog &HFF , &HC2 , &HDF , &HF9                                                 ' generated. Take care that the chip supports all fuse bytes.

Config Portd = Output                                                           '7-Segment-Port, D.P.=MSB
Config Portb = Output                                                           'Abschwcher und gemeinsame Anschlsse 7-Segment
Config Portc.1 = Input : Set Portc.1                                            'Pullups einschalten
Config Portc.2 = Input : Set Portc.2                                            'Pullups einschalten

Config Adc = Single , Prescaler = Auto , Reference = Avcc                       '

Config Timer1 = Timer , Prescale = 1                                            '16bit-Timer1 als Interrupt-Timer mit 125Hz fr MPX-Steuerung
On Timer1 Timer1_isr                                                            'Interrupt
Enable Interrupts
Enable Timer1

Dim Adc_value As Word                                                           'ADC-Wert
Dim Switcher As Byte                                                            'Schaltausgnge
Dim Port_b As Byte                                                              'Output-Wert fr Port B
Dim Db_adc As Byte                                                              '
Dim Db_value As Byte
Dim Db_bcd As Byte                                                              'dB-Variable (BCD)
Dim Db_poti_old As Byte                                                         'letzter Poti dB-Wert
Dim Einer As Byte                                                               'Segment-Daten fr Einerstelle dB-Wert
Dim Zehner As Byte                                                              'Segment-Daten fr Zehnerstelle dB-Wert
Dim Segments As Byte
Dim Input_type As Byte                                                          'Input ber Poti (0) oder Taster (1)

'*****************
'*** MAIN-LOOP ***
'*****************
Do

Disable Timer1                                                                  'Timer1-IRQ whrend ADC-Wandlung und Werteberechnung sperren

Adc_value = Getadc(0)                                                           'Hole ADC-Wert

Enable Timer1

Adc_value = Adc_value / 31

If Adc_value = 0 Then                                                           '0dB=berbrckung
   Db_adc = 0
Elseif Adc_value > 31 Then                                                      '66dB
   Db_adc = 66
Else                                                                            'Zwischenwerte
   Adc_value = Adc_value - 1
   Adc_value = Adc_value * 2
   Adc_value = Adc_value + 4
   Db_adc = Low(adc_value)
End If

If Db_adc <> Db_poti_old Then                                                   'Poti-Wert verndert?
   Input_type = 0                                                               'Input_type wieder auf Poti setzen
   Db_poti_old = Db_adc                                                         'letzten ADC-Wert retten
   Db_value = Db_adc
   Gosub Switches_leds                                                          'Schaltausgnge setzen und 7-Segment-Werte berechnen
End If

Debounce Pinc.1 , 0 , Dec_db , Sub                                              'Taster "-" gedrckt?
Debounce Pinc.2 , 0 , Inc_db , Sub                                              'Taster "+" gedrckt?

Loop


'***************************
'*** "-" Taster gedrckt ***
'***************************

Dec_db:                                                                         'dB-Wert um 2dB decrementieren

Input_type = 1                                                                  'Input auf Taster setzen

If Db_value > 0 Then                                                            'nur bei Werten >0dB reagieren
   If Db_value = 4 Then                                                         'von -4db auf 0dB dekrementieren?
      Db_value = 0
   Else
      Db_value = Db_value - 2                                                   'sonst um 2dB dekrementieren
   End If
End If

Gosub Switches_leds                                                             'Schaltausgnge setzen und 7-Segment-Werte berechnen

Return

'***************************
'*** "+" Taster gedrckt ***
'***************************

Inc_db:                                                                         'dB-Wert um 2dB decrementieren

Input_type = 1                                                                  'Input auf Taster setzen

If Db_value < 66 Then                                                           'nur bei Werten <66dB reagieren
   If Db_value = 0 Then                                                         'von 0db direkt auf -4dB inkrementieren?
      Db_value = 4
   Else
      Db_value = Db_value + 2                                                   'sonst um 2dB dekrementieren
   End If
End If

Gosub Switches_leds                                                             'Schaltausgnge setzen und 7-Segment-Werte berechnen

Return

'*****************************************************
'*** Switches setzen und 7-Segment-Werte berechnen ***
'*****************************************************

Switches_leds:

Disable Timer1

If Db_value = 0 Then                                                            'Schaltausgnge berechnen
   Switcher = &B00000000                                                        'Bit0 = 0dB-berbrckung setzen
Else
   Switcher = Db_value - 2                                                      'Bit-Wert fr Schaltausgnge ableiten
   Switcher = Switcher Or &B00000001                                            'LSB setzen = Dmpfungs-IC aktiv aus
End If

Port_b = Portb And &B11000000                                                   'PB6 und PB7 isolieren
Portb = Switcher Or Port_b                                                      'PORT B ausgeben

Db_bcd = Makebcd(db_value)                                                      'Teile dB-Wert in Einer und Zehner-Stelle

Einer = Db_bcd                                                                  'Einer-Stelle isolieren
Einer = Einer And &B00001111

Select Case Einer                                                               'Segment-Bits fr 0...9 berechnen
       Case 0 : Segments = &B11000000                                           'negative Logik, da Common Anode Typ
       Case 1 : Segments = &B11111001
       Case 2 : Segments = &B10100100
       Case 3 : Segments = &B10110000
       Case 4 : Segments = &B10011001
       Case 5 : Segments = &B10010010
       Case 6 : Segments = &B10000010
       Case 7 : Segments = &B11111000
       Case 8 : Segments = &B10000000
       Case 9 : Segments = &B10010000
End Select

Einer = Segments
If Db_bcd <> 0 Then Einer = Einer And &B01111111                                'Bei 0dB --> "-"-Zeichen ausschalten

Zehner = Db_bcd                                                                 'Zehner-Stelle isolieren
Swap Zehner
Zehner = Zehner And &B00001111


Select Case Zehner                                                              'Segment-Bits fr 0...9 berechnen
       Case 0 : Segments = &B11000000                                           'negative Logik, da Common Anode Typ
       Case 1 : Segments = &B11111001
       Case 2 : Segments = &B10100100
       Case 3 : Segments = &B10110000
       Case 4 : Segments = &B10011001
       Case 5 : Segments = &B10010010
       Case 6 : Segments = &B10000010
       Case 7 : Segments = &B11111000
       Case 8 : Segments = &B10000000
       Case 9 : Segments = &B10010000
End Select

If Db_bcd < 10 Then                                                             'fhrende Null unterdrcken
   Zehner = &B11111111
Else
   Zehner = Segments
End If

If Db_bcd <> 0 Then Zehner = Zehner And &B01111111                              'Bei 0dB --> "-"-Zeichen ausschalten

Enable Timer1

Return

'************************
'*** Timer1-INTERRUPT ***
'************************

Timer1_isr:                                                                     'Timer1-Interrupt, ca. 125Hz

If Portb.6 = 0 Then                                                             'Toggle Bit zwischen PB6 und PB7
   Set Portb.6                                                                  'Zehner-Stelle einschalten und Segment-Daten ausgeben
   Reset Portb.7
   Portd = Einer
Else                                                                            'Einer-Stelle einschalten und Segment-Daten ausgeben
   Set Portb.7
   Reset Portb.6
   Portd = Zehner
End If

Return

End