#!/usr/bin/perl

use Device::SerialPort qw( :PARAM :STAT 0.07 );
use Proc::Daemon;

# Dämonprozess
if($ARGV[0] eq "--daemonize") { Proc::Daemon::Init; }

# Öffnen des seriellen Ports
my $port=Device::SerialPort->new("/dev/ttyUSB0");
if(!$port) { die "Der serielle Port kann nicht geoeffnet werden.\n"; }
$port->read_char_time(0);   
$port->read_const_time(1000); 
$port->baudrate(4800);
$port->parity("none");
$port->databits(8);
$port->stopbits(1);        

# Auslesen der GPS-Daten
while (1) 
{
  my ($count, $readchrs) = $port->read(255); 
  if ($count > 0) 
  {
    if($readchrs =~ /^\$GPGGA,/m)
    {
      my ($time, $lat, $NS, $lon, $WE, $valid) = ($readchrs =~ /^\$GPGGA,([\d.]+),([\d.]+),([NS]),([\d.]+),([WE]),(\d+),/m);           
      print"-->$time,$lat,$NS,$lon,$WE,$valid";
      open(FILEOUT, "> /tmp/aprsbeacon.txt") ||
           die "Die Datei '/tmp/aprsbeacon.txt' kann nicht zum Schreiben geoeffnet werden.\n";
      if($valid > 0) 
      { 
        my $BeaconString = sprintf("!%s%s/%s%s>APRX-Bake", substr($lat,0,7), $NS, substr($lon,0,8), $WE);
        print FILEOUT $BeaconString;
        print "\n";
      }
      else 
      {
        print " - ungueltige GPS-Daten\n"; 
      }
      close(FILEOUT);
    }         
  }
}
