/*------------------------------------------------------------

TR2200 control firmware
based on Si570 LO
derived from DDS.c

Written (c) by Wulf-Gerd Traving 2008


---------------------------------------------------------------*/

/* CPU frequency */
#define F_CPU 8000000UL


// original fuses: 0xff, 0x5D, 0xE1 (no Reset, no self programming, no debug wire, spi download on, brown out 2.7V, PLL clock)
// now: 0xff, 0x5d, 0xe2 (internal 8MHz clock)
// now: 0xff, 0xdd, 0xe2 (enable RESET PB5 to allow serial reprogramming)
// now: 0xff, 0xd7, 0xe2

// #define HALF_RATE_SPI

// wx rx if
#define ZF 10700000l
//#define ZF 0L

/*
I/O connects
Port B0 - (SDA) PTT active low input
     B1 - SDA I2C to Si570
	 B2 - (SCL) ADC1 analog input 0...2.5V channel/frequency dial
	 B3 - SCL I2C to Si570
	 B4 - High=Channel Mode, Low=VFO Mode
	 B5 - (RESET) (may be SQL or REV input later)
*/

#define CHANVFO (PINB & 0x10)
#define REVERSE (PINB & 0x20)
#define PTT (PINB & 0x01)

// check for freq updates every nn ms
#define UPDATEINTERVAL 5l
// scan next channel every 1s, that is every nn UPDATEINTERVAL
#define SCANINTERVAL (1000l/UPDATEINTERVAL)
// hold scan for 10s, if signal detected
#define HOLDINTERVAL (20000l/UPDATEINTERVAL)
