//TaICOM.cpp:App + MainWindow
// G.Tamm,DF9ZO 2007
//------------------
#include "stdafx.h"
#include "TaICOM.h"
//------------------
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
//CTaICOMApp+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CTaICOMApp theApp;

BEGIN_MESSAGE_MAP( CTaICOMApp, CWinApp )
	//{{AFX_MSG_MAP( CTaICOMApp )

	//}}AFX_MSG_MAP
    // Standard print setup command
    ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

BOOL CTaICOMApp::InitInstance()
{
 CWinApp::InitInstance();
/*
 if (!AfxSocketInit())
  {
   AfxMessageBox(msg07);return FALSE;
  }

 if (!AfxOleInit())
  {
   AfxMessageBox(msg06);return FALSE;
  }
*/
 //Registry---------
 SetRegistryKey(RegKey);
 //LoadStdProfileSettings(0);// Load standard INI file options (including MRU)

 //Kommandozeile----
 CmdFName[0]='\0';if (m_lpCmdLine[0] != '\0') strcpy(CmdFName,m_lpCmdLine);
 //----------------- 
 m_pMainWnd = new CMainWindow;
 m_pMainWnd->MoveWindow(Win_X,Win_Y,Win_W,Win_H);
 m_pMainWnd->SetWindowText(AppName);
 m_pMainWnd->ShowWindow(m_nCmdShow);
 m_pMainWnd->UpdateWindow();

 return TRUE;
}
//-----------------------------------------------------------------------------
BOOL CTaICOMApp::OnIdle(LONG lCount)
{
 int res;

 if (CWinApp::OnIdle(lCount)) return TRUE;
 
 if (REMO == 1 && COM_Poll_Mode == 0)//ONLY when COM-Polling=Continuous
  {
   if (COM_IsPolling == 0) {res=comport.AskCOM_IDLE();return TRUE;}
  }

 return FALSE;//s. CWinApp::OnIdle
}
//CMainWindow++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
	//{{AFX_MSG_MAP( CMainWindow )
	ON_WM_PAINT()
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_WM_SIZE()
   ON_WM_MOVE()
	ON_COMMAND(CM_M_ABOUT,         On_M_About)
	ON_COMMAND(CM_M_INFO,          On_M_Info)
	ON_COMMAND(CM_M_EXIT,          On_M_Exit)
   ON_COMMAND(CM_M_RADIO1,        On_M_Radio1)
	ON_COMMAND(CM_M_RADIO2,        On_M_Radio2)
	ON_COMMAND(CM_M_RADIO3,        On_M_Radio3)
	ON_COMMAND(CM_M_RADIO4,        On_M_Radio4)
	ON_COMMAND(CM_M_RADIOPAR1,     On_M_RadioPar1)
	ON_COMMAND(CM_M_RADIOPAR2,     On_M_RadioPar2)
	ON_COMMAND(CM_M_RADIOPAR3,     On_M_RadioPar3)
	ON_COMMAND(CM_M_RADIOPAR4,     On_M_RadioPar4)
	ON_COMMAND(CM_M_REM,           On_M_Rem)
   ON_COMMAND(CM_M_SCAN,          On_M_Scan)
	ON_COMMAND(CM_M_COM_CHPORTS,   On_M_COM_ChPorts)
	ON_COMMAND(CM_M_COM_CLRRXBUF,  On_M_COM_ClrRXBuf)
	ON_COMMAND(CM_M_IB_SETMEM_TXT, On_M_ICOMBUS_SetMem_Txt)
   ON_COMMAND(CM_M_IB_SETMEM_ED,  On_M_ICOMBUS_SetMem_Ed)
	ON_COMMAND(CM_M_IB_MEMCLR,     On_M_ICOMBUS_ClrMem)
   ON_COMMAND(CM_M_GENOPTIONS,    On_M_GenOptions)
   ON_COMMAND(ID_TEST,            On_ID_Test)
	//}}AFX_MSG_MAP   
END_MESSAGE_MAP()

static UINT indicators[] = // StatusBar
{
 ID_SEPARATOR,           
 //ID_INDICATOR_CAPS,
 //ID_INDICATOR_NUM,
 //ID_INDICATOR_SCRL,
};
//Diagnose---------------------------------------
#ifdef _DEBUG
void CMainWindow::AssertValid() const
{
     
 CFrameWnd::AssertValid();
}
void CMainWindow::Dump(CDumpContext& dc) const
{

 CFrameWnd::Dump(dc);
}
#endif
//-----------------------------------------------------------------------------
CMainWindow::CMainWindow()
{
 CFrameWnd();
 LoadFrame(IDR_MAINFRAME);
 //Initialisierungen---------------
 remdlg=0;remextdlg=0;remdisp=0;remwin=0;
 scandlg=0;scandisp=0;
 PtrToRemDisp=NULL;PtrToRemDlg=NULL;PtrToRemExtDlg=NULL;
 R_IniFile();
 RadioSettings();
}

CMainWindow::~CMainWindow()
{
 List_RemAllElem(CoBoStrLi);
 W_IniFile();
}
//-----------------------------------------------------------------------------
int CMainWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
 if (CFrameWnd::OnCreate(lpCreateStruct) == -1) return -1;
 
 if (!m_wndStatusBar.Create(this) ||
	  !m_wndStatusBar.SetIndicators(indicators,
	  sizeof(indicators)/sizeof(UINT))) return -1;

 icon=::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME));

 return 0;
}
//-----------------------------------------------------------------------------
void CMainWindow::OnClose() 
{
 if (REMO || SCAN) 
  {
   TaMsgBox(AppName,msg02,2);
   return;
  }

 if (remwin     != 0) {remwin  ->DestroyWindow();remwin=0;}
 if (remdlg     != 0) {remdisp ->DestroyWindow();remdisp=0;}
 if (scandlg    != 0) 
  {
   scanview->DestroyWindow();scanview=0;
   scandisp->DestroyWindow();scandisp=0;
  }
 if (_TaMsgWin_ != 0) _TaMsgWin_->DestroyWindow();

 GetWinPars();
 Win_X=XIOpos-Dvframe;
 Win_Y=YIOpos-Dhframe-Hcaption-Hmenue;
 Win_W=XIUpos-XIOpos+(2*Dvframe);
 Win_H=YIUpos-YIOpos+(2*Dhframe)+Hcaption+Hmenue;
 CFrameWnd::OnClose();
}
//-----------------------------------------------------------------------------
void CMainWindow::GetWinPars()
{
 CRect rect;

 GetWindowRect(rect);//Screen-Coord.
 XOpos=rect.left;YOpos=rect.top;XUpos=rect.right;YUpos=rect.bottom;
 //-----------------------------
 Hcaption=GetSystemMetrics(SM_CYCAPTION);
 Hmenue=GetSystemMetrics(SM_CYMENU); 	
 Dvframe=GetSystemMetrics(SM_CYSIZEFRAME);
 Dhframe=GetSystemMetrics(SM_CXSIZEFRAME);
 BVScr=GetSystemMetrics(SM_CXVSCROLL);//Breite vert. Scr
 HHScr=GetSystemMetrics(SM_CYHSCROLL);//Hoehe hor. Scr
 XIOpos=rect.left  +Dvframe;
 YIOpos=rect.top   +Dhframe+Hcaption+Hmenue;
 XIUpos=rect.right -Dvframe;
 YIUpos=rect.bottom-Dhframe;
 //-----------------------------
 Win_XIOpos=XIOpos;Win_YIOpos=YIOpos;//Screen-Coord. 
 //icon=::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME));
}
//-----------------------------------------------------------------------------
void CMainWindow::UpDateStatusStr(int mode)
{
 char tmpstr[50],numstr[10];

 _itoa(Radio_Num+1,numstr,10);
 if (mode == 1 && Radio_Num == -1) strcpy(StatStr,"Select a radio");
 if (mode == 1 && Radio_Num >= 0) {strcpy(StatStr,statmsg03);strcat(StatStr,numstr);}
 if (mode == 2) {strcpy(StatStr,statmsg01);strcat(StatStr,numstr);}
 if ((mode == 1 && Radio_Num >= 0) || mode == 2)
  {
   strcat(StatStr," ( ");strcat(StatStr,RADIOS[Radio_Num].Name);
   wsprintf(tmpstr," , COM%d , %d Bd)",COM_PORT+1,BAUD_n[COM_BAUD]);
   strcat(StatStr,tmpstr);
  }
}

void CMainWindow::UpDateStatusBar()
{
 m_wndStatusBar.SetPaneText(0,StatStr);	
}

void CMainWindow::OnSize(UINT nType, int cx, int cy) 
{
 CFrameWnd ::OnSize(nType, cx, cy);
 Invalidate();
}

void CMainWindow::OnMove(int x, int y)
{
 CFrameWnd::OnMove(x, y);

 GetWinPars();
 if (remdlg  != NULL) remdlg ->PostMessage(WM_MAINWINDOW_POSCHANGE);
 if (scandlg != NULL) scandlg->PostMessage(WM_MAINWINDOW_POSCHANGE);
}

void CMainWindow::OnPaint()
{
 CPaintDC   dc(this);
 TEXTMETRIC metric;
 
 dc.GetTextMetrics(&metric);
 SchrH=metric.tmHeight+metric.tmExternalLeading;
 SchrB=metric.tmAveCharWidth+metric.tmOverhang;
 //---------------------------------------------
 UpDateStatusStr(1);UpDateStatusBar();
 //---------------------------------------------
 On_M_ShowInfo();
}
//*****************************************************************************
void CMainWindow::On_M_RadioPar1() 
{
 int tmp;

 if (REMO || SCAN) return;
 tmp=Radio_Num;Radio_Num=0;
 IBRAD_Dlg ibrad_dlg(this);
 ibrad_dlg.TransferToDlg(Radio_Num);
 if (ibrad_dlg.DoModal() == IDOK) 
  {
   ibrad_dlg.TransferFrDlg(Radio_Num);
   On_M_Radio1();
  }else {Radio_Num=tmp;Invalidate();return;}
}

void CMainWindow::On_M_Radio1() 
{
 if (REMO || SCAN) return;
 Radio_Num=0;RadioSettings();//SetCOMpars();
 Invalidate();UpDateStatusStr(1);UpDateStatusBar();
}

void CMainWindow::On_M_RadioPar2() 
{
 int tmp;

 if (REMO || SCAN) return;
 tmp=Radio_Num;Radio_Num=1;
 IBRAD_Dlg ibrad_dlg(this);
 ibrad_dlg.TransferToDlg(Radio_Num);
 if (ibrad_dlg.DoModal() == IDOK) 
  {
   ibrad_dlg.TransferFrDlg(Radio_Num);
   On_M_Radio2();
  }else {Radio_Num=tmp;Invalidate();return;}
}

void CMainWindow::On_M_Radio2() 
{
 if (REMO || SCAN) return;
 Radio_Num=1;RadioSettings();//SetCOMpars();
 Invalidate();UpDateStatusStr(1);UpDateStatusBar();
}

void CMainWindow::On_M_RadioPar3() 
{
 int tmp;

 if (REMO || SCAN) return;
 tmp=Radio_Num;Radio_Num=2;
 IBRAD_Dlg ibrad_dlg(this);
 ibrad_dlg.TransferToDlg(Radio_Num);
 if (ibrad_dlg.DoModal() == IDOK) 
  {
   ibrad_dlg.TransferFrDlg(Radio_Num);
   On_M_Radio3();
  }else {Radio_Num=tmp;Invalidate();return;}
}

void CMainWindow::On_M_Radio3() 
{
 if (REMO || SCAN) return;
 Radio_Num=2;RadioSettings();//SetCOMpars();
 Invalidate();UpDateStatusStr(1);UpDateStatusBar();
}

void CMainWindow::On_M_RadioPar4() 
{
 int tmp;

 if (REMO || SCAN) return;
 tmp=Radio_Num;Radio_Num=3;
 IBRAD_Dlg ibrad_dlg(this);
 ibrad_dlg.TransferToDlg(Radio_Num);
 if (ibrad_dlg.DoModal() == IDOK) 
  {
   ibrad_dlg.TransferFrDlg(Radio_Num);
   On_M_Radio4();
  }else {Radio_Num=tmp;Invalidate();return;}
}

void CMainWindow::On_M_Radio4() 
{
 if (REMO || SCAN) return;
 Radio_Num=3;RadioSettings();//SetCOMpars();
 Invalidate();UpDateStatusStr(1);UpDateStatusBar();	
}

void CMainWindow::On_M_ShowInfo() 
{
 CClientDC dc(this);
 CSize     size;
 CString   str("",200),str1("",200);
 char      tmpstr[200];
 int       s,x,y,z;
 int       y1=SchrH,y2=SchrH+y1,y3=y2+y1;
                       
 if (REMO || SCAN) return;
 x=0;y=0; 
 for (z=1;z < 5;z++)
  {
   if (strcmp(RADIOS[z-1].Name,"") == 0 && strcmp(RADIOS[z-1].IB_Adr_s,"") == 0) continue; 
     
   dc.SetTextColor(red);
   wsprintf(tmpstr,"RADIO %d (ICOM CI-V): ",z);
   str=tmpstr;dc.TextOut(0,y,str);size=dc.GetTextExtent(str);s=size.cx;

   dc.SetTextColor(black);
   str1=RADIOS[z-1].Name;
   str1+=" (";str1+=RADIOS[z-1].IB_Adr_s;str1+="/";
   _itoa(RADIOS[z-1].IB_Da_n,tmpstr,10);str1+=tmpstr;str1+=")  ";
   dc.TextOut(s,y,str1);y+=y1;x=0;

   dc.SetTextColor(blue);
   str1="F[MHz]: ";
   str1+=RADIOS[z-1].Fmin_s;str1+=" - ";str1+=RADIOS[z-1].Fmax_s;
   dc.TextOut(x,y,str1);y+=y2;x=0;
  }
  y+=y1;x=0;

  dc.SetTextColor(black);
  str="All Radios (Gen. Options): ";
  dc.TextOut(x,y,str);y+=y2;x=0;

  str="COM Polling: ";
  if (COM_Poll_Mode == 0) str1="Continuous (ONLY Test)";
  if (COM_Poll_Mode == 1) 
   {
    str1="Interval=";
    _itoa(COM_Poll_Interval,tmpstr,10);strcat(tmpstr," ms");
    str1+=tmpstr;
   }
  str+=str1;
  dc.TextOut(x,y,str);y+=y2;x=0;

  str="S-Meter / SQL Polling: ";
  if (SQLSM_Poll_Mode == 0) str1="On Command";
  if (SQLSM_Poll_Mode == 1) 
   {
    str1="Interval=";
    _itoa(SQLSM_Poll_Interval,tmpstr,10);strcat(tmpstr," ms");
    str1+=tmpstr;
   }
  str+=str1;
  dc.TextOut(x,y,str);y+=y2;x=0;

  dc.SetTextColor(black);
  wsprintf(tmpstr,"CMD-Confirmation: %d",CMD_Conf);
  str1=tmpstr;dc.TextOut(0,y,str1);
  y+=y1;x=0; 
  wsprintf(tmpstr,"CMD-Delay (Higher with low COM-Baudrates, >=19200 = 0): %d",CMD_Del);
  str1=tmpstr;
  dc.TextOut(0,y,str1);y+=y3;x=0; 

  dc.SetTextColor(black);
  str="Selected Radio: ";
  dc.TextOut(x,y,str);
  size=dc.GetTextExtent(str);
  dc.SetTextColor(red);
  _itoa(Radio_Num+1,tmpstr,10);
  str1="RADIO ";str1+=tmpstr;
  dc.TextOut(size.cx,y,str1);y+=y1;x=0;
  dc.SetTextColor(black);
  str="(Selection: CTRL+x / Configuration: ALT+x)";
  dc.TextOut(x,y,str);
}
//*****************************************************************************
void CMainWindow::On_M_Rem() 
{
 if (REMO || SCAN) return;
 Invalidate();
 COMTest_Single(COM_PORT);if (!COMAvail[COM_PORT]) {TaMsgBox(AppName,commsg00,3);return;}
 //-------------------------
 GetWinPars();REMO=1;Invalidate();
 remdlg=new RemDlg(this);
 remdlg->Create(IDD_REM_DLG,this);
 remdlg->ShowWindow(SW_SHOW); 
}

void CMainWindow::On_M_Scan()
{
 if (REMO || SCAN) return;
 Invalidate();
 COMTest_Single(COM_PORT);if (!COMAvail[COM_PORT]) {TaMsgBox(AppName,commsg00,3);return;}
 //-------------------------
 GetWinPars();SCAN=1;Invalidate();
 scandlg=new ScanDlg(this);
 scandlg->Create(IDD_SCAN_DLG,this);
 scandlg->ShowWindow(SW_SHOW);	 
}
//ICOM_BUS*********************************************************************
void CMainWindow::On_M_ICOMBUS_ClrMem() 
{
 if (REMO || SCAN) return;

 IBMEMCLR_Dlg ibmemclrdlg(this);
 if (ibmemclrdlg.DoModal() == IDOK) {}
}

void CMainWindow::On_M_ICOMBUS_SetMem_Ed()
{
 IBMEMDlg ibmemdlg(this);

 if (REMO || SCAN) return;
 if (ibmemdlg.DoModal() == IDOK) {} 
}

void CMainWindow::On_M_ICOMBUS_SetMem_Txt() 
{
 if (REMO || SCAN) return;
 IB_SetMemFrTxt(); 
}
//*****************************************************************************
void CMainWindow::On_M_COM_ChPorts() 
{
 if (REMO || SCAN) return;
 COMTest_Complete();	
}

void CMainWindow::On_M_COM_ClrRXBuf() 
{
 if (REMO || SCAN) comport.ClrRXBuf();	
}
//-----------------------------------------------------------------------------
void CMainWindow::On_M_GenOptions()
{
 char             str[5],tmpstr[9]="";
 GENOPTIONS_Dlg   genoptionsdlg(this);

 if (REMO || SCAN) return;  
 genoptionsdlg.m_cmd_conf  =CMD_Conf;

 genoptionsdlg.m_sm_sel    =SM_sel;
 genoptionsdlg.m_sqlsm_mode=SQLSM_Poll_Mode;
 _itoa(SQLSM_Poll_Interval,str,10);  
 genoptionsdlg.m_sqlsm_poll_iv=str;

 _itoa(CMD_Del,str,10);  
 genoptionsdlg.m_cmd_del=str;

 if (COM_Poll_Mode == 0) genoptionsdlg.m_com_poll_mode=0;else genoptionsdlg.m_com_poll_mode=1; 
 _itoa(COM_Poll_Interval,tmpstr,10);genoptionsdlg.m_com_poll_iv=tmpstr;
 
 if (genoptionsdlg.DoModal() == IDOK)
  {
   CMD_Conf=genoptionsdlg.m_cmd_conf;

   CMD_Del=CStrToInt(genoptionsdlg.m_cmd_del);
   if (CMD_Del <   0) CMD_Del=0;
   if (CMD_Del > 200) CMD_Del=200;

   if (genoptionsdlg.m_com_poll_mode == 0) COM_Poll_Mode=0;else COM_Poll_Mode=1;
   COM_Poll_Interval=CStrToInt(genoptionsdlg.m_com_poll_iv);
   if (COM_Poll_Interval <=  10) COM_Poll_Interval=10;
   if (COM_Poll_Interval >  200) COM_Poll_Interval=200;

   SM_sel         =genoptionsdlg.m_sm_sel;
   SQLSM_Poll_Mode=genoptionsdlg.m_sqlsm_mode;
   SQLSM_Poll_Interval=CStrToInt(genoptionsdlg.m_sqlsm_poll_iv);
   if (SQLSM_Poll_Interval <  10) SQLSM_Poll_Interval=10;
   if (SQLSM_Poll_Interval > 200) SQLSM_Poll_Interval=200;

   Invalidate();On_M_ShowInfo();
  }else return;
}
//-----------------------------------------------------------------------------
void CMainWindow::On_M_Info() 
{
 ExecNotePad(F_Help);	
}
//-----------------------------------------------------------------------------
void CMainWindow::On_M_About() 
{
 TaMsgBox(AppName,InfoStr,1);		
}
//-----------------------------------------------------------------------------
void CMainWindow::On_M_Exit() 
{
 OnClose();	
}
//-----------------------------------------------------------------------------
void CMainWindow::On_ID_Test()// CTRL + SHIFT + T 
{

}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



















































