// R_VAR.H : Variablen, Konstante f. Radio
// G. TAMM, DF9ZO 1999-2007
//-------------------------
#pragma once
//--------------------
#include "R_ICOMdata.H" // includes #include "stdafx.h"
#include "R_STRDIV.H"   // includes #include "stdafx.h"
#include "R_LISTS.H"    // includes #include "stdafx.h"
//--------------------
#include "resource.h"
//Specials+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define             WM_REMDISP_FREQCHANGE     (WM_USER + 1)
#define             WM_REMDISP_MOFICHANGE     (WM_USER + 2)
#define             WM_REMDISP_SQLSMCHANGE    (WM_USER + 3)
#define             WM_REMWIN_ITEMSELECTION   (WM_USER + 4)
#define             WM_MODEDLG_MOFICHANGE     (WM_USER + 5)
#define             WM_CWKBDLG_OK             (WM_USER + 6)
#define             WM_CWDISP_SPEEDTEST       (WM_USER + 7)
#define             WM_MAINWINDOW_POSCHANGE   (WM_USER + 8)

extern              CFrameWnd*                PtrToRemDisp;
extern              CFrameWnd*                PtrToCWDisp;
extern              CDialog*                  PtrToRemDlg;
extern              CDialog*                  PtrToRemExtDlg;
extern              CDialog*                  PtrToModeDlg;
extern              CDialog*                  PtrToCWKBDlg;
//Globale Variablen++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//Alle Laengenangaben INKLUSIVE term. '\0'
const int	 	     RStrLt=501,                     //max. Laenge normger. Radio-String
				        RStrLf=13,                      //Laenge Frequenz
				        RStrLm=MODES.Mlen_s,            //Laenge Mode
                    RStrLr=RStrLt-RStrLf-RStrLm-3,  //Laenge Remarks (-2 Trenner + term. '\0')
                    //---------------------------------------------------------
				        RStrSf=0,                       //Start Frequenz im String
				        RStrSm=13,                      //Start Mode     im String
				        RStrSr=20,                      //Start Remarks  im String         todo
                    //---------------------------------------------------------
                    Fl=250;                         //Laenge f. Filenamen
//-----------------------------------------------------------------------------
extern char		     AppName     [],
				        InfoStr     [],
                    CmdFName    [],
				        F_Env       [],
                    RegKey      [],
                    F_Help      [],
                    F_Log       [],
                    StatStr     [],
                    ComStatStr  [],
                    RadioStatStr[];
//-----------------------------------------------------------------------------
extern int          Win_X,Win_Y,Win_W,Win_H;        //Fensterposition Hauptfenster
extern int          Win_XIOpos,Win_YIOpos;          //Fensterposition Client

extern int          RSDisp_W,RSDisp_H;              //RemDisp, ScanDisp Breite, Hoehe
extern int          RSDlg_X ,RSDlg_Y;               //RemDlg,  ScanDlg
extern int          RSDlg_W ,RSDlg_H;               //RemDlg,  ScanDlg  Breite, Hoehe
//-----------------------------------------------------------------------------
extern COLORREF     SystemBgrColor, 
                    red,black,blue,green,
                    magenta,ltgray,dkgray,white;

extern CFont        font,*oldfont;

extern int          fontH;    
//-----------------------------------------------------------------------------
extern int	        COM_PORT;
extern int			  COM_BAUD;
extern int          COM_DATA;
extern int          COM_STOP;
extern int          COM_PARI;
extern int          COM_PROT;
extern int          COM_Poll_Mode;               //0=Cont., 1=Interval     
extern int          COM_Poll_Interval;           //Polling-Rate Interval
extern int          COM_IsPolling;               //Verh. Wiedereintr. bei lfd. Routine
extern UINT         TimerID_COM;                 //Timer ID
extern UINT         TimerID_SQLSM;               //Timer ID
//-----------------------------------------------------------------------------
extern int 		     REMO;
extern int 			  RemDisp_UPD;
extern int 			  SCAN;
extern int 	 		  Radio_Num;
//-----------------------------------------------------------------------------
extern char         Fact_s[];				          //Frequenz aktuell als String
extern char         Fdef_s[];                    //Frequenz default als String
extern unsigned int Fact_n;                      //Frequenz aktuell als num. Wert
extern unsigned int Fmin_n;
extern unsigned int Fmax_n;
//-----------------------------------------------------------------------------
extern char         SF_HW_s[11][RStrLf];         //Frequenz-Step HW (Radio)
extern int          SF_HW_act_n; 

extern char         SFact_s[];				       //Frequenz-Step SW
extern char			  SFdef_s[];
extern unsigned int SFact_n;

extern char         SF_SSB_s [],                 //Frequenz-Steps (Arrow-Keys)
                    SF_FM_s  [],
                    SF_FMW_s [],
                    SF_AM_s  [],
                    SF_DATA_s[];         
extern int          SF_SSB_n,                    
                    SF_FM_n,
                    SF_FMW_n,
                    SF_AM_n,
                    SF_DATA_n;

extern char         OFact_s[];				       //Frequenz-Offset SW
extern char			  OFdef_s[];
extern int   		  OFact_n;
//-----------------------------------------------------------------------------
extern char         Mact_s[];				          //Mode
extern char			  Mdef_s[];
extern int			  Mact_n;                      //Modeliste Indexierung

extern char         Marr_s[MODES.Mmax][RStrLm];  //Modeliste
//-----------------------------------------------------------------------------
extern char         FIact_s[];				       //Filterstring f. Anzeige
extern int 			  FIact_n;                     //Filter Indexierung

extern char         FIarr_s[6][7];               //Filterliste

extern int          FI_SwHw;                     //0=HW-Filter, 1=DSP-Filter            

extern int          FI_SW_Fmin;                  //SW-Filter
extern int          FI_SW_Fmin_lev;
extern int          FI_SW_Fmax;
extern int          FI_SW_Fmax_lev;
extern int          FI_SW_BW1def;                //             Wide
extern int          FI_SW_BW1def_lev;
extern int          FI_SW_BW2def;                //             Normal
extern int          FI_SW_BW2def_lev;
extern int          FI_SW_BW3def;                //             Narrow
extern int          FI_SW_BW3def_lev;
extern int          FI_SW_BW_lev;                //akt.
extern int          FI_SW_Shape;                 //0=Sharp, 1=Soft
//-----------------------------------------------------------------------------
extern int          ROOFsw;                      //R-Fi    -Switch (0-2                  )

extern int			  ANTsw;                       //ANT     -Switch (0=A1  / 1=A2         )
extern int			  ANTmax;                      //ANT     -Max. schaltb. ANT            )

extern int			  ATTsw;                       //ATT     -Switch (0=off / 1=10dB / ... )
extern int			  ATTmax;                      //ATT     -Max. schaltb. ATT            )
extern char         ATT_s[10];                   //ATT     -Strings                      )

extern int			  PAMPsw;                      //PAMP    -Switch (0=off / 1 / 2        )
extern int			  PAMPmax;                     //PAMP    -Max. schaltb. PAMP           )
extern char         PAMP_s[10];                  //PAMP    -Strings                      )

extern int			  AGCsw;                       //AGC     -Switch (0=off / 1=F / 2=S    )

extern int 			  DUPsw;                       //DUP     -Switch (0=SIM / 1=-DUP  / 2..)
extern char         DUParr_s[6][5];

extern int 			  VFOsw;                       //VFO     -Switch (0=A   / 1=B          )

extern int 			  VFOspl;                      //VFO     -Switch (0=Norm/ 1=Split      )

extern int 			  VMsw;                        //V/M     -Switch (0=VFO / 1=Memory     )

extern int			  NBsw;                        //NB      -Switch (0=off / 1=on         )
extern int			  NBlev_n;                     //NB-Level-Einst. (0-255                )
extern int			  NBwid_n;                     //NB-Width-Einst. (0-255                )

extern int			  NRsw;                        //NR      -Switch (0=off / 1=on         )
extern int			  NRlev_n;                     //NR-Level-Einst. (0-255                )

extern int			  ANFsw;                       //ANF     -Switch (0=off / 1=on         )
extern int			  MNF1sw;                      //MNF1    -Switch (0=off / 1=on         )
extern int			  MNF2sw;                      //MNF2    -Switch (0=off / 1=on         )
extern int			  MNF1lev_n;                   //MNF1-Lev-Einst. (0-255                )
extern int			  MNF2lev_n;                   //MNF2-Lev-Einst. (0-255                )

extern int 			  SQL_SwHw;                    //SW-/HW-SQL      (0=Sw / 1=Hw          )       
extern int   		  SQLlev_n;				          //SQL-Level-Einst.(0-255                )
extern int   		  SQL_oc;					       //SQL     -Erg.   (0=closed / 1=open    )
extern int	 		  SMlev_n;				          //SM      -Erg.   (0-255                )
extern char			  SMlev_s[];                   //SM      -Anz.   (String               )
extern int			  SM_li_n[15];                 //SM      -Liste  (num.                 )
extern char			  SM_li_s[15][8];              //SM      -Liste  (Strings              )
extern int	 		  SM_sel;				          //SM      -Ausw.  (0=num. / 1=S-Wert    )
extern int	 		  SQLSM_Poll_Mode;		       //SQL/SM  -Ausw.  (0=Abfrage / 1=cont.  )
extern int          SQLSM_Poll_Interval;         //Polling-Rate Interval                 )

extern int 			  AFlev_n;                     //AF      -Einst. (0-255                )

extern int 			  RFlev_n;                     //RF      -Einst. (0-255                )

extern int 			  PBTH_n;                      //PBT H   -Einst. (0-255                )
extern int 			  PBTL_n;                      //PBT L   -Einst. (0-255                )

extern int 			  CWSPEED_n;                   //CW-SPEED-Einst. (0-255                )
extern int          APFsw;                       //APF     -Switch (0=off / 1=on         )
extern int          APFlev_n;                    //APF     -Einst. (0-255                ) 

extern int   		  TXPWR_n;				          //Sendel. -Einst. (0-255                )
extern int   		  TXPWR_tune;				       //Sendel. -ini-F. (0-255                )

extern int   		  RTTY_TPFsw_n;                //TPFilter-Switch (0=off / 1=on         )
extern int          RTTY_KPsw_n;                 //Key Pol.-Switch (0=normal / 1=reverse )
extern int          RTTY_MFsw_n;                 //Mark-F  -Switch (0-2=1275,1615,2125   )
extern int          RTTY_SHsw_n;                 //Shift   -Switch (0-2=170,200,425      )
extern int          RTTY_RXDECsw_n;              //RX-Dec. -Switch (0=CR,LF,CR+LF,1=CR+LF)

extern int 			  MIClev_n;                    //Mic-Gain-Einst. (0-255                )
extern int          COMPsw;                      //Compr.  -Switch (0=off / 1=on         )
extern int 			  COMPlev_n;                   //Compr.  -Einst. (0-10                 )

extern int          TXSSBbw_n;                   //SSB-BW  -Einst. (0=w, 1=m, 2=n        )
extern int          TXSSBbw_wilo_n;
extern int          TXSSBbw_wihi_n;
extern int          TXSSBbw_milo_n;
extern int          TXSSBbw_mihi_n;
extern int          TXSSBbw_nalo_n;
extern int          TXSSBbw_nahi_n;

extern char			  MEMtxt_s[];                  //                (String               )

extern int 			  CMD_Conf;                    //0=NO Confirmation 
extern int 			  CMD_Del;                     //Delay zwischen 2 Befehlen [ms]     
//-----------------------------------------------------------------------------
extern const char   RadAdds_s[7][7];             //zus. Befehle im RadStr
//-----------------------------------------------------------------------------
const  int    	      ScLiMax               =1000;//Scanliste max. Inhalt   300
extern int           ScLiInd,                    //Scanliste Index
                     ScLiNum;                    //Scanliste Anz. Elemente

extern int		      ScOpMo,					       //0=NO Sel., 1=Scan, 2=MScan, 3=Lib
                     ScOpMoFrFile,               //LibFile: 1=Scan, 2=MScan
                     ScStopMo,                   //0=Mode1,1=Mode2, 2=Mode3
                     ScIsRu,
                     ScIsSta,
                     ScIsSto,
                     ScIsResta;

extern char          ScLoF_s[],
                     ScHiF_s[];
extern unsigned int	ScLoF_n,
					      ScHiF_n;

extern char			   ScStepDel_s[],
					      ScM2Del_s[],
                     ScM3Lev_s[];
extern int			   ScStepDel_n,
					      ScM2Del_n,
                     ScM3Lev_n;

extern char          ScStr1[],
                     ScStr2[],
                     ScTime1[],
                     ScTime2[];

extern int 			   ScWrSpec,                   //0=Scannen / 1=Scannen+Spec schreiben
                     ScLtSpec;                   //0=Spec nach j. Durchgang loeschen
                                                 //1=Spec nicht loeschen

extern char          F_ScMScanFi[],              //File f. M-Scan (*.fre)
                     F_ScLibFi[];                //File f. Lib    (*.lib)		
                    
struct TScan
{
 char f[ScLiMax][RStrLf];                        //Frequenz
 int  m[ScLiMax];                                //ModeIndex
 int  y[ScLiMax];                                //Y-Achse
};

extern TScan ScAr;
//CW+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern char          CWStr    [],
                     CWStr_ini[][500];

extern int           CW_Pitch,                   //Tonhoehe
                     CW_PitchMin, 
                     CW_PitchMax,

                     CW_Speed,                   //Speed
                     CW_SpeedMin, 
                     CW_SpeedMax,

                     CW_DOT,                     //Laenge Punkt
                     CW_DASH,                    //Laenge Strich
                     CW_B_CHARCOMP,              //Laenge zwischen den CW-Komp. eines Character
                     CW_B_CHAR,                  //Laenge zwischen Buchstaben 
                     CW_B_WORD,                  //Laenge zwischen Woertern

                     CW_TXing,
                     CW_SpeedTest; 

extern int           CW_Chars_CHAR[];
extern char          CW_Chars_CW[][10];

extern char          CW_KbStr[];
//Messages+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern char          msg00[],msg01[],msg02[],msg03[],msg04[],msg05[],
                     msg06[],msg07[],
       		 		   //-------------------
                     scmsg00[],scmsg01[],scmsg02[],scmsg03[],
                     //-------------------
                     commsg00[],              
       		 		   //-------------------
                     statmsg00[],statmsg01[],statmsg02[],statmsg03[],
                     //ICOM CI-V - Bus----
       		         IB_msg00[],IB_msg01[],IB_msg02[],IB_msg03[],IB_msg04[];
//INI-File+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern char          defini01[],defini02[],defini03[],defini04[],defini05[],
                     defini06[],defini07[],defini08[],defini09[],defini10[],
                     defini11[],defini12[],defini13[],defini14[],defini15[],
                     defini16[],defini17[],defini18[],defini19[],defini20[];

int  R_IniFile(void);
//Liest INI-File
int  W_IniFile(void);
//Schreibt INI-File
//SCAN-LIB+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern char          scini01[],scini02[],scini03[],scini04[],scini05[],
                     scini06[],scini07[],scini08[],scini09[],scini10[],
                     scini11[],scini12[];

int R_ScanLib(char *FName);
//Liest LIB-File
int W_ScanLib(char *FName);
//Schreibt LIB-File
//SMC-File+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern char          smcini01[],smcini02[],smcini03[],smcini04[],smcini05[],
                     smcini06[],smcini07[],smcini08[],smcini09[],smcini10[],
                     smcini11[],smcini12[],smcini13[],smcini14[],smcini15[];

int R_SMCFile(char *FName);
//Liest *SMC-File
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//Dialogs + Wins+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//TaInpDlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class TaInpDlg : public CDialog
{
public:
	TaInpDlg(CWnd* pParent = NULL);
	CString m_strDlgTitle,m_strStatic1,m_strStatic2;
   int StrLim;
// Dialog Data
	//{{AFX_DATA(TaInpDlg)
	enum { IDD = IDD_TAINP_DLG };
	CString	m_strEdit;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TaInpDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(TaInpDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//-----------------------------------------------------------------------------
int MyInpDlg(CWnd* parent,char* title,char* msg1,char* msg2,
             char* inp,int lim);
int MyInpDlg(CWnd* parent,CString& title,CString& msg1,CString& msg2,
             CString& inp,int lim);
/*
Aufruf:
 int res,limit=5;
 char instr[100]="inp";

 res=MyInpDlg(this,"title","msg1","msg2",instr,limit);
 if (res == IDOK) TaMsgBox("",instr,1);
*/
//TaStatBar++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class TaStatBar : public CStatusBar 
{
// Construction
public:
	TaStatBar();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TaStatBar)
	//}}AFX_VIRTUAL
public:
	virtual ~TaStatBar();

protected:
    afx_msg LRESULT OnSetText(WPARAM, LPARAM);
	//{{AFX_MSG(TaStatBar)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//TaMsgWin+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class TaMsgWin : public CFrameWnd
{
	DECLARE_DYNCREATE(TaMsgWin)
protected:

public:
    TaMsgWin();
    TaMsgWin(CFrameWnd* parent,char* title,char* msgstr);   
public:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TaMsgWin)
	//}}AFX_VIRTUAL
protected:
	virtual ~TaMsgWin();

   CString paintstr;    
	// Generated message map functions
	//{{AFX_MSG(TaMsgWin)
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//-----------------------------------------------------------------------------
void MyMsgWin(CFrameWnd* parent,char* title,char* msgstr,
              int delay,int X,int Y,int W,int H);
/*
Aufruf:
 if (_TaMsgWin_ != 0) return;
 GetWinPars();
 MyMsgWin(this,AppName,"Hallo",5000,XIOpos,YIOpos,XIOpos+200,YIOpos+200);
 
 void CMainWindow::OnClose() 
  {
   if (_TaMsgWin_ == 0) CFrameWnd::OnClose();
   //--------------------	
   //CFrameWnd::OnClose();
  }
*/
//TaMsgBox+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int TaMsgBox(char     *titlestr,char    *msgstr,int mode);
int TaMsgBox(CString& titlestr ,CString& msgstr,int mode);
// mode=1  MB_OK       | MB_TASKMODAL
// mode=2  MB_OK       | MB_ICONINFORMATION | MB_TASKMODAL
// mode=3  MB_OK       | MB_ICONSTOP 		  | MB_TASKMODAL
// mode=4  MB_OKCANCEL | MB_ICONINFORMATION | MB_TASKMODAL
// mode=5  MB_YESNO    | MB_ICONQUESTION    | MB_TASKMODAL
// mode=6
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern TaMsgWin* _TaMsgWin_;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
if (PtrToRemDisp != NULL) PtrToRemDisp->PostMessage(WM_REMDISP_FREQCHANGED);
if (PtrToRemDisp != NULL) PtrToRemDisp->PostMessage(WM_REMDISP_STATUSCHANGED);

Icons:
32X32 4bit Terminal  9 fett (DF9ZO)
48X48 4bit Arial    11 fett (DF9ZO)
64X64 4bit Arial    14 fett (DF9ZO)   


Todo:


BUGS:



+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Datenformat fuer FRE-Files:

*.FRE-FILES:

xxxx.xxx,xxx_xxxxxx_123456789a123456789b123456789c123456789d123456789e123456789f
F(12)        M(6)   Additional Data/Remarks
0-11         13-18  20-200

           1_1    1_2
0   4   8  1_3    8_0


Modes:

USB, LSB, FM, FMW, AM, CW, FSK, (SKI)


Additional Data:

>SF=F-Step;        Example: >SF=.025;      / >SF=.012,5;
>OF=F-Offset;      Example: >OF=.6;        / >OF=4.6;
>FI=Filter;        Example: >FI=-;(Normal) / >FI=N;(Narrow) / >FI=W;(Wide)
>ATT=Attenuator;   Example: >ATT=0;        / >ATT=2;
>DUP=Duplex;       Example: >DUP=S;        / >DUP=-;        / >DUP=+;


Example for frequency database files:

    .199,000 AM     BBC                                >SF=.001;
    .846,000 AM     RAI                                >SF=.009;
    .873,000 AM     AFN                                >SF=.009;>ATT=3;
   3.790,000 LSB                                       >SF=.000,1;
   7.002,000 CW                                        >SF=.000,1;>FI=N;
   9.410,000 AM     BBC                                >SF=.005;  
  10.000,000 SKI    Skip this frequency when scanning
  14.313,000 USB    Maritime                           >SF=.000,1;
  89.300,000 FMW    HR3                                >SF=.1;>FI=W;
 145.350,000 FM     OV Hanau(DF9ZO)                    >SF=.025;>OF=.6;
 430.350,000 FM     OV Hanau(DF9ZO)                    >SF=.025;
1295.350,000 FM     OV Hanau(DF9ZO)                    >SF=.025;
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CW

Zeichenlaengen:

Punkt                                     1
Strich                                    3
Zwischen CW-Komponenten eines Characters  1
Zwischen Buchstaben                       3
Zwischen Woertern                         7

Zulaessige Zeichen:

A .-      B -...    C -.-.    D -..     E .      F ..-.
G --.     H ....    I ..      J .---    K -.-    L .-..
M --      N -.      O ---     P .--.    Q --.-   R .-.
S ...     T -       U ..-     V ...-    W .--    X -..-
Y -.--    Z --..

0 -----   1 .----   2 ..---   3 ...--   4 ....-  
5 .....   6 -....   7 --...   8 ---..   9 ----.

Punkt                  [.] : .-.-.-
Komma                  [,] : --..--
Doppelpunkt            [:] : ---...
Semikolon              [;] : -.-.-.
Fragezeichen           [?] : ..--..
Bindestrich            [-] : -....-
Gleichheitszeichen     [=] : -...-
Linke Klammer          [(] : -.--.
Rechte Klammer         [)] : -.--.-
Schraegstrich          [/] : -..-.

End of message         [+] : .-.-.
Invitation to transmit [K] : -.-
Error                      : ........    Tastatur: *
End of work            [SK]: ...-.-      Tastatur: #

CW_Str0=df9zo
CW_Str1=cfm 5nn ur 5nn 73
CW_Str2=de df9zo cfm 5nn ur 5nn 73
CW_Str3=
CW_Str4=
CW_Str5=
CW_Str6=
CW_Str7=test de df9zo
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 if (IBRad_Adr_n == 0x68)                    //IC-703 
 if (IBRad_Adr_n == 0x58)                    //IC-706MK2G 
 if (IBRad_Adr_n == 0x56)                    //IC-746 
 if (IBRad_Adr_n == 0x6E)                    //IC-756pro3 
 if (IBRad_Adr_n == 0x70)                    //IC-7000
 if (IBRad_Adr_n == 0x76)                    //IC-7200 
 if (IBRad_Adr_n == 0x66)                    //IC-7400
 if (IBRad_Adr_n == 0x74)                    //IC-7700  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800 
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/




