// R_VAR.CPP : Implementierung Variablen, Konstante f. Radio
// G. TAMM, DF9ZO 1999-2007
//-------------------------
#include "stdafx.h"
#include "R_VAR.H"
//+Specials++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CFrameWnd*   PtrToRemDisp         =NULL;
CFrameWnd*   PtrToCWDisp          =NULL;
CDialog*     PtrToRemDlg          =NULL;
CDialog*     PtrToRemExtDlg       =NULL;
CDialog*     PtrToModeDlg         =NULL;
CDialog*     PtrToCWKBDlg         =NULL;
//+Globale Variablen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char		    AppName     []	  	 ="TaICOM by DF9ZO",
			    InfoStr     []	  	 ="TaICOM by DF9ZO, V 5.023 (Build 22 December 2008)\n"
                                   "Copyright 1991-2008 by G. TAMM, DF9ZO",
             CmdFName    [Fl]     ="",
		  	    F_Env       []       ="TaICOM.INI",
             RegKey      []       ="TaICOM",
             F_Help      []       ="TaICOM_INFO.TXT",
             F_Log       []       ="TaICOM.LOG",
             StatStr     [150]    ="Ready",
			    ComStatStr  [150]    ="",
             RadioStatStr[150]    ="";
//-----------------------------------------------------------------------------
int          Win_X                =0,
             Win_Y                =0,
             Win_W                =614,
             Win_H                =620;
int          Win_XIOpos           =0,
             Win_YIOpos           =0;

int          RSDisp_W             =0,
             RSDisp_H             =0;
int          RSDlg_X              =0,
             RSDlg_Y              =0,
             RSDlg_W              =0,
             RSDlg_H              =0;
//-----------------------------------------------------------------------------
COLORREF     SystemBgrColor,
             red	                =RGB(255,0  ,0  ),
             black                =RGB(0  ,0  ,0  ),
             blue	                =RGB(0  ,0  ,255),
             green                =RGB(0  ,128,0  ),
             magenta              =RGB(255,0  ,255),
             ltgray               =RGB(192,192,192),
             dkgray               =RGB(128,128,128),
             white                =RGB(255,255,255);

CFont        font,*oldfont;

int          fontH                =18;//12,18,24     
//-----------------------------------------------------------------------------
int	       COM_PORT             =1;
int		    COM_BAUD             =8;
int          COM_DATA             =4;
int          COM_STOP             =0;
int          COM_PARI             =4;
int          COM_PROT             =3;
int          COM_Poll_Mode        =1;
int          COM_Poll_Interval    =30;
int          COM_IsPolling        =0;
UINT         TimerID_COM          =0;
UINT         TimerID_SQLSM        =0; 
//-----------------------------------------------------------------------------
int 		    REMO				       =0;
int 		    RemDisp_UPD          =0;
int		    SCAN				       =0;
int          Radio_Num            =0;                
//-----------------------------------------------------------------------------
char         Fact_s[RStrLf]	    ="  10.000,000";
char         Fdef_s[RStrLf]	    ="  10.000,000";  
unsigned int Fact_n               =10000000;
unsigned int Fmin_n        	    =0;
unsigned int Fmax_n        	    =0;
//-----------------------------------------------------------------------------
char         SF_HW_s[11][RStrLf]  ={"10 Hz"   ,"100 Hz" ,"1 kHz" ,
                                    "5 kHz"   ,"9 kHz"  ,"10 kHz",
                                    "12,5 kHz","20 kHz" ,"25 kHz",
                                    "100 kHz" ,"1.0 MHz"};        //10             
int          SF_HW_act_n          =1; 

char         SFact_s[RStrLf]	    ="0000.025,000";
char		    SFdef_s[RStrLf]	    ="0000.025,000";    
unsigned int SFact_n              =25000;

char         SF_SSB_s [RStrLf]    ="0000.000,100",
             SF_FM_s  [RStrLf]    ="0000.012,500",
             SF_FMW_s [RStrLf]    ="0000.100,000",
             SF_AM_s  [RStrLf]    ="0000.009,000",
             SF_DATA_s[RStrLf]    ="0000.000,010";         
int          SF_SSB_n             =100,                    
             SF_FM_n              =12500,
             SF_FMW_n             =100000,
             SF_AM_n              =9000,
             SF_DATA_n            =10;

extern char  OFact_s[RStrLf]      =".600,000";
extern char	 OFdef_s[RStrLf]      =".600,000";    
extern int   OFact_n              =600000;
//-----------------------------------------------------------------------------
char         Mact_s[RStrLm];
char		    Mdef_s[RStrLm]       ="AM    ";         
int			 Mact_n;

char         Marr_s[MODES.Mmax][RStrLm];
//-----------------------------------------------------------------------------
char         FIact_s[RStrLm]	    ="-";
int 		    FIact_n		 	       =0;             //Voreinstellung Normal

char         FIarr_s[6][7]        ={"-","N","W","NORMAL","NARROW","WIDE  "};

int          FI_SwHw              =0;            

int          FI_SW_Fmin           =0;
int          FI_SW_Fmin_lev       =0;
int          FI_SW_Fmax           =0;
int          FI_SW_Fmax_lev       =0;
int          FI_SW_BW1def         =0;
int          FI_SW_BW1def_lev     =0;
int          FI_SW_BW2def         =0;
int          FI_SW_BW2def_lev     =0;
int          FI_SW_BW3def         =0;
int          FI_SW_BW3def_lev     =0;
int          FI_SW_BW_lev         =0;
int          FI_SW_Shape          =0;
//-----------------------------------------------------------------------------
int          ROOFsw               =0;

int			 ANTsw                =0;
int			 ANTmax               =0; 

int 		    ATTsw		 		    =0;
int			 ATTmax               =1;
char         ATT_s[10]            ="-";

int			 PAMPsw               =0;
int			 PAMPmax              =1;
char         PAMP_s[10]           ="";
int			 AGCsw                =2;

int          DUPsw                =0;
char         DUParr_s[6][5]       ={"S","-","+","SIM ","-DUP","+DUP"};
   
int          VFOsw                =0;

int          VFOspl               =0;

int          VMsw                 =0;

int			 NBsw                 =0;
int			 NBlev_n              =128;
int			 NBwid_n              =128;

int			 NRsw                 =0;
int          NRlev_n              =72;

int			 ANFsw                =0;
int			 MNF1sw               =0;
int			 MNF2sw               =0;    
int			 MNF1lev_n            =0; 
int			 MNF2lev_n            =0; 

int 		    SQL_SwHw             =0;
int 		    SQLlev_n             =0;
int 		    SQL_oc               =0;
int	 		 SMlev_n              =0;
char		    SMlev_s[20]          ="0";
int			 SM_li_n[15]          ={20,40,60,80,100,120,140,160,180,
                                    200,210,220,230,240,250};
char		    SM_li_s[15][8]       ={"S1","S2","S3","S4","S5","S6","S7",
                                    "S8 ","S9",
                                    "S9+10dB","S9+20dB","S9+30dB","S9+40dB",
                                    "S9+50dB","S9+60dB"};
int	 		 SM_sel               =1;
int	 		 SQLSM_Poll_Mode      =0;
int          SQLSM_Poll_Interval  =100;	

int 		    AFlev_n              =0;

int 		    RFlev_n              =255;

int 		    PBTH_n               =128;
int 		    PBTL_n               =128;

int 		    CWSPEED_n            =0;
int          APFsw                =0;
int          APFlev_n             =0;  
	
int          TXPWR_n              =0;
int          TXPWR_tune           =10;

int   		 RTTY_TPFsw_n         =0;
int          RTTY_KPsw_n          =0;
int          RTTY_MFsw_n          =2;
int          RTTY_SHsw_n          =0;
int          RTTY_RXDECsw_n       =0;

int 		    MIClev_n             =0;
int          COMPsw               =0;
int 		    COMPlev_n            =0;

int          TXSSBbw_n            =0;
int          TXSSBbw_wilo_n       =0;
int          TXSSBbw_wihi_n       =3;
int          TXSSBbw_milo_n       =0;
int          TXSSBbw_mihi_n       =3;
int          TXSSBbw_nalo_n       =0;
int          TXSSBbw_nahi_n       =3;

char         MEMtxt_s[100]        =""; 

int          CMD_Conf             =0;
int 		    CMD_Del              =5;              
//-----------------------------------------------------------------------------
const char   RadAdds_s[7][7]      ={">SF="  ,">OF=" ,
                                    ">FI="  ,">ATT=",
                                    ">PAMP=",">DUP=",
                                    ">TXT="};
//-----------------------------------------------------------------------------
int			 ScLiInd              =0,
             ScLiNum              =0;

int			 ScOpMo               =0,
             ScOpMoFrFile         =0,
             ScStopMo             =0, 
             ScIsRu               =0,
             ScIsSta              =0,
             ScIsSto              =0,
             ScIsResta            =0;

char         ScLoF_s[RStrLf]	    ="144.400,000",
             ScHiF_s[RStrLf]      ="145.975,000";
unsigned int ScLoF_n              =0,
			    ScHiF_n              =0;

char		    ScStepDel_s[6]		 ="20",
			    ScM2Del_s[6]         ="1000",
             ScM3Lev_s[6]         ="100";
int			 ScStepDel_n          =20,
			    ScM2Del_n            =1000,
             ScM3Lev_n            =100;

char         ScStr1[200]          ="",
             ScStr2[200]          ="",
             ScTime1[30]          ="",
             ScTime2[30]          ="";

int 		    ScWrSpec             =0,
             ScLtSpec             =0;

char         F_ScMScanFi[Fl]      ="EXAMPLE.FRE",
             F_ScLibFi[Fl]        ="EXAMPLE.LIB";   
             
TScan ScAr;
//CW+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char         CWStr    [500]       ="test de df9zo",
             CWStr_ini[8][500]    ={"df9zo",
                                    "cfm 5nn ur 5nn 73",
                                    "de df9zo cfm 5nn ur 5nn 73",
                                    "",
                                    "",
                                    "",
                                    "",
                                    "test de df9zo"};

int          CW_Pitch             =700,
             CW_PitchMin          =CW_Pitch-300, 
             CW_PitchMax          =CW_Pitch+300,

             CW_Speed             =35,
             CW_SpeedMin          =20, //Duration of DOT high speed 
             CW_SpeedMax          =200,//Duration of DOT low  speed 

             CW_DOT,
             CW_DASH,
             CW_B_CHARCOMP,
             CW_B_CHAR, 
             CW_B_WORD,

             CW_TXing             =0,
             CW_SpeedTest         =0; 

int          CW_Chars_CHAR[]      ={'A','B','C','D','E',//04
                                    'F','G','H','I','J',//09
                                    'K','L','M','N','O',//14
                                    'P','Q','R','S','T',//19
                                    'U','V','W','X','Y',//24
                                    'Z',                //25

                                    '0','1','2','3','4',//30
                                    '5','6','7','8','9',//35

                                    '.','=','/','?',    //39
                                    '*',                //40 Error

                                    ',',':',';','-','(',//45
                                    ')',                //46
                                    
                                    '+',                //47 End of message
                                    '#',                //48 End of work
                                    ' ',                //49 Leerschritt
                                    };                  //   Ende Array
char         CW_Chars_CW[50][10]  ={".-"      ,"-..."  ,"-.-."  ,"-.."   ,"."    ,//04 A B C D E
                                    "..-."    ,"--."   ,"...."  ,".."    ,".---" ,//09 F G H I J
                                    "-.-"     ,".-.."  ,"--"    ,"-."    ,"---"  ,//14 K L M N O
                                    ".--."    ,"--.-"  ,".-."   ,"..."   ,"-"    ,//19 P Q R S T
                                    "..-"     ,"...-"  ,".--"   ,"-..-"  ,"-.--" ,//24 U V W X Y
                                    "--.."    ,                                   //25 Z

                                    "-----"   ,".----" ,"..---" ,"...--" ,"....-",//30 0 1 2 3 4
                                    "....."   ,"-...." ,"--..." ,"---.." ,"----.",//35 5 6 7 8 9

                                    ".-.-.-"  ,"-...-" ,"-..-." ,"..--..",        //39 . = / ?
                                    "........",                                   //40 Error *
                                     
                                    "--..--"  ,"---...","-.-.-.","-....-","-.--.",//45 , : ; - (
                                    "-.--.-",                                     //46 )

                                    ".-.-."   ,                                   //47 End of message +                            
                                    "...-.-"  ,                                   //48 End of work    #
                                    " "};                                         //49 Leerschritt

char         CW_KbStr[200]        ="";
//Messages+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char         msg00[]              ="Feature NOT implemented",
             msg01[]			       ="Memory operations done",
             msg02[]			       ="Close Remote-/Scan-Dialog first",
     		    msg03[]			       ="ERROR\n\n"
                                   "- Radio does not respond\n"
                                   "- Radio not equipped with this function\n\n",
             msg04[]			       ="ERROR\n\n"
                                   "Feature ONLY for Radios with Datalength=5",
             msg05[]			       ="ERROR\n\n"
                                   "Feature ONLY for Radios with DSP-Filters",
             msg06[]              ="OLE initialization failed"
                                   "Make sure that the OLE libraries are the correct version",
             msg07[]              ="Windows sockets initialization failed",
             //-----------------     
     		    scmsg00[]			    ="Select SCAN, M-SCAN or load a Library",
     		    scmsg01[]			    ="ERROR M-Scan/Library:\n\n"
                                   "No/Bad File selected\n",
     		    scmsg02[]			    ="ERROR Scan:\n\n"
                                   "- LoF >= HiF\n"
                                   "- LoF or HiF out of range of radio\n"
                                   "- Too many scan steps\n"
                                   "  (Enlarge display to the right)\n"
                                   "- Wrong parameter format",
     		    scmsg03[]			    ="ERROR M-Scan:\n\n"
                                   "- No/Bad File\n"
                                   "- Frequencies out of range of radio\n"
                                   "- Too many scan steps\n"
                                   "  (Enlarge display to the right)\n"
                                   "- Wrong parameter format\n\n"
                                   "->Items with bad parameters modified/deleted",
             //-----------------     
     		    commsg00[]			    ="Selected COM-Port is NOT available",             
             //-----------------
             statmsg00[]          ="Ready",
             statmsg01[]          ="Configuration of Radio ",
             statmsg02[]          ="Configure/Select a Radio",
             statmsg03[]          ="Selected Radio: ",
             //ICOM CI-V - Bus--
       		 IB_msg00[]			    ="ICOM-Message",
     		    IB_msg01[]			    ="Collision on ICOM-Bus",
     		    IB_msg02[]			    ="Data OK",
             IB_msg03[]			    ="Data NOT OK",
             IB_msg04[]			    ="ERROR: Radio OFF/NOT equipped with this function";
//INI-File+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char         defini01[]           ="WinX",
             defini02[]           ="WinY",
             defini03[]           ="WinW",
             defini04[]           ="WinH",
             defini05[]           ="Radio_Selection",
             defini06[]           ="COM_Poll_Mode",
             defini07[]           ="COM_Poll_Interval",
             defini08[]           ="SQLSM_Poll_Mode",
             defini09[]           ="SQLSM_Poll_Interval",        
             defini10[]           ="Radio_TUNE-PWR",
             defini11[]           ="CmdDel",
             defini12[]           ="CmdConf",
             defini13[]           ="SF_SSB",
             defini14[]           ="SF_FM",
             defini15[]           ="SF_FMW",
             defini16[]           ="SF_AM",
             defini17[]           ="SF_DATA",
             defini18[]           ="CW_Speed",
             defini19[]           ="CW_Pitch",     
             defini20[]           ="CW_Str";

int R_IniFile(void)
{
 TaIniLib li;
 char     str[500],indstr[15];
 int      r,x,y;

 r=li.ReadList(F_Env);if (r == 0) return 0;//File nicht vorhanden
 //defini------------------------------------------
 li.Rint(defini01,Win_X              );
 li.Rint(defini02,Win_Y              );
 li.Rint(defini03,Win_W              );
 li.Rint(defini04,Win_H              );
 
 li.Rint(defini05,Radio_Num          );
 li.Rint(defini06,COM_Poll_Mode      );
 li.Rint(defini07,COM_Poll_Interval  );
 li.Rint(defini08,SQLSM_Poll_Mode    );
 li.Rint(defini09,SQLSM_Poll_Interval);
 li.Rint(defini10,TXPWR_tune         );
 li.Rint(defini11,CMD_Del            );
 li.Rint(defini12,CMD_Conf           );

 li.Rstr(defini13,SF_SSB_s           );
 li.Rstr(defini14,SF_FM_s            );
 li.Rstr(defini15,SF_FMW_s           );
 li.Rstr(defini16,SF_AM_s            );
 li.Rstr(defini17,SF_DATA_s          );
 
 li.Rint(defini18,CW_Speed           );
 li.Rint(defini19,CW_Pitch           );
 for (x=0;x < 8;x++)
  {
   indstr[0]=0;itoa(x,indstr,10);
   strcpy(str,defini20);strcat(str,indstr);
   li.Rstr(str,CWStr_ini[x]);
  }
 //radini------------------------------------------
 for (x=0;x < IBRad_Max;x++)
  {
   _itoa(x,indstr,10);strcat(indstr,"_");

   strcpy(str,indstr);strcat(str,IBRad_ini01);li.Rstr(str,RADIOS[x].Name        );

   strcpy(str,indstr);strcat(str,IBRad_ini02);li.Rstr(str,RADIOS[x].IB_Adr_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini03);li.Rint(str,RADIOS[x].IB_Da_n     );

   strcpy(str,indstr);strcat(str,IBRad_ini04);li.Rint(str,RADIOS[x].COMport     );
   strcpy(str,indstr);strcat(str,IBRad_ini05);li.Rint(str,RADIOS[x].COMbaud     );
   strcpy(str,indstr);strcat(str,IBRad_ini06);li.Rint(str,RADIOS[x].COMdata     );
   strcpy(str,indstr);strcat(str,IBRad_ini07);li.Rint(str,RADIOS[x].COMpari     );
   strcpy(str,indstr);strcat(str,IBRad_ini08);li.Rint(str,RADIOS[x].COMstop     );
   strcpy(str,indstr);strcat(str,IBRad_ini09);li.Rint(str,RADIOS[x].COMprot     );

   strcpy(str,indstr);strcat(str,IBRad_ini10);li.Rstr(str,RADIOS[x].Fdef_s      );
   strcpy(str,indstr);strcat(str,IBRad_ini11);li.Rstr(str,RADIOS[x].Fmin_s      );
   strcpy(str,indstr);strcat(str,IBRad_ini12);li.Rstr(str,RADIOS[x].Fmax_s      );
   strcpy(str,indstr);strcat(str,IBRad_ini13);li.Rstr(str,RADIOS[x].SmConv_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini14);li.Rint(str,RADIOS[x].SQL_SwHw    );   
   strcpy(str,indstr);strcat(str,IBRad_ini15);li.Rint(str,RADIOS[x].FI_SwHw     );
   strcpy(str,indstr);strcat(str,IBRad_ini16);li.Rint(str,RADIOS[x].ANTmax      );
   strcpy(str,indstr);strcat(str,IBRad_ini17);li.Rint(str,RADIOS[x].ATTmax      );
   strcpy(str,indstr);strcat(str,IBRad_ini18);li.Rint(str,RADIOS[x].PAMPmax     );
   strcpy(str,indstr);strcat(str,IBRad_ini19);li.Rint(str,RADIOS[x].MICgain     );
   strcpy(str,indstr);strcat(str,IBRad_ini20);li.Rint(str,RADIOS[x].COMPlev     );
   strcpy(str,indstr);strcat(str,IBRad_ini44);li.Rint(str,RADIOS[x].RoofFi_n    );

   strcpy(str,indstr);strcat(str,IBRad_ini21);li.Rstr(str,RADIOS[x].RE_Fact_s   );
   strcpy(str,indstr);strcat(str,IBRad_ini22);li.Rstr(str,RADIOS[x].RE_SFact_s  );
   strcpy(str,indstr);strcat(str,IBRad_ini23);li.Rstr(str,RADIOS[x].RE_OFact_s  );
   strcpy(str,indstr);strcat(str,IBRad_ini24);li.Rint(str,RADIOS[x].RE_Mact_n   );
   strcpy(str,indstr);strcat(str,IBRad_ini25);li.Rint(str,RADIOS[x].RE_FIact_n  );

   strcpy(str,indstr);strcat(str,IBRad_ini26);li.Rstr(str,RADIOS[x].SC_LoF_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini27);li.Rstr(str,RADIOS[x].SC_HiF_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini28);li.Rstr(str,RADIOS[x].SC_SFact_s  );
   strcpy(str,indstr);strcat(str,IBRad_ini29);li.Rint(str,RADIOS[x].SC_Mact_n   );
   strcpy(str,indstr);strcat(str,IBRad_ini30);li.Rint(str,RADIOS[x].SC_FIact_n  );
   strcpy(str,indstr);strcat(str,IBRad_ini31);li.Rint(str,RADIOS[x].SC_StepDel  );
   strcpy(str,indstr);strcat(str,IBRad_ini32);li.Rint(str,RADIOS[x].SC_StopMo   );
   strcpy(str,indstr);strcat(str,IBRad_ini33);li.Rint(str,RADIOS[x].SC_M2Del    );
   strcpy(str,indstr);strcat(str,IBRad_ini34);li.Rint(str,RADIOS[x].SC_M3Lev    );
   strcpy(str,indstr);strcat(str,IBRad_ini35);li.Rint(str,RADIOS[x].SC_WrSpec   );
   strcpy(str,indstr);strcat(str,IBRad_ini36);li.Rint(str,RADIOS[x].SC_LtSpec   );

   strcpy(str,indstr);strcat(str,IBRad_ini37);li.Rint(str,RADIOS[x].TXSSBbw     );
   strcpy(str,indstr);strcat(str,IBRad_ini38);li.Rint(str,RADIOS[x].TXSSBbw_wilo);
   strcpy(str,indstr);strcat(str,IBRad_ini39);li.Rint(str,RADIOS[x].TXSSBbw_wihi);
   strcpy(str,indstr);strcat(str,IBRad_ini40);li.Rint(str,RADIOS[x].TXSSBbw_milo);
   strcpy(str,indstr);strcat(str,IBRad_ini41);li.Rint(str,RADIOS[x].TXSSBbw_mihi);
   strcpy(str,indstr);strcat(str,IBRad_ini42);li.Rint(str,RADIOS[x].TXSSBbw_nalo);
   strcpy(str,indstr);strcat(str,IBRad_ini43);li.Rint(str,RADIOS[x].TXSSBbw_nahi);

   for (y=0;y < 18;y++)
    {
     strcpy(str,indstr);strcat(str,IBRad_FI_HW_ini[y]);
     li.Rstr(str,RADIOS[x].IB_FI_HW_s[y]);
     if (RADIOS[x].IB_FI_HW_s[y][0] == '-') RADIOS[x].IB_FI_HW_s[y][0]='\0';
    }
   for (y=0;y < 60;y++)
    {
     strcpy(str,indstr);strcat(str,IBRad_FI_SW_ini[y]);     
     li.Rstr(str,RADIOS[x].IB_FI_SW_s[y]);
     if (RADIOS[x].IB_FI_SW_s[y][0] == '-') RADIOS[x].IB_FI_SW_s[y][0]='\0';
    }
  }
 //------------------------------------------------
 return 1;
}
//-----------------------------------------------------------------------------
int W_IniFile(void)
{
 TaIniLib li;
 char     str[500],indstr[15],radstr[15]="[RADIO_";
 int      x,y;
 //defini------------------------------------------
 li.AppStr("[WINDOWS******************]"); 
 li.Wint(defini01,Win_X              );
 li.Wint(defini02,Win_Y              );
 li.Wint(defini03,Win_W              );
 li.Wint(defini04,Win_H              ); 
 li.AppStr("[RADIO-Settings***********]");            
 li.Wint(defini05,Radio_Num          );
 li.Wint(defini06,COM_Poll_Mode      );
 li.Wint(defini07,COM_Poll_Interval  );
 li.Wint(defini08,SQLSM_Poll_Mode    );
 li.Wint(defini09,SQLSM_Poll_Interval);
 li.Wint(defini10,TXPWR_tune         );
 li.Wint(defini11,CMD_Del            );
 li.Wint(defini12,CMD_Conf           );

 li.Wstr(defini13,SF_SSB_s           );
 li.Wstr(defini14,SF_FM_s            );
 li.Wstr(defini15,SF_FMW_s           );
 li.Wstr(defini16,SF_AM_s            );
 li.Wstr(defini17,SF_DATA_s          );  
 li.AppStr("[CW-Settings**************]");            
 li.Wint(defini18,CW_Speed           );
 li.Wint(defini19,CW_Pitch           );
 for (x=0;x < 8;x++)
  {
   indstr[0]=0;itoa(x,indstr,10);
   strcpy(str,defini20);
   strcat(str,indstr);
   li.Wstr(str,CWStr_ini[x]);
  }
 //radini------------------------------------------
 li.AppStr("[Radios (ICOM CI-V)*******]");
 for (x=0;x < IBRad_Max;x++)
  {
   _itoa(x,indstr,10);

   strcpy(str,radstr);strcat(str,indstr);strcat(str,"]");
   li.AppStr(str); 
   
   strcat(indstr,"_");

   strcpy(str,indstr);strcat(str,IBRad_ini01);li.Wstr(str,RADIOS[x].Name        );

   strcpy(str,indstr);strcat(str,IBRad_ini02);li.Wstr(str,RADIOS[x].IB_Adr_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini03);li.Wint(str,RADIOS[x].IB_Da_n     );

   strcpy(str,indstr);strcat(str,IBRad_ini04);li.Wint(str,RADIOS[x].COMport     );
   strcpy(str,indstr);strcat(str,IBRad_ini05);li.Wint(str,RADIOS[x].COMbaud     );
   strcpy(str,indstr);strcat(str,IBRad_ini06);li.Wint(str,RADIOS[x].COMdata     );
   strcpy(str,indstr);strcat(str,IBRad_ini07);li.Wint(str,RADIOS[x].COMpari     );
   strcpy(str,indstr);strcat(str,IBRad_ini08);li.Wint(str,RADIOS[x].COMstop     );
   strcpy(str,indstr);strcat(str,IBRad_ini09);li.Wint(str,RADIOS[x].COMprot     );

   strcpy(str,indstr);strcat(str,IBRad_ini10);li.Wstr(str,RADIOS[x].Fdef_s      );
   strcpy(str,indstr);strcat(str,IBRad_ini11);li.Wstr(str,RADIOS[x].Fmin_s      );
   strcpy(str,indstr);strcat(str,IBRad_ini12);li.Wstr(str,RADIOS[x].Fmax_s      );
   strcpy(str,indstr);strcat(str,IBRad_ini13);li.Wstr(str,RADIOS[x].SmConv_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini14);li.Wint(str,RADIOS[x].SQL_SwHw    );
   strcpy(str,indstr);strcat(str,IBRad_ini15);li.Wint(str,RADIOS[x].FI_SwHw     );
   strcpy(str,indstr);strcat(str,IBRad_ini16);li.Wint(str,RADIOS[x].ANTmax      );
   strcpy(str,indstr);strcat(str,IBRad_ini17);li.Wint(str,RADIOS[x].ATTmax      );
   strcpy(str,indstr);strcat(str,IBRad_ini18);li.Wint(str,RADIOS[x].PAMPmax     );
   strcpy(str,indstr);strcat(str,IBRad_ini19);li.Wint(str,RADIOS[x].MICgain     );
   strcpy(str,indstr);strcat(str,IBRad_ini20);li.Wint(str,RADIOS[x].COMPlev     );
   strcpy(str,indstr);strcat(str,IBRad_ini44);li.Wint(str,RADIOS[x].RoofFi_n    );

   strcpy(str,indstr);strcat(str,IBRad_ini21);li.Wstr(str,RADIOS[x].RE_Fact_s   );
   strcpy(str,indstr);strcat(str,IBRad_ini22);li.Wstr(str,RADIOS[x].RE_SFact_s  );
   strcpy(str,indstr);strcat(str,IBRad_ini23);li.Wstr(str,RADIOS[x].RE_OFact_s  );
   strcpy(str,indstr);strcat(str,IBRad_ini24);li.Wint(str,RADIOS[x].RE_Mact_n   );
   strcpy(str,indstr);strcat(str,IBRad_ini25);li.Wint(str,RADIOS[x].RE_FIact_n  );

   strcpy(str,indstr);strcat(str,IBRad_ini26);li.Wstr(str,RADIOS[x].SC_LoF_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini27);li.Wstr(str,RADIOS[x].SC_HiF_s    );
   strcpy(str,indstr);strcat(str,IBRad_ini28);li.Wstr(str,RADIOS[x].SC_SFact_s  );
   strcpy(str,indstr);strcat(str,IBRad_ini29);li.Wint(str,RADIOS[x].SC_Mact_n   );
   strcpy(str,indstr);strcat(str,IBRad_ini30);li.Wint(str,RADIOS[x].SC_FIact_n  );
   strcpy(str,indstr);strcat(str,IBRad_ini31);li.Wint(str,RADIOS[x].SC_StepDel  );
   strcpy(str,indstr);strcat(str,IBRad_ini32);li.Wint(str,RADIOS[x].SC_StopMo   );
   strcpy(str,indstr);strcat(str,IBRad_ini33);li.Wint(str,RADIOS[x].SC_M2Del    );
   strcpy(str,indstr);strcat(str,IBRad_ini34);li.Wint(str,RADIOS[x].SC_M3Lev    );
   strcpy(str,indstr);strcat(str,IBRad_ini35);li.Wint(str,RADIOS[x].SC_WrSpec   );
   strcpy(str,indstr);strcat(str,IBRad_ini36);li.Wint(str,RADIOS[x].SC_LtSpec   );

   strcpy(str,indstr);strcat(str,IBRad_ini37);li.Wint(str,RADIOS[x].TXSSBbw     );
   strcpy(str,indstr);strcat(str,IBRad_ini38);li.Wint(str,RADIOS[x].TXSSBbw_wilo);
   strcpy(str,indstr);strcat(str,IBRad_ini39);li.Wint(str,RADIOS[x].TXSSBbw_wihi);
   strcpy(str,indstr);strcat(str,IBRad_ini40);li.Wint(str,RADIOS[x].TXSSBbw_milo);
   strcpy(str,indstr);strcat(str,IBRad_ini41);li.Wint(str,RADIOS[x].TXSSBbw_mihi);
   strcpy(str,indstr);strcat(str,IBRad_ini42);li.Wint(str,RADIOS[x].TXSSBbw_nalo);
   strcpy(str,indstr);strcat(str,IBRad_ini43);li.Wint(str,RADIOS[x].TXSSBbw_nahi);

   for (y=0;y < 18;y++)
    {
     strcpy(str,indstr);strcat(str,IBRad_FI_HW_ini[y]);
     if (RADIOS[x].IB_FI_HW_s[y][0] == '\0') li.Wstr(str,"-\0");
        else li.Wstr(str,RADIOS[x].IB_FI_HW_s[y]);
    }
   for (y=0;y < 60;y++)
    {
     strcpy(str,indstr);strcat(str,IBRad_FI_SW_ini[y]);
     if (RADIOS[x].IB_FI_SW_s[y][0] == '\0') li.Wstr(str,"-\0");
        else li.Wstr(str,RADIOS[x].IB_FI_SW_s[y]);
    }
  }
 //------------------------------------------------ 
 li.WriteList(F_Env);
 return 1;
}
//SCAN-LIB+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char         scini01[]			    ="OpMode",
             scini02[]			    ="LoF",
             scini03[]			    ="HiF",
             scini04[]			    ="Fstep",
             scini05[]			    ="M",
             scini06[]			    ="FI",
             scini07[]			    ="StepDel",
             scini08[]			    ="StopMode",
             scini09[]			    ="M2Del",
             scini10[]			    ="M3Lev",
             scini11[]			    ="WrSpec",
             scini12[]			    ="LtSpec";

int R_ScanLib(char *FName)
{
 TaIniLib li;
 char     indstr[20],str[50],tmpstr[6],tre=';';
 int      x,pos;

 x=li.ReadList(FName);if (x == 0) return 0;//File nicht vorhanden
 //---------------------------------
 li.Rint(scini01,ScOpMoFrFile);
 li.Rstr(scini02,ScLoF_s     );
 li.Rstr(scini03,ScHiF_s     );
 li.Rstr(scini04,SFact_s     );
 li.Rint(scini05,Mact_n      );
 li.Rstr(scini06,FIact_s     );
 li.Rint(scini07,ScStepDel_n );
 li.Rint(scini08,ScStopMo    );
 li.Rint(scini09,ScM2Del_n   );
 li.Rint(scini10,ScM3Lev_n   );
 li.Rint(scini11,ScWrSpec    );
 li.Rint(scini12,ScLtSpec    );
 //-----------------------
 ScLiNum=0;
 for (x=0;x<ScLiMax+1;x++)
  {
   if (x == ScLiMax-1) break;
   _itoa(x,indstr,10);StrFiLe(indstr,'0',3);//strcat(indstr,"_val");   
   li.Rstr(indstr,str);if (str[0] == tre) break;
   //------------
   pos=StrStartToTok(str,ScAr.f[x],tre,0);
   pos=StrStartToTok(str,tmpstr,tre,pos+1);ScAr.m[x]=atoi(tmpstr);
   pos=StrStartToTok(str,tmpstr,tre,pos+1);ScAr.y[x]=atoi(tmpstr);
   //------------
   ScLiNum++;
  }
 //---------------------------------
 return 1;
}  

int W_ScanLib(char *FName)
{
 TaIniLib li;
 char     indstr[20],str[30],substr[10],tre[2]=";";
 int      x;
 //---------------------------------
 if (ScOpMo == 1) x=1;//SCAN
 if (ScOpMo == 2) x=2;//M-SCAN
 if (ScOpMo == 3)     //LIB
  {
   if (ScOpMoFrFile == 1) x=1;//scan in lib
   if (ScOpMoFrFile == 2) x=2;//m-scan in lib
  }
 li.Wint(scini01,x);
 li.Wstr(scini02,ScLoF_s    );
 li.Wstr(scini03,ScHiF_s    );
 li.Wstr(scini04,SFact_s    );
 li.Wint(scini05,Mact_n     );
 li.Wstr(scini06,FIact_s    );
 li.Wint(scini07,ScStepDel_n);
 li.Wint(scini08,ScStopMo   );
 li.Wint(scini09,ScM2Del_n  );
 li.Wint(scini10,ScM3Lev_n  );
 li.Wint(scini11,ScWrSpec   );
 li.Wint(scini12,ScLtSpec   );
 //-----------------------
 for (x=0;x<ScLiMax;x++)
  {
   _itoa(x,indstr,10);StrFiLe(indstr,'0',3);//strcat(indstr,"_val");   
   if (ScAr.f[x][0] == '\0' || x == ScLiMax-1) {li.Wstr(indstr,tre);break;}  
   strcpy(str,ScAr.f[x]);strcat(str,tre);
   _itoa(ScAr.m[x],substr,10);strcat(str,substr);strcat(str,tre);
   _itoa(ScAr.y[x],substr,10);strcat(str,substr);strcat(str,tre);
   li.Wstr(indstr,str);
  }
 //---------------------------------
 li.WriteList(FName);
 return 1;
}
//SMC-File+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char         smcini01[]           ="S1",
             smcini02[]           ="S2",
             smcini03[]           ="S3",
             smcini04[]           ="S4",
             smcini05[]           ="S5",
             smcini06[]           ="S6",
             smcini07[]           ="S7",
             smcini08[]           ="S8",
             smcini09[]           ="S9",
             smcini10[]           ="S9_10",
             smcini11[]           ="S9_20",
             smcini12[]           ="S9_30",
             smcini13[]           ="S9_40",
             smcini14[]           ="S9_50",
             smcini15[]           ="S9_60";

int R_SMCFile(char *FName)
{
 TaIniLib li;
 int      x;

 x=li.ReadList(FName);if (x == 0) return 0;//File nicht vorhanden
 //---------------------------------
 li.Rint(smcini01,SM_li_n[ 0]);
 li.Rint(smcini02,SM_li_n[ 1]);
 li.Rint(smcini03,SM_li_n[ 2]);
 li.Rint(smcini04,SM_li_n[ 3]);
 li.Rint(smcini05,SM_li_n[ 4]);
 li.Rint(smcini06,SM_li_n[ 5]);
 li.Rint(smcini07,SM_li_n[ 6]);
 li.Rint(smcini08,SM_li_n[ 7]);
 li.Rint(smcini09,SM_li_n[ 8]);
 li.Rint(smcini10,SM_li_n[ 9]);
 li.Rint(smcini11,SM_li_n[10]);
 li.Rint(smcini12,SM_li_n[11]);
 li.Rint(smcini13,SM_li_n[12]);
 li.Rint(smcini14,SM_li_n[13]);
 li.Rint(smcini15,SM_li_n[14]);
 //---------------------------------
 return 1;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//Dialogs + Wins+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
TaMsgWin* _TaMsgWin_=0;
//TaInpDlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
TaInpDlg::TaInpDlg(CWnd* pParent)
	     :CDialog(TaInpDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TaInpDlg)
	m_strEdit = "";
	//}}AFX_DATA_INIT
}

void TaInpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TaInpDlg)
	DDX_Text(pDX, IDC_TAINPDLG_EDIT, m_strEdit);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(TaInpDlg,CDialog)
	//{{AFX_MSG_MAP(TaInpDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL TaInpDlg::OnInitDialog() 
{
 CDialog::OnInitDialog();
 SetWindowText(m_strDlgTitle);
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);
 GetDlgItem(IDC_TAINPDLG_STATIC1)->SetWindowText(m_strStatic1);
 GetDlgItem(IDC_TAINPDLG_STATIC2)->SetWindowText(m_strStatic2);
 ((CEdit*)GetDlgItem(IDC_TAINPDLG_EDIT))->SetLimitText(StrLim);
 ((CEdit*)GetDlgItem(IDC_TAINPDLG_EDIT))->SetSel(0,-1);
 GetDlgItem(IDC_TAINPDLG_EDIT)->SetFocus();	
 return FALSE;// return TRUE unless you set the focus to a control
	           // EXCEPTION: OCX Property Pages should return FALSE 
}
//-----------------------------------------------------------------------------
int MyInpDlg(CWnd* parent,char* title,char* msg1,char* msg2,
                          char* inp,int lim)
{
 int le;

 TaInpDlg dlg(parent);
 dlg.m_strDlgTitle=title;
 dlg.m_strStatic1=msg1;
 dlg.m_strStatic2=msg2;
 dlg.StrLim=lim;
 le=(int)strlen(inp);if (le > lim) inp[lim]=0;
 dlg.m_strEdit=inp;
 if (dlg.DoModal() == IDOK)
  {
   strcpy(inp,LPCTSTR(dlg.m_strEdit));	 
   return IDOK;
  }else return IDCANCEL;
}

int MyInpDlg(CWnd* parent,CString& title,CString& msg1,CString& msg2,
             CString& inp,int lim)
{
 int le;

 TaInpDlg dlg(parent);
 dlg.m_strDlgTitle=title;
 dlg.m_strStatic1=msg1;
 dlg.m_strStatic2=msg2;
 dlg.StrLim=lim;
 le=inp.GetLength();if (le > lim) inp.Right(le-lim);
 dlg.m_strEdit=inp;
 if (dlg.DoModal() == IDOK)
  {
   inp=dlg.m_strEdit;	 
   return IDOK;
  }else return IDCANCEL;
}
//TaStatBar++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
TaStatBar::TaStatBar() {}

TaStatBar::~TaStatBar() {}

LRESULT TaStatBar::OnSetText(WPARAM wParam, LPARAM lParam)
{
 int bIgnoreSetText=1;

 if ( !bIgnoreSetText ) return CStatusBar::OnSetText( wParam, lParam );
 return 0; 
/*
void CMainWindow::UpDateStatusBar()
{
 m_wndStatusBar.SetPaneText(0,StatStr);	!!!
}

Die WM_SETTEXT-Nachrichten des Anwendungsgersts werden blockiert, 
bei bIgnoreSetText=1, sonst durchgelassen. 
Die Blockade betrifft nur den ersten Statusleistenabschnitt !!!
*/
}

BEGIN_MESSAGE_MAP(TaStatBar, CStatusBar)
	//{{AFX_MSG_MAP(TaStatBar)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
ON_MESSAGE( WM_SETTEXT,OnSetText)
END_MESSAGE_MAP()
//TaMsgWin+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNCREATE(TaMsgWin, CFrameWnd)

TaMsgWin::TaMsgWin() {}

TaMsgWin::TaMsgWin(CFrameWnd* parent,char* title,char* msgstr)
{
 CFrameWnd();
 paintstr=msgstr;
} 

TaMsgWin::~TaMsgWin() 
{
 _TaMsgWin_=0;
}

BEGIN_MESSAGE_MAP(TaMsgWin, CFrameWnd)
	//{{AFX_MSG_MAP(TaMsgWin)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
void TaMsgWin::OnPaint() 
{
 CPaintDC dc(this);
 CRect rect;
 
 GetClientRect(rect);
 rect.InflateRect(-2,0);
 dc.SetTextAlign(TA_BASELINE | TA_CENTER);
 dc.TextOut(rect.right/2,rect.bottom/2,paintstr);
}
//-----------------------------------------------------------------------------
void MyMsgWin(CFrameWnd* parent,char* title,char* msgstr,
              int delay,int X,int Y,int W,int H)
{
 CRect rect; 
 
 if (_TaMsgWin_ != 0) return;
 rect.left=X;rect.top=Y;rect.right=W;rect.bottom=H; 
 _TaMsgWin_=new TaMsgWin(parent,title,msgstr);
 _TaMsgWin_->Create(NULL,title,WS_OVERLAPPED,rect,parent,NULL,0,NULL);
 _TaMsgWin_->ShowWindow(SW_SHOW);
 VDelay(delay);
 if (_TaMsgWin_ != 0) _TaMsgWin_->DestroyWindow();
 _TaMsgWin_=0;
}
//TaMsgBox+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int TaMsgBox(char *titlestr,char *msgstr,int mode)
{
 int style;
 int res;

 switch (mode)
  {
   case 1: style=MB_OK       | MB_TASKMODAL;break;
   case 2: style=MB_OK       | MB_ICONINFORMATION | MB_TASKMODAL;break;
   case 3: style=MB_OK       | MB_ICONSTOP   	  | MB_TASKMODAL;break;
   case 4: style=MB_OKCANCEL | MB_ICONINFORMATION | MB_TASKMODAL;break;
   case 5: style=MB_YESNO    | MB_ICONQUESTION	  | MB_TASKMODAL;break;
   default:style=MB_OK       | MB_TASKMODAL;
  }
 res=MessageBox(AfxGetApp()->GetMainWnd()->m_hWnd,msgstr,titlestr,style);
 return res;
}

int TaMsgBox(CString& titlestr,CString& msgstr,int mode)
{
 int style;
 int res;

 switch (mode)
  {
   case 1: style=MB_OK       | MB_TASKMODAL;break;
   case 2: style=MB_OK       | MB_ICONINFORMATION | MB_TASKMODAL;break;
   case 3: style=MB_OK       | MB_ICONSTOP   	  | MB_TASKMODAL;break;
   case 4: style=MB_OKCANCEL | MB_ICONINFORMATION | MB_TASKMODAL;break;
   case 5: style=MB_YESNO    | MB_ICONQUESTION	  | MB_TASKMODAL;break;
   default:style=MB_OK       | MB_TASKMODAL;
  }
 res=MessageBox(AfxGetApp()->GetMainWnd()->m_hWnd,msgstr,titlestr,style);
 return res;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
