// R_STRDIV.H : Manipulation von Strings + Div. Funktionen
// G. TAMM, DF9ZO 2003
//--------------------
#pragma once
#include "stdafx.h"
//--------------------
// Disable warning C4996: Unsafe strcpy, strcat etc.
#pragma warning(disable : 4996)
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN FUER EINZELNE CHARACTER + STRINGS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char ChIsPu(char ch);
// 1, wenn ch = '.', sonst 0
//-----------------------------------------------------------------------------
char ChIsKo(char ch);
// 1, wenn ch = ',', sonst 0
//-----------------------------------------------------------------------------
char ChDo(char ch);
// A..Z -> a..z + Selbstlaute
//-----------------------------------------------------------------------------
char ChUp(char ch);
// a..z -> A..Z + Selbstlaute
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN FUER STRINGS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char* StrDo(char* dest,const char* str);
// Wandelt String in Kleinbuchstaben, benutzt ChDo
//-----------------------------------------------------------------------------
char* StrUp(char* dest,const char* str);
// Wandelt String in Grobuchstaben, benutzt ChUp
//-----------------------------------------------------------------------------
int StrCmp(const char *s1,const char *s2);
// Ergebnis:
//  <  0      wenn   s1 <  s2
//  == 0      wenn   s1 == s2
//  >  0      wenn   s1 >  s2
//-----------------------------------------------------------------------------
char* StrCopy(char* dest,const char* str,int index,int count);
// Kopiert ab index count Zeichen aus str nach dest
// Ist index > Laenge von str, ist dest ein Nullstring
// Ist index+count > Laenge von str, wird am Ende v. str gestoppt
//-----------------------------------------------------------------------------
int StrCopyStartToCh(char* dest,const char* str,int start,char stopch);
// Kopiert ab start bis zum ersten Auftreten von stopch oder \0
// alle Zeichen in dest
// Ist start > Laenge str -> start=0
// Gibt Position stopch oder \0 zurueck
//-----------------------------------------------------------------------------
int StrCopyStartToStr(char* dest,const char* str,int start,char* stopstr);
// Kopiert ab start bis zum ersten Auftreten von stopstr oder \0
// alle Zeichen in dest
// Ist start > Laenge str -> start=0
// Gibt Position stopstr oder \0 zurueck
//-----------------------------------------------------------------------------
int StrChNum(const char *str,char ch);
// Ermittelt in str die Anzahl von ch
//-----------------------------------------------------------------------------
int StrChPos(const char *str,char ch,int start);
// Sucht in str ab start nach erstem Vorkommen von ch
// Ist start > Laenge str -> start=0
// Bei Nichterfolg wird -1 zurueckgegeben, sonst Position
//-----------------------------------------------------------------------------
int StrStrFiPos(const char* str,const char* substr);
// Sucht nach erstem Auftreten von substr in str
// Gross-, Kleinschreibung wird beachtet !
// Bei Nichterfolg wird -1 zurueckgegeben, sonst Position
//-----------------------------------------------------------------------------
int StrStrPosNoC(const char* str,const char* substr);
// Sucht nach erstem Auftreten von substr in str
// Gross-, Kleinschreibung wird NICHT beachtet !
// Bei Nichterfolg wird -1 zurueckgegeben, sonst Position
//-----------------------------------------------------------------------------
int StrStrLaPos(char* str,char* substr);
// Sucht nach letztem Auftreten von substr in str
// Gross-, Kleinschreibung wird beachtet !
// Bei Nichterfolg wird -1 zurueckgegeben, sonst Position
//-----------------------------------------------------------------------------
void StrReplChPos(char* str,char chnew,int pos);
// Ersetzt in str an pos vorhandenen ch durch chnew
//-----------------------------------------------------------------------------
void StrReplAllCh(char* str,char chold,char chnew,int start);
// Ersetzt in str ab start chold durch chnew
//-----------------------------------------------------------------------------
char* StrTrLe(char* str,char ch);
// Entfernt fuehrende ch
//-----------------------------------------------------------------------------
char* StrTrRi(char* str,char ch);
// Entfernt ueberhaengende ch
//-----------------------------------------------------------------------------
char* StrFiLe(char* str,char ch,int newle);
// Fuellt str vorne mit ch auf, bis strlen(str)=newle
//-----------------------------------------------------------------------------
char* StrFiRi(char* str,char ch,int newle);
// Fuellt str hinten mit ch auf, bis strlen(str)=newle
//-----------------------------------------------------------------------------
char* StrDelChPos(char* str,int pos);
// Entfernt in str den ch an pos
//-----------------------------------------------------------------------------
char* StrDelAllCh(char* str,char ch);
// Entfernt in str alle ch
// Einsatz der Funktion lohnt nur bei vielen zu entfernenden ch's
//-----------------------------------------------------------------------------
char* StrDel(char* str,int index,int count);
// Ab index werden count Zeichen aus str geloescht.
// Ist index > Laenge von str -> keine Funktion
// Ist index+count >= Laenge von str -> nur Zeichen vor index bleiben
//-----------------------------------------------------------------------------
char* StrInsChPos(char* str,char ch,int pos);
// Fuegt in str an pos einen ch ein
//-----------------------------------------------------------------------------
char* StrStrIns(char* str,char* substr,int pos);
// Fuegt in str an pos den substr ein
//-----------------------------------------------------------------------------
int StrStartToTok(char* str,char* dest,char tok,int start);
// Kopiert TeilStr ab start bis tok/Stringende
// return=pos von tok, return=-1 tok nicht gefunden/Stringende
// str="1.222;0;58" dest="1.222" -> dest="0" -> dest="58"
//-----------------------------------------------------------------------------
void StrDel_CR_LF(char*    str);
void StrDel_CR_LF(CString& str);
//Entfernt CR + LF im String
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN ZUR UMWANDLUNG STRINGS/ZAHLEN (hex, bin)
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int HexStrToInt(char* str);
// Akzeptiert als Eingabe max. den String str="ffff"
//-----------------------------------------------------------------------------
unsigned long HexStrToUL(char* str);
// Akzeptiert als Eingabe max. den String str="ffffffff"
//-----------------------------------------------------------------------------
char* ByteToHexStr(char* dest,unsigned int num);
// Akzeptiert als Eingabe max. num=255
// dest muss mindestens 3 chars aufnehmen koennen
//-----------------------------------------------------------------------------
char* ULToHexStr(char* dest,unsigned long num);
// Akzeptiert als Eingabe max. num=4.294.967.295 u. ergibt dann "FFFFFFFF"
// dest muss mindestens 9 chars aufnehmen koennen
//-----------------------------------------------------------------------------
char* ULToBinStr(char* dest,unsigned long num,int bit);
// Akzeptiert Input max. num=4.294.967.295 u. ergibt "11..11\0" (32 bit)
// dest muss max. num mindestens 33 chars aufnehmen koennen
// bit (8,16,32) gibt an, wie breit die Ausgabe ist
//-----------------------------------------------------------------------------
unsigned long BinStrToUL(char* str);
// Akzeptiert Input max. str="11..11\0" (32 bit), erg. max. num=4.294.967.295
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
int CStrToInt(CString cstr);
// Wandelt str in int
//-----------------------------------------------------------------------------
unsigned long CStrToLong(CString cstr);
// Wandelt str in unsigned long
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN STRINGS/DATUM
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void GetDateTime(char *dest,int mode);
//Datum u. Zeit als Strings
// mode=1    dd.mm.yy
// mode=2    hh:mm:ss
// mode=3    hh:mm:ss:ms
//
// mode=10   dd.mm.yy/hh:mm:ss UTC
//-----------------------------------------------------------------------------
void AdjDateStr(char *dest);
// 1.1.1998 -> 01.01.1998
//-----------------------------------------------------------------------------
void DateStrToNum(char *datestr,int& danum,int& monum,int& yenum);
// str=01.01.1998 -> daynum=1 , monthnum=1 , yearnum=1998
//-----------------------------------------------------------------------------
void NumToDateStr(char *dest,int danum,int monum,int yenum);
// daynum=1 , monthnum=1 , yearnum=1998 -> dest=01.01.1998
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// SONSTIGE STRING-FUNKTIONEN
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int ASCIINumsToStr(char *str,int *dest);
// "254,254,0,4,0,0,0,0,3,253" -> str[0]=(unsigned char)254; usw.
// Liefert Laenge zurueck
//-----------------------------------------------------------------------------
// CIPAdressCtrl
int  StrToIPAdrCtrl(char* inp, BYTE& ip1,BYTE& ip2,BYTE& ip3,BYTE& ip4);
void IPAdrCtrlToStr(char* dest,BYTE ip1,BYTE ip2,BYTE ip3,BYTE ip4);
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN FUER FILEs + FILENAMEN
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int FiExist(char *fName);
//Prueft, ob File vorhanden: 0=NICHT vorhanden / 1=vorhanden
//-----------------------------------------------------------------------------
void ForceFiExt(char *finame,char *def);
// tamm / tamm. / tamm.xxx -> tamm.def
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// SONSTIGE FUNKTIONEN
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void NBeep(void);
//Normaler Beep
void VBeep(unsigned int freq,unsigned int dur);
//Ton: freq[Hz], dur[ms]
//-----------------------------------------------------------------------------
void KeepWindowsAlive(void);
//-----------------------------------------------------------------------------
void VDelay(unsigned int deltime);
//-----------------------------------------------------------------------------
void ExecNotePad(char *fName);
//Fuehrt Notepad.exe mit fName als Kommandozeile aus
//-----------------------------------------------------------------------------
void IntDeb(int x1,int x2,int x3,int x4);
//Zeigt ints x1-x4 in Messagebox an
void CharDeb(char *x1,char *x2,char *x3,char *x4);
//Zeigt strings x1-x4 in Messagebox an
void TimeDiff(int mode,int start_stop);
//Ermittelt Zeitdifferenz
//mode      =0: Anzeige s,ms / mode=1      : Anzeige ms    
//start_stop=0: Startzeit    / start_stop=1: Endzeit
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++






