// R_STRDIV.CPP : Manipulation von Strings + Div. Funktionen
// G. TAMM, DF9ZO 2003
//--------------------
#include "stdafx.h"
#include "R_STRDIV.H"
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN FUER EINZELNE CHARACTER + STRINGS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char ChIsPu(char ch)
{
 if (ch == '.') return 1;else return 0;
}
//-----------------------------------------------------------------------------
char ChIsKo(char ch)
{
 if (ch == ',') return 1;else return 0;
}
//-----------------------------------------------------------------------------
char ChDo(char ch)
{
 //if (ch >='A' && ch <='Z') ch=ch-'A'+'a';
 switch (ch)
  {
   case 'A':ch='a';break;case 'B':ch='b';break;case 'C':ch='c';break;
   case 'D':ch='d';break;case 'E':ch='e';break;case 'F':ch='f';break;
   case 'G':ch='g';break;case 'H':ch='h';break;case 'I':ch='i';break;
   case 'J':ch='j';break;case 'K':ch='k';break;case 'L':ch='l';break;
   case 'M':ch='m';break;case 'N':ch='n';break;case 'O':ch='o';break;
   case 'P':ch='p';break;case 'Q':ch='q';break;case 'R':ch='r';break;
   case 'S':ch='s';break;case 'T':ch='t';break;case 'U':ch='u';break;
   case 'V':ch='v';break;case 'W':ch='w';break;case 'X':ch='x';break;
   case 'Y':ch='y';break;case 'Z':ch='z';break;
   case '':ch='';break;case '':ch='';break;case '':ch='';break;
   default:break;
  }

 return ch;
}
//-----------------------------------------------------------------------------
char ChUp(char ch)
{
 //if (ch >='a' && ch <='z') ch=ch-'a'+'A';
 switch (ch)
  {
   case 'a':ch='A';break;case 'b':ch='B';break;case 'c':ch='C';break;
   case 'd':ch='D';break;case 'e':ch='E';break;case 'f':ch='F';break;
   case 'g':ch='G';break;case 'h':ch='H';break;case 'i':ch='I';break;
   case 'j':ch='J';break;case 'k':ch='K';break;case 'l':ch='L';break;
   case 'm':ch='M';break;case 'n':ch='N';break;case 'o':ch='O';break;
   case 'p':ch='P';break;case 'q':ch='Q';break;case 'r':ch='R';break;
   case 's':ch='S';break;case 't':ch='T';break;case 'u':ch='U';break;
   case 'v':ch='V';break;case 'w':ch='W';break;case 'x':ch='X';break;
   case 'y':ch='Y';break;case 'z':ch='Z';break;
   case '':ch='';break;case '':ch='';break;case '':ch='';break;
   default:break;
  }

 return ch;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN FUER STRINGS
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char* StrDo(char* dest,const char* str)
{
 int  index=0;

 while (*(str+index) != '\0')
  {
   *(dest+index)=ChDo(*(str+index));
   index++;
  }
 *(dest+index)='\0';

 return dest;
}
//-----------------------------------------------------------------------------
char* StrUp(char* dest,const char* str)
{
 int  index=0;

 while (*(str+index) != '\0')
  {
   *(dest+index)=ChUp(*(str+index));
   index++;
  }
 *(dest+index)='\0';

 return dest;
}
//-----------------------------------------------------------------------------
int StrCmp(const char *s1,const char *s2)
{
 while (*s1 == *s2++)
 if (*s1++ == 0) return (0);
 return (*(unsigned char *)s1 - *(unsigned char *)--s2);
}
//-----------------------------------------------------------------------------
char* StrCopy(char* dest,const char* str,int index,int count)
{
 int le=0,destindex=0;

 while (*(str+le) != '\0') le++;

 *dest='\0';
 if(le == 0 || index < 0 || index > le || count < 1) return dest;

 while (*(str+index) != '\0' && destindex < count)
  {
	*(dest+destindex)=*(str+index);
	index++;destindex++;
  }
 *(dest+destindex)='\0';

 return dest;
}
//-----------------------------------------------------------------------------
int StrCopyStartToCh(char* dest,const char* str,int start,char stopch)
{
 int le=0,destindex=0;

 while (*(str+le) != '\0') le++;

 if (start > le || start < 0) start=0;
 *dest='\0';
 while (*(str+start) != '\0' && *(str+start) != stopch)
  {
   *(dest+destindex)=*(str+start);
   if (*(str+start) == stopch) break;//Aendern wie StrCopyStartToStr 
   start++;destindex++;
  }
 *(dest+destindex)='\0';

 return start;
}
//-----------------------------------------------------------------------------
int StrCopyStartToStr(char* dest,const char* str,int start,char* stopstr)
{
 int le=0,destindex=0,res;

 while (*(str+le) != '\0') le++;
 if (start > le || start < 0) start=0;
 res=StrStrFiPos(str,stopstr);

 *dest='\0';
 while (*(str+start) != '\0')
  {
   *(dest+destindex)=*(str+start);
   if (start == res-1) {destindex++;break;   }//Geaendert
   start++;destindex++;
  }
 *(dest+destindex)='\0';

 return start;
}
//-----------------------------------------------------------------------------
int StrChNum(const char *str,char ch)
{
 int x=0,num=0;

 while (str[x] != '\0')
  {
	if (str[x]==ch) num++;
	x++;
  }

 return num;
}
//-----------------------------------------------------------------------------
int StrChPos(const char *str,char ch,int start)
{
 int le=0;

 while (*(str+le) != '\0') le++;

 if (start > le || start < 0) start=0;
 while (*(str+start) != '\0')
  {
	if (*(str+start) == ch) return start;
	start++;
  }

 return (-1);
}
//-----------------------------------------------------------------------------
int StrStrFiPos(const char* str,const char* substr)
{
 int i=0,j,k;

 if (*str == '\0' || *substr == '\0') return (-1);
 while (*(str+i) != '\0')
  {
   for (j=i,k=0;*(str+j) == *(substr+k);j++,k++)
    {
     if (*(substr+k+1) == '\0') return i;
    }
   i++;
  }

 return (-1);
}
//-----------------------------------------------------------------------------
int StrStrPosNoC(const char* str,const char* substr)
{
 int i=0,j,k,tmp,subtmp;

 if (*str == '\0' || *substr == '\0') return (-1);
 while (*(str+i) != '\0')
  {
   for (j=i,k=0;
	tmp=ChDo(*(str+j)),subtmp=ChDo(*(substr+k)),tmp == subtmp;
	j++,k++)
    {
     if (*(substr+k+1) == '\0') return i;
    }
   i++;
  }

 return (-1);
}
//-----------------------------------------------------------------------------
int StrStrLaPos(char* str,char* substr)
{
 int pos,le=0,suble=0;

 if (*str == '\0' || *substr == '\0') return -1;
 strrev(str);strrev(substr);
 pos=StrStrFiPos(str,substr);
 strrev(str);strrev(substr);
 if (pos > -1)
  {
   while (*(str+le) != '\0') le++;while (*(substr+suble) != '\0') suble++;
   pos=le-pos-suble;return pos;
  }else return (-1);
}
//-----------------------------------------------------------------------------
void StrReplChPos(char* str,char chnew,int pos)
{
 int le=0;

 while (*(str+le) != '\0') le++;
 if (pos < le && *str != '\0') *(str+pos)=chnew;
}
//-----------------------------------------------------------------------------
void StrReplAllCh(char* str,char chold,char chnew,int start)
{
 int le=0;

 while (*(str+le) != '\0') le++;
 if (start >= le) start=0;
 for (start;*(str+start) != '\0';start++)
  {
   if (*(str+start) == chold) *(str+start)=chnew;
  }
}
//-----------------------------------------------------------------------------
char* StrTrLe(char* str,char ch)
{
 int i=0,j=0;

 if (*str == '\0') return str;
 while (*(str+i) == ch ) i++;
 if (i > 0) while (*(str+j) != '\0') {*(str+j)=*(str+i);j++;i++;}

 return str;
}
//-----------------------------------------------------------------------------
char* StrTrRi(char* str,char ch)
{
 int le;

 if (*str == '\0') return str;
 le=0;while (*(str+le) != '\0') le++;
 le--;
 while (le > -1 && *(str+le) == ch) {*(str+le)='\0';le--;}

 return str;
}
//-----------------------------------------------------------------------------
char* StrFiLe(char* str,char ch,int newle)
{
 int index,le,diff;

 le=0;while (*(str+le) != '\0') le++;
 if (newle == 0 || newle <= le) return str;
 diff=newle-le;
 while (le > -1) {*(str+newle)=*(str+le);newle--;le--;}
 index=0;
 while (index < diff) {*(str+index)=ch;index++;}

 return str;
}
//-----------------------------------------------------------------------------
char* StrFiRi(char* str,char ch,int newle)
{
 int le,index;

 le=0;while (*(str+le) != '\0') le++;
 if (newle == 0 || newle <= le) return str;
 index=le;
 while (index < newle) {*(str+index)=ch;index++;}
 *(str+index)='\0';

 return str;
}
//-----------------------------------------------------------------------------
char* StrDelChPos(char* str,int pos)
{
 int le;

 le=0;while (*(str+le) != '\0') le++;
 if (pos < le && *str != '\0')
  {
   while (*(str+pos) != '\0')
    {
     *(str+pos)=*(str+pos+1);
     pos++;
    }
  }

 return str;
}
//-----------------------------------------------------------------------------
char* StrDelAllCh(char* str,char ch)
{
 int  index=0,count=0;
 char tmp;

 while (*(str+index) != '\0')
  {
   count=index;
   while (*(str+count) == ch) count++;
   if (count > index)
    {
     tmp=*(str+index);*(str+index)=*(str+count);
     if (*(str+count) == '\0') {*(str+index+1)='\0';break;}
     *(str+count)=tmp;
    }
   index++;
  }

 return str;
} 
//-----------------------------------------------------------------------------
char* StrDel(char* str,int index,int count)
{
 int le,diff;

 if (*str == '\0') return str;
 le=0;while (*(str+le) != '\0') le++;
 if (index < le && index >= 0 && count > 0)
  {
   diff=le-index;
   if (count >= diff) count=diff;
   while (*(str+index) != '\0')
    {
     *(str+index)=*(str+index+count);
     index++;
    }
   *(str+le-count)='\0';
  }

 return str;
}
//-----------------------------------------------------------------------------
char* StrInsChPos(char* str,char ch,int pos)
{
 int le;

 le=0;while (*(str+le) != '\0') le++;
 if (pos < 0 || pos > le) return str;
 *(str+le+1)='\0';
 while (le > pos)
  {
   *(str+le)=*(str+le-1);
   le--;
  }
 *(str+pos)=ch;

 return str;
}
//-----------------------------------------------------------------------------
char* StrStrIns(char* str,char* substr,int pos)
{
 int le,suble,count;

 le=0;while (*(str+le) != '\0') le++;
 suble=0;while (*(substr+suble) != '\0') suble++;
 if (suble == 0 || pos < 0 || pos > le) return str;
 *(str+le+suble)='\0';
 le=le+suble-1;
 while (le >= pos+suble)
  {
   *(str+le)=*(str+le-suble);
   le--;
  }
 count=0;
 while(*(substr+count) != '\0')
  {
   *(str+pos)=*(substr+count);
   pos++;count++;
  }

 return str;
}
//-----------------------------------------------------------------------------
int StrStartToTok(char* str,char* dest,char tok,int start)
// Kopiert TeilStr ab start bis tok/Stringende
// return=pos von tok, return=-1 tok nicht gefunden/Stringende
// str="1.222;0;58" dest="1.222" -> dest="0" -> dest="58"
{
 int ind,le;

 le=0;while (*(str+le) != '\0') le++;
 if (start > le || start < 0) start=0;
 //-----------------------------------
 dest[0]=0;ind=0;
 while (*(str+start) != '\0')
  {
	if (*(str+start) == tok) {*(dest+ind)='\0';return start;}
   if (*(str+start) == '\0') {*(dest+ind)='\0';return -1;}
   *(dest+ind)=*(str+start);
	ind++;start++;
  }
 return (-1);
}
//-----------------------------------------------------------------------------
void StrDel_CR_LF(char*    str)
{
 int index;

 index=StrChPos(str,(char)13,0);if (index > -1) str[index]=0;
 index=StrChPos(str,(char)10,0);if (index > -1) str[index]=0;
}

void StrDel_CR_LF(CString& str)
{
 str="";
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN ZUR UMWANDLUNG STRINGS/ZAHLEN (hex, bin)
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int HexStrToInt(char* str)
{
 int le,index,num,shift=0,total=0;

 StrTrLe(str,' ');
 if (*str == '\0') return total;
 le=0;while (*(str+le) != '\0') le++;
 index=le-1;
 while (index > -1) {
   switch (*(str+index)) {
     case '0' :num=0;break;
     case '1' :num=1;break;
     case '2' :num=2;break;
     case '3' :num=3;break;
     case '4' :num=4;break;
     case '5' :num=5;break;
     case '6' :num=6;break;
     case '7' :num=7;break;
     case '8' :num=8;break;
     case '9' :num=9;break;
     case 'a' :
     case 'A' :num=10;break;
     case 'b' :
     case 'B' :num=11;break;
     case 'c' :
     case 'C' :num=12;break;
     case 'd' :
     case 'D' :num=13;break;
     case 'e' :
     case 'E' :num=14;break;
     case 'f' :
     case 'F' :num=15;break;
     default  :num=0;
    }
   num <<= shift;
   total+=num;
   index --;
   shift+=4;
  }

 return total;
}
//-----------------------------------------------------------------------------
unsigned long HexStrToUL(char* str)
{
 int           le,index=0,num;
 unsigned long shift=0,total=0;

 StrTrLe(str,' ');
 if (*str == '\0') return total;
 le=0;while (*(str+le) != '\0') le++;
 index=le-1;
 while (index > -1) {
   switch (*(str+index)) {
     case '0' :num=0;break;
     case '1' :num=1;break;
     case '2' :num=2;break;
     case '3' :num=3;break;
     case '4' :num=4;break;
     case '5' :num=5;break;
     case '6' :num=6;break;
     case '7' :num=7;break;
     case '8' :num=8;break;
     case '9' :num=9;break;
     case 'a' :
     case 'A' :num=10;break;
     case 'b' :
     case 'B' :num=11;break;
     case 'c' :
     case 'C' :num=12;break;
     case 'd' :
     case 'D' :num=13;break;
     case 'e' :
     case 'E' :num=14;break;
     case 'f' :
     case 'F' :num=15;break;
     default  :num=0;
    }
   num <<= shift;
   total+=num;
   index --;
   shift+=4;
  }

 return total;
}
//-----------------------------------------------------------------------------
char* ByteToHexStr(char* dest,unsigned int num)
{
 char hexchar[17]="0123456789ABCDEF";

 *(dest+2)='\0';
 if (num >= 255) {*dest='F';*(dest+1)='F';return dest;}
 *(dest+1)=hexchar[num & 0xF];
 *dest=hexchar[num>>=4];

 return dest;
}
//-----------------------------------------------------------------------------
char* ULToHexStr(char* dest,unsigned long num)
{
 char hexchar[17]="0123456789ABCDEF";

 *(dest+8)='\0';
 if (num >= 4294967295L) {for (int x=0;x<8;x++) *(dest+x)='F';return dest;}
 for (int x=7;x > -1;x--) 
  {
   *(dest+x)=hexchar[(int)num & 0xF];
   num>>=4;
  }

 return dest;
}
//-----------------------------------------------------------------------------
char* ULToBinStr(char* dest,unsigned long num,int bit)
{
 char binchar[3]="01";
 int  x,count;

 --bit;
 for (count=0,x=bit;x > -1;count++,x--) 
  {
   if ((num & (1<<x)) > 0) *(dest+count)=binchar[1];
      else *(dest+count)=binchar[0];
  }
 *(dest+count)='\0';

 return dest;
}
//-----------------------------------------------------------------------------
unsigned long BinStrToUL(char* str)
{
 char          binchar[3]="01";
 unsigned long res=0,mul=1;
 int           le,Ocount;

 if (*str == '\0') return res;
 le=0;while (*(str+le) != '\0' ) le++;
 Ocount=0;
 while (*(str+Ocount) == '0' ) Ocount++;
 le--;
 for (le;le > Ocount-1;le--) 
  {
   if (*(str+le) == binchar[1]) res+=mul;
   mul<<=1;
  }

 return res;
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
int CStrToInt(CString cstr)
{
 return _ttoi(cstr);
}
//-----------------------------------------------------------------------------
unsigned long CStrToLong(CString cstr)
{
 return _ttol(cstr);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN STRINGS/DATUM
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void GetDateTime(char *dest,int mode)
{
 SYSTEMTIME systime;
 char       str[20],tr1[2]=".",tr2[2]=":";

 GetLocalTime(&systime);
 switch (mode)
  {
   case 1 :_itoa(systime.wDay,dest,10);//dd.mm.yy
           if (dest[1]==0) {dest[1]=dest[0];dest[0]='0';dest[2]=0;}
           strcat(dest,tr1);
           _itoa(systime.wMonth,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,tr1);
           _itoa(systime.wYear,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);
           break;
   case 2 :_itoa(systime.wHour,dest,10);//hh:mm:ss
           if (dest[1]==0) {dest[1]=dest[0];dest[0]='0';dest[2]=0;}
           strcat(dest,tr2);
           _itoa(systime.wMinute,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,tr2);
           _itoa(systime.wSecond,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);
           break;
   case 3 :_itoa(systime.wHour,dest,10);//hh:mm:ss:ms
           if (dest[1]==0) {dest[1]=dest[0];dest[0]='0';dest[2]=0;}
           strcat(dest,tr2);
           _itoa(systime.wMinute,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,tr2);
           _itoa(systime.wSecond,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,tr2);
           _itoa(systime.wMilliseconds,str,10);
           strcat(dest,str);
           break;

   case 10:_itoa(systime.wDay,dest,10);//dd.mm.yy/hh:mm:ss UTC
           if (dest[1]==0) {dest[1]=dest[0];dest[0]='0';dest[2]=0;}
           strcat(dest,tr1);
           _itoa(systime.wMonth,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,tr1);
           _itoa(systime.wYear,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,"/");
           _itoa(systime.wHour,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,tr2);
           _itoa(systime.wMinute,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest,tr2);
           _itoa(systime.wSecond,str,10);
           if (str[1]==0) {str[1]=str[0];str[0]='0';str[2]=0;}
           strcat(dest,str);strcat(dest," UTC");
           break;
   case 11:
           break;
   default:dest[0]=0;
   		  break;
  }
}
//-----------------------------------------------------------------------------
void AdjDateStr(char *dest)
{
 int pointnum,pos1,pos2;

 pointnum=StrChNum(dest,'.');//Anzahl Punkte ?
 pos1=StrChPos(dest,'.',0);//Erster Punkt wo ?
 if (pos1 == 1) {StrInsChPos(dest,'0',0);pos1++;}//Format Tage 1 -> 01
 if (pointnum == 1) {strcat(dest,".");pointnum++;}
 pos2=StrChPos(dest,'.',pos1+1);
 if (pos2-pos1 == 2) StrInsChPos(dest,'0',pos1+1);//Format Monate 1 -> 01
}
//-----------------------------------------------------------------------------
void DateStrToNum(char *datestr,int& danum,int& monum,int& yenum)
{
 char tmpstr[5];
 // 01.01.1998
 
 danum=monum=yenum=0;

 tmpstr[0]=datestr[0];tmpstr[1]=datestr[1];tmpstr[2]=0;danum=atoi(tmpstr);
 tmpstr[0]=datestr[3];tmpstr[1]=datestr[4];tmpstr[2]=0;monum=atoi(tmpstr);

 tmpstr[0]=datestr[6];tmpstr[1]=datestr[7];tmpstr[2]=datestr[8];tmpstr[3]=datestr[9];
 tmpstr[4]=0;yenum=atoi(tmpstr);
}
//-----------------------------------------------------------------------------
void NumToDateStr(char *dest,int danum,int monum,int yenum)
{
 char tmpstr[10];

 _itoa(danum,dest,10);
 if (dest[1]== '\0') {dest[1]=dest[0];dest[0]='0';dest[2]='\0';}
 strcat(dest,".");
 //---
 _itoa(monum,tmpstr,10);
 if (tmpstr[1]== '\0') {tmpstr[1]=tmpstr[0];tmpstr[0]='0';tmpstr[2]='\0';}
 strcat(dest,tmpstr);strcat(dest,".");
 //---
 _itoa(yenum,tmpstr,10);strcat(dest,tmpstr);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// SONSTIGE STRING-FUNKTIONEN
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int ASCIINumsToStr(char *str,int *dest)
{
 int  le,count,x,y;
 char tmpstr[5];

 StrDelAllCh(str,' ');
 le=0;while (*(str+le) != '\0' ) le++;
 if (*(str+le-1) == ',') {*(str+le-1)='\0';le--;}
 if (le == 0) return 0;
 count=StrChNum(str,',');
 //-----------------------------
 for (x=0,y=0;x<le;x++,y++)
  {
   x=StrCopyStartToCh(tmpstr,str,x,',');
   dest[y]=(int)atoi(tmpstr);dest[y+1]=-999;
  }

 return count+1;
}
//-----------------------------------------------------------------------------
// CIPAdressCtrl
int StrToIPAdrCtrl(char* inp, BYTE& ip1,BYTE& ip2,BYTE& ip3,BYTE& ip4)
{
 BYTE ip[4];
 int  le,i,j,k,pos;
 char temp[4];
 

 StrTrLe(inp,' ');StrTrRi(inp,' ');
 le=0;while (*(inp+le) != '\0') le++;
 //Fehlerermittlung
 i=StrChNum(inp,'.');
 if (i < 3 || inp[le-1] == '.') return -1;//mehr als 3 Punkte
 i=0;
 while (*(inp+i) != '\0')//Abstand zwischen 2 Punkten = Null 
  {
   if (*(inp+i) == '.' && *(inp+i+1) == '.') return -1;
   i++;
  }
 
 pos=0;i=0;k=0;
 while (*(inp+i) != '\0') 
  {
   if (*(inp+i) == '.' || *(inp+i+1) == '\0')
    {
     j=i-pos;if (j == 0) j=1;
     StrCopy(temp,inp,pos,j);ip[k]=atoi(temp);
     pos=i+1;k++;
    }   
   i++;
  }
 ip1=ip[0];ip2=ip[1];ip3=ip[2];ip4=ip[3];

 return 1; 
}

void IPAdrCtrlToStr(char* dest,BYTE ip1,BYTE ip2,BYTE ip3,BYTE ip4)
{
 char temp[4];
 char pu[2]=".";

 *dest='\0';
 _itoa(ip1,temp,10);strcpy(dest,temp);strcat(dest,pu);
 _itoa(ip2,temp,10);strcat(dest,temp);strcat(dest,pu);
 _itoa(ip3,temp,10);strcat(dest,temp);strcat(dest,pu);
 _itoa(ip4,temp,10);strcat(dest,temp);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// FUNKTIONEN FUER FILEs + FILENAMEN
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int FiExist(char *fName)
{
 CFile          f;
 CFileException fexc;

 if (!f.Open(fName,CFile::modeRead,&fexc)) return 0;else return 1;
}
//-----------------------------------------------------------------------------
void ForceFiExt(char *finame,char *def)
{
 int res;

 res=StrChPos(finame,'.',0);
 if (res == -1)
  {
	strcat(finame,".\0");strcat(finame,def);return;
  }
 if (res > -1)
  {
	*(finame+res+1)='\0';
	strcat(finame,def);
	return;
  }
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// SONSTIGE FUNKTIONEN
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void NBeep(void)
{
 Beep(800,200);
}

void VBeep(unsigned int freq,unsigned int dur)
{
 Beep(freq,dur);
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void KeepWindowsAlive(void)
{
 MSG msg;

 while (PeekMessage(&msg,0,0,0,PM_REMOVE))
  {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
  }
 return;
}
//-----------------------------------------------------------------------------
void VDelay(unsigned int deltime)
{
 unsigned int tickcount;

 tickcount=GetTickCount();
 while (GetTickCount()-tickcount < deltime) KeepWindowsAlive();
 return;
}
//-----------------------------------------------------------------------------
void ExecNotePad(char *fName)
{
 char execstr[100]="notepad.exe ";

 strcat(execstr,fName);
 WinExec(execstr,SW_SHOW);
}
//-----------------------------------------------------------------------------
void IntDeb(int x1,int x2,int x3,int x4)
{
 char str[60];
 wsprintf(str,"x1: %d \nx2: %d \nx3: %d \nx4: %d",x1,x2,x3,x4);
 MessageBox(GetFocus(),str,"",MB_OK);
}
//-----------------------------------------------------------------------------
void CharDeb(char *x1,char *x2,char *x3,char *x4)
{
 char str[60];
 strcpy(str,x1);strcat(str,"\n");strcat(str,x2);strcat(str,"\n");
 strcat(str,x3);strcat(str,"\n");strcat(str,x4);
 MessageBox(GetFocus(),str,"",MB_OK);
}
//-----------------------------------------------------------------------------
void TimeDiff(int mode,int start_stop)    
{
 char         str_s[50],str_ms[50]; 
 static DWORD t_start,t_stop,timediff_s,timediff_ms;

 if (start_stop == 0) t_start=GetTickCount();
 if (start_stop == 1)
  {
   t_stop=GetTickCount();
   if (mode == 0)//Anzeige s,ms
    {
     timediff_s =(t_stop-t_start)/1000;_ultoa(timediff_s ,str_s ,10);
     timediff_ms=(t_stop-t_start)%1000;_ultoa(timediff_ms,str_ms,10);
     strcat(str_s,",");strcat(str_s,str_ms);strcat(str_s," s");
    }
   if (mode == 1)//Anzeige ms
    {
     timediff_s =t_stop-t_start;_ultoa(timediff_s,str_s,10);
     strcat(str_s," ms");
    }
   MessageBox(AfxGetApp()->GetMainWnd()->m_hWnd,str_s,"Time-Diff",MB_OK  | MB_ICONINFORMATION | MB_TASKMODAL);
  }
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
