// R_SCAN.H : Scan f. Radio
// G. TAMM, DF9ZO 2007
//--------------------
#pragma once
//--------------------
#include "R_DLG.H"
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ScanView+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class ScanView : public CView
{
protected:
	DECLARE_DYNCREATE(ScanView)
public:
	ScanView();

   void DoThePrint();
   void CalcWinSize();
   void EraseScreen(int mode);//1=Markers, 2=Speclines
   void DrawCoords();
   void DrawMark(int ind);
   void DrawLine(int ind);
   void UpdateStatusLine1();
   void UpdateStatusLine2();
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ScanView)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

protected:
   virtual ~ScanView();	    
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
   CBrush     brush,*oldbrush;
   CFont      font,*oldfont;
   int        SchrH,SchrB;
   int        xoff,yoff,lioff,lidiff,xlimax;
   
   int  CalcIndex(int pos);
   void ToRadio();
	//{{AFX_MSG(ScanView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ScanDisp+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class ScanDisp : public CFrameWnd
{
	DECLARE_DYNCREATE(ScanDisp)
public:
	ScanDisp(); 
	virtual ~ScanDisp();

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ScanDisp)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

protected:
	// Generated message map functions
	//{{AFX_MSG(ScanDisp)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnClose();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ScanDlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class ScanDlg : public CDialog
{
public:
	ScanDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(ScanDlg)
	enum { IDD = IDD_SCAN_DLG };
	BOOL     m_spec;
	BOOL     m_ltspec;
	CString	m_del;
	CString	m_fstep;
	CString	m_hif;
	CString	m_lof;
	//}}AFX_DATA


	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ScanDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

protected:
    HACCEL     m_hAccel;
    CScrollBar *pSB;

    CString    FiName;
    char       finame[Fl];
    int        SKI_Index;
    
    void TransferToDlg();
    void TransferFrDlg();
    void PrepareScan(); 
    void Scan(int start);
    void ToRadio();
    //void IsStarted();
    void IsStopped();
    void IsRestarted();
	// Generated message map functions
	//{{AFX_MSG(ScanDlg)
    afx_msg LRESULT OnMainWindowPosChange(WPARAM wParam,LPARAM lParam);

	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnATT();
	afx_msg void OnDO();
	afx_msg void OnLOG();
	afx_msg void OnLOLIB();
	afx_msg void OnMODE();
	afx_msg void OnMSCAN();
	afx_msg void OnPAMP();
	afx_msg void OnPRINTDISP();
	afx_msg void OnRESTART();
	afx_msg void OnSCAN();
	afx_msg void OnSKIP();
	afx_msg void OnSTART();
	afx_msg void OnSTOLIB();
	afx_msg void OnUP();
	afx_msg void OnSTOP();
	afx_msg void OnSTOPMODE();
	afx_msg void OnLOADDEFAULT();
    afx_msg void OnALT_F4();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()    
};
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern ScanDlg*   scandlg;
extern ScanDisp*  scandisp;
extern ScanView*  scanview;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

