// R_SCAN.CPP : Scan f. Radio
// G. TAMM, DF9ZO 2007
//--------------------
#include "stdafx.h"
#include "R_SCAN.H"
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ScanDlg*   scandlg=0;
ScanDisp*  scandisp=0;
ScanView*  scanview=0;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ScanView+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNCREATE(ScanView, CView)

ScanView::ScanView() {}

ScanView::~ScanView() {}

BEGIN_MESSAGE_MAP(ScanView, CView)
	//{{AFX_MSG_MAP(ScanView)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
#ifdef _DEBUG
void ScanView::AssertValid() const
{
 CView::AssertValid();
}

void ScanView::Dump(CDumpContext& dc) const
{
 CView::Dump(dc);
}
#endif //_DEBUG
//-----------------------------------------------------------------------------
BOOL ScanView::PreCreateWindow(CREATESTRUCT& cs) 
{
 SchrH=14;SchrB=9;
 xoff=8;
 yoff=8;
 lidiff=4;
 lioff=xoff+lidiff;
 xlimax=(2*SchrH)+3;

 cs.style|=WS_CHILD;

 font.CreateFont(SchrH,SchrB,0,0,FW_MEDIUM,FALSE,FALSE,0,ANSI_CHARSET,
                 OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
                 DEFAULT_PITCH | FF_MODERN,"Courier New");//"Courier New" "Arial"
 brush.CreateSolidBrush(RGB(255,255,255));
	
 return CView::PreCreateWindow(cs);
}
//-----------------------------------------------------------------------------
void ScanView::ToRadio()
{
 comport.F_Set(ScAr.f[ScLiInd]);
 if ((ScOpMo == 2 || (ScOpMo == 3 && ScOpMoFrFile == 2))
     && Mact_n != ScAr.m[ScLiInd])
  {
   comport.M_Set(ScAr.m[ScLiInd],FIact_n); 
   Mact_n=ScAr.m[ScLiInd];
  }
}
//-----------------------------------------------------------------------------
void ScanView::CalcWinSize()
{
 CRect rect;

 GetClientRect(rect);
 if (ScLiNum > 0)
  {
   lidiff=(rect.right-3*xoff)/ScLiNum;if (lidiff < 1) lidiff=1;
   lioff=xoff+lidiff;
  }
}

void ScanView::OnDraw(CDC* pDC)
{
 TEXTMETRIC metric;
 CRect      rect;
 int        h,x;

 if (pDC->IsPrinting())
  {
   rect.left=0;rect.top=0;rect.right=200;rect.bottom=30;
   if (ScLiNum > 0)
    {
     lidiff=(rect.right-3*xoff)/ScLiNum;if (lidiff < 1) lidiff=1;
     lioff=xoff+lidiff;
    }else return;
   pDC->GetTextMetrics(&metric);
   //UpdateStatusLine1();
   //UpdateStatusLine2();
   h=metric.tmHeight+metric.tmExternalLeading;
   x=(int)strlen(ScStr1);pDC->TextOut(0,0,ScStr1,x);
   x=(int)strlen(ScStr2);pDC->TextOut(0,h,ScStr2,x);
   //----------
   pDC->MoveTo(xoff,rect.bottom-yoff);pDC->LineTo(xoff,xlimax);
   pDC->MoveTo(xoff,rect.bottom-yoff);pDC->LineTo(rect.right-2,rect.bottom-yoff);

   return;
  }
 pDC->SetBkMode(TRANSPARENT);
 //oldfont=(CFont*) pDC->SelectObject(&font);
 //--------------------------
 CalcWinSize();
 UpdateStatusLine1();
 UpdateStatusLine2();
 DrawCoords();
 if (ScAr.f[0][0] == '\0') return;
 if (ScLiInd > 0) {for (x=0;x<ScLiInd+1;x++)  DrawMark(x);}
 for (x=0;x<ScLiNum+1;x++) DrawLine(x);
 //--------------------------
 //pDC->SelectObject(&oldfont);
}

void ScanView::UpdateStatusLine1()
{
 CClientDC dc(this);
 CRect     rect;
 char      str[20];
 int       le;

 GetClientRect(rect); 
 dc.SetBkMode(TRANSPARENT);
 //--------------------------------------
 oldbrush=(CBrush*) dc.SelectObject(&brush);
 rect.bottom=SchrH; 
 dc.FillRect(rect,&brush);
 dc.SelectObject(&oldbrush);
 //--------------------------------------
 oldfont=(CFont*) dc.SelectObject(&font);
 
 if (ScOpMo == 0) strcpy(ScStr1,scmsg00);
 if (ScOpMo == 1) strcpy(ScStr1,"SCAN:");
 if (ScOpMo == 2) {strcpy(ScStr1,"M-SCAN:");strcat(ScStr1,F_ScMScanFi);}
 if (ScOpMo == 3)
  {
   if (ScOpMoFrFile == 1) strcpy(ScStr1,"LIB/scan:");
   if (ScOpMoFrFile == 2) {strcpy(ScStr1,"LIB/m-scan:");strcat(ScStr1,F_ScMScanFi);}
  }
 if (ScOpMo == 1 || (ScOpMo == 3 && ScOpMoFrFile == 1))
  {
   strcpy(str,ScLoF_s);StrTrLe(str,' ');strcat(ScStr1,str);strcat(ScStr1,"-");
   strcpy(str,ScHiF_s);StrTrLe(str,' ');strcat(ScStr1,str);
   strcat(ScStr1,"/Step:");
   strcpy(str,SFact_s);StrTrLe(str,' ');strcat(ScStr1,str);strcat(ScStr1,"/");
   strcat(ScStr1,Mact_s);strcat(ScStr1," ");strcat(ScStr1,FIact_s);
  }
 if (ScOpMo != 0)
  {
   strcat(ScStr1," Att:");
   switch (ATTsw)
    {
     case 0:strcat(ScStr1,"-");break;
     case 1:strcat(ScStr1,"1");break;
     case 2:strcat(ScStr1,"2");break;
     case 3:strcat(ScStr1,"3");break;
    }
   strcat(ScStr1,"/PAMP:");
   switch (PAMPsw)
    {
     case 0:strcat(ScStr1,"-");break;
     case 1:strcat(ScStr1,"1");break;
     case 2:strcat(ScStr1,"2");break;
    }
  }
 dc.SetTextColor(blue);le=(int)strlen(ScStr1);dc.TextOut(0,0,ScStr1,le);

 dc.SelectObject(&oldfont);
} 

void ScanView::UpdateStatusLine2()
{
 CClientDC dc(this);
 CRect     rect;
 int       le;

 GetClientRect(rect); 
 dc.SetBkMode(TRANSPARENT);
 //--------------------------------------
 oldbrush=(CBrush*) dc.SelectObject(&brush);
 rect.top=SchrH;rect.bottom=rect.top+SchrH; 
 dc.FillRect(rect,&brush);
 dc.SelectObject(&oldbrush);
 //--------------------------------------
 oldfont=(CFont*) dc.SelectObject(&font);
		
 if (ScOpMo == 0) strcpy(ScStr2,"");
 if (ScOpMo > 0)
  {
   if (ScIsSta) {strcpy(ScStr2,"STARTED:");strcat(ScStr2,ScTime1);}
   if (ScIsSto || ScIsResta)
    {
     if (ScIsSto) strcpy(ScStr2,"STOPPED:");
     if (ScIsResta) strcpy(ScStr2,"RESTARTED:");
     strcat(ScStr2,ScTime2);strcat(ScStr2,"/");strcat(ScStr2,ScAr.f[ScLiInd]);
    }
  }
 dc.SetTextColor(red);le=(int)strlen(ScStr2);dc.TextOut(0,SchrH,ScStr2,le);
 dc.SelectObject(&oldfont);
} 
//-----------------------------------------------------------------------------
int ScanView::CalcIndex(int pos)
{
 int x,tol;

 if (pos <= lioff) return 0;
 if (pos >= lioff+((ScLiNum-1)*lidiff)) return ScLiNum-1;
 
 if (lidiff <  2) tol=0;
 if (lidiff == 3) tol=1;
 if (lidiff >  3) tol=(int)(0.4*lidiff);//tol=0.4*lidiff;

 for (x=0;x < ScLiNum+1;x++)
  {
   if (pos >= lioff+(x*lidiff)-tol && pos <= lioff+(x*lidiff)+tol) return x;
  }
 return -1;
}
/*
int ScanView::CalcIndex(int pos) Original
{
 int x,tol;

 if (pos <= lioff) return 0;
 if (pos >= lioff+((ScLiNum-1)*lidiff)) return ScLiNum-1;
 if (lidiff == 1) tol=0;else tol=(int)0.4*lidiff;//tol=0.4*lidiff;
 for (x=0;x < ScLiNum+1;x++)
  {
   if (pos >= lioff+(x*lidiff)-tol && pos <= lioff+(x*lidiff)+tol) return x;
  }
 return -1;
}
*/

void ScanView::EraseScreen(int mode)
{
 CClientDC dc(this);
 CRect     rect;

 oldbrush=(CBrush*) dc.SelectObject(&brush);
 GetClientRect(rect);
 if (mode == 1)//Markers
  {
   rect.left=lioff;rect.top=rect.bottom-6;
   dc.FillRect(rect,&brush);
  }
 if (mode == 2)//Speclines
  {
   rect.left=lioff;rect.top=xlimax;rect.bottom-=yoff;
   dc.FillRect(rect,&brush);
  }
 dc.SelectObject(&oldbrush);
}

void ScanView::DrawCoords()
{
 CClientDC dc(this);
 CRect     rect;

 GetClientRect(rect);
 dc.SetTextColor(black);
 dc.MoveTo(xoff,rect.bottom-yoff);dc.LineTo(xoff,xlimax);
 dc.MoveTo(xoff,rect.bottom-yoff);dc.LineTo(rect.right-2,rect.bottom-yoff);
}

void ScanView::DrawMark(int ind)
{
 CClientDC dc(this);
 CPen      pen(PS_SOLID,0,magenta),*oldpen;
 CRect     rect;
 int       x;

 x=lioff+(ind*lidiff);
 GetClientRect(rect);
 oldpen=(CPen*) dc.SelectObject(&pen);
 dc.MoveTo(x,rect.bottom-3);dc.LineTo(x,rect.bottom-6);
 dc.SelectObject(&oldpen);
}

void ScanView::DrawLine(int ind)
{
 CClientDC dc(this);
 CPen      pen(PS_SOLID,0,red),*oldpen;
 CRect     rect;
 int       x,y,li;

 x=lioff+(ind*lidiff);
 GetClientRect(rect);
 oldpen=(CPen*) dc.SelectObject(&pen);
 y=rect.bottom-yoff-1;
 dc.MoveTo(x,y);
 if (ScAr.y[ind] > y-xlimax) li=xlimax;else li=y-ScAr.y[ind];
 dc.LineTo(x,li);
 dc.SelectObject(&oldpen);
}
//-----------------------------------------------------------------------------
void ScanView::OnLButtonDown(UINT nFlags, CPoint point) 
{
 int res;

 if (ScIsRu || ScLiNum==0) return;
 res=CalcIndex(point.x);if (res == -1) return;
 ScLiInd=res;
 ToRadio();EraseScreen(1);DrawMark(res);
 strcpy(Fact_s,ScAr.f[res]);Mact_n=ScAr.m[res];MnumToMstr(Mact_n,Mact_s);
 	
 CView::OnLButtonDown(nFlags, point);
}

void ScanView::OnRButtonDown(UINT nFlags, CPoint point) 
{
 int  res;

 if (ScIsRu || ScLiNum==0) return;
 res=CalcIndex(point.x);if (res == -1) return;
 strcpy(Fact_s,ScAr.f[res]);Mact_n=ScAr.m[res];MnumToMstr(Mact_n,Mact_s);
 
 MyMsgWin((CFrameWnd*)this,"Frequency",Fact_s,1000,
           point.x,point.y,point.x+200,point.y+100);
	
 CView::OnRButtonDown(nFlags, point);
}

void ScanView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
 if (ScIsRu || ScLiNum==0) return;

 if (nChar == VK_HOME) ScLiInd=0;
 if (nChar == VK_END)  ScLiInd=ScLiNum-1;
 if (nChar == VK_DOWN) if (ScLiInd-1 >= 0) ScLiInd--;else ScLiInd=ScLiNum-1;
 if (nChar == VK_UP)   if (ScLiInd+1 < ScLiNum) ScLiInd++;else ScLiInd=0;
 ToRadio();EraseScreen(1);DrawMark(ScLiInd);
	
 CView::OnKeyDown(nChar, nRepCnt, nFlags);
}
//-----------------------------------------------------------------------------
void ScanView::DoThePrint()
{
 OnFilePrint();
}// CWinApp   CView   CWnd     CPrintInfo   CPrintDialog    PRINTDLG

BOOL ScanView::OnPreparePrinting(CPrintInfo* pInfo) 
{
 BOOL retB;

 pInfo->SetMaxPage(1);
 retB=DoPreparePrinting(pInfo);
 return retB;
}

void ScanView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
 // TODO: Add your specialized code here and/or call the base class
 CView::OnBeginPrinting(pDC, pInfo);
}

void ScanView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
 // TODO: Add your specialized code here and/or call the base class
 CView::OnEndPrinting(pDC, pInfo);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ScanDisp+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNCREATE(ScanDisp, CFrameWnd)

ScanDisp::ScanDisp() {}

ScanDisp::~ScanDisp() {}

BEGIN_MESSAGE_MAP(ScanDisp, CFrameWnd)
	//{{AFX_MSG_MAP(ScanDisp)
	ON_WM_SIZE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL ScanDisp::PreCreateWindow(CREATESTRUCT& cs) 
{
 cs.style|=WS_POPUP | WS_VISIBLE | WS_CAPTION;
 cs.style|=WS_THICKFRAME;// TEST

 cs.x=Win_XIOpos+2;cs.y=Win_YIOpos+2;  
 cs.cx=602;cs.cy=200;
 RSDisp_W=cs.cx;RSDisp_H=cs.cy;

 return CFrameWnd::PreCreateWindow(cs);
}
//-----------------------------------------------------------------------------
void ScanDisp::OnClose() 
{
 if (SCAN) return;	
 CFrameWnd::OnClose();
}
//-----------------------------------------------------------------------------
void ScanDisp::OnSize(UINT nType, int cx, int cy) 
{
 CRect rect;

 CFrameWnd::OnSize(nType, cx, cy);

 GetWindowRect(rect);
 if (rect.bottom-rect.top > 200)
  {
   MoveWindow(Win_XIOpos+2,Win_YIOpos+2,rect.right-rect.left,200);
  }
 //ScanView in Rahmenfenster anpassen
 GetClientRect(rect);
 if (scanview != 0) 
  {
   scanview->MoveWindow(&rect);
   scanview->Invalidate();
  }	
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ScanDlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ScanDlg::ScanDlg(CWnd* pParent /*=NULL*/)
	    : CDialog(ScanDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(ScanDlg)
	m_spec   = FALSE;
	m_ltspec = FALSE;
	m_del    = _T("");
	m_fstep  = _T("");
	m_hif    = _T("");
	m_lof    = _T("");
	//}}AFX_DATA_INIT
}

void ScanDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ScanDlg)
	DDX_Check(pDX, IDC_SCA_CH_SPEC,   m_spec);
	DDX_Check(pDX, IDC_SCA_CH_LTSPEC, m_ltspec);
	DDX_Text(pDX, IDC_SCA_ED_DEL,     m_del);
	DDV_MaxChars(pDX, m_del, 5);
	DDX_Text(pDX, IDC_SCA_ED_FSTEP,   m_fstep);
	DDV_MaxChars(pDX, m_fstep, 12);
	DDX_Text(pDX, IDC_SCA_ED_HIF,     m_hif);
	DDV_MaxChars(pDX, m_hif, 12);
	DDX_Text(pDX, IDC_SCA_ED_LOF,     m_lof);
	DDV_MaxChars(pDX, m_lof, 12);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(ScanDlg, CDialog)
	//{{AFX_MSG_MAP(ScanDlg)
    ON_MESSAGE(WM_MAINWINDOW_POSCHANGE,OnMainWindowPosChange)

	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_SCA_ATT,       OnATT)
	ON_BN_CLICKED(IDC_SCA_DO,        OnDO)
	ON_BN_CLICKED(IDC_SCA_LOG,       OnLOG)
	ON_BN_CLICKED(IDC_SCA_LOLIB,     OnLOLIB)
	ON_BN_CLICKED(IDC_SCA_MODE,      OnMODE)
	ON_BN_CLICKED(IDC_SCA_MSCAN,     OnMSCAN)
	ON_BN_CLICKED(IDC_SCA_PAMP,      OnPAMP)
	ON_BN_CLICKED(IDC_SCA_PRINTDISP, OnPRINTDISP)
	ON_BN_CLICKED(IDC_SCA_RESTART,   OnRESTART)
	ON_BN_CLICKED(IDC_SCA_SCAN,      OnSCAN)
	ON_BN_CLICKED(IDC_SCA_SKIP,      OnSKIP)
	ON_BN_CLICKED(IDC_SCA_START,     OnSTART)
	ON_BN_CLICKED(IDC_SCA_STOLIB,    OnSTOLIB)
	ON_BN_CLICKED(IDC_SCA_UP,        OnUP)
	ON_BN_CLICKED(IDC_SCA_STOP,      OnSTOP)
	ON_BN_CLICKED(IDC_SCA_STOPMODE,  OnSTOPMODE)
	ON_BN_CLICKED(IDC_SCA_LODEF,     OnLOADDEFAULT)
   ON_COMMAND   (IDC_SCA_ALTF4,     OnALT_F4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL ScanDlg::OnInitDialog() 
{
 LPCTSTR WIN,VIEW; 
 CRect   rect;
 CString str("",50);
 char    dspstr[100],
         tmpstr[10];

 CDialog::OnInitDialog();
   
 m_hAccel=NULL;
 m_hAccel=LoadAccelerators(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_SCANACCEL));

 _itoa(Radio_Num+1,tmpstr,10);
 str="SCAN (RADIO ";str+=tmpstr;str+=")";
 SetWindowText(str);
 
 scandisp=new ScanDisp();
 _itoa(Radio_Num+1,tmpstr,10);
 str="DISPLAY (RADIO ";str+=tmpstr;str+=")";
 strcpy(dspstr,LPCTSTR(str));
 
 WIN=AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
	                     LoadCursor(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDC_CURSOR_SCAN)),
		                 (HBRUSH)(COLOR_WINDOW+1),
			             NULL);
 scandisp->Create(WIN,dspstr,0,CFrameWnd::rectDefault,AfxGetApp()->GetMainWnd(),0,NULL);
 scandisp->SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 scandisp->GetClientRect(rect);
 scanview=new ScanView();
 VIEW=AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
	                      LoadCursor(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDC_CURSOR_SCAN)),
		                   (HBRUSH)(COLOR_WINDOW+1),
			                NULL);
 scanview->Create(VIEW,"",0,rect,scandisp,0,NULL);
 scanview->ShowWindow(SW_SHOW);scanview->OnInitialUpdate();
 //-----------------------------------------------
 RadioSettings();

 strcpy(ScLoF_s,RADIOS[Radio_Num].SC_LoF_s);    
 strcpy(ScHiF_s,RADIOS[Radio_Num].SC_HiF_s);
 strcpy(SFact_s,RADIOS[Radio_Num].SC_SFact_s);    
 Mact_n     =RADIOS[Radio_Num].SC_Mact_n;MnumToMstr(Mact_n,Mact_s);
 FIact_n    =RADIOS[Radio_Num].SC_FIact_n;strcpy(FIact_s,FIarr_s[FIact_n]);//FInumToFIstr(FIact_n,FIact_s);
 ScStepDel_n=RADIOS[Radio_Num].SC_StepDel;_itoa(ScStepDel_n,ScStepDel_s,10); 
 ScStopMo   =RADIOS[Radio_Num].SC_StopMo;  
 ScM2Del_n  =RADIOS[Radio_Num].SC_M2Del;_itoa(ScM2Del_n,ScM2Del_s,10); 
 ScM3Lev_n  =RADIOS[Radio_Num].SC_M3Lev;_itoa(ScM3Lev_n,ScM3Lev_s,10); 
 ScWrSpec   =RADIOS[Radio_Num].SC_WrSpec;    
 ScLtSpec   =RADIOS[Radio_Num].SC_LtSpec;
 
 ScOpMo=0;	
 ScLiInd=0;ScLiNum=0;
 ScIsRu=0;ScIsSta=0;ScIsSto=0;ScIsResta=0;
 CMD_Conf=0;
 ModMstr(Mact_s);ModFIstr(FIact_s);
 R_SMCFile(RADIOS[Radio_Num].SmConv_s);
 SKI_Index=11;//Bei Erw. Modes anpassen
 TransferToDlg();
 //-----------------------------------------------
 comport.Open(COM_PORT,COM_BAUD,COM_DATA,COM_STOP,COM_PARI,COM_PROT,1000,1000);
 SCAN=1;

 ATTsw=0;
 comport.ATT_Switch(ATTsw);//scanview->UpdateStatusLine1();
 PAMPsw=0;
 comport.PAMP_Switch(PAMPsw);//scanview->UpdateStatusLine1();

 pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_AF);
 pSB->SetScrollRange(0,255);AFlev_n=0;
 comport.AFlev_Ask();
 pSB->SetScrollPos(AFlev_n);

 pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_RF);
 pSB->SetScrollRange(0,255);RFlev_n=0;
 comport.RFlev_Ask();
 pSB->SetScrollPos(RFlev_n);

 pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_SQL);
 pSB->SetScrollRange(0,255);SMlev_n=0;
 comport.SQLlev_Ask();
 pSB->SetScrollPos(SQLlev_n);

 pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_PBTL);        
 pSB->SetScrollRange(0,255);PBTL_n=128;
 if (Mact_n < 2 && Mact_n > 3) comport.PBTL_Ask();//FM, WFM: Fehlermeldung 
 pSB->SetScrollPos(PBTL_n);

 pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_PBTH);
 pSB->SetScrollRange(0,255);PBTH_n=128;
 if (Mact_n < 2 && Mact_n > 3) comport.PBTH_Ask();//FM, WFM: Fehlermeldung 
 pSB->SetScrollPos(PBTH_n);
 //-----------------------------------------------	
 GetDlgItem(IDC_SCA_START)->SetFocus();

 GetWindowRect(&rect);//Screen-Coord.
 RSDlg_W=rect.right-rect.left;RSDlg_H=rect.bottom-rect.top;
 RSDlg_Y=rect.top-Win_YIOpos;

 IBRad_Tr_n=0;
 comport.TRANSCEIVE_Set(IBRad_Tr_n);

 return FALSE;// return TRUE unless you set the focus to a control*/
}
//-----------------------------------------------------------------------------
LRESULT ScanDlg::OnMainWindowPosChange(WPARAM wParam,LPARAM lParam)
{
 MoveWindow(Win_XIOpos+2,Win_YIOpos+RSDlg_Y,RSDlg_W,RSDlg_H,TRUE); 
 scandisp->MoveWindow(Win_XIOpos+2,Win_YIOpos+2,RSDisp_W,RSDisp_H,TRUE); 
 return 0L;
}
//-----------------------------------------------------------------------------
BOOL ScanDlg::PreTranslateMessage(MSG* pMsg) 
{
 if(!(m_hAccel && ::TranslateAccelerator(m_hWnd, m_hAccel, pMsg)))
   return CDialog::PreTranslateMessage(pMsg);else return TRUE;
	
 return CDialog::PreTranslateMessage(pMsg);
}
//-----------------------------------------------------------------------------
void ScanDlg::OnOK() 
{
 if (ScIsRu) return;
 scanview->DestroyWindow();scanview=0;
 scandisp->DestroyWindow();scandisp=0;
 //-----------------------------------------------
 TransferFrDlg();
 
 strcpy(RADIOS[Radio_Num].SC_LoF_s,ScLoF_s);    
 strcpy(RADIOS[Radio_Num].SC_HiF_s,ScHiF_s);
 strcpy(RADIOS[Radio_Num].SC_SFact_s,SFact_s);    
 RADIOS[Radio_Num].SC_Mact_n =Mact_n;
 RADIOS[Radio_Num].SC_FIact_n=FIact_n;
 ScStepDel_n=atoi(ScStepDel_s);
 RADIOS[Radio_Num].SC_StepDel=ScStepDel_n; 
 RADIOS[Radio_Num].SC_StopMo =ScStopMo;  
 ScM2Del_n=atoi(ScM2Del_s); 
 RADIOS[Radio_Num].SC_M2Del  =ScM2Del_n;
 ScM3Lev_n=atoi(ScM3Lev_s);
 RADIOS[Radio_Num].SC_M3Lev  =ScM3Lev_n;
 RADIOS[Radio_Num].SC_WrSpec =ScWrSpec;    
 RADIOS[Radio_Num].SC_LtSpec =ScLtSpec;
 
 DestroyWindow();
}

void ScanDlg::OnALT_F4()
{
 OnOK();
}

void ScanDlg::PostNcDestroy() 
{
 SCAN=0;

 IBRad_Tr_n=1;
 comport.TRANSCEIVE_Set(IBRad_Tr_n);

 comport.ResDTR();//Dont allow CW-Keying
 if (Mact_n > 4)  //CW, CW, RTTY, PSK
  {
   Mact_n=0;comport.M_Set(Mact_n,FIact_n);//USB   
  }

 comport.ClrRXBuf();comport.ClrTXBuf();
 comport.Close();
 delete this;scandlg=0;
}
//-----------------------------------------------------------------------------
void ScanDlg::TransferToDlg()
{
 m_lof   =ScLoF_s;
 m_hif   =ScHiF_s;
 m_fstep =SFact_s;
 m_del   =ScStepDel_s;
 m_spec  =ScWrSpec;
 m_ltspec=ScLtSpec;
 UpdateData(FALSE);
}

void ScanDlg::TransferFrDlg()
{
 UpdateData(TRUE);
 strcpy(ScLoF_s,    LPCTSTR(m_lof));
 strcpy(ScHiF_s,    LPCTSTR(m_hif));
 strcpy(SFact_s,    LPCTSTR(m_fstep));
 strcpy(ScStepDel_s,LPCTSTR(m_del));
 ScWrSpec=m_spec;
 ScLtSpec=m_ltspec;
}
//-----------------------------------------------------------------------------
void ScanDlg::OnPRINTDISP() 
{
 if (ScIsRu) return;
 scanview->DoThePrint();	
}

void ScanDlg::OnLOG() 
{
 CStdioFile     F_Out;
 CFileException F_Exc;
 char           inStr[30]="";
 int            res,limit=29;

 if (ScIsRu || ScAr.f[ScLiInd] == 0) return;
 res=MyInpDlg(this,AppName,"Enter Remark for Logbook","",inStr,limit);
 if (res == IDOK) ToLOG(inStr);
}
//-----------------------------------------------------------------------------
void ScanDlg::OnSTOPMODE() 
{
 if (ScIsRu) return;
 STOPMODE_Dlg stopmodedlg(this);
 stopmodedlg.m_mo  =ScStopMo;
 stopmodedlg.m_ed00=ScM2Del_s;
 stopmodedlg.m_ed01=ScM3Lev_s;
 if (stopmodedlg.DoModal()==IDOK) 
  {
   ScStopMo=stopmodedlg.m_mo;
   strcpy(ScM2Del_s,LPCTSTR(stopmodedlg.m_ed00));ScM2Del_n=atoi(ScM2Del_s);
   strcpy(ScM3Lev_s,LPCTSTR(stopmodedlg.m_ed01));ScM3Lev_n=atoi(ScM3Lev_s);
  }	
}
//-----------------------------------------------------------------------------
void ScanDlg::OnMODE() 
{
 if (modedlg != 0) return;
 modedlg=new MODE_Dlg(this);
 modedlg->Create(IDD_MODE_DLG,this);
 modedlg->ShowWindow(SW_SHOW);
}
//-----------------------------------------------------------------------------
void ScanDlg::OnATT() 
{
 if (ScIsRu) return;
 ATTsw++;if (ATTsw > ATTmax) ATTsw=0;
 comport.ATT_Switch(ATTsw);  
 scanview->UpdateStatusLine1();
}

void ScanDlg::OnPAMP() 
{
 if (ScIsRu) return;
 PAMPsw++;if (PAMPsw > PAMPmax) PAMPsw=0;
 comport.PAMP_Switch(PAMPsw); 
 scanview->UpdateStatusLine1();	
}

void ScanDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
 int scr,pos;

 if (ScIsRu) return; 
 if (nSBCode > 7) return;

 switch (pScrollBar->GetDlgCtrlID())
  {
   case IDC_SCA_SCR_AF  :scr=0;pos=pScrollBar->GetScrollPos();break;
   case IDC_SCA_SCR_RF  :scr=1;pos=pScrollBar->GetScrollPos();break;
   case IDC_SCA_SCR_SQL :scr=2;pos=pScrollBar->GetScrollPos();break;
   case IDC_SCA_SCR_PBTL:scr=3;pos=pScrollBar->GetScrollPos();break;
   case IDC_SCA_SCR_PBTH:scr=4;pos=pScrollBar->GetScrollPos();break;
  }

 switch (nSBCode) 
  {
   case SB_PAGEUP       :pos+=10;if (pos > 255) pos=255;break;//Bild nach oben
   case SB_PAGEDOWN     :pos-=10;if (pos <   0) pos=0  ;break;//Bild nach unten
     
   case SB_LINELEFT     :pos--;if (pos < 0) pos=0;break;      //<-
   case SB_LINERIGHT    :pos++;if (pos > 255) pos=255;break;  //->
   case SB_LEFT         :pos=0;break;                         //Pos1
   case SB_RIGHT        :pos=255;break;                       //End      
   case SB_THUMBPOSITION: 
   case SB_THUMBTRACK   :pos=nPos;break;
  }

 switch (scr) 
  {     
   case 0:pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_AF);
          AFlev_n=pos;pSB->SetScrollPos(AFlev_n);
          comport.AFlev_Set(AFlev_n);
          break;
   case 1:pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_RF);
          RFlev_n=pos;pSB->SetScrollPos(RFlev_n);
          comport.RFlev_Set(RFlev_n);
          break;
   case 2:pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_SQL);
          SQLlev_n=pos;pSB->SetScrollPos(SQLlev_n);
          comport.SQLlev_Set(SQLlev_n);
          break;
   case 3:pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_PBTL);
          PBTL_n=pos;pSB->SetScrollPos(PBTL_n);
          comport.PBTLlev_Set(PBTL_n);
          break;
   case 4:pSB=(CScrollBar*) GetDlgItem(IDC_SCA_SCR_PBTH);
          PBTH_n=pos;pSB->SetScrollPos(PBTH_n);
          comport.PBTHlev_Set(PBTH_n);
          break;
  }		
 CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
//-----------------------------------------------------------------------------
void ScanDlg::PrepareScan()
{
 CString     DlgTitle; 
 CString     szFilter;
 CString     defName="";
 CFileDialog *OpenDlg;
 int         res;

 //Files laden-------------------------
 switch (ScOpMo)
  {
   case 1:break;
   case 2:if (FiExist(F_ScMScanFi)) defName=F_ScMScanFi;else defName=""; 
          szFilter="Frequency - Files (*.FRE) |*.fre|";
          DlgTitle="Select a Memory SCAN-File";
          break;
   case 3:if (FiExist(F_ScLibFi)) defName=F_ScLibFi;else defName="";
          szFilter="Library - Files (*.LIB) |*.lib|";
          DlgTitle="Select a Library-File";
          break;
  }
 if (ScOpMo == 2 || ScOpMo == 3) 
  {
   OpenDlg=new CFileDialog(TRUE,NULL,defName,
                           OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST, 
                           szFilter);
   OpenDlg->m_ofn.lpstrTitle=DlgTitle;
   if (OpenDlg->DoModal()== IDOK)
    {
     FiName=OpenDlg->GetPathName();
    }else FiName="";
   delete OpenDlg;
   //AfxMessageBox(FiName);
   if (FiName == "")
    {
     TaMsgBox(AppName,scmsg01,2);
     ScOpMo=0;
     return;
    }
   if (ScOpMo == 2) strcpy(F_ScMScanFi,LPCTSTR(FiName));
   if (ScOpMo == 3) strcpy(F_ScLibFi,LPCTSTR(FiName));  
  }
 //------------------------------------
 ScLiInd=0;ScLiNum=0;

 if (ScOpMo == 1)//SCAN
  {
   TransferFrDlg();
   res=MakeAndCheckScanPars(0,"");
   if (res < 0) {TaMsgBox(AppName,scmsg02,2);ScOpMo=0;return;}
  }
 if (ScOpMo == 2)//M-SCAN
  {
   TransferFrDlg();
   strcpy(finame,LPCTSTR(FiName));
   res=MakeAndCheckScanPars(1,finame);
   if (res < 0) {TaMsgBox(AppName,scmsg03,2);ScOpMo=0;return;}
   ScLoF_s[0]=0;ScHiF_s[0]=0;SFact_s[0]=0;TransferToDlg();
  }
 if (ScOpMo == 3)//LIB
  {
   strcpy(finame,LPCTSTR(FiName));
   res=R_ScanLib(finame);
   if (res < 0) {TaMsgBox(AppName,scmsg01,2);ScOpMo=0;return;}
   if (ScOpMoFrFile == 1)//scan in lib
    {
     TransferToDlg();
    }
   if (ScOpMoFrFile == 2)//m-scan in lib
    {
     ScLoF_s[0]=0;ScHiF_s[0]=0;SFact_s[0]=0;TransferToDlg();
    }
  }
 scanview->Invalidate();
 ScIsRu=0;ScIsSta=0;ScIsSto=0;ScIsResta=0;
 //------------------------------------
 comport.F_Set(ScAr.f[ScLiInd]); 
 comport.M_Set(ScAr.m[ScLiInd],FIact_n);
}

void ScanDlg::OnSCAN() 
{
 if (ScIsRu) return;
 ScOpMo=1;PrepareScan();	
}

void ScanDlg::OnMSCAN() 
{
 if (ScIsRu) return;
 ScOpMo=2;PrepareScan();	
}

void ScanDlg::OnLOLIB() 
{
 if (ScIsRu) return;
 ScOpMo=3;PrepareScan();	
}

void ScanDlg::OnSTOLIB() 
{
 char        fname[Fl];
 CString     FiName;
 CString     szFilter="Library - Files (*.LIB) |*.lib|"; 
 CString     defName="NEW.LIB";
 CFileDialog *SaveDlg;

 if (ScIsRu || ScOpMo == 0) return; 
 SaveDlg=new CFileDialog(FALSE,NULL,defName,
                         OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
                         szFilter);
 SaveDlg->m_ofn.lpstrTitle="File Save As";
 SaveDlg->m_ofn.lpstrDefExt="lib";
 if (SaveDlg->DoModal()== IDOK) FiName=SaveDlg->GetPathName();else FiName="";
 delete SaveDlg;
 if (FiName == "") return;
 TransferFrDlg();
 strcpy(fname,LPCTSTR(FiName));W_ScanLib(fname); 
}

void ScanDlg::OnLOADDEFAULT() 
{
 if (ScIsRu) return; 
 strcpy(ScLoF_s,"144.400,000");
 strcpy(ScHiF_s,"147.990,000");
 strcpy(SFact_s ,".012,500");

 strcpy(Mact_s,"FM");ModMstr(Mact_s);
 strcpy(FIact_s,"-");ModFIstr(FIact_s);

 strcpy(ScStepDel_s,"10");ScStepDel_n=10;
 strcpy(ScM2Del_s,"1000");ScM2Del_n=1000;
 strcpy(ScM3Lev_s,"100");ScM3Lev_n=100;
 ScStopMo=1;

 ScWrSpec=1;
 ScLtSpec=1;

 TransferToDlg();
 ScOpMo=0;
}
//-----------------------------------------------------------------------------
void ScanDlg::ToRadio() 
{
 comport.F_Set(ScAr.f[ScLiInd]);
 if ((ScOpMo == 2 || (ScOpMo == 3 && ScOpMoFrFile == 2))
     && Mact_n != ScAr.m[ScLiInd])
  {
   comport.M_Set(ScAr.m[ScLiInd],FIact_n);
   Mact_n=ScAr.m[ScLiInd];
  }
}

void ScanDlg::Scan(int start) 
{
 int sw_hw;
 
 sw_hw=RADIOS[Radio_Num].SQL_SwHw;//0=SW / 1=HW
 while (ScIsRu)
  {
   KeepWindowsAlive();
   ScLiInd=start;SQL_oc=0;SMlev_n=0;
   if (ScAr.m[start] != 7) {ToRadio();VDelay(ScStepDel_n);}
   //Speclines + Marker zeichnen-----------------------
   if (ScWrSpec)
    {
     comport.SMlev_Ask();
     
     if (ScLtSpec)
      {
       if (ScStopMo  < 2 && SMlev_n > ScAr.y[ScLiInd]) ScAr.y[ScLiInd]=SMlev_n;
       if (ScStopMo == 2 && SMlev_n > ScM3Lev_n && SMlev_n > ScAr.y[ScLiInd]) ScAr.y[ScLiInd]=SMlev_n;
      }else
      {
       if (ScStopMo  < 2) ScAr.y[ScLiInd]=SMlev_n;
       if (ScStopMo == 2) if (SMlev_n > ScM3Lev_n) ScAr.y[ScLiInd]=SMlev_n;else ScAr.y[ScLiInd]=0;
      }
     //if (ScMode==2 && SmVal<ScM3Levn) ScAr.y[ScInd]=0;else ScAr.y[ScInd]=SmVal;
     scanview->DrawLine(ScLiInd);
    }
   scanview->DrawMark(ScLiInd);
   //Stopmodes-----------------------------------------
   if (ScStopMo == 0)//------------M1
    {
     if (sw_hw  == 0) comport.SQLoc_SW_Ask();
     if (sw_hw  == 1) {VDelay(CMD_Del);comport.SQLoc_HW_Ask();}
     if (SQL_oc == 1) 
      {
       ScIsRu=0;IsStopped();//MsgBox("","stop",1);
      }
    }
   if (ScStopMo == 1)//------------M2
    {
     if (sw_hw  == 0) comport.SQLoc_SW_Ask();
     if (sw_hw  == 1) {VDelay(CMD_Del);comport.SQLoc_HW_Ask();}
     if (SQL_oc == 1) 
      {
       VDelay(ScM2Del_n);
      } 
    }
   if (ScStopMo == 2)//------------M3
    {
     comport.SMlev_Ask();
     if (SMlev_n > ScM3Lev_n)
      {
       VDelay(ScM2Del_n);
      }
    }
   //--------------------------------------------------
   if (ScLiInd+1 < ScLiNum) start++;else start=0;
   if (start == 0)
    {
     scanview->EraseScreen(1);//Marker
     if (ScWrSpec && !ScLtSpec) scanview->EraseScreen(2);//Speclines
    }
  }
}

void ScanDlg::OnSTART() 
{
 if (ScIsRu) return;
 if (ScOpMo == 0)
  {
   TaMsgBox(AppName,"Set SCAN-Mode first\n(Scan/M-Scan/Lib)",3);
   return;
  }       

 GetDateTime(ScTime1,10);
 //------------------------------------
 comport.M_Set(Mact_n,FIact_n);
 //------------------------------------
 GetDlgItem(IDC_SCA_STOP)->SetFocus();
 ScIsSta=1;ScIsSto=0;ScIsResta=0;
 scanview->CalcWinSize();
 scanview->UpdateStatusLine2();
 scanview->DrawCoords();
 ScIsRu=1;ScLiInd=0;Scan(ScLiInd);
}

void ScanDlg::IsStopped() 
{
 ScIsSta=0;ScIsSto=1;ScIsResta=0;
 GetDlgItem(IDC_SCA_RESTART)->SetFocus();
 //------------------------------------
 GetDateTime(ScTime2,10);
 scanview->UpdateStatusLine2();
 ScIsRu=0;
}

void ScanDlg::OnSTOP() 
{
 if (!ScIsRu) return;
 IsStopped();
}

void ScanDlg::IsRestarted() 
{
 ScIsSta=0;ScIsSto=0;ScIsResta=1;
 GetDlgItem(IDC_SCA_STOP)->SetFocus();
 //------------------------------------
 GetDateTime(ScTime2,10);
 if (ScLiInd+1 < ScLiNum) ScLiInd++;else ScLiInd=0;
 strcpy(Fact_s,ScAr.f[ScLiInd]);
 scanview->UpdateStatusLine2();
 scanview->EraseScreen(1);
 ScIsRu=1;Scan(ScLiInd);
}

void ScanDlg::OnRESTART() 
{
 if (ScIsRu || ScLiNum == 0) return;
 IsRestarted();
}

void ScanDlg::OnSKIP() 
{
 if (ScIsRu || ScLiNum == 0) return;
 ScAr.m[ScLiInd]=SKI_Index;
}

void ScanDlg::OnDO() 
{
 if (ScIsRu || ScLiNum == 0) return;
 if (ScLiInd-1 >= 0) ScLiInd--;else ScLiInd=ScLiNum;
 if (ScAr.m[ScLiInd] == SKI_Index) return;
 ToRadio();
 scanview->EraseScreen(1);scanview->DrawMark(ScLiInd);
}

void ScanDlg::OnUP() 
{
 if (ScIsRu || ScLiNum == 0) return;
 if (ScLiInd+1 < ScLiNum) ScLiInd++;else ScLiInd=0;
 if (ScAr.m[ScLiInd] == SKI_Index) return;
 ToRadio();
 scanview->EraseScreen(1);scanview->DrawMark(ScLiInd);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++














































































