// R_REM.H : Remote f. Radio
// G. TAMM, DF9ZO 2007
//--------------------
#pragma once
//--------------------
#include "R_DLG.H"
#include "R_ICOMmem.H"
#include "R_CWKB.H"
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemWin:File-Display++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class RemWin : public CFrameWnd
{
	DECLARE_DYNCREATE(RemWin)
public:
    RemWin(CFrameWnd* parent,CString& file);

    CString LineBuf;
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(RemWin)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

protected:
   RemWin();  
	virtual ~RemWin();

   CFrameWnd* winparent;
   char       finame[Fl];                      
   //Scrollbars-------------
   int ScrX,ScrXmax,ScrY,ScrPaStep;
   int SchrH,SchrB;     

   void OnReturn();
   void UpdateScrBars();    
   void OnHome();
	void OnEnd();
	void OnLineDo();
	void OnLineUp();
	void OnPageDo();
	void OnPageUp();
   void OnLineRi();
	void OnLineLe();
	void OnPageRi();
	void OnPageLe();
   // Generated message map functions
	//{{AFX_MSG(RemWin)
	afx_msg void OnHScroll    (UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSize       (UINT nType, int cx, int cy);
	afx_msg void OnVScroll    (UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnPaint();
	afx_msg void OnKeyDown    (UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemDisp:Frequency-Display++++++++++++++++++++++++++++++++++++++++++++++++++++
class RemDisp : public CFrameWnd
{
	DECLARE_DYNCREATE(RemDisp)
public:
	RemDisp(); 
	virtual ~RemDisp();

   void         UpdateFreqDisp(void);
   void         UpdateStatusDisp(int line1,int line2,int line3,int line4);
   void         ChFreqByKeys(int up);
   void         ChFreqInDisp(unsigned int step,int up);
   unsigned int CalcDispStep(int mx);
   // ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(RemDisp)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL
protected:
   CBrush Brush,*oldbrush;
   CFont  Nfont,Ffont,*oldfont;

   int    Hn,Bn,Hf,Bf;   //Schrift: Hoehe normal/freq, Breite: normal/freq
   int    SHIFT_DO,CTRL_DO;
   char   DispStr1[150],DispStr2[150],DispStr3[150],DispStr4[150];
   char   Fold_s[RStrLf];//Speicherung alter F-String
  
	// Generated message map functions
	//{{AFX_MSG(RemDisp)
   afx_msg LRESULT MSG_UpdateFreq (WPARAM wParam,LPARAM lParam);
   afx_msg LRESULT MSG_UpdateMoFi (WPARAM wParam,LPARAM lParam);
   afx_msg LRESULT MSG_UpdateSQLSM(WPARAM wParam,LPARAM lParam);

   afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyUp      (UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown    (UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg BOOL OnMouseWheel (UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemExtDlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class RemExtDlg : public CDialog
{
public:
	RemExtDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(RemExtDlg)
	enum { IDD = IDD_REMEXT_DLG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(RemExtDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL
protected:
   HACCEL      m_hAccel;
   CScrollBar  *pSB;
   CStatic     *pST;

	// Generated message map functions
	//{{AFX_MSG(RemExtDlg)
   virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnANF_Switch();
   afx_msg void OnMNF();
	afx_msg void OnNB_Switch();
	afx_msg void OnNR_Switch();
   afx_msg void OnAskAll();
	afx_msg void OnAllNeutral();
   afx_msg void OnPBTH_NEUTRAL();
   afx_msg void OnPBTL_NEUTRAL();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()    
};
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemDlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class RemDlg : public CDialog
{
public:
	RemDlg(CWnd* pParent = NULL);   // standard constructor

   void F_Ask_M_Ask();
   void S_Ask_SQL_Ask();

   void SetCOMTimer();
   void KillCOMTimer();
   void SetSQLSMTimer();
   void KillSQLSMTimer();
// Dialog Data
	//{{AFX_DATA(RemDlg)
	enum { IDD = IDD_REM_DLG };
	// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(RemDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

protected:
   HACCEL m_hAccel;
   UINT   RegWinTaWEB;
   int    CTRL_DO;      

   // Generated message map functions
	//{{AFX_MSG(RemDlg)
   afx_msg LRESULT MSG_RemWinItemSelection(WPARAM wParam,LPARAM lParam);
   afx_msg LRESULT MSG_MainWindowPosChange(WPARAM wParam,LPARAM lParam);
   
	virtual BOOL OnInitDialog();
	virtual void OnOK();

	afx_msg void OnEXTENDED();
	afx_msg void OnLOG();
	afx_msg void OnMEM();
   afx_msg void OnRTTY();
	afx_msg void OnHOWTO();
   afx_msg void OnM_Set();
   afx_msg void OnF_Set();
   afx_msg void OnF_MPW();
   afx_msg void OnFSTEPS_Set();
	afx_msg void OnVFO_AB_Switch();
   afx_msg void OnVFO_EQUAL_Switch();
   afx_msg void OnVFO_SPLIT_Switch();
   afx_msg void OnVFO_MEM_Switch();   
   afx_msg void OnDUP_Switch();
   afx_msg void OnANT_Switch();
   afx_msg void OnATT_Switch();
   afx_msg void OnPAMP_Switch();
   afx_msg void OnAGC_Switch();
   afx_msg void OnROOF_Switch();
   afx_msg void OnTUNE();
   afx_msg void OnASK_RADIO();
   afx_msg void OnMIC();
   afx_msg void OnCW();
   afx_msg void OnCWKeyB();
   afx_msg void OnDXCLUSTER();
   afx_msg void OnALT_F4();
   afx_msg void OnTimer(UINT nIDEvent);   
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()   
};
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern RemDlg*    remdlg;
extern RemExtDlg* remextdlg;
extern RemDisp*   remdisp;
extern RemWin*    remwin;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

