// R_REM.CPP : Remote f. Radio
// G. TAMM, DF9ZO 2007
//--------------------
#include "stdafx.h"
#include "R_REM.H"
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
RemDlg*    remdlg   =0;
RemExtDlg* remextdlg=0;
RemDisp*   remdisp  =0;
RemWin*    remwin   =0;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemWin:File-Display++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNCREATE(RemWin, CFrameWnd)

RemWin::RemWin() {}

RemWin::RemWin(CFrameWnd* parent,CString& file)
{
 winparent=parent;
 strcpy(finame,LPCTSTR(file));
 List_ReadFile(CStrLi,0,finame);CStrLi_Max=(int)CStrLi.size();
}

RemWin::~RemWin()
{
 List_RemAllElem(CStrLi);
 remwin=0;
}

BEGIN_MESSAGE_MAP(RemWin, CFrameWnd)
	//{{AFX_MSG_MAP(RemWin)
	ON_WM_HSCROLL()
	ON_WM_LBUTTONDOWN()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_PAINT()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL RemWin::PreCreateWindow(CREATESTRUCT& cs) 
{
 cs.style|=WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL;

 cs.x=Win_XIOpos+2;cs.y=Win_YIOpos+2;  
 cs.cx=250;cs.cy=200;

 ScrX=ScrY=0;ScrXmax=50;ScrPaStep=5;
 SetScrollRange(SB_VERT,0,CStrLi_Max-1);
 SetScrollRange(SB_HORZ,0,ScrXmax);
 SetScrollPos(SB_VERT,0);SetScrollPos(SB_HORZ,0);

 return CFrameWnd::PreCreateWindow(cs);
}
//-----------------------------------------------------------------------------
void RemWin::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
 if (CStrLi_Max == 0) return; 
 switch (nSBCode) 
  {     
   case SB_LINELEFT     :OnLineLe();break;
   case SB_LINERIGHT    :OnLineRi();break;
   case SB_PAGELEFT     :OnPageLe();break;
   case SB_PAGERIGHT    :OnPageRi();break;
   case SB_THUMBPOSITION: 
   case SB_THUMBTRACK   :ScrX=nPos;UpdateScrBars();break;
  }			
 CFrameWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

void RemWin::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
 if (CStrLi_Max == 0) return; 
 switch (nSBCode) 
  {     
   case SB_LINEUP       :OnLineUp();break;
   case SB_LINEDOWN     :OnLineDo();break;
   case SB_PAGEUP       :OnPageUp();break;
   case SB_PAGEDOWN     :OnPageDo();break;
   case SB_THUMBPOSITION: 
   case SB_THUMBTRACK   :ScrY=nPos;UpdateScrBars();break;
  }				
 CFrameWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

void RemWin::OnLineUp() {ScrY--;UpdateScrBars();}

void RemWin::OnLineDo() {ScrY++;UpdateScrBars();}

void RemWin::OnPageUp() {ScrY-=ScrPaStep;UpdateScrBars();}

void RemWin::OnPageDo() {ScrY+=ScrPaStep;UpdateScrBars();}

void RemWin::OnHome()   {ScrX=ScrY=0;UpdateScrBars();}

void RemWin::OnEnd()    {ScrX=0;ScrY=CStrLi_Max-1;UpdateScrBars();}

void RemWin::OnLineLe() {ScrX--;UpdateScrBars();}

void RemWin::OnLineRi() {ScrX++;UpdateScrBars();}

void RemWin::OnPageLe() {ScrX-=ScrPaStep;UpdateScrBars();}

void RemWin::OnPageRi() {ScrX+=ScrPaStep;UpdateScrBars();}

void RemWin::UpdateScrBars()
{
 if (ScrX < 0) ScrX=0;
 if (ScrX > ScrXmax-1)    ScrX=ScrXmax;
 if (ScrY < 0) ScrY=0; 
 if (ScrY > CStrLi_Max-1) ScrY=CStrLi_Max-1;

 SetScrollRange(SB_VERT,0,CStrLi_Max-1);SetScrollRange(SB_HORZ,0,ScrXmax);
 SetScrollPos(SB_VERT,0);SetScrollPos(SB_HORZ,0); 
 SetScrollPos(SB_HORZ,ScrX,TRUE);SetScrollPos(SB_VERT,ScrY,TRUE);
 Invalidate();
}
//-----------------------------------------------------------------------------
void RemWin::OnLButtonDown(UINT nFlags, CPoint point) 
{
 int MouseY;

 if (CStrLi_Max == 0) return;
 MouseY=(point.y/SchrH)+(ScrY+1);
 if (MouseY <= CStrLi_Max)
  {
   List_GetElemAt(CStrLi,LineBuf,MouseY);
   winparent->PostMessage(WM_REMWIN_ITEMSELECTION);
  }		
 CFrameWnd::OnLButtonDown(nFlags, point);
}

void RemWin::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
 if (CStrLi_Max == 0) return;
 switch (nChar)
  {
   case VK_HOME  :OnHome();  break;
   case VK_END   :OnEnd();   break;
   case VK_NEXT  :OnPageDo();break;
   case VK_DOWN  :OnLineDo();break;
   case VK_PRIOR :OnPageUp();break;
   case VK_UP    :OnLineUp();break;
   case VK_LEFT  :OnLineLe();break;
   case VK_RIGHT :OnLineRi();break;
   case VK_RETURN:OnReturn();break;
   default       :break;
  }	
 CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void RemWin::OnReturn()
{
 if (ScrY <= CStrLi_Max-1)
  {
   List_GetElemAt(CStrLi,LineBuf,ScrY+1);
   winparent->PostMessage(WM_REMWIN_ITEMSELECTION);
  }
}
//-----------------------------------------------------------------------------
void RemWin::OnSize(UINT nType, int cx, int cy) 
{
 CFrameWnd::OnSize(nType, cx, cy);
 Invalidate();		
}

void RemWin::OnPaint() 
{
 CPaintDC   dc(this);
 CFont*     oldfont;
 TEXTMETRIC metric;
 CRect      rect;
 CString    str;
 int        i,x,y,lifrom,lito;
  
 if (CStrLi_Max == 0) return; 
 oldfont=(CFont*) dc.SelectStockObject(ANSI_FIXED_FONT);
 GetClientRect(rect);
 dc.GetTextMetrics(&metric);
 SchrH=metric.tmHeight+metric.tmExternalLeading;
 SchrB=metric.tmAveCharWidth+metric.tmOverhang;
 //---------------------------------------------
 x=-(ScrX*SchrB);y=0;
 lifrom=ScrY+1;//Scroller beginnt bei 0
 lito=lifrom+((rect.bottom-rect.top)/SchrH);
 if (lito > CStrLi_Max) lito=CStrLi_Max;
 //---------------------------------------------
 for (i=lifrom;i<lito+1;i++)
  {
   List_GetElemAt(CStrLi,str,i);
   if (i == lifrom) dc.SetTextColor(RGB(255,0,0));
      else dc.SetTextColor(RGB(0,0,0));
   dc.TextOut(x,y,str);
   y+=SchrH;
  }
 //---------------------------------------------
 dc.SelectObject(oldfont); 
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemDisp:Frequency-Display++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNCREATE(RemDisp, CFrameWnd)

RemDisp::RemDisp() {}

RemDisp::~RemDisp() {}

BEGIN_MESSAGE_MAP(RemDisp, CFrameWnd)
	//{{AFX_MSG_MAP(RemDisp)
   ON_MESSAGE(WM_REMDISP_FREQCHANGE ,MSG_UpdateFreq)
   ON_MESSAGE(WM_REMDISP_MOFICHANGE ,MSG_UpdateMoFi)
   ON_MESSAGE(WM_REMDISP_SQLSMCHANGE,MSG_UpdateSQLSM)

   ON_WM_LBUTTONDOWN()
	ON_WM_KEYUP()
	ON_WM_KEYDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_PAINT()
	ON_WM_MOUSEWHEEL()
   ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP 
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL RemDisp::PreCreateWindow(CREATESTRUCT& cs) 
{
 SHIFT_DO=0;CTRL_DO=0;

 cs.style|=WS_POPUP | WS_VISIBLE | WS_CAPTION;
 
 cs.x=Win_XIOpos+2;cs.y=Win_YIOpos+2;  
 Hf=95;Bf=40;
 Hn=16;Bn=10;  
 cs.cx=13*Bf+10;cs.cy=Hf+5*Hn;
 RSDisp_W=cs.cx;RSDisp_H=cs.cy;

 Ffont.CreateFont(Hf,Bf,0,0,FW_BOLD,FALSE,FALSE,0,ANSI_CHARSET,
                  OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
                  DEFAULT_PITCH | FF_MODERN,"Courier New");
 Nfont.CreateFont(Hn,Bn,0,0,FW_MEDIUM,FALSE,FALSE,0,ANSI_CHARSET,
                  OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
                  DEFAULT_PITCH | FF_MODERN,"Arial");
 Brush.CreateSolidBrush(RGB(255,255,255));

 for (int x=0;x < 13;x++) Fold_s[x]=-1;
 PtrToRemDisp=this;

 return CFrameWnd::PreCreateWindow(cs);
}
//-----------------------------------------------------------------------------
void RemDisp::ChFreqByKeys(int up)
{
 float res;
 int   step;

 step=AdjFstepAndMode();
 if (up)
  {
   res=(float)Fact_n+step;
   if ((unsigned int)res > Fmax_n) return;else Fact_n+=step;
  }else
  {
   res=(float)Fact_n-step;
   if ((unsigned int)res < Fmin_n) return;else Fact_n-=step;
  }
 
 FnumToFstr(Fact_s,Fact_n);
 comport.F_Set(Fact_s);
 UpdateFreqDisp();UpdateStatusDisp(1,1,0,0);
}

void RemDisp::ChFreqInDisp(unsigned int step,int up)
{
 float res;

 if (up)
  {
   res=(float)Fact_n+step;
   if ((unsigned int)res > Fmax_n) return;else Fact_n+=step;
  }else
  {
   res=(float)Fact_n-step;
   if ((unsigned int)res < Fmin_n) return;else Fact_n-=step;
  }
 
 FnumToFstr(Fact_s,Fact_n);
 comport.F_Set(Fact_s);
 UpdateFreqDisp();UpdateStatusDisp(1,1,0,0);
}

unsigned int RemDisp::CalcDispStep(int mx)
{
 // 1295.350,000   Bf=40
 if (CTRL_DO && mx >= 480) return OFact_n;
 if (SHIFT_DO)
  {
   if (mx > 200 && mx < 240) return 5;
   if (mx > 240 && mx < 280) return 6;
   if (mx > 280 && mx < 320) return 7;
   if (mx > 360 && mx < 400) return 9;
   if (mx > 400 && mx < 440) return 10;
   if (mx > 440 && mx < 480) return 11;
   return 0;
  }
 //------------------------------------------
 if (mx < 40)              return 1000000000;
 if (mx >  40 && mx <  80) return 100000000;
 if (mx >  80 && mx < 120) return 10000000;
 if (mx > 120 && mx < 160) return 1000000;
 if (mx > 160 && mx < 200) return 0;
 if (mx > 200 && mx < 240) return 100000;
 if (mx > 240 && mx < 280) return 10000;
 if (mx > 280 && mx < 320) return 1000;
 if (mx > 320 && mx < 360) return 0;
 if (mx > 360 && mx < 400) return 100;
 if (mx > 400 && mx < 440) return 10;
 if (mx > 440 && mx < 480) return 1;
 if (mx > 480) return SFact_n;
 return 0;
}
//-----------------------------------------------------------------------------
void RemDisp::OnPaint() 
{
 CPaintDC dc(this); 

 dc.SetBkMode(TRANSPARENT);
 oldfont=(CFont*)dc.SelectObject(&Ffont);
 dc.SetTextColor(blue);dc.TextOut(0,0,Fact_s,12);
 dc.SetTextColor(magenta);dc.TextOut(12*Bf,0,"",1); // 
 dc.SelectObject(&oldfont);
 strcpy(Fold_s,Fact_s);
 UpdateStatusDisp(1,1,1,1);
}

LRESULT RemDisp::MSG_UpdateFreq(WPARAM wParam,LPARAM lParam)
{
 UpdateFreqDisp();
 return 0L;
}

void RemDisp::UpdateFreqDisp(void)
{
 CClientDC dc(this);
 CRect     rect;
 char      str[2];
 int       i,x;

 oldbrush=(CBrush*)dc.SelectObject(&Brush);
 oldfont=(CFont*)dc.SelectObject(&Ffont);
 dc.SetBkMode(TRANSPARENT);
 dc.SetTextColor(blue);
 str[1]=0;
 for (x=0;x<12;x++)
  {
   if (x==4 || x==8) continue;// . , im String
   if (Fold_s[x] != Fact_s[x])
    {
     i=x*Bf;
     rect.left=i;rect.top=0;rect.right=i+Bf;rect.bottom=Hf; 
     dc.FillRect(rect,&Brush);
     str[0]=Fact_s[x];Fold_s[x]=Fact_s[x];
     dc.TextOut(i,0,str,1);
    }
  }
 dc.SelectObject(&oldfont);
 dc.SelectObject(&oldbrush);
}

LRESULT RemDisp::MSG_UpdateMoFi(WPARAM wParam,LPARAM lParam)
{
 UpdateStatusDisp(1,0,0,0); 
 return 0L;
}

LRESULT RemDisp::MSG_UpdateSQLSM(WPARAM wParam,LPARAM lParam)
{
 UpdateStatusDisp(0,0,0,1); 
 return 0L;
}

void RemDisp::UpdateStatusDisp(int line1,int line2,int line3,int line4)
{
 CClientDC dc(this);
 CString   dstr("",200);
 CRect     rect;
 char      str[20],str_tmp[10],OFFstr[7]="-",ONstr[7]="+";
 int       start_sql=310;

 oldbrush=(CBrush*)dc.SelectObject(&Brush);
 if (line1)
  {
   DispStr1[0]=' ';DispStr1[1]='\0';
   strcat(DispStr1,Mact_s);strcpy(str_tmp,FIarr_s[FIact_n+3]);
   strcat(DispStr1," / ");strcat(DispStr1,str_tmp);
   //rect.left=0;rect.top=Hf;rect.right=13*Bf;rect.bottom=Hf+Hn; 
   rect.left=0;rect.top=Hf;rect.right=start_sql+1;rect.bottom=Hf+Hn;
   dc.FillRect(rect,&Brush);
  }
 if (line2)
  {
   strcpy(DispStr2," F-Step(SW): ");   strcat(DispStr2,SFact_s);
   strcat(DispStr2,"  F-Offs.(SW): ");strcat(DispStr2,OFact_s);
   rect.left=0;rect.top=Hf+Hn;rect.right=13*Bf;rect.bottom=Hf+2*Hn; 
   dc.FillRect(rect,&Brush);
  }
 if (line3)
  {
   strcpy(DispStr3," ANT:");
   if (ANTsw == 0) strcat(DispStr3,"1");                            //ANT
   if (ANTsw  > 0) {_itoa(ANTsw,str,10);strcat(DispStr3,str);}
   
   strcat(DispStr3,"  ATT:");                                       //ATT
   if (ATT_s[0] == '-') strcpy(ATT_s,"OFF ");
   strcat(DispStr3,ATT_s);              

   strcat(DispStr3,"  PAMP:");                                      //PAMP
   if (PAMP_s[0] == '-') strcpy(PAMP_s,"OFF ");
   strcat(DispStr3,PAMP_s);
      
   strcat(DispStr3,"  NB:");
   if (NBsw) strcat(DispStr3,ONstr);else strcat(DispStr3,OFFstr);
   strcat(DispStr3,"  NR:");
   if (NRsw) strcat(DispStr3,ONstr);else strcat(DispStr3,OFFstr);
   strcat(DispStr3,"  ANF:");
   if (ANFsw) strcat(DispStr3,ONstr);else strcat(DispStr3,OFFstr);
   rect.left=0;rect.top=Hf+2*Hn;rect.right=13*Bf;rect.bottom=Hf+3*Hn;       
   dc.FillRect(rect,&Brush);
  }
 if (line4)
  {
   strcpy(DispStr4,"SQL: ");
   if (SQL_oc == 0) DispStr4[5]='C';else DispStr4[5]='O';DispStr4[6]=0;
   strcat(DispStr4," / S: ");strcat(DispStr4,SMlev_s);
   //rect.left=0;rect.top=Hf;rect.right=13*Bf;rect.bottom=Hf+Hn;                  
   rect.left=start_sql-1;rect.top=Hf;rect.right=13*Bf;rect.bottom=Hf+Hn;   
   dc.FillRect(rect,&Brush);
  }
 dc.SelectObject(&oldbrush);
 //-----------------------------------
 dc.SetBkMode(TRANSPARENT);
 oldfont=(CFont*)dc.SelectObject(&Nfont);
 if (line1) {dc.SetTextColor(red);    dstr=DispStr1;dc.TextOut(          0,Hf,dstr);}
 if (line2) {dc.SetTextColor(green);  dstr=DispStr2;dc.TextOut(          0,Hf+Hn,dstr);}
 if (line3) {dc.SetTextColor(black);  dstr=DispStr3;dc.TextOut(          0,Hf+2*Hn,dstr);}
 if (line4) {dc.SetTextColor(magenta);dstr=DispStr4;dc.TextOut(start_sql+2,Hf,dstr);} 
 dc.SelectObject(&oldfont);
}
//-----------------------------------------------------------------------------
void RemDisp::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{            
 if (nChar == VK_SHIFT)   {SHIFT_DO=1;return;}
 if (nChar == VK_CONTROL) {CTRL_DO=1;return;}
 if (nChar == VK_NEXT)    {ChFreqInDisp(OFact_n,0);return;}//F-Offset
 if (nChar == VK_PRIOR)   {ChFreqInDisp(OFact_n,1);return;}
 if (nChar == VK_DOWN)    {ChFreqInDisp(SFact_n,0);return;}//F-Step
 if (nChar == VK_UP)      {ChFreqInDisp(SFact_n,1);return;}
 if (nChar == VK_LEFT)    {ChFreqByKeys(0);return;}
 if (nChar == VK_RIGHT)   {ChFreqByKeys(1);return;} 
	
 CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void RemDisp::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
 if (nChar == VK_SHIFT)   {SHIFT_DO=0;return;}
 if (nChar == VK_CONTROL) {CTRL_DO=0;return;}
	
 CFrameWnd::OnKeyUp(nChar, nRepCnt, nFlags);
}

void RemDisp::OnLButtonDown(UINT nFlags, CPoint point) 
{
 unsigned int x;
 char     fstr[13];

 if (point.y > Hf) return;
 x=CalcDispStep(point.x);
 if (SHIFT_DO)
  {
   if (x < 1) return;
   strcpy(fstr,Fact_s);fstr[x]='0';
   Fact_s[x]='0';Fact_n=FstrToFnum(Fact_s);
   comport.F_Set(Fact_s);
   UpdateFreqDisp();
   return;
  }
 if (Fact_n > x) ChFreqInDisp(x,0);
	
 CFrameWnd::OnLButtonDown(nFlags, point); 
}

void RemDisp::OnRButtonDown(UINT nFlags, CPoint point) 
{
 if (point.y > Hf || SHIFT_DO) return;
 ChFreqInDisp(CalcDispStep(point.x),1);
	
 CFrameWnd::OnRButtonDown(nFlags, point);
}

BOOL RemDisp::OnMouseWheel(UINT nFlags, short zDelta, CPoint point) 
{
 int direction;

 ScreenToClient(&point);
 if (point.y > Hf || SHIFT_DO) return 0;
 if (zDelta > 0) direction=1;else direction=0;  
 ChFreqInDisp(CalcDispStep(point.x),direction);
	
 return CFrameWnd::OnMouseWheel(nFlags, zDelta, point);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemExtDlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
RemExtDlg::RemExtDlg(CWnd* pParent /*=NULL*/)
	      : CDialog(RemExtDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(RemExtDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void RemExtDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(RemExtDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(RemExtDlg, CDialog)
	//{{AFX_MSG_MAP(RemExtDlg)
   ON_BN_CLICKED(IDC_REMEXT_ANF,          OnANF_Switch)
	ON_BN_CLICKED(IDC_REMEXT_NB,           OnNB_Switch)
	ON_BN_CLICKED(IDC_REMEXT_NR,           OnNR_Switch)
   ON_BN_CLICKED(IDC_REMEXT_ASKALL,       OnAskAll)
	ON_BN_CLICKED(IDC_REMEXT_NEUTRAL,      OnAllNeutral)
   ON_BN_CLICKED(IDC_REMEXT_PBTH_NEUTRAL, OnPBTH_NEUTRAL)
   ON_BN_CLICKED(IDC_REMEXT_PBTL_NEUTRAL, OnPBTL_NEUTRAL)
   ON_BN_CLICKED(IDC_REMEXT_MNF,          OnMNF)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP    
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL RemExtDlg::OnInitDialog() 
{
 CString str("",50);
 char    tmpstr[10];

 CDialog::OnInitDialog();

 m_hAccel=NULL;
 m_hAccel=LoadAccelerators(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_REMEXTACCEL));
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 _itoa(Radio_Num+1,tmpstr,10);
 str="EXTENDED FUNCTIONS (RADIO ";str+=tmpstr;str+=")";
 SetWindowText(str);
 //-----------------------
 OnAskAll(); 
 //-----------------------
 PtrToRemExtDlg=this;

 return FALSE;// return TRUE unless you set the focus to a control
}
//-----------------------------------------------------------------------------
BOOL RemExtDlg::PreTranslateMessage(MSG* pMsg) 
{  
 if(!(m_hAccel && ::TranslateAccelerator(m_hWnd, m_hAccel, pMsg)))
   return CDialog::PreTranslateMessage(pMsg);else return TRUE;
	
 return CDialog::PreTranslateMessage(pMsg);
}
//-----------------------------------------------------------------------------
void RemExtDlg::OnOK() 
{
 DestroyWindow();
}

void RemExtDlg::PostNcDestroy() 
{
 delete this;remextdlg=0;PtrToRemExtDlg=NULL;
}
//-----------------------------------------------------------------------------
void RemExtDlg::OnANF_Switch() 
{
 ANFsw++;if (ANFsw > 1) ANFsw=0;
 comport.ANF_Switch(ANFsw);
 remdisp->UpdateStatusDisp(0,0,1,0);	
}

void RemExtDlg::OnMNF()
{
 MNF_Dlg mnfdlg(this); 
 
 if (mnfdlg.DoModal() == IDOK) 
  {
  }else return;  
}
//-----------------------------------------------------------------------------
void RemExtDlg::OnNB_Switch() 
{
 NBsw++;if (NBsw > 1) NBsw=0;
 if (NBsw == 1) 
  {
   pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NB_LEV);
   pSB->SetFocus();
  }
 comport.NB_Switch(NBsw);
 remdisp->UpdateStatusDisp(0,0,1,0);	
}

void RemExtDlg::OnNR_Switch() 
{
 NRsw++;if (NRsw > 1) NRsw=0;
 if (NRsw == 1) 
  {
   pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NR_LEV);
   pSB->SetFocus();
  }
 comport.NR_Switch(NRsw);
 remdisp->UpdateStatusDisp(0,0,1,0);
}
//-----------------------------------------------------------------------------
void RemExtDlg::OnAskAll()
{
 NRsw=0;NBsw=0;ANFsw=0;
 comport.ANF_Ask();
 comport.NR_Ask() ;
 comport.NB_Ask() ;

 AFlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_AF);
 pSB->SetScrollRange(0,255);
 comport.AFlev_Ask();
 pSB->SetScrollPos(AFlev_n);

 RFlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_RF);
 pSB->SetScrollRange(0,255);
 comport.RFlev_Ask();
 pSB->SetScrollPos(RFlev_n); 

 SQLlev_n=0;SMlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_SQL);
 pSB->SetScrollRange(0,255);
 comport.SQLlev_Ask();
 pSB->SetScrollPos(SQLlev_n);
   
 TXPWR_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_TXPWR);
 pSB->SetScrollRange(0,255);
 comport.TXPWR_Ask();
 pSB->SetScrollPos(TXPWR_n); 
 
 /*CWSPEED_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_CWSPEED);
 pSB->SetScrollRange(0,255);
 comport.CWSPEED_Ask();
 pSB->SetScrollPos(CWSPEED_n);*/
 
 NRlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NR_LEV);
 pSB->SetScrollRange(0,255);
 comport.NRlev_Ask();
 pSB->SetScrollPos(NRlev_n);

 NBlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NB_LEV);
 pSB->SetScrollRange(0,255);
 comport.NBlev_Ask();
 pSB->SetScrollPos(NBlev_n);

 NBwid_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NB_WID);
 pSB->SetScrollRange(0,255);
 comport.NBwid_Ask();
 pSB->SetScrollPos(NBwid_n);
 
 PBTL_n=128;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_PBTL);        
 pSB->SetScrollRange(0,255);
 if (Mact_n < 2 && Mact_n > 3) comport.PBTL_Ask();//FM, WFM: Fehlermeldung 
 pSB->SetScrollPos(PBTL_n);

 PBTH_n=128;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_PBTH);
 pSB->SetScrollRange(0,255);
 if (Mact_n < 2 && Mact_n > 3) comport.PBTH_Ask();//FM, WFM: Fehlermeldung 
 pSB->SetScrollPos(PBTH_n);
}

void RemExtDlg::OnAllNeutral() 
{
 ANFsw=0;
 comport.ANF_Switch(ANFsw);
 
 /*AFlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_AF);
 pSB->SetScrollPos(AFlev_n);
 comport.SetAF_lev(AFlev_n);*/

 NBsw=0;
 comport.NB_Switch(NBsw);
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NB_LEV);
 NBlev_n=128;/*Default=50%*/pSB->SetScrollPos(NBlev_n);
 comport.NBlev_Set(NBlev_n);
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NB_WID);
 NBwid_n=128;/*Default=50%*/pSB->SetScrollPos(NBwid_n);
 comport.NBwid_Set(NBwid_n);

 NRsw=0;
 comport.NR_Switch(NRsw);
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NR_LEV);
 NRlev_n=72;/*Default=4*/pSB->SetScrollPos(NRlev_n);
 comport.NRlev_Set(NRlev_n);

 OnPBTL_NEUTRAL();
 OnPBTH_NEUTRAL();
 
 remdisp->UpdateStatusDisp(1,1,1,1);		
}
void RemExtDlg::OnPBTH_NEUTRAL()
{
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_PBTH);
 PBTH_n=128;pSB->SetScrollPos(PBTH_n);
 comport.PBTHlev_Set(PBTH_n);
}

void RemExtDlg::OnPBTL_NEUTRAL()
{
 pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_PBTL);
 PBTL_n=128;pSB->SetScrollPos(PBTL_n);
 comport.PBTLlev_Set(PBTL_n);
}
//-----------------------------------------------------------------------------
void RemExtDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
 int scr=0,pos=0,posmax=255;

 if (nSBCode > 8) return;

 switch (pScrollBar->GetDlgCtrlID())
  {
   case IDC_REMEXT_SCR_AF     :scr=0 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_RF     :scr=1 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_SQL    :scr=2 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_PBTL   :scr=3 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_PBTH   :scr=4 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_NR_LEV :scr=5 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_TXPWR  :scr=6 ;pos=pScrollBar->GetScrollPos();break;
   //case IDC_REMEXT_SCR_CWSPEED:scr=7 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_NB_LEV :scr=7 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_REMEXT_SCR_NB_WID :scr=8 ;pos=pScrollBar->GetScrollPos();break;   
  }

 switch (nSBCode) 
  {
   case SB_PAGEUP       :pos+=10;if (pos > posmax) pos=posmax;break;//Bild nach oben
   case SB_PAGEDOWN     :pos-=10;if (pos <      0) pos=0     ;break;//Bild nach unten
        
   case SB_LINELEFT     :pos--;  if (pos <      0) pos=0     ;break;//<-
   case SB_LINERIGHT    :pos++;  if (pos > posmax) pos=posmax;break;//->
   case SB_LEFT         :pos=0;break;                               //Pos1
   case SB_RIGHT        :pos=posmax;break;                          //End   
   case SB_THUMBPOSITION: 
   case SB_THUMBTRACK   :pos=nPos;break;
  }
   
 switch (scr) 
  {     
   case 0 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_AF);
           AFlev_n=pos;pSB->SetScrollPos(AFlev_n);
           comport.AFlev_Set(AFlev_n);
           break;
   case 1 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_RF);
           RFlev_n=pos;pSB->SetScrollPos(RFlev_n);
           comport.RFlev_Set(RFlev_n);
           break;
   case 2 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_SQL);
           SQLlev_n=pos;pSB->SetScrollPos(SQLlev_n);
           comport.SQLlev_Set(SQLlev_n);
           break;
   case 3 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_PBTL);
           PBTL_n=pos;pSB->SetScrollPos(PBTL_n);
           comport.PBTLlev_Set(PBTL_n);
           break;
   case 4 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_PBTH);
           PBTH_n=pos;pSB->SetScrollPos(PBTH_n);
           comport.PBTHlev_Set(PBTH_n);
           break;
   case 5 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NR_LEV);
           NRlev_n=pos;pSB->SetScrollPos(NRlev_n);
           comport.NRlev_Set(NRlev_n);  
           break;
   case 6 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_TXPWR);
           TXPWR_n=pos;pSB->SetScrollPos(TXPWR_n);
           comport.TXPWR_Set(TXPWR_n);
           break;
   /*case 7 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_CWSPEED);
           CWSPEED_n=pos;pSB->SetScrollPos(CWSPEED_n);
           comport.CWSPEED_Set(CWSPEED_n);
           break;*/
   case 7 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NB_LEV);
           NBlev_n=pos;pSB->SetScrollPos(NBlev_n);
           comport.NBlev_Set(NBlev_n);      
           break;
   case 8 :pSB=(CScrollBar*) GetDlgItem(IDC_REMEXT_SCR_NB_WID);
           NBwid_n=pos;pSB->SetScrollPos(NBwid_n);
           comport.NBwid_Set(NBwid_n);    
           break;
  }		
 CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//RemDlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
RemDlg::RemDlg(CWnd* pParent /*=NULL*/)
	   : CDialog(RemDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(RemDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void RemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(RemDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(RemDlg, CDialog)
	//{{AFX_MSG_MAP(RemDlg)
   ON_MESSAGE(WM_REMWIN_ITEMSELECTION,MSG_RemWinItemSelection)
   ON_MESSAGE(WM_MAINWINDOW_POSCHANGE,MSG_MainWindowPosChange)
   
   ON_BN_CLICKED(IDC_REM_EXT,               OnEXTENDED)
	ON_BN_CLICKED(IDC_REM_LOG,               OnLOG)
	ON_BN_CLICKED(IDC_REM_MEM,               OnMEM)
	ON_BN_CLICKED(IDC_REM_RTTY,              OnRTTY)
	ON_BN_CLICKED(IDC_REM_HOWTO,             OnHOWTO)
   ON_BN_CLICKED(IDC_REM_SET_MODE,          OnM_Set)   
   ON_BN_CLICKED(IDC_REM_SET_F,             OnF_Set)
   ON_BN_CLICKED(IDC_REM_SET_FMPW,          OnF_MPW)
   ON_BN_CLICKED(IDC_REM_SET_FSTEP,         OnFSTEPS_Set)
	ON_BN_CLICKED(IDC_REM_SET_VFO_AB,        OnVFO_AB_Switch)
   ON_BN_CLICKED(IDC_REM_SET_VFOEQUAL,      OnVFO_EQUAL_Switch)
   ON_BN_CLICKED(IDC_REM_SET_VFOSPLIT,      OnVFO_SPLIT_Switch)
   ON_BN_CLICKED(IDC_REM_SET_VFOMEM,        OnVFO_MEM_Switch)
   ON_BN_CLICKED(IDC_REM_SET_VFODUP,        OnDUP_Switch)
   ON_BN_CLICKED(IDC_REM_SET_ANT,           OnANT_Switch)
   ON_BN_CLICKED(IDC_REM_SET_ATT,           OnATT_Switch)
   ON_BN_CLICKED(IDC_REM_SET_PAMP,          OnPAMP_Switch)
   ON_BN_CLICKED(IDC_REM_SET_AGC,           OnAGC_Switch)
   ON_BN_CLICKED(IDC_REM_SET_ROOF,          OnROOF_Switch)
   ON_BN_CLICKED(IDC_REM_TUNE,              OnTUNE)
   ON_BN_CLICKED(IDC_REM_ASKRADIO,          OnASK_RADIO)
   ON_BN_CLICKED(IDC_REM_MIC,               OnMIC)
   ON_BN_CLICKED(IDC_REM_CW,                OnCW)
   ON_BN_CLICKED(IDC_REM_CWKB,              OnCWKeyB)
   ON_BN_CLICKED(IDC_REM_TAWEB,             OnDXCLUSTER)
   ON_COMMAND   (IDC_REM_ALTF4,             OnALT_F4) 
	ON_WM_TIMER()
	//}}AFX_MSG_MAP   
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL RemDlg::OnInitDialog() 
{
 LPCTSTR REMDISP;
 CRect   rect;
 CString str("",50);
 char    dspstr[100],
         tmpstr[10];
 
 CDialog::OnInitDialog();

 m_hAccel=NULL;
 m_hAccel=LoadAccelerators(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_REMACCEL));
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 _itoa(Radio_Num+1,tmpstr,10);
 str="REMOTE (RADIO ";str+=tmpstr;str+=")";
 SetWindowText(str);
  
 remdisp=new RemDisp();
 _itoa(Radio_Num+1,tmpstr,10);
 str="DISPLAY (RADIO ";str+=tmpstr;str+=")";
 strcpy(dspstr,LPCTSTR(str));
 
 REMDISP=AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
                             LoadCursor(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDC_CURSOR_REMO)),
                             (HBRUSH)(COLOR_WINDOW+1),NULL);

 remdisp->Create(REMDISP,dspstr,0,CFrameWnd::rectDefault,AfxGetApp()->GetMainWnd(),0,NULL);
 remdisp->SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 RadioSettings();
 comport.Open(COM_PORT,COM_BAUD,COM_DATA,COM_STOP,COM_PARI,COM_PROT,1000,1000);
 comport.ResDTR(); 
 //Initialisierungen------
 strcpy(Fdef_s,RADIOS[Radio_Num].Fdef_s);ModFstr(Fdef_s,Fdef_s);
 strcpy(Fact_s,RADIOS[Radio_Num].RE_Fact_s);ModFstr(Fact_s,Fdef_s);Fact_n=FstrToFnum(Fact_s); 
 ModFstr(RADIOS[Radio_Num].Fmin_s,Fdef_s);Fmin_n=FstrToFnum(RADIOS[Radio_Num].Fmin_s);
 ModFstr(RADIOS[Radio_Num].Fmax_s,Fdef_s);Fmax_n=FstrToFnum(RADIOS[Radio_Num].Fmax_s);
 strcpy(SFact_s,RADIOS[Radio_Num].RE_SFact_s);ModFstr(SFact_s,SFdef_s);SFact_n=FstrToFnum(SFact_s);
 strcpy(OFact_s,RADIOS[Radio_Num].RE_OFact_s);ModFstr(OFact_s,OFdef_s);OFact_n=FstrToFnum(OFact_s);
 Mact_n =RADIOS[Radio_Num].RE_Mact_n;MnumToMstr(Mact_n,Mact_s);
 FIact_n=RADIOS[Radio_Num].RE_FIact_n;strcpy(FIact_s,FIarr_s[FIact_n]);                 //FInumToFIstr(FIact_n,FIact_s);
 strcpy(SMlev_s,"0");R_SMCFile(RADIOS[Radio_Num].SmConv_s);

 comport.PopUpFI_Set (1);
 comport.PopUpPBT_Set(1);
 
 REMO=1;PtrToRemDlg=this;
 CTRL_DO=0;

 if (COM_Poll_Mode   == 1) SetCOMTimer();
 if (SQLSM_Poll_Mode == 1) SetSQLSMTimer();   
 
 GetDlgItem(IDC_REM_HOWTO)->SetFocus();
 F_Ask_M_Ask();VDelay(CMD_Del);S_Ask_SQL_Ask();
 
 comport.ROOF_Ask();
 comport.ANT_Ask();
 comport.ATT_Ask() ;
 comport.PAMP_Ask();
 NRsw=0;NBsw=0;ANFsw=0;
 comport.ANF_Ask();
 comport.NR_Ask() ;
 comport.NB_Ask() ;
 comport.AGC_Ask();
 remdisp->Invalidate();

 comport.MIClev_Set (MIClev_n) ;
 comport.COMPlev_Set(COMPlev_n);

 GetWindowRect(&rect);//Screen-Coord.
 RSDlg_W=rect.right-rect.left;RSDlg_H=rect.bottom-rect.top;
 RSDlg_Y=rect.top-Win_YIOpos;

 comport.TRANSCEIVE_Set(1);//Transceive auf ON

 RegWinTaWEB=::RegisterWindowMessage("Msg_TaWEB_DXCluster");
 if (RegWinTaWEB == 0) AfxMessageBox(_T("TaWEB RegisterWindowMessage failed")); 

 return FALSE;// return TRUE unless you set the focus to a control
}
//-----------------------------------------------------------------------------
LRESULT RemDlg::MSG_MainWindowPosChange(WPARAM wParam,LPARAM lParam) 
{
 MoveWindow(Win_XIOpos+2,Win_YIOpos+RSDlg_Y,RSDlg_W,RSDlg_H,TRUE); 
 remdisp->MoveWindow(Win_XIOpos+2,Win_YIOpos+2,RSDisp_W,RSDisp_H,TRUE); 
 return 0L;
}
//-----------------------------------------------------------------------------
BOOL RemDlg::PreTranslateMessage(MSG* pMsg) 
{
 if(pMsg->message == WM_KEYDOWN)
  {
   if (pMsg->wParam == VK_CONTROL) 
    {
     CTRL_DO=1;return TRUE;
    }
   if (pMsg->wParam == VK_LEFT && CTRL_DO == 1) 
    {
     remdisp->ChFreqByKeys(0);return TRUE;
    }
   if (pMsg->wParam == VK_RIGHT && CTRL_DO == 1) 
    {
     remdisp->ChFreqByKeys(1);return TRUE;
    }      
  }
 if(pMsg->message == WM_KEYUP)
  {
   if (pMsg->wParam == VK_CONTROL) {CTRL_DO=0;return TRUE;}
  }

 if(pMsg->message == RegWinTaWEB)
  {
   char str[RStrLf]="";
   UINT freq=0,freqtmp=0;
   int  le,res;

   _ultoa(pMsg->wParam,str,10);
   le=strlen(str);
   StrInsChPos(str,',',le-1-2);le+=1;
   if      (le == 6) {StrInsChPos(str,'0',0);StrInsChPos(str,'.',0);le+=2;}
   else if (le == 7) {StrInsChPos(str,'.',0);le+=1;}
   else if (le >  7) {StrInsChPos(str,'.',le-1-6);le+=1;}

   strcpy(Fact_s,str);ModFstr(Fact_s,Fdef_s);Fact_n=FstrToFnum(Fact_s);
   if (Fact_n < Fmin_n || Fact_n > Fmax_n) return TRUE;
   res=comport.F_Set(Fact_s);
   if (res) {remdisp->UpdateFreqDisp();remdisp->UpdateStatusDisp(1,1,0,0);}
   
   return TRUE;
  }

 if(!(m_hAccel && ::TranslateAccelerator(m_hWnd, m_hAccel, pMsg)))
  {
   return CDialog::PreTranslateMessage(pMsg);
  }else return TRUE;
	
 return CDialog::PreTranslateMessage(pMsg);
}
//return TRUE if the message was fully processed in PreTranslateMessage 
//and should not be processed further. 
//return FALSE if the message should be processed in the normal way.
//-----------------------------------------------------------------------------
void RemDlg::OnOK() 
{
 PtrToRemDisp=NULL;
 remdisp->DestroyWindow();remdisp=0;
 if (remwin != 0) {remwin->DestroyWindow();remwin=0;}

 if (COM_Poll_Mode   == 1) KillCOMTimer();
 if (SQLSM_Poll_Mode == 1) KillSQLSMTimer();

 DestroyWindow();
}

void RemDlg::OnALT_F4() {OnOK();}

void RemDlg::PostNcDestroy() 
{
 REMO=0;CTRL_DO=0;

 if (remwin    != 0) {remwin   ->DestroyWindow();remwin   =0;}
 if (remextdlg != 0) {remextdlg->DestroyWindow();remextdlg=0;}
 if (cwkbdlg   != 0) {cwkbdlg  ->DestroyWindow();cwkbdlg  =0;}

 comport.ResDTR();//Dont allow CW-Keying
 if (Mact_n > 4)  //CW, CW, RTTY, PSK
  {
   Mact_n=0;comport.M_Set(Mact_n,FIact_n);//USB   
  }

 comport.ClrRXBuf();comport.ClrTXBuf();comport.Close();
 //Deinitialisierungen------
 strcpy(RADIOS[Radio_Num].RE_Fact_s,Fact_s);
 strcpy(RADIOS[Radio_Num].RE_SFact_s,SFact_s);
 strcpy(RADIOS[Radio_Num].RE_OFact_s,OFact_s);
 RADIOS[Radio_Num].RE_Mact_n =Mact_n;
 RADIOS[Radio_Num].RE_FIact_n=FIact_n;
 RADIOS[Radio_Num].RoofFi_n  =ROOFsw;  
 
 delete this;remdlg=0;PtrToRemDlg=NULL; 
}
//-----------------------------------------------------------------------------
void RemDlg::OnASK_RADIO()
{
 F_Ask_M_Ask();VDelay(CMD_Del);
 S_Ask_SQL_Ask();
}

void RemDlg::F_Ask_M_Ask() 
{
 comport.F_Ask();
 comport.M_Ask();
 remdisp->UpdateFreqDisp();remdisp->UpdateStatusDisp(1,0,0,0);  
}

void RemDlg::S_Ask_SQL_Ask() 
{
 if (RADIOS[Radio_Num].SQL_SwHw == 0) comport.SQLoc_SW_Ask();else comport.SQLoc_HW_Ask();
 comport.SMlev_Ask();
 if (SM_sel) SetSMstr(SMlev_n,1);else SetSMstr(SMlev_n,0);
 remdisp->UpdateStatusDisp(0,0,0,1);//remdisp->UpdateStatusDisp(1,0,0,0);  
}
//-----------------------------------------------------------------------------
void RemDlg::OnF_Set() 
{
 CString cstr;
 char    str[100],tr='#';
 int     pos,res;
 UINT    fnum;

 FSET_Dlg fsetdlg(this);
 fsetdlg.m_f=Fact_s;
 if (fsetdlg.DoModal() == IDOK)
  {
   cstr=fsetdlg.m_f;
  }else return;

 strcpy(str,(LPCTSTR)cstr);
 pos=StrChPos(str,tr,0);
 if (pos > -1) str[pos]=0;
 ModFstr(str,Fdef_s);fnum=FstrToFnum(str);
 if (fnum < Fmin_n || fnum > Fmax_n) return;

 strcpy(Fact_s,str);ModFstr(Fact_s,Fdef_s);Fact_n=FstrToFnum(Fact_s);
 res=comport.F_Set(Fact_s);
 if (res) {remdisp->UpdateFreqDisp();/*remdisp->UpdateStatusDisp(1,1,0,0);*/}//todo

 if (pos > -1)
  {
   comport.RadioComplete_Set(cstr);
   remdisp->UpdateStatusDisp(1,0,1,0);
  } 
}

void RemDlg::OnF_MPW()
{
 CString cstr;

 comport.RadioComplete_Get(cstr);
 CoBoStrLi.push_back(cstr);//push_front(cstr);
}

void RemDlg::OnM_Set() 
{
 if (modedlg != 0) return;
 modedlg=new MODE_Dlg(this);
 modedlg->Create(IDD_MODE_DLG,this);
 modedlg->ShowWindow(SW_SHOW);
}

void RemDlg::OnFSTEPS_Set()
{
 FSTEP_Dlg fstepdlg(this);

 fstepdlg.TransferToDlg();UpdateData(TRUE);

 if (fstepdlg.DoModal() == IDOK)
  {
   UpdateData(FALSE);fstepdlg.TransferFrDlg();
   remdisp->UpdateStatusDisp(0,1,0,0);
  }else return;
}
//-----------------------------------------------------------------------------
void RemDlg::OnVFO_AB_Switch()
{
 VFOsw++;if (VFOsw > 1) VFOsw=0;
 comport.VFO_AB_Switch(VFOsw);
 F_Ask_M_Ask();
}

void RemDlg::OnVFO_MEM_Switch()
{
 VMsw++;if (VMsw > 1) VMsw=0;
 comport.VFO_MEM_Switch(VMsw);
 F_Ask_M_Ask();
}

void RemDlg::OnVFO_EQUAL_Switch()
{
 comport.VFO_EQUAL_Switch();
}

void RemDlg::OnVFO_SPLIT_Switch()
{
 VFOspl++;if (VFOspl > 1) VFOspl=0;
 comport.VFO_SPLIT_Switch(VFOspl);
 OnVFO_EQUAL_Switch();
}

void RemDlg::OnDUP_Switch()
{
 DUPsw++;if (DUPsw > 2) DUPsw=0;
 comport.DUP_Switch(DUPsw);
}
//-----------------------------------------------------------------------------
void RemDlg::OnANT_Switch()
{
 ANTsw++;if (ANTsw > ANTmax) ANTsw=0;
 if (ANTmax > 0) comport.ANT_Switch(ANTsw);
 remdisp->UpdateStatusDisp(0,0,1,0);	
}

void RemDlg::OnATT_Switch()
{
 ATTsw++;if (ATTsw > ATTmax) ATTsw=0;
 comport.ATT_Switch(ATTsw);
 remdisp->UpdateStatusDisp(0,0,1,0);	
}

void RemDlg::OnPAMP_Switch()
{
 PAMPsw++;if (PAMPsw > PAMPmax) PAMPsw=0;
 comport.PAMP_Switch(PAMPsw);
 remdisp->UpdateStatusDisp(0,0,1,0);
}

void RemDlg::OnAGC_Switch()
{
 AGCsw++;if (AGCsw > 3) AGCsw=1;
 comport.AGC_Switch(AGCsw);
}

void RemDlg::OnROOF_Switch()
{
 ROOFsw++;if (ROOFsw > 2) ROOFsw=0;
 comport.ROOF_Switch(ROOFsw);
}
//-----------------------------------------------------------------------------
void RemDlg::OnTUNE()
{
 int          mode_org,fi_org,pwr_org,pwr_tune;
 unsigned int f_vfoplus;
 char         instr[RStrLf]     ="10",
              F_vfobplus[RStrLf]="2",
              tunestr[]         ="Push PTT to transmit + tune\n"
                                 "Press Enter to return to original TX-PWR + Mode";
 
 comport.ClrRXBuf();
                                                  
 comport.TXPWR_Ask();                                                       //Ask TXPWR 
 pwr_org=TXPWR_n;if (TXPWR_tune > 255) TXPWR_tune=255;
 _itoa(TXPWR_tune,instr,10);
 
 TUNE_Dlg dlg(this);
 dlg.m_vfoa    =Fact_s;
 dlg.m_vfobplus=F_vfobplus;
 dlg.m_txpwr   =instr; 
 if (dlg.DoModal()==IDOK)
  {
   comport.VFO_AB_Switch(0);                                                //Set VFO A
   VFOspl=0;comport.VFO_SPLIT_Switch(VFOspl);                               //Set NO Split

   strcpy(Fact_s,LPCTSTR(dlg.m_vfoa));                                      //Set F VFO A 
   ModFstr(Fact_s,Fdef_s);
   comport.F_Set(Fact_s);
   remdisp->UpdateFreqDisp();

   //OnM_Set();                                                             //Set Mode/Filter F VFO A
   comport.M_Ask();
   mode_org=Mact_n;fi_org=FIact_n;
 
   OnVFO_EQUAL_Switch();                                                    //Set VFO B=VFO A
   remdisp->UpdateStatusDisp(1,0,0,0);

   Fact_n=FstrToFnum(Fact_s);                                               //Set VFO B=VFO A + x kHz
   strcpy(instr,LPCTSTR(dlg.m_vfobplus));
   f_vfoplus=1000*(atoi(instr)); 
   Fact_n+=f_vfoplus;FnumToFstr(F_vfobplus,Fact_n);
   comport.VFO_AB_Switch(1) ;
   comport.F_Set(F_vfobplus);

   strcpy(instr,LPCTSTR(dlg.m_txpwr));                                      //Set TX-PWR
   TXPWR_tune=atoi(instr);
   if (TXPWR_tune > 100) TXPWR_tune=100;if (TXPWR_tune < 1) TXPWR_tune=1;
   pwr_tune=(TXPWR_tune*255)/100;
   comport.M_Set(5,FIact_n);                                                //Set Mode VFO B to FM=5
   comport.TXPWR_Set(pwr_tune);
   TaMsgBox(AppName,tunestr,2);

   comport.M_Set(mode_org,fi_org/*FIact_n*/);                               //Set Mode/Filter VFO B to org
   comport.TXPWR_Set(pwr_org);

   comport.VFO_AB_Switch(0);                                                //Set VFO A

   VFOspl=1;comport.VFO_SPLIT_Switch(VFOspl);                               //Set Split
  }else return;
}
//-----------------------------------------------------------------------------
void RemDlg::OnRTTY()
{
 RTTY_Dlg rttydlg(this); 
/*
 Neutralstellung
 RTTY_MFsw_n=2;
 RTTY_SHsw_n=0;
 RTTY_KPsw_n=0;
 RTTY_RXDECsw_n=0; 
 RTTY_TPFsw_n=0;
*/
 RTTY_MFsw_n=2;
 comport.RTTY_MF_Ask();
 rttydlg.m_MF=RTTY_MFsw_n;

 RTTY_SHsw_n=0;
 comport.RTTY_SH_Ask();
 rttydlg.m_SH=RTTY_SHsw_n;

 RTTY_KPsw_n=0;
 comport.RTTY_KP_Ask();
 rttydlg.m_KP=RTTY_KPsw_n;

 RTTY_RXDECsw_n=0;
 comport.RTTY_RXDEC_Ask();
 rttydlg.m_RXDEC=RTTY_RXDECsw_n;
 
 RTTY_TPFsw_n=0;
 comport.RTTY_TPF_Ask();
 rttydlg.m_TPF=RTTY_TPFsw_n;

 if (rttydlg.DoModal() == IDOK) 
  {
   RTTY_MFsw_n=rttydlg.m_MF;
   comport.RTTY_MF_Set(RTTY_MFsw_n);

   RTTY_SHsw_n=rttydlg.m_SH;
   comport.RTTY_SH_Set(RTTY_SHsw_n);

   RTTY_KPsw_n=rttydlg.m_KP;
   comport.RTTY_KP_Set(RTTY_KPsw_n);

   RTTY_RXDECsw_n=rttydlg.m_RXDEC;
   comport.RTTY_RXDEC_Set(RTTY_RXDECsw_n);
   
   RTTY_TPFsw_n=rttydlg.m_TPF;
   comport.RTTY_TPF_Set(RTTY_TPFsw_n);
  }
}
//-----------------------------------------------------------------------------
void RemDlg::OnCW()
{
 if (cwdlg != 0) return;
 cwdlg=new CW_Dlg(this);
 cwdlg->Create(IDD_CW_DLG,this);
 cwdlg->ShowWindow(SW_SHOW); 
}
//-----------------------------------------------------------------------------
void RemDlg::OnMIC()
{
 MIC_Dlg micdlg(this);
 
 micdlg.m_ssbbw=TXSSBbw_n;
 micdlg.m_wilo =TXSSBbw_wilo_n;
 micdlg.m_wihi =TXSSBbw_wihi_n;
 micdlg.m_milo =TXSSBbw_milo_n;
 micdlg.m_mihi =TXSSBbw_mihi_n;
 micdlg.m_nalo =TXSSBbw_nalo_n;
 micdlg.m_nahi =TXSSBbw_nahi_n;
 
 if (micdlg.DoModal() == IDOK) 
  {
   TXSSBbw_n     =micdlg.m_ssbbw;
   TXSSBbw_wilo_n=micdlg.m_wilo;
   TXSSBbw_wihi_n=micdlg.m_wihi;
   TXSSBbw_milo_n=micdlg.m_milo;
   TXSSBbw_mihi_n=micdlg.m_mihi;
   TXSSBbw_nalo_n=micdlg.m_nalo;
   TXSSBbw_nahi_n=micdlg.m_nahi;
  }else return;

 RADIOS[Radio_Num].TXSSBbw=TXSSBbw_n;
 comport.TXSSBbw_Set(TXSSBbw_n);

 RADIOS[Radio_Num].TXSSBbw_wilo=TXSSBbw_wilo_n;
 RADIOS[Radio_Num].TXSSBbw_wihi=TXSSBbw_wihi_n;
 RADIOS[Radio_Num].TXSSBbw_milo=TXSSBbw_milo_n;
 RADIOS[Radio_Num].TXSSBbw_mihi=TXSSBbw_mihi_n;
 RADIOS[Radio_Num].TXSSBbw_nalo=TXSSBbw_nalo_n;
 RADIOS[Radio_Num].TXSSBbw_nahi=TXSSBbw_nahi_n;
 comport.TXSSBwimilow_Set();  
}
//-----------------------------------------------------------------------------
void RemDlg::OnLOG() 
{
 CStdioFile     F_Out;
 CFileException F_Exc;
 CString        str; 
 char           inStr[30]="";
 int            res,limit=29;

 res=MyInpDlg(this,AppName,"Enter Remark for Logbook","",inStr,limit);
 if (res == IDOK) ToLOG(inStr); 
}
//-----------------------------------------------------------------------------
LRESULT RemDlg::MSG_RemWinItemSelection(WPARAM wParam,LPARAM lParam)
{
 char         tmpF[20],tmpM[20],str[RStrLt];
 unsigned int x;

 strcpy(str,LPCTSTR(remwin->LineBuf));
 
 GetFM(tmpF,tmpM,str);
 if (ChCorrFstart(tmpF) == 0) return 0;

 ModFstr(tmpF,Fdef_s);
 x=FstrToFnum(tmpF);
 if (x < Fmin_n || x > Fmax_n) return 0;
 //-----------------------------
 strcpy(Fact_s,tmpF);Fact_n=FstrToFnum(Fact_s);
 comport.F_Set(Fact_s);
 //-----------------------------
 GetAddData(str,0);                     //SF
 GetAddData(str,1);                     //OF
 GetAddData(str,2);                     //FI
 //-----------------------------
 GetAddData(str,3);                     //ATT
 comport.ATT_Switch(ATTsw);
 //-----------------------------
 GetAddData(str,4);                     //PAMP
 comport.PAMP_Switch(PAMPsw);
 //----------------------------- 
 GetAddData(str,5);                     //DUP
 comport.DUP_Switch(DUPsw);
 //----------------------------- 
 ModMstr(tmpM);strcpy(Mact_s,Marr_s[Mact_n]);
 comport.M_Set(Mact_n,FIact_n);
 //-----------------------------
 remdisp->UpdateFreqDisp();remdisp->UpdateStatusDisp(1,1,1,1);
 //HW-SF setzen----------------- 
 strcpy(tmpF,SFact_s);
 ModFstr(SFact_s,".001");StrTrLe(SFact_s,' ');
 comport.FSTEP_HW_Set(SFstrToSFind(SFact_s));

 return 0L;
}

void RemDlg::OnMEM() 
{
 CFileDialog *OpenDlg;
 CRect       rect; 
 CString     FiName("",Fl); 
 char        file[Fl]="";

 if (remwin != 0) return;
 OpenDlg=new CFileDialog(TRUE,NULL,"",OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST, 
                         //"Frequency-Files (*.FRE)|*.fre|All Files (*.*)|*.*||");
                         "Frequency-Files (*.FRE;*.LOG)|*.fre;*.log|All Files (*.*)|*.*||");
 OpenDlg->m_ofn.lpstrTitle="File Open";
 if (OpenDlg->DoModal()== IDOK)
  {
   FiName=OpenDlg->GetPathName();
  }else FiName="";
 delete OpenDlg;
 if (FiName == "") return;
 //FiName="A_FRETEST.FRE";//Test
 //-----------------------
 remwin=new RemWin((CFrameWnd*)this,FiName);
 remwin->Create(NULL,FiName,0,CFrameWnd::rectDefault,this,0,NULL);
 remwin->SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);
}
//-----------------------------------------------------------------------------
void RemDlg::OnEXTENDED() 
{
 if (remextdlg != 0) return;
 remextdlg=new RemExtDlg(this);
 remextdlg->Create(IDD_REMEXT_DLG,this);
 remextdlg->ShowWindow(SW_SHOW);
}

void RemDlg::OnCWKeyB()
{
 if (cwdisp != 0 || cwkbdlg != 0) return;

 comport.CWKeyType_Set(0);
 cwdisp=new CWDisp();
 cwdisp->Create(NULL,"CW-Keyboard (TaICOM)",0,CFrameWnd::rectDefault,this,0,NULL);
 cwdisp->SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);
 cwdisp->UpdateWindow();

 cwkbdlg=new CWKB_Dlg(this);
 cwkbdlg->Create(IDD_CWKB_DLG,this);
 cwkbdlg->ShowWindow(SW_SHOW);
}

void RemDlg::OnDXCLUSTER()
{
 STARTUPINFO         si;
 PROCESS_INFORMATION pi;
 LPSTR               lpstr=0;
 int                 res;  

 ZeroMemory(&si,sizeof(si));
 si.cb = sizeof(si);
 ZeroMemory(&pi,sizeof(pi));
 
 res=CreateProcess("TaWEB.exe", // Module name
                   NULL,        // Command line 
                   NULL,        // Process handle not inheritable 
                   NULL,        // Thread handle not inheritable 
                   FALSE,       // Set handle inheritance to FALSE 
                   0,           // No creation flags 
                   NULL,        // Use parent's environment block 
                   NULL,        // Use parent's starting directory 
                   &si,         // Pointer to STARTUPINFO structure
                   &pi);        // Pointer to PROCESS_INFORMATION structure
}
//-----------------------------------------------------------------------------
void RemDlg::OnHOWTO() 
{
 //comport.PopUpFI_Set(0);comport.PopUpPBT_Set(0);comport.PopUpPBT_Set(1);return;
 
 comport.AnnounceWithVoice();
 TaMsgBox(AppName,"ENTER FREQUENCIES (see TaICOM_info):\n\n"
                  "REMOTE-DIALOG:\n\n"
                  "MHz numbers (1-4)\n"
                  "POINT\t + optional (1-3) kHz number(s)\n"
                  "comma\t + optional (1-3) Hz number(s)\n\n"
                  "Final format (i.e. 1295.350,000) adj. by SW\n\n"
                  "Examples:\n"
                  ".5 ->    .500,000\n"
                  "14 ->  14.000,000\n"
                  "28.53 ->  28.530,000\n"
                  "145.362,5 -> 145.362,500\n\n"
                  "CTRL+Arrow-keys (Left, Right): F up/down\n\n"
                  "F-DISPLAY:\n\n"
                  "L./R. Mouseb. on digit\t: Down/Up 1\n"
                  "L./R. Mouseb. on  \t: F-Step Down/Up\n"
                  "Same functions available for Mousewheel\n\n"
                  "L. Mouseb. + CTRL on \t: F-Offset\n"
                  "R. Mouseb. + CTRL on \t: F+Offset\n\n"
                  "L. Mouseb. + SHIFT on digit\t: Digit=0\n\n"
                  "Arrow-keys (Left, Right)\t: F up/down\n"
                  "Arrow-keys (Up, Down)\t: F-Step up/down\n"
                  "Pg Up/Down\t\t: F-Offset up/down\n",1);
 SetFocus(); 
}
//-----------------------------------------------------------------------------
void RemDlg::SetCOMTimer()
{
 if (TimerID_COM != 0) KillCOMTimer();//Falls Timer inst., kill

 TimerID_COM=SetTimer(1,COM_Poll_Interval,NULL);		
 if (TimerID_COM == 0) TaMsgBox(AppName,"ERROR: COM-Timer",3);//Kein Timer verf.
}

void RemDlg::KillCOMTimer()
{
 if (TimerID_COM != 0) {KillTimer(TimerID_COM);TimerID_COM=0;}
}

void RemDlg::SetSQLSMTimer()
{
 if (TimerID_SQLSM != 0) KillSQLSMTimer();//Falls Timer inst., kill

 TimerID_SQLSM=SetTimer(2,SQLSM_Poll_Interval,NULL);		
 if (TimerID_SQLSM == 0) TaMsgBox(AppName,"ERROR: SQL-/SM-Timer",3);//Kein Timer verf. 
}

void RemDlg::KillSQLSMTimer()
{
 if (TimerID_SQLSM != 0) {KillTimer(TimerID_SQLSM);TimerID_SQLSM=0;}
}

void RemDlg::OnTimer(UINT nIDEvent) 
{
 int res;

 if (nIDEvent == TimerID_COM && COM_Poll_Mode == 1)    //ONLY if COM-Polling=Intervals
  {
   if (COM_IsPolling == 0) res=comport.AskCOM_IDLE(); 
  }

 if (nIDEvent == TimerID_SQLSM && SQLSM_Poll_Mode == 1)//ONLY if SQLSM-Polling=Intervals 
  {
   if (COM_IsPolling == 0) S_Ask_SQL_Ask(); 
  }

 CDialog::OnTimer(nIDEvent);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




