// R_RLIB.H : Funktionen f. Radio
// G. TAMM, DF9ZO 2007
//--------------------
#pragma once
//--------------------
#include "R_VAR.H"
//+Allgemeine Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++
void ModFstr(char *freq,char *freqdef);
// Macht normgerechten FreqStr/StepStr/OffsetStr
//-----------------------------------------------------------------------------
int ChCorrFstart(const char *freq);
//Erstes Zeichen in freq darf nur '0'...'9' oder '.' sein
//-----------------------------------------------------------------------------
unsigned int FstrToFnum(const char *freqstr);
// Wandelt normierten(!) Frequency-String[14] in freqnum
// Keine Fehlerueberpruefung !
//-----------------------------------------------------------------------------
void FnumToFstr(char *freqstr,int freqnum);
// Wandelt freqnum in normierten(!) Frequency-String[13]
//+Funktionen z. Modifikation ModeStr, FilterStr, AttStr, usw.+++++++++++++++++
void ModMstr(char *mode);
//Macht normgerechten ModeStr
int MstrToMnum(char *mode);
//Liefert Modeindex aus Modestring
void MnumToMstr(int num,char *mode);
//Liefert Modestring aus Modeindex
int AdjFstepAndMode();
//Liefert Schrittweite zu Mode
//-----------------------------------------------------------------------------
void ModFIstr(char *fi);
//Macht normgerechten FilterStr
//-----------------------------------------------------------------------------
int SFstrToSFind(char *fstep);
//Liefert aus normgerechtem normgerechten F-StepStr Index Cmd-Table 0x08 
//-----------------------------------------------------------------------------
void SetSMstr(int sm,int mode);
//Macht SmStr
//mode=0 Ausgabe als Zahl, mode=1 Ausgabe als S-Wert
//+Scan-Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int MakeAndCheckScanPars(int mode,char *memscfi);
//Ueberprueft Parameter f. ScanListe auf Korrektheit und macht Scanliste
//Keine normgerechte Strings erforderlich, macht normger. Strings
//+Allgemeine Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++
void RadioSettings();
//Berechnet Spezifika f. Radios
//-----------------------------------------------------------------------------
void GetFM(char *destf,char *destm,char *src);
//Zerlegt src nach Freq, Mode u. kopiert nach destf, destm
int GetAddData(char *src,int what);
// what=0 SF
// what=1 OF
// what=2 FI
// what=3 ATT
// what=4 DUP
// what=5 PAMP
// what=6 TXT
// Rueckmeldung: 1=Angabe gefunden, 0=Angabe NICHT gefunden
//-----------------------------------------------------------------------------
void ToLOG(char *instr);
//Bildet LOGstr
//void CombineRemStr(char *dest,char *rstr);
//Bildet Remark-String, keine normgerechten Eingaben erforderlich
//void CombineRadStr(char *dest,char *rstr);
//Bildet normgerechten Radio-String
//+CW-Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void CW_Calc();
int  CW_IsValidChar(char ch);
//+IBRadio-Funktionen++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int  IB_HexStrToInt(char *src);
//Interpretiert Str als Hexzahl
//-----------------------------------------------------------------------------
void IB_HexToDecStr(char *dest,int data);
//Interpretiert Zahl als Hexzahl und wandelt in String, 137 -> "89\0"
//-----------------------------------------------------------------------------
void IB_DecToBCD(int &hi,int &lo,int dec);//IB_SplitDecToHiLo
//Wandelt Dec in BCD-Format, dec=199 -> hi=1, lo=99
int  IB_BCDtoDec(int hi,int lo);
//Wandelt BCD-Format in dec, hi=1, lo=153 -> dec=199
//-----------------------------------------------------------------------------
void IB_FreqToSend(int dest[],char *freq);
//Freqstr -> ICOM freq-daten
//Erwartet normgerechten FreqStr
//-----------------------------------------------------------------------------
int  IB_FISWlevToBW(int FIswBWlev);
//Helper-Func
void IB_FISWFromTable(int radio_num);
//Voreinstellungen f. FI_DSP
//-----------------------------------------------------------------------------
void IB_ATTsnFromIBcmd(int rxb5);
int  IB_ATTcmdFromATTn(int att);
//-----------------------------------------------------------------------------
void IB_PAMPsnFromIBcmd(int rxb6);
int  IB_PAMPcmdFromPAMPn(int pamp);
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*

*/
