// R_RLIB.CPP : Funktionen f. Radio
// G. TAMM, DF9ZO 1999
//--------------------
#include "stdafx.h"
#include "R_RLIB.H"
//+Allgemeine Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++
void ModFstr(char *freq,char *freqdef)
{
 int error=0,le,diff,count=0,poscomma=0,pospunct=0;

 //Fuehrende u. anhaengende Leerzeichen u. Nullen entfernen
 StrTrLe(freq,' ');StrTrLe(freq,'0');StrTrRi(freq,' ');
 //Zulaessige Zeichen:'0'..'9' / ein '.' / ein ','
 while (*(freq+count) != '\0')
  {
   if (!isdigit(*(freq+count)) && *(freq+count) != '.' && *(freq+count) != ',')
      error++;
   if (*(freq+count) == '.') pospunct++;
   if (*(freq+count) == ',') poscomma++;
   count++;
  }
 if (error || pospunct > 1 || poscomma >1 || strlen(freq) == 0)
    {strcpy(freq,freqdef);return;}
 //Stellenzahl vor Punkt bzw. Gesanmtlaenge bei keinem Punkt
 le=(int)strlen(freq);pospunct=StrChPos(freq,'.',0);
 if (pospunct > 4 || ((pospunct < 0) && (le > 4)))
	{strcpy(freq,freqdef);return;}
 //Punkt erkennen und ggf. anhaengen
 if (pospunct < 0) strcat(freq,".");
 //Test auf Komma vor Punkt, Zwischenraum zwischen Punkt und Komma
 le=(int)strlen(freq);pospunct=StrChPos(freq,'.',0);poscomma=StrChPos(freq,',',0);
 if (poscomma > -1 && pospunct > -1)
  {
   diff=poscomma-pospunct;
   if (pospunct > poscomma || diff != 4) {strcpy(freq,freqdef);return;}
  }
 //Test auf Stellen nach Punkt, wenn kein Komma
 if (poscomma < 0 && pospunct > -1)
  {
   diff=le-pospunct;
   if (diff > 4) {strcpy(freq,freqdef);return;}
  }
 //Test auf Stellen nach Komma
 if (poscomma > 0)
  {
   diff=le-poscomma;
   if (diff > 4) *(freq+poscomma+4)='\0';
  }
 //Nullen nach Punkt anhaengen
 pospunct=StrChPos(freq,'.',0);le=(int)strlen(freq);diff=le-pospunct;
 switch (diff) 
  {
   case 1:strcat(freq,"000");break;
   case 2:strcat(freq,"00");break;
   case 3:strcat(freq,"0");break;
   case 4:break;
  }
 //Nullen nach Komma anhaengen
 poscomma=StrChPos(freq,',',0);if (poscomma < 0) strcat(freq,",");
 le=(int)strlen(freq);poscomma=StrChPos(freq,',',0);diff=le-poscomma;
 switch (diff) 
  {
   case 1:strcat(freq,"000");break;
   case 2:strcat(freq,"00");break;
   case 3:strcat(freq,"0");break;
   case 4:break;
  }
 StrFiLe(freq,' ',RStrLf-1);
}
//-----------------------------------------------------------------------------
int ChCorrFstart(const char *freq)
{
 char str[RStrLf];

 strcpy(str,freq);StrTrLe(str,' ');
 if (str[0]=='0'||str[0]=='1'||str[0]=='2'||str[0]=='3'||str[0]=='4'||
 	  str[0]=='5'||str[0]=='6'||str[0]=='7'||str[0]=='8'||str[0]=='9'||
     str[0]=='.') return 1;
     else return 0;
}
//-----------------------------------------------------------------------------
unsigned int FstrToFnum(const char *freqstr)
{
 char tmpstr[RStrLf];
 int pos;

 strcpy(tmpstr,freqstr);
 StrTrLe(tmpstr,' ');
 pos=StrChPos(tmpstr,'.',0);StrDelChPos(tmpstr,pos);
 pos=StrChPos(tmpstr,',',0);StrDelChPos(tmpstr,pos);
 return (unsigned int)strtol(tmpstr,0,10);
}
//-----------------------------------------------------------------------------
void FnumToFstr(char *freqstr,int freqnum)
{
 int le;

 _ultoa(freqnum,freqstr,10);le=(int)strlen(freqstr);
 switch (le) {
   case  6:StrInsChPos(freqstr,'.',0);StrInsChPos(freqstr,',',4);break;
   case  7:StrInsChPos(freqstr,'.',1);StrInsChPos(freqstr,',',5);break;
   case  8:StrInsChPos(freqstr,'.',2);StrInsChPos(freqstr,',',6);break;
   case  9:StrInsChPos(freqstr,'.',3);StrInsChPos(freqstr,',',7);break;
   case 10:StrInsChPos(freqstr,'.',4);StrInsChPos(freqstr,',',8);break;
   case  5:StrStrIns(freqstr,".0",0) ;StrInsChPos(freqstr,',',4);break;
   case  4:StrStrIns(freqstr,".00",0);StrInsChPos(freqstr,',',4);break;
   case  3:StrStrIns(freqstr,".000,",0)   ;break;
   case  2:StrStrIns(freqstr,".000,0",0)  ;break;
   case  1:StrStrIns(freqstr,".000,00",0) ;break;
   case  0:StrStrIns(freqstr,".000,000",0);break;
  }
 StrFiLe(freqstr,' ',RStrLf-1);
}
//+Funktionen z. Modifikation ModeStr, FilterStr, AttStr, usw.+++++++++++++++++
void ModMstr(char *mode)
{
 StrTrRi(mode,' ');StrFiRi(mode,' ',RStrLm-1);
 for (int x=0;x < MODES.Mmax;x++)
  {
   if (_strcmpi(mode,Marr_s[x]) == 0) 
    {
     strcpy(mode,Marr_s[x]);
     Mact_n=x;strcpy(Mact_s,Marr_s[x]);
     return;
    }
  }
 strcpy(mode,Mdef_s);Mact_n=4;
}

int MstrToMnum(char *mode)
{
 ModMstr(mode);
 return Mact_n;
}

void MnumToMstr(int num,char *mode)
{
 strcpy(mode,Marr_s[num]);
}

int AdjFstepAndMode()
{
 int step;

 if (Mact_n == 0 || Mact_n ==  1) step=SF_SSB_n; //USB,LSB         
 if (Mact_n == 3 || Mact_n ==  7) step=SF_DATA_n;//CW,CW-R
 if (Mact_n == 5                ) step=SF_FM_n;  //FM
 if (Mact_n == 6                ) step=SF_FMW_n; //FMW 
 if (Mact_n == 2                ) step=SF_AM_n;  //AM
 if (Mact_n == 4 || Mact_n ==  8) step=SF_DATA_n;//RTTY,RTTY-R
 if (Mact_n == 9 || Mact_n == 10) step=SF_DATA_n;//PSK,PSK-R

 return step;
} 
//-----------------------------------------------------------------------------
void ModFIstr(char *fi)
{
 StrTrRi(fi,' ');
 //StrFiRi(fi,' ',MaxFIle);
 for (int x=0;x < 3;x++)
  {
   if (_strcmpi(fi,FIarr_s[x]) == 0) 
    {
     strcpy(fi,FIarr_s[x]);
     FIact_n=x;
     strcpy(FIact_s,FIarr_s[x]);
     return;
    }
  }
 strcpy(fi,FIarr_s[0]);FIact_n=0;
}
//-----------------------------------------------------------------------------
int SFstrToSFind(char *fstep)
{
 if (strcmp(fstep,".000,010") == 0) return 0;
 if (strcmp(fstep,".000,100") == 0) return 1;
 if (strcmp(fstep,".001,000") == 0) return 2;
 if (strcmp(fstep,".005,000") == 0) return 3;
 if (strcmp(fstep,".009,000") == 0) return 4;
 if (strcmp(fstep,".010,000") == 0) return 5;
 if (strcmp(fstep,".012,500") == 0) return 6;
 if (strcmp(fstep,".020,000") == 0) return 7;
 if (strcmp(fstep,".025,000") == 0) return 8;
 if (strcmp(fstep,".100,000") == 0) return 9;
 return 2;
}
//-----------------------------------------------------------------------------
void SetSMstr(int sm,int mode)
{      
 if (mode == 0) {_itoa(SMlev_n,SMlev_s,10);return;}

 if (sm > SM_li_n[14]) {strcpy(SMlev_s,SM_li_s[14]);return;}
 if (sm > SM_li_n[13]) {strcpy(SMlev_s,SM_li_s[13]);return;}
 if (sm > SM_li_n[12]) {strcpy(SMlev_s,SM_li_s[12]);return;}
 if (sm > SM_li_n[11]) {strcpy(SMlev_s,SM_li_s[11]);return;}
 if (sm > SM_li_n[10]) {strcpy(SMlev_s,SM_li_s[10]);return;}
 if (sm > SM_li_n[ 9]) {strcpy(SMlev_s,SM_li_s[9]) ;return;}
 if (sm > SM_li_n[ 8]) {strcpy(SMlev_s,SM_li_s[8]) ;return;}
 if (sm > SM_li_n[ 7]) {strcpy(SMlev_s,SM_li_s[7]) ;return;}
 if (sm > SM_li_n[ 6]) {strcpy(SMlev_s,SM_li_s[6]) ;return;}
 if (sm > SM_li_n[ 5]) {strcpy(SMlev_s,SM_li_s[5]) ;return;}
 if (sm > SM_li_n[ 4]) {strcpy(SMlev_s,SM_li_s[4]) ;return;}
 if (sm > SM_li_n[ 3]) {strcpy(SMlev_s,SM_li_s[3]) ;return;}
 if (sm > SM_li_n[ 2]) {strcpy(SMlev_s,SM_li_s[2]) ;return;}
 if (sm > SM_li_n[ 1]) {strcpy(SMlev_s,SM_li_s[1]) ;return;}
 if (sm > SM_li_n[ 0]) {strcpy(SMlev_s,SM_li_s[0]) ;return;}
 if (sm >= 0)          {strcpy(SMlev_s,"-");return;}
}
//+Scan-Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int MakeAndCheckScanPars(int mode,char *memscfi)
{
 CStdioFile     F_In;
 CFileException F_Exc;
 char           DiskL[RStrLt],destf[RStrLf],destm[RStrLm];
 unsigned int   F;
 int            err,ind;
 
 ScLiNum=0;
 ModFstr(ScLoF_s,Fdef_s);ScLoF_n=FstrToFnum(ScLoF_s);
 ModFstr(ScHiF_s,Fdef_s);ScHiF_n=FstrToFnum(ScHiF_s);
 ModFstr(SFact_s,SFdef_s);SFact_n=FstrToFnum(SFact_s);
 ModFstr(RADIOS[Radio_Num].Fmin_s,Fdef_s);Fmin_n=FstrToFnum(RADIOS[Radio_Num].Fmin_s);
 ModFstr(RADIOS[Radio_Num].Fmax_s,Fdef_s);Fmax_n=FstrToFnum(RADIOS[Radio_Num].Fmax_s);
 for (ind=0;ind < ScLiMax;ind++)
  {
   ScAr.f[ind][0]='\0';ScAr.m[ind]=0;ScAr.y[ind]=0;
  }
 err=0;ind=-1;
 if (mode == 0)//SCAN
  {
   if (ScLoF_n >= ScHiF_n  || (ScHiF_n-ScLoF_n)/SFact_n > ScLiMax ||
       ScLoF_n <  Fmin_n   || ScHiF_n > Fmax_n) return -1;
   F=ScLoF_n;ind=0;
   while (F <= ScHiF_n && ind < ScLiMax)
    {
     FnumToFstr(ScAr.f[ind],F);ScAr.m[ind]=Mact_n;
     F+=SFact_n;ind++;ScLiNum++;
    }
  }
 if (mode == 1)//M-SCAN            
  {
   if(!F_In.Open(memscfi,CFile::modeRead | CFile::typeText,&F_Exc)) 
    {
     //MessageBox(0,"ERROR file (R_Lib:MakeAndCheckScanPars)","",MB_ICONSTOP | MB_OK);
    }else
    {
     while (F_In.ReadString(DiskL,RStrLt-2) != 0)
      {
       StrDel_CR_LF(DiskL);

	   if (DiskL[0] == '\0' || DiskL[0] == ';' || DiskL[0] == '[') continue;
       DiskL[RStrLt-3]=0;
       GetFM(destf,destm,DiskL);
       if (ChCorrFstart(destf) == 0) continue;
       ModFstr(destf,Fdef_s);F=FstrToFnum(destf);
       if (F <  Fmin_n || F > Fmax_n || ind+1 == ScLiMax) {err=1;continue;}
       ModMstr(destm);
       ind++;ScLiNum++;
       strcpy(ScAr.f[ind],destf);ScAr.m[ind]=Mact_n;
      }
     F_In.Close();
     if (err == 1 || ind == -1) return -2;
    }
  }
 return 1;
}
//+Allgemeine Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++
void RadioSettings()
{
 int x;

 //Modes------------------------------------
 for (x=0;x < MODES.Mmax;x++) strcpy(Marr_s[x],MODES.m_s[x]);
 strcpy(Mact_s,MODES.m_s[2]);Mact_n=2;//Voreinstellung AM 
 strcpy(Mact_s,Mdef_s);
 //FSteps-----------------------------------
 ModFstr(SF_SSB_s ,SFdef_s);
 ModFstr(SF_FM_s  ,SFdef_s);
 ModFstr(SF_FMW_s ,SFdef_s);
 ModFstr(SF_AM_s  ,SFdef_s);
 ModFstr(SF_DATA_s,SFdef_s);
 SF_SSB_n =FstrToFnum(SF_SSB_s);
 SF_FM_n  =FstrToFnum(SF_FM_s);
 SF_FMW_n =FstrToFnum(SF_FMW_s);
 SF_AM_n  =FstrToFnum(SF_AM_s);
 SF_DATA_n=FstrToFnum(SF_DATA_s);
 //MIC--------------------------------------
 MIClev_n =RADIOS[Radio_Num].MICgain;
 COMPlev_n=RADIOS[Radio_Num].COMPlev;

 TXSSBbw_n     =RADIOS[Radio_Num].TXSSBbw;
 TXSSBbw_wilo_n=RADIOS[Radio_Num].TXSSBbw_wilo;
 TXSSBbw_wihi_n=RADIOS[Radio_Num].TXSSBbw_wihi;
 TXSSBbw_milo_n=RADIOS[Radio_Num].TXSSBbw_milo;
 TXSSBbw_mihi_n=RADIOS[Radio_Num].TXSSBbw_mihi;
 TXSSBbw_nalo_n=RADIOS[Radio_Num].TXSSBbw_nalo;
 TXSSBbw_nahi_n=RADIOS[Radio_Num].TXSSBbw_nahi;
 //COM--------------------------------------
 COM_PORT=RADIOS[Radio_Num].COMport;
 COM_BAUD=RADIOS[Radio_Num].COMbaud;
 COM_DATA=RADIOS[Radio_Num].COMdata;
 COM_PARI=RADIOS[Radio_Num].COMpari;
 COM_STOP=RADIOS[Radio_Num].COMstop;
 COM_PROT=RADIOS[Radio_Num].COMprot;

 SQL_SwHw=RADIOS[Radio_Num].SQL_SwHw;
 FI_SwHw =RADIOS[Radio_Num].FI_SwHw;

 ANTmax =RADIOS[Radio_Num].ANTmax; 
 ATTmax =RADIOS[Radio_Num].ATTmax;
 PAMPmax=RADIOS[Radio_Num].PAMPmax;

 ROOFsw=RADIOS[Radio_Num].RoofFi_n;
 //Radio------------------------------------
 IBRad_Adr_n=IB_HexStrToInt(RADIOS[Radio_Num].IB_Adr_s);
 IBRad_Da_n =RADIOS[Radio_Num].IB_Da_n;
   
 if (FI_SwHw == 0)//HW-Filter
  {
   for (x=0;x < 18;x++)
    {
     if (RADIOS[Radio_Num].IB_FI_HW_s[x][0] == '\0') IBRad_FI_HW[x]=-1;
         else IBRad_FI_HW[x]=IB_HexStrToInt(RADIOS[Radio_Num].IB_FI_HW_s[x]);
    }
  }else         //SW-Filter
  {
  }
}
//-----------------------------------------------------------------------------
void GetFM(char *destf,char *destm,char *src)
{
 StrCopy(destf,src,RStrSf,RStrLf-1);destf[RStrLf]=0;
 StrCopy(destm,src,RStrSm,RStrLm-1);destm[RStrLm]=0;
 return; 
}

int GetAddData(char *src,int what)
{
 int  posa,pose,lekey;
 char tre=';';
 char tmpstr[500];

 src[RStrLr]=0;
 posa=StrStrFiPos(src,RadAdds_s[what]);
 if (posa > -1)
  {
   lekey=(int)strlen(RadAdds_s[what]);
   pose=StrChPos(src,tre,posa+lekey);
   if (pose > -1)
    {
     if (what == 0)// SF
      {
       StrCopy(SFact_s,src,posa+lekey,pose-posa-lekey);
       ModFstr(SFact_s,SFdef_s);SFact_n=FstrToFnum(SFact_s);
      }
     if (what == 1)// OF
      {
       StrCopy(OFact_s,src,posa+lekey,pose-posa-lekey);
       ModFstr(OFact_s,SFdef_s);OFact_n=FstrToFnum(OFact_s);
      }
     if (what == 2)// FI
      {
       StrCopy(tmpstr,src,posa+lekey,pose-posa-lekey);
       FIact_n=0;strcpy(FIact_s,FIarr_s[FIact_n]);
       ModFIstr(tmpstr);
      }
     if (what == 3)// ATT
      {
       ATTsw=0;
       StrCopy(tmpstr,src,posa+lekey,pose-posa-lekey);
       ATTsw=atoi(tmpstr);
      }
     if (what == 4)// PAMP
      {
       PAMPsw=0;
       StrCopy(tmpstr,src,posa+lekey,pose-posa-lekey);
       PAMPsw=atoi(tmpstr);
      }
     if (what == 5)// DUP
      {
       DUPsw=0;
       StrCopy(tmpstr,src,posa+lekey,pose-posa-lekey);
       if (tmpstr[0] == 'S') DUPsw=0;
       if (tmpstr[0] == '-') DUPsw=1;
       if (tmpstr[0] == '+') DUPsw=2;       
      }
     if (what == 6)// TXT
      {
       StrCopy(tmpstr,src,posa+lekey,pose-posa-lekey);
       strcpy(MEMtxt_s,tmpstr);
      }
     return 1;
    }
  }
 return 0;
}
//-----------------------------------------------------------------------------
void ToLOG(char *instr)
{
 CStdioFile     F_Out;
 CFileException F_Exc;
 CString        cstr;
 char           str[1000],str_tmp[200]; 
 
 ModFstr(Fact_s,Fdef_s);
 strcpy(str,Fact_s);strcat(str," ");strcat(str,Mact_s);strcat(str," ");
 //Remark, Time--------------------------
 strcat(str,instr);StrFiRi(str,' ',52); 
 GetDateTime(str_tmp,10);strcat(str,str_tmp);strcat(str," ");
 //FI------------------------------------
 strcat(str,RadAdds_s[2]);
 if (FIact_n == 0) strcat(str,"-;");//normal
 if (FIact_n == 1) strcat(str,"N;");//narrow
 if (FIact_n == 2) strcat(str,"W;");//wide
 //ATT-----------------------------------
 strcat(str,RadAdds_s[3]);
 _itoa(ATTsw,str_tmp,10);strcat(str,str_tmp);strcat(str,";");
 //PAMP----------------------------------
 strcat(str,RadAdds_s[4]);
 _itoa(PAMPsw,str_tmp,10);strcat(str,str_tmp);strcat(str,";");
 //DUP-----------------------------------
 strcat(str,RadAdds_s[5]);
 if (DUPsw == 0) strcat(str,"S;");
 if (DUPsw == 1) strcat(str,"-;");
 if (DUPsw == 2) strcat(str,"+;");
 //SF------------------------------------
 strcat(str,RadAdds_s[0]);
 StrTrLe(SFact_s,' ');StrTrRi(SFact_s,'0');StrTrRi(SFact_s,',');StrTrRi(SFact_s,'0');
 strcat(str,SFact_s);strcat(str,";");
 //OF------------------------------------
 strcat(str,RadAdds_s[1]);
 StrTrLe(OFact_s,' ');StrTrRi(OFact_s,'0');StrTrRi(OFact_s,',');StrTrRi(OFact_s,'0');
 strcat(str,OFact_s);strcat(str,";");
 //--------------------------------------
 strcat(str,"\n");cstr=str; 
 if(!F_Out.Open(F_Log,CFile::modeCreate | CFile::modeNoTruncate | CFile::modeWrite | CFile::typeText,&F_Exc))
  {
   //MessageBox(0,"ERROR: LOG","",MB_ICONSTOP | MB_OK);
  }else
  {
   F_Out.SeekToEnd();
   F_Out.WriteString(cstr);//F_Out.WriteString("\n");
   F_Out.Close();
  }	
}
//+CW-Funktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void CW_Calc()
{
 CW_DOT       =CW_Speed;
 CW_DASH      =3*CW_DOT;
 CW_B_CHARCOMP=CW_DOT;
 CW_B_CHAR    =3*CW_DOT; 
 CW_B_WORD    =7*CW_DOT;   	
}

int CW_IsValidChar(char ch)
{
 int x;

 for (x=0;x < 100;x++)
  {
   if (CW_Chars_CHAR[x] == 0) return -1;
   if (CW_Chars_CHAR[x] == ch) return x;
  }

 return -1;
}
//+IBRadio-Funktionen++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int IB_HexStrToInt(char *src)
{
 char str[6]="0x";
 
 strcat(str,src);
 return strtol(str,0,16);
}
//-----------------------------------------------------------------------------
void IB_HexToDecStr(char *dest,int data)
{
 _itoa(data,dest,16);
 if (dest[1]=='\0')
  {
   dest[2]='\0';dest[1]=dest[0];dest[0]='0';
  }
}
//-----------------------------------------------------------------------------
void IB_DecToBCD(int &hi,int &lo,int dec)
{
 int loo;
 //char str[20];

 hi=dec / 100;
 lo=dec % 100;loo=lo % 10;
 lo/=10;lo<<=4;
 lo=lo | loo;//_itoa(lo,str,2);
}

int  IB_BCDtoDec(int hi,int lo)
//Wandelt BCD-Format in dec, hi=1, lo=153 -> dec=199
{
 char str[4];
 int res=hi*100;

 _itoa(lo,str,16);
 return res+=atoi(str);
}
//-----------------------------------------------------------------------------
void IB_FreqToSend(int dest[],char *freq)
{
 int x,y,res;
 char str[5];

 res=StrChPos(freq,'.',0);StrDelChPos(freq,res);
 res=StrChPos(freq,',',0);StrDelChPos(freq,res);
 StrReplAllCh(freq,' ','0',0);
 //----------------------
 for (x=0,y=8;x<5;x++,y-=2)
  {
   str[0]=freq[y];str[1]=freq[y+1];str[2]=0;
   dest[x]=strtol(str,0,16);
  }
}
//-----------------------------------------------------------------------------
int  IB_FISWlevToBW(int FIswBWlev)//see IBModes MODES;
{
 if (Mact_n == 5 || Mact_n == 6) return FI_SW_Fmax;//FM, FMW
 else 
 if (Mact_n == 2)                                  //AM
  {
   return 200*(FIswBWlev+1);
  }
 else                                              //Rest
 if (FI_SW_BW_lev < 10)
  {
   return 50*(FIswBWlev+1);
  }else
  {
   return 500+(100*(FIswBWlev-9));
  }
}

void IB_FISWFromTable(int radio_num)//see IBModes MODES;
{
 int x;

 for (x=0;x < 60;x++)
  {
   IBRad_FI_SW[x]=atoi(RADIOS[radio_num].IB_FI_SW_s[x]);
  }

 if (Mact_n == 0 || Mact_n ==  1) x= 0;//LSB,  USB                  
 if (Mact_n == 5)                 x=10;//FM 
 if (Mact_n == 6)                 x=20;//FMW 
 if (Mact_n == 2)                 x=30;//AM
 if (Mact_n == 3 || Mact_n ==  7) x=40;//CW,   CW-R
 if (Mact_n == 4 || Mact_n ==  8) x=50;//RTTY, RTTY-R
 //if (Mact_n == 9 || Mact_n == 10) x=60;//PSK,  PSK-R

 FI_SW_Fmin      =IBRad_FI_SW[x];
 FI_SW_Fmin_lev  =IBRad_FI_SW[x+5];
 FI_SW_Fmax      =IBRad_FI_SW[x+1];
 if (Mact_n == 5)//FM
  {
   if (FIact_n == 2) FI_SW_Fmax=IBRad_FI_SW[x+4];//Wide   DSP 1
   if (FIact_n == 0) FI_SW_Fmax=IBRad_FI_SW[x+2];//Normal DSP 2
   if (FIact_n == 1) FI_SW_Fmax=IBRad_FI_SW[x+3];//Narrow DSP 3      
  }
 if (Mact_n == 6)//FMW
  {
   FI_SW_Fmax=IBRad_FI_SW[x+4];
  }
 FI_SW_Fmax_lev  =IBRad_FI_SW[x+6]; 
 FI_SW_BW2def    =IBRad_FI_SW[x+2];
 FI_SW_BW2def_lev=IBRad_FI_SW[x+7];
 FI_SW_BW3def    =IBRad_FI_SW[x+3];
 FI_SW_BW3def_lev=IBRad_FI_SW[x+8];
 FI_SW_BW1def    =IBRad_FI_SW[x+4];
 FI_SW_BW1def_lev=IBRad_FI_SW[x+9];

 FI_SW_BW_lev=0; 
}
/*
      BW-low,BW-high,Def-Normal(2),Def-Narrow(3),Def-Wide(1)
    
SSB    0      1       2             3             4
       5      6       7             8             9
FM    10     11      12            13            14
      15     16      17            18            19
FM-W  20
AM    30
CW    40
RTTY  50
*/
//-----------------------------------------------------------------------------
void IB_ATTsnFromIBcmd(int rxb5)//Radio specific
{
 char str_on[5]="ON  ";

 if (rxb5 == 0x00) {ATTsw=0;strcpy(ATT_s,"-");return;}

 if (IBRad_Adr_n == 0x58 ||//IC-706MK2G
     IBRad_Adr_n == 0x56)  //IC-746
  {
   if (rxb5 == 0x20) {ATTsw=1;strcpy(ATT_s,str_on);return;}   
  } 
 if (IBRad_Adr_n == 0x70)  //IC-7000
  {
   if (rxb5 == 0x12) {ATTsw=1;strcpy(ATT_s,str_on);return;}   
  }
 if (IBRad_Adr_n == 0x76)  //IC-7200
  {
   if (rxb5 == 0x01) {ATTsw=1;strcpy(ATT_s,str_on);return;}   
  }
 if (IBRad_Adr_n == 0x66)  //IC-7400
  {
   if (rxb5 == 0x01) {ATTsw=1;strcpy(ATT_s,str_on);return;}   
  }
 if (IBRad_Adr_n == 0x74)  //IC-7700
  {
   if (rxb5 == 0x06) {ATTsw=1;strcpy(ATT_s," 6dB");return;}
   if (rxb5 == 0x12) {ATTsw=2;strcpy(ATT_s,"12dB");return;}
   if (rxb5 == 0x18) {ATTsw=3;strcpy(ATT_s,"18dB");return;}   
  }
 if (IBRad_Adr_n == 0x6A)  //IC-7800
  {
   if (rxb5 == 0x01) {ATTsw=1;strcpy(ATT_s," 3dB");return;}
   if (rxb5 == 0x02) {ATTsw=2;strcpy(ATT_s," 6dB");return;}
   if (rxb5 == 0x03) {ATTsw=3;strcpy(ATT_s," 9dB");return;}
   if (rxb5 == 0x04) {ATTsw=4;strcpy(ATT_s,"12dB");return;}
   if (rxb5 == 0x05) {ATTsw=5;strcpy(ATT_s,"15dB");return;}
   if (rxb5 == 0x06) {ATTsw=6;strcpy(ATT_s,"18dB");return;}
   if (rxb5 == 0x07) {ATTsw=7;strcpy(ATT_s,"21dB");return;}   
  }

 if (rxb5 == 0x01 || rxb5 == 0x10) {ATTsw=1;strcpy(ATT_s,"1");};
 if (rxb5 == 0x02 || rxb5 == 0x20) {ATTsw=2;strcpy(ATT_s,"2");};
 if (rxb5 == 0x03 || rxb5 == 0x30) {ATTsw=3;strcpy(ATT_s,"3");};
}

int IB_ATTcmdFromATTn(int att)//Radio specific
{
 char str_on[5]="ON  ";

 if (att == 0) {strcpy(ATT_s,"-");return 0x00;}

 if (IBRad_Adr_n == 0x58 ||//IC-706MK2G
     IBRad_Adr_n == 0x56)  //IC-746
  {
   if (att == 1) {strcpy(ATT_s,str_on);return 0x20;}
  }
 if (IBRad_Adr_n == 0x70)  //IC-7000
  {
   if (att == 1) {strcpy(ATT_s,str_on);return 0x12;}
  }
 if (IBRad_Adr_n == 0x76)  //IC-7200
  {
   if (att == 1) {strcpy(ATT_s,str_on);return 0x01;}
  }
 if (IBRad_Adr_n == 0x66)  //IC-7400
  {
   if (att == 1) {strcpy(ATT_s,str_on);return 0x01;}
  }
 if (IBRad_Adr_n == 0x74)  //IC-7700
  {
   if (att == 1) {strcpy(ATT_s,"6dB") ;return 0x06;}   
   if (att == 2) {strcpy(ATT_s,"12dB");return 0x12;}   
   if (att == 3) {strcpy(ATT_s,"18dB");return 0x18;}
  }
 if (IBRad_Adr_n == 0x6A)  //IC-7800
  {
   if (att == 1) {strcpy(ATT_s,"3dB") ;return 0x01;}
   if (att == 2) {strcpy(ATT_s,"6dB") ;return 0x02;}
   if (att == 3) {strcpy(ATT_s,"9dB") ;return 0x03;}
   if (att == 4) {strcpy(ATT_s,"12dB");return 0x04;}
   if (att == 5) {strcpy(ATT_s,"15dB");return 0x05;}
   if (att == 6) {strcpy(ATT_s,"18dB");return 0x06;}
   if (att == 7) {strcpy(ATT_s,"21dB");return 0x07;}
  }

 if (att == 1) {strcpy(ATT_s,"1");return 0x01;} 
 if (att == 2) {strcpy(ATT_s,"2");return 0x02;} 
 if (att == 3) {strcpy(ATT_s,"3");return 0x03;}

 return 0x00;
}
//-----------------------------------------------------------------------------
void IB_PAMPsnFromIBcmd(int rxb6)//Radio specific
{
 char str_on[5]="ON  ";

 if (rxb6 == 0x00) {PAMPsw=0;strcpy(PAMP_s,"-");return;}

 if (IBRad_Adr_n == 0x58 ||//IC-706MK2G
     IBRad_Adr_n == 0x56)  //IC-746
  {
   if (rxb6 == 0x01) {PAMPsw=1;strcpy(PAMP_s,str_on);return;}     
  }
 if (IBRad_Adr_n == 0x70)  //IC-7000
  {
   if (rxb6 == 0x01) {PAMPsw=1;strcpy(PAMP_s,str_on);return;}   
  }
 if (IBRad_Adr_n == 0x76)  //IC-7200
  {
   if (rxb6 == 0x01) {PAMPsw=1;strcpy(PAMP_s,str_on);return;}   
  }
 if (IBRad_Adr_n == 0x66)  //IC-7400
  {
   if (rxb6 == 0x01) {PAMPsw=1;strcpy(PAMP_s,str_on);return;}   
  }
 if (IBRad_Adr_n == 0x74)  //IC-7700
  {
   if (rxb6 == 0x01) {PAMPsw=1;strcpy(PAMP_s,"1   ");return;}   
   if (rxb6 == 0x02) {PAMPsw=2;strcpy(PAMP_s,"2   ");return;}  
  }
 if (IBRad_Adr_n == 0x6A)  //IC-7800
  {
   if (rxb6 == 0x01) {PAMPsw=1;strcpy(PAMP_s,"1   ");return;}   
   if (rxb6 == 0x02) {PAMPsw=2;strcpy(PAMP_s,"2   ");return;}  
  }

 if (rxb6 == 0x01) {PAMPsw=1;strcpy(PAMP_s,str_on);return;}

 return;   
}

int  IB_PAMPcmdFromPAMPn(int pamp)//Radio specific
{
 char str_on[5]="ON  ";

 if (pamp == 0) {strcpy(PAMP_s,"-");return 0x00;}

 if (IBRad_Adr_n == 0x58 ||//IC-706MK2G
     IBRad_Adr_n == 0x56 ||//IC-746
     IBRad_Adr_n == 0x70 ||//IC-7000
     IBRad_Adr_n == 0x76 ||//IC-7200
     IBRad_Adr_n == 0x66)  //IC-7400
  {
   if (pamp == 1) {strcpy(PAMP_s,str_on);return 0x01;}
  }
 if (IBRad_Adr_n == 0x74)  //IC-7700
  {
   if (pamp == 1) {strcpy(PAMP_s,"1   ");return 0x01;}   
   if (pamp == 2) {strcpy(PAMP_s,"2   ");return 0x02;}  
  }
 if (IBRad_Adr_n == 0x6A)  //IC-7800
  {
   if (pamp == 1) {strcpy(PAMP_s,"1   ");return 0x01;}   
   if (pamp == 2) {strcpy(PAMP_s,"2   ");return 0x02;}  
  }

 if (pamp == 1) {strcpy(PAMP_s,str_on);return 0x01;}

 return 0x00;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
