// R_LISTS.H : Listen + STL-Listen
// G. TAMM, DF9ZO 1999-
//-------------------------
#pragma once
//--------------------
// Disable warning C4786: Symbol greater than 255 character
#pragma warning(disable: 4786)

#include <list>

using namespace std;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//CString-Liste++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
typedef list<CString>  List;
extern  List           CStrLi,
                       CoBoStrLi;
extern  int            CStrLi_Max;
//-----------------------------------------------------------------------------
int  List_ReadFile(List& l,int sel,char *fName);
//Liest File ein
void List_RemAllElem(List& l);
//Entfernt alle Elemente aus Liste
void List_GetElemAt(List& l,CString& dest,int pos);
void List_GetElemAt(List& l,char*    dest,int pos);
//Kopiert Element an pos in dest
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//Klasse z. Lesen/Schreiben v. *.INI - FILES+++++++++++++++++++++++++++++++++++
/*
Regeln f. d. Funktionen z. Lesen:
-keyw im File :
 * Max. Laenge = IniLib_MaxLe_Keyword 
 * Gross-/Kleinschreibung zulaessig: Zwei versch. Schluesselwoerter
   duerfen sich nicht nur durch Gross-/Kleinschreibung unterscheiden 
 * '=' darf nicht enthalten sein
-Ergebnisstring im File:
 * Max. Laenge = IniLib_MaxLe_ResString
 * '=' darf nicht enthalten sein
-Im Erfolgsfall(keyw gefunden und res hinter del nicht leer) ist
 Funktionsergebnis=1, sonst 0.
*/
//-----------------------------------------------------------------------------
const int IL_Le_StrLe=200,                      //**ANPASSEN** 
          IL_Le_StrRi=200,                      //**ANPASSEN** 
          IL_Le_Str  =IL_Le_StrLe+IL_Le_StrRi+3;
//-----------------------------------------------------------------------------
class TaIniLib
{
 public:
  //Standardkonstruktor
  TaIniLib():SoL(NULL),EoL(NULL),elcount(0) {}
  //Destruktor
  ~TaIniLib();
  //Allgemeine Methoden
  int IsEmpty() const {return elcount == 0;} //Prueft, ob Liste leer ist
  int IsElem(char *src) const;               //Prueft, ob El. in Liste ist
  int ElCount() const {return elcount;}      //Gibt Anzahl El. in Liste an
  //----------------------------
  int AppStr(char *src);                     //Fuegt   El. in Liste am Ende ein
  int DelAllElem();                          //Loescht El. aus Liste
  //----------------------------
  int SplitComp(CString str_ini,CString str_key);
  int SplitComp(char*   str_ini,char*   str_key);
  //----------------------------
  int WriteList(char *fName);                    //Schreibt El. in File
  int ReadList (char *fName);                    //Liest El. aus File
  //----------------------------
  //Methoden z. Lesen
  int  Rint(char*   keyw,int&           progvar);//Liest int
  int  Rint(CString keyw,int&           progvar);

  int  Rul (char*   keyw,unsigned long& progvar);//Liest unsigned long
  int  Rul (CString keyw,unsigned long& progvar);
  
  int  Rstr(char*   keyw,char*          progvar);//Liest char[]
  int  Rstr(CString keyw,CString&       progvar);//Liest CString
  //Methoden z. Schreiben 
  void Wint(char*   keyw,int            progvar);//Schreibt int
  void Wint(CString keyw,int            progvar);

  void Wul (char*   keyw,unsigned long  progvar);//Schreibt unsigned long
  void Wul (CString keyw,unsigned long  progvar);

  void Wstr(char*   keyw,char*          progvar);//Schreibt char[]
  void Wstr(CString keyw,CString        progvar);//Schreibt CString
  //----------------------------
 private:
  struct LiEl 
   {
    char *el;        // ** Datenfeld
    LiEl *prev,*next;//Zeiger auf vorheriges, naechstes Element
   };
  LiEl *SoL,*EoL;    //Zeiger auf Listenanfang, Listenende

  CString iniCStr            ,iniCStr_l            ,iniCStr_r;         
  char    inistr[IL_Le_StrLe],inistr_l[IL_Le_StrLe],inistr_r[IL_Le_StrRi];  
  int     elcount;
};
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
