// // R_LISTS.CPP : Listen + STL-Listen
// G. TAMM, DF9ZO 1999-
//-------------------------
#include "stdafx.h"
#include "R_LISTS.H"
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//CString-List+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
List CStrLi,
     CoBoStrLi;
int  CStrLi_Max;
//-----------------------------------------------------------------------------
int List_ReadFile(List& li,int sel,char *fName)
{
 CStdioFile     F_In;
 CFileException F_Exc;
 const int      le=500;
 CString        str("",le);
 char           DiskL[le];

 if(!F_In.Open(fName,CFile::modeRead | CFile::typeText,&F_Exc)) 
  {
   //MessageBox(0,"ERROR file (R_VAR:LiReadFile)","",MB_ICONSTOP | MB_OK);
  }else
  {
   while (F_In.ReadString(DiskL,le-2) != 0)
    {
     StrDel_CR_LF(DiskL);
     if (sel == 0)
      {
       str=DiskL;li.push_back(str);
      }
     if (sel == 1)
      {
       if (DiskL[0] == 'M' && DiskL[1] == '_') {str=DiskL;li.push_back(str);}
      }
    }
   F_In.Close();
  }

 if (li.size() == 0) return 0;else return 1;
}
//-----------------------------------------------------------------------------
void List_RemAllElem(List& l)
{
 List::iterator iter;
 int            x;

 if (l.size() == 0) return;
 //--------------------------
 for (x=1;l.size() > 0;x++)
  {
   iter=l.begin();
   l.erase(iter);
  }
}
//-----------------------------------------------------------------------------
void List_GetElemAt(List& l,CString& dest,int pos)
{
 List::iterator iter;
 int            x;

 if (pos > (int)l.size()) {dest="";return;}
 iter=l.begin();
 for (x=1;x < pos;x++) iter++;
 dest=(*iter);
}

void List_GetElemAt(List& l,char* dest,int pos)
{
 List::iterator iter;
 CString        cstr("",500);
 int            x;

 if (pos > (int)l.size()) {dest="";return;}
 iter=l.begin();
 for (x=1;x < pos;x++) iter++;
 cstr=(*iter);strcpy(dest,LPCTSTR(cstr));
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//Klasse z. Lesen/Schreiben v. *.INI - FILES+++++++++++++++++++++++++++++++++++
TaIniLib::~TaIniLib()//Destruktor
{
 DelAllElem();
}
//-----------------------------------------------------------------------------
int TaIniLib::ReadList(char *fName)
{
 CStdioFile     F_In;
 CFileException F_Exc;
 char           str[IL_Le_Str];
 int            index;

 if(!F_In.Open(fName,CFile::modeRead | CFile::typeText,&F_Exc)) 
  {
   //MessageBox(0,"ERROR file (IniLib:Read)","",MB_ICONSTOP | MB_OK);
   return 0;
  }else
  {
   while (F_In.ReadString(str,IL_Le_Str-2) != 0)
    {
     StrTrLe(str,' ');StrTrRi(str,' ');StrDel_CR_LF(str);
     if (str[0] == '\0' || str[0] == ';' || str[0] == '[') continue;
     index=StrChPos(str,'=',0);
     if (index < 0 || str[index+1] == '\0') continue;
     
     AppStr(str);   
    }
   F_In.Close();   
   return 1;
  }
}
//-----------------------------------------------------------------------------
int TaIniLib::WriteList(char *fName)
{
 CStdioFile     F_Out;
 CFileException F_Exc;
 char           str[IL_Le_Str];

 if (elcount == 0) return 0;

 if(!F_Out.Open(fName,CFile::modeCreate |CFile::modeWrite | CFile::typeText,&F_Exc)) 
  {
   //MessageBox(0,"ERROR file (IniLib:Write)","",MB_ICONSTOP | MB_OK);
   return 0;
  }else
  {
   LiEl* ptr=SoL;
   strcpy(str,ptr->el);strcat(str,"\n");
   F_Out.WriteString(str);

   while ((ptr=ptr->next) != NULL) 
    {
     strcpy(str,ptr->el);strcat(str,"\n");
     F_Out.WriteString(str);
    }

   F_Out.Close();   
   return 1;
  }
}
//-----------------------------------------------------------------------------
int TaIniLib::SplitComp(CString str_ini,CString str_key)
{
 return 0;
}
/*
void SplitIniStr(CString org)
{
 int le,x;

 le=org.GetLength();
 x=org.Find("=");
 INI_l=org.Left(x);
 INI_r=org.Right(le-x-1);
 INI_r.TrimLeft(' ');
 INI_r.TrimRight(' ');
}
*/
int TaIniLib::SplitComp(char*   str_ini,char*   str_key)
{
 str_ini[0]=0;str_key[0]=0;
 return 0;
}
//-----------------------------------------------------------------------------
int TaIniLib::DelAllElem()
{
 LiEl *ptr=SoL,*tmp;

 if (elcount == 0) return 1;

 do 
  {
  tmp=ptr->next;
  delete [](ptr->el);delete ptr;
  ptr=tmp;
  }while (ptr != NULL);
 SoL=NULL;EoL=NULL;elcount=0;

 return 1;
}
//-----------------------------------------------------------------------------
int TaIniLib::IsElem(char *src) const
// Element nicht gefunden =0, sonst Position Element
{
 LiEl* ptr=SoL;
 int   index=1;

 if (IsEmpty()) return 0;

 do 
  {
   if (strcmp(ptr->el,src) == 0) return index;// ** Datenfeld
      else {ptr=ptr->next;index++;}
  }while(ptr != NULL);

 return 0;
}
//-----------------------------------------------------------------------------
int TaIniLib::AppStr(char *src)
{
 if (IsElem(src) > 0) return 0;
 //-----------------
 LiEl *neu=new LiEl;
 if (neu == NULL) return 0;//kein Platz auf Heap f. neues Listenelement
 neu->prev=NULL;neu->next=NULL;
 //-----------------
 char *strneu=new char[strlen(src)+1];
 if (strneu == NULL)//kein Platz auf Heap f. String
    {delete neu;return 0;}
 strcpy(strneu,src);
 neu->el=strneu;// ** Datenfeld
 //-----------------
 if (SoL == NULL)
  {
   SoL=EoL=neu;
  }else
  {
   LiEl *ptr=EoL;
   EoL=ptr->next=neu;
   EoL->prev=ptr;
  }
 elcount++;

 return 1;
}
//-----------------------------------------------------------------------------
int TaIniLib::Rint(char* keyw,int& progvar)
{
 LiEl* ptr=SoL;
 int   index;

 if (elcount == 0) return 0;

 while (ptr != NULL)
  {
   StrUp(inistr_r,keyw);
   //Teilstring vor '=' abspalten
   strcpy(inistr,ptr->el);
   index=StrChPos(inistr,'=',0);
   if (index > 0)//'=' vorhanden und ist nicht erstes Zeichen im String
    {
     inistr[index]=0;
     StrUp(inistr_l,inistr);
     if (strcmp(inistr_l,inistr_r) == 0)
      {
       strcpy(inistr_r,&ptr->el[index+1]);
       if (inistr_r[0] != 0) {progvar=atoi(inistr_r);return 1;}
      }
    }
   ptr=ptr->next;
  }

 return 0;
}

int TaIniLib::Rint(CString keyw,int& progvar)
{
 LiEl* ptr=SoL;
 int   index,le;

 if (elcount == 0) return 0;

 while (ptr != NULL)
  {
   iniCStr_r=keyw;iniCStr_r.MakeUpper();   
   //Teilstring vor '=' abspalten
   iniCStr=ptr->el;
   index=iniCStr.Find('=',0);
   if (index > 0)//'=' vorhanden und ist nicht erstes Zeichen im String
    {
     le=iniCStr.GetLength();
     iniCStr_l=iniCStr.Left(index);iniCStr_l.MakeUpper(); 
     if (iniCStr_l == iniCStr_r)
      {
       iniCStr_r=iniCStr.Right(le-index-1);
       if (inistr_r != "") {progvar=CStrToInt(iniCStr_r);return 1;}
      } 
    }  
   ptr=ptr->next;
  }

 return 0;
}
//-----------------------------------------------------------------------------
int TaIniLib::Rul(char* keyw,unsigned long& progvar)
{
 LiEl* ptr=SoL;
 int   index;

 if (elcount == 0) return 0;

 while (ptr != NULL)
  {
   StrUp(inistr_r,keyw);
   //Teilstring vor '=' abspalten
   strcpy(inistr,ptr->el);
   index=StrChPos(inistr,'=',0);
   if (index > 0)//'=' vorhanden und ist nicht erstes Zeichen im String
    {
     inistr[index]=0;
     StrUp(inistr_l,inistr);
     if (strcmp(inistr_l,inistr_r) == 0)
      {
       strcpy(inistr_r,&ptr->el[index+1]);
       if (inistr_r[0] != 0) {progvar=atol(inistr_r);return 1;}
      }
    }
   ptr=ptr->next;
  }

 return 0;
}

int TaIniLib::Rul(CString keyw,unsigned long& progvar)
{
 LiEl* ptr=SoL;
 int   index,le;

 if (elcount == 0) return 0;

 while (ptr != NULL)
  {
   iniCStr_r=keyw;iniCStr_r.MakeUpper();   
   //Teilstring vor '=' abspalten
   iniCStr=ptr->el;
   index=iniCStr.Find('=',0);
   if (index > 0)//'=' vorhanden und ist nicht erstes Zeichen im String
    {
     le=iniCStr.GetLength();
     iniCStr_l=iniCStr.Left(index);iniCStr_l.MakeUpper(); 
     if (iniCStr_l == iniCStr_r)
      {
       iniCStr_r=iniCStr.Right(le-index-1);
       if (inistr_r != "") {progvar=CStrToLong(iniCStr_r);return 1;}
      } 
    }  
   ptr=ptr->next;
  }

 return 0;
}
//-----------------------------------------------------------------------------
int TaIniLib::Rstr(char* keyw,char* progvar)
{
 LiEl* ptr=SoL;
 int   index;

 if (elcount == 0) return 0;

 while (ptr != NULL)
  {
   StrUp(inistr_r,keyw);
   //Teilstring vor '=' abspalten
   strcpy(inistr,ptr->el);
   index=StrChPos(inistr,'=',0);
   if (index > 0)//'=' vorhanden und ist nicht erstes Zeichen im String
    {
     inistr[index]=0;
     StrUp(inistr_l,inistr);
     if (strcmp(inistr_l,inistr_r) == 0)
      {
       strcpy(inistr_r,&ptr->el[index+1]);
       if (inistr_r[0] != 0) {strcpy(progvar,inistr_r);return 1;}
      }
    }
   ptr=ptr->next;
  }

 return 0;
}

int TaIniLib::Rstr(CString keyw,CString& progvar)
{
 LiEl* ptr=SoL;
 int   index,le;

 if (elcount == 0) return 0;

 while (ptr != NULL)
  {
   iniCStr_r=keyw;iniCStr_r.MakeUpper();   
   //Teilstring vor '=' abspalten
   iniCStr=ptr->el;
   index=iniCStr.Find('=',0);
   if (index > 0)//'=' vorhanden und ist nicht erstes Zeichen im String
    {
     le=iniCStr.GetLength();
     iniCStr_l=iniCStr.Left(index);iniCStr_l.MakeUpper(); 
     if (iniCStr_l == iniCStr_r)
      {
       iniCStr_r=iniCStr.Right(le-index-1);
       if (inistr_r != "") {progvar=iniCStr_r;return 1;}
      } 
    }  
   ptr=ptr->next;
  }

 return 0;
}
//-----------------------------------------------------------------------------
void TaIniLib::Wint(char* keyw,int progvar)
{
 char strtmp[30],tr[2]="=";

 strcpy(inistr,keyw);strcat(inistr,tr);
 _itoa(progvar,strtmp,10);strcat(inistr,strtmp);
 AppStr(inistr);
}

void TaIniLib::Wint(CString keyw,int progvar)
{
 CString cstr("",100);
 char    strtmp[30],tr[2]="=";

 cstr=keyw;cstr+=tr;
 _itoa(progvar,strtmp,10);cstr+=strtmp;
 strcpy(inistr,LPCTSTR(cstr));
 AppStr(inistr);
}
//-----------------------------------------------------------------------------
void TaIniLib::Wul(char* keyw,unsigned long progvar)
{
 char strtmp[30],tr[2]="=";

 strcpy(inistr,keyw);strcat(inistr,tr);
 _ultoa(progvar,strtmp,10);strcat(inistr,strtmp);
 AppStr(inistr);
}

void TaIniLib::Wul(CString keyw,unsigned long progvar)
{
 CString cstr("",100);
 char    strtmp[30],tr[2]="=";

 cstr=keyw;cstr+=tr;
 _ultoa(progvar,strtmp,10);cstr+=strtmp;
 strcpy(inistr,LPCTSTR(cstr));
 AppStr(inistr);
}
//-----------------------------------------------------------------------------
void TaIniLib::Wstr(char* keyw,char* progvar)
{
 char tr[2]="=";

 strcpy(inistr,keyw);strcat(inistr,tr);strcat(inistr,progvar);
 AppStr(inistr);
}

void TaIniLib::Wstr(CString keyw,CString progvar)
{
 CString cstr("",100);
 char    tr[2]="=";

 cstr=keyw;cstr+=tr;cstr+=progvar;
 strcpy(inistr,LPCTSTR(cstr));
 AppStr(inistr);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++