// R_ICOMmem.CPP : ICOM CI-V - Bus
// G. TAMM, DF9ZO 2007
//--------------------
#include "stdafx.h"
#include "R_ICOMmem.H"
//IB_SetMemFrTxt+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void IB_SetMemFrTxt() 
{
 const int    le=1000;
 CFileDialog  *OpenDlg;
 CString      FiName("",Fl),DirName("",Fl); 
 char         str[le],str_tmp[le],finame[Fl]="",
              F_tmp[100],M_tmp[100],Fs_org[100];  
 int          x,i,memnum,membank=0,memcmd=0,Mn_org,FIn_org;

 if (Radio_Num < 0) {TaMsgBox(AppName,statmsg02,3);return;}
 RadioSettings();
 if (IBRad_Da_n <  5) {TaMsgBox(AppName,msg04,3);return;}
 COMTest_Single(COM_PORT);if (!COMAvail[COM_PORT]) {TaMsgBox(AppName,commsg00,3);return;}
 //-----------------------
 _getcwd(str,le-1);DirName=str;
 OpenDlg=new CFileDialog(TRUE,NULL,DirName,OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST, 
                         "Memory-Files (*.TXTMEM)|*.txtmem|All Files (*.*)|*.*||");
 OpenDlg->m_ofn.lpstrTitle="File Open";
 if (OpenDlg->DoModal()== IDOK)
  {
   FiName=OpenDlg->GetPathName();
  }else FiName="";
 delete OpenDlg;
 if (FiName == "") return;
 //-----------------------
 IBMEMCMD_Dlg ibmemcmddlg;
 ibmemcmddlg.m_cmd=memcmd;
 if (ibmemcmddlg.DoModal() == IDOK)
  {
   memcmd =ibmemcmddlg.m_cmd;
   membank=ibmemcmddlg.m_bank+1;
  }else return;
 
 comport.Open(COM_PORT,COM_BAUD,COM_DATA,COM_STOP,COM_PARI,COM_PROT,1000,1000);
 comport.ClrRXBuf();comport.ClrTXBuf();

 comport.F_Ask();comport.M_Ask();
 strcpy(Fs_org,Fact_s);
 Mn_org=Mact_n;FIn_org=FIact_n; 

 strcpy(finame,LPCTSTR(FiName));
 List_ReadFile(CStrLi,1,finame);CStrLi_Max=(int)CStrLi.size();
 comport.MEM_BANK_Set(membank);
 //-----------------------
 for (x=1;x < CStrLi_Max+1;x++)
  {
   List_GetElemAt(CStrLi,str,x);
   if (str[6] == '=' && str[7] == '-') continue;

   strcpy(str_tmp,str);str_tmp[6]=0;
   str_tmp[0]='0';str_tmp[1]='0';StrTrLe(str_tmp,'0');
   memnum=atoi(str_tmp);
   comport.MEM_ToNum_Set(memnum);                                      //Mem-Nummer setzen
   
   comport.VFO_MEM_Switch(0);                                          //In VFO-Modus schalten     
   comport.VFO_AB_Switch(0) ;                                          //VFO A       
                                 
   for (i=0;i < 7;i++) str[i]='x';
   StrTrLe(str,'x');
   GetFM(F_tmp,M_tmp,str);ModFstr(F_tmp,Fdef_s);
   comport.F_Set(F_tmp);                                               //Frequenz

   GetAddData(str,2);//FI
   ModMstr(M_tmp);                                                     //Mode
   comport.M_Set(Mact_n,FIact_n);
      
   GetAddData(str,0);                                                  //SF
   ModFstr(SFact_s,".001");StrTrLe(SFact_s,' ');
   comport.FSTEP_HW_Set(SFstrToSFind(SFact_s));

   DUPsw=0;GetAddData(str,4);                                          //DUP
   comport.DUP_Switch(DUPsw);
   
   ATTsw=0;GetAddData(str,3);                                          //ATT
   comport.ATT_Switch(ATTsw);
   
   PAMPsw=0;GetAddData(str,5);                                         //PAMP
   comport.PAMP_Switch(PAMPsw);

   MEMtxt_s[0]=0;GetAddData(str,6);                                    //TXT
   MEMtxt_s[9]=0;
 
   comport.VFO_EQUAL_Switch();                                         //VFO A=B
   comport.MEM_ToNum_Set(memnum);

   if (memcmd == 0) 
    {     
     comport.MEM_FromVFO_Set();
    }else
    {     
     comport.MEM_Set_7000(membank,memnum,F_tmp,Mact_n,FIact_n,DUPsw,MEMtxt_s);     
    }
  }
 //-----------------------
 List_RemAllElem(CStrLi);

 comport.VFO_MEM_Switch(0);
 comport.VFO_AB_Switch(0);
 comport.F_Set(Fs_org);
 comport.M_Set(Mn_org,FIn_org);

 comport.Close(); 
 TaMsgBox(AppName,msg01,2);  
}
//IBMEMCLR_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IBMEMCLR_Dlg::IBMEMCLR_Dlg(CWnd* pParent /*=NULL*/)
	          : CDialog(IBMEMCLR_Dlg::IDD, pParent)
             , m_bank(0)
{
	//{{AFX_DATA_INIT(IBMEMCLR_Dlg)
	m_from = _T("1");
	m_to   = _T("99");
	//}}AFX_DATA_INIT
}

void IBMEMCLR_Dlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(IBMEMCLR_Dlg)
   DDX_Text(pDX, IDC_IBMEMCLR_ED01,  m_from);
   DDV_MaxChars(pDX, m_from, 3);
   DDX_Text(pDX, IDC_IBMEMCLR_ED02,  m_to);
   DDV_MaxChars(pDX, m_to,   3);
   DDX_CBIndex (pDX, IDC_IBMEMCLR_CB01, m_bank);
   //}}AFX_DATA_MAP   
}

BEGIN_MESSAGE_MAP(IBMEMCLR_Dlg, CDialog)
	//{{AFX_MSG_MAP(IBMEMCLR_Dlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL IBMEMCLR_Dlg::OnInitDialog() 
{
 CString    str("",50);
 char       tmpstr[10];

 CDialog::OnInitDialog();

 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 _itoa(Radio_Num+1,tmpstr,10);
 str="Clear Radio Memories (RADIO ";str+=tmpstr;str+=")";
 SetWindowText(str);

 GetDlgItem(IDOK)->SetFocus();
 UpdateData(FALSE);

 return FALSE;// return TRUE unless you set the focus to a control
}

void IBMEMCLR_Dlg::OnOK() 
{
 char str[100],Fs_org[100]; 
 int  x,fromnum,tonum,error,membank=0,Mn_org,FIn_org; 

 if (!UpdateData(TRUE)) return;

 if (Radio_Num < 0) {TaMsgBox(AppName,statmsg02,3);return;}
 RadioSettings();
 Invalidate();error=0;
 COMTest_Single(COM_PORT);if (!COMAvail[COM_PORT]) {TaMsgBox(AppName,commsg00,3);return;}
 
 membank=m_bank+1;//Bank:Start mit 1
 strcpy(str,LPCTSTR(m_from));fromnum=atoi(str);
 strcpy(str,LPCTSTR(m_to  ));tonum  =atoi(str);

 comport.Open(COM_PORT,COM_BAUD,COM_DATA,COM_STOP,COM_PARI,COM_PROT,1000,1000);
 comport.ClrRXBuf();comport.ClrTXBuf();

 comport.F_Ask();comport.M_Ask();
 strcpy(Fs_org,Fact_s);
 Mn_org=Mact_n;FIn_org=FIact_n;

 comport.VFO_MEM_Switch(1)    ;                 //Bed.: In Memory-Modus schalten
 if (membank < 6) comport.MEM_BANK_Set(membank);//Bank setzen
 //-----------------------
 if (fromnum < 1) fromnum=1;
 for (x=fromnum;x < tonum+1;x++) 
  {
   comport.MEM_ToNum_Set(x);VDelay(CMD_Del);
   comport.MEM_CLR_Set()   ;VDelay(CMD_Del);
  }

 comport.VFO_MEM_Switch(0);
 comport.VFO_AB_Switch(0);
 comport.F_Set(Fs_org);
 comport.M_Set(Mn_org,FIn_org);

 comport.Close();
 TaMsgBox(AppName,msg01,2);
	
 CDialog::OnOK();
}
//IBMEMCMD_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(IBMEMCMD_Dlg, CDialog)
IBMEMCMD_Dlg::IBMEMCMD_Dlg(CWnd* pParent /*=NULL*/)
	          : CDialog(IBMEMCMD_Dlg::IDD, pParent)
             , m_cmd(0)
             , m_bank(0)
{
}

IBMEMCMD_Dlg::~IBMEMCMD_Dlg()
{
}

void IBMEMCMD_Dlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   DDX_Radio(pDX, IDC_IBMEMCMD_RB1,    m_cmd);
   DDX_CBIndex(pDX, IDC_IBMEMCMD_CB01, m_bank);
}

BEGIN_MESSAGE_MAP(IBMEMCMD_Dlg, CDialog)
END_MESSAGE_MAP()
//IBMEMDlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(IBMEMDlg, CDialog)

IBMEMDlg::IBMEMDlg(CWnd* pParent /*=NULL*/)
	      : CDialog(IBMEMDlg::IDD, pParent)
{
}

IBMEMDlg::~IBMEMDlg()
{
}

void IBMEMDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   DDX_Control(pDX, IDC_IBMEM_LIST, replist);
}

BEGIN_MESSAGE_MAP(IBMEMDlg, CDialog)
   ON_BN_CLICKED(IDC_IBMEM_LIST_OPEN,      &IBMEMDlg::OnListOpen)
   ON_BN_CLICKED(IDC_IBMEM_LIST_SAVEAS,    &IBMEMDlg::OnListSaveAs)
   ON_BN_CLICKED(IDC_IBMEM_LIST_ITEMADD,   &IBMEMDlg::OnItemAdd)
   ON_BN_CLICKED(IDC_IBMEM_ITEM_DELMARKED, &IBMEMDlg::OnItemDelMarked)
   ON_BN_CLICKED(IDC_IBMEM_ITEM_DELALL,    &IBMEMDlg::OnItemDelAll)   
   ON_BN_CLICKED(IDC_IBMEM_ITEM_MOVEUP,    &IBMEMDlg::OnItemMoveUp)
   ON_BN_CLICKED(IDC_IBMEM_ITEM_MOVEDOWN,  &IBMEMDlg::OnItemMoveDown)
   ON_BN_CLICKED(IDC_IBMEM_HELP,           &IBMEMDlg::OnHelp)
   ON_BN_CLICKED(IDC_IBMEM_ITEM_FORMCOLS,  &IBMEMDlg::OnFormatCols)
   ON_CBN_SELCHANGE(IDC_IBMEM_CB1,         &IBMEMDlg::OnCBSelchange)
   ON_BN_CLICKED(IDC_IBMEM_UPLOAD,         &IBMEMDlg::OnUpload)
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL IBMEMDlg::OnInitDialog()
{
 CString    str("",50);
 char       tmpstr[10];
 
 CDialog::OnInitDialog();

 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 _itoa(Radio_Num+1,tmpstr,10);
 str="Edit Radio Memories (RADIO ";str+=tmpstr;str+=")";
 SetWindowText(str);

 replist.SetColumnHeader("Idx,35,0;MEM,35,0;Frequency,80,2;Mode,60,0;Filter,60,1;SIM/DUP,60,1;Text (9),150,0");
 
 replist.SetGridLines(TRUE);                // Show grid lines
 replist.SetCheckboxeStyle(RC_CHKBOX_NONE); // Enable checkboxes
 replist.SetEditable(TRUE);                 // Allow sub-text edit
 replist.SetSortable(FALSE);
 
 pCB=(CComboBox*) GetDlgItem(IDC_IBMEM_CB1);
 pCB->SetCurSel(0); 
 replist.BankSel=0;
 UpdateData(FALSE);

 return TRUE;  // return TRUE unless you set the focus to a control
               // EXCEPTION: OCX Property Pages should return FALSE
}
//-----------------------------------------------------------------------------
void IBMEMDlg::OnListOpen()
{
 replist.ListOpen();
 pCB->SetCurSel(replist.BankSel);
}

void IBMEMDlg::OnListSaveAs()
{
 OnFormatCols();
 replist.BankSel=pCB->GetCurSel(); 
 replist.ListSave();
}
//-----------------------------------------------------------------------------
void IBMEMDlg::ReArrInd()
{
 char str_tmp[10];
 int  num_row,row;

 num_row=replist.GetItemCount();
 for (row=0;row < num_row;row++)
  {
   _itoa(row,str_tmp,10);
   replist.SetItemText(row,0,str_tmp);//Index

   _itoa(row+1,str_tmp,10);
   replist.SetItemText(row,1,str_tmp);//MEM
  }
}

void IBMEMDlg::OnItemDelAll()
{
 replist.DeleteAllItems();
}

void IBMEMDlg::OnItemDelMarked()
{
 int row;

 row=replist.GetFirstItem(RC_ITEM_SELECTED,-1);
 if (row == -1) return;
 replist.DeleteItem(row);
 ReArrInd();
 replist.SetFocus();
 replist.SetItemStates(row-1,RC_ITEM_SELECTED);
}

void IBMEMDlg::OnItemAdd()
{
 CString cstr;
 char    str_tmp[20];
 int     num,x; 
 
 num=replist.GetItemCount();
 _itoa(num,str_tmp,10);

 replist.InsertItem(num,"");
 replist.SetItemText(num,0,str_tmp);
 //replist.SetSortable(TRUE);replist.SortItems(0,TRUE);replist.SetSortable(FALSE);
 if (num > 0)
  {
   cstr=replist.GetItemText(num-1,1);
   if (cstr == "") return;
   x=CStrToInt(cstr);x++;_itoa(x,str_tmp,10);
   replist.SetItemText(num,1,str_tmp);
  }                 
}

void IBMEMDlg::OnItemMoveUp()
{
 int row;

 row=replist.GetFirstItem(RC_ITEM_SELECTED,-1);
 if (row == 0) return;
 replist.MoveUp(row);
 ReArrInd();
 replist.SetFocus();
}

void IBMEMDlg::OnItemMoveDown()
{
 int num_row,row;

 num_row=replist.GetItemCount();
 row=replist.GetFirstItem(RC_ITEM_SELECTED,-1);
 if (row+1 == num_row) return;
 replist.MoveDown(row);
 ReArrInd();
 replist.SetFocus(); 
}

void IBMEMDlg::OnFormatCols()
{
 CString cstr;
 char    str[15];
 int     num_row,row;

 num_row=replist.GetItemCount();
 for (row=0;row < num_row;row++)
  {
   cstr=replist.GetItemText(row,2);//Frequency
   if (cstr != "")
    {
     strcpy(str,(LPCTSTR)cstr);
     StrTrLe(str,' ');StrTrRi(str,' ');  
     ModFstr(str,Fdef_s);
     replist.SetItemText(row,2,str);
    }else continue;

   cstr=replist.GetItemText(row,6);//Text
   strcpy(str,(LPCTSTR)cstr);
   if (IBRad_Adr_n == 0x70) str[9]=0;//IC-7000
   replist.SetItemText(row,6,str);  
  }
}

void IBMEMDlg::OnCBSelchange()
{
 replist.BankSel=pCB->GetCurSel();  
}
//-----------------------------------------------------------------------------
void IBMEMDlg::OnHelp()
{
 TaMsgBox(AppName,"ENTER FREQUENCIES (see TaICOM_info):\n\n"
                  "MHz numbers (1-4)\n"
                  "POINT\t + optional (1-3) kHz number(s)\n"
                  "comma\t + optional (1-3) Hz number(s)\n\n"
                  "Final format (i.e. 1295.350,000) adj. by SW\n\n"
                  "Examples:\n"
                  ".5 ->    .500,000\n"
                  "14 ->  14.000,000\n"
                  "28.53 ->  28.530,000\n"
                  "145.362,5 -> 145.362,500\n",1);
}
//-----------------------------------------------------------------------------
void IBMEMDlg::OnUpload()
{
 CString      cstr;
 char         str[100],Fs[100],Fs_org[100],Ms[100]; 
 int          call_scan,memnum,membank=0,num_row,row,Mn,Mn_org,FIn,FIn_org,DUPn;

 if (Radio_Num < 0) {TaMsgBox(AppName,statmsg02,3);return;}
 RadioSettings();
 if (IBRad_Da_n <  5) {TaMsgBox(AppName,msg04,3);return;}
 Invalidate();
 OnFormatCols();
 COMTest_Single(COM_PORT);if (!COMAvail[COM_PORT]) {TaMsgBox(AppName,commsg00,3);return;}
 //-----------------------
 comport.Open(COM_PORT,COM_BAUD,COM_DATA,COM_STOP,COM_PARI,COM_PROT,1000,1000);
 comport.ClrRXBuf();comport.ClrTXBuf();

 comport.F_Ask();comport.M_Ask();
 strcpy(Fs_org,Fact_s);
 Mn_org=Mact_n;FIn_org=FIact_n; 

 comport.VFO_MEM_Switch(1);                                     //Bed.: In Memory-Modus schalten
 membank=pCB->GetCurSel();membank+=1;                           //Bank:Start mit 1
 call_scan=0;
 if (membank < 6) comport.MEM_BANK_Set(membank);                //Bank setzen
 if (membank == 6)                                              //100-107 Call... 
  {
   membank=5;call_scan=1;
   comport.MEM_BANK_Set(membank);
  }
 //-----------------------
 num_row=replist.GetItemCount(); 
 for (row=0;row < num_row;row++)
  {
   cstr=replist.GetItemText(row,1);
   strcpy(str,(LPCTSTR)cstr);
   memnum=atoi(str);
   if (memnum < 1) continue;
   comport.MEM_ToNum_Set(memnum);VDelay(CMD_Del);               //Mem-Nummer setzen

   cstr=replist.GetItemText(row,2);
   if (call_scan && (memnum < 100 || memnum >107)) continue;    //100-107 Call...
   if (cstr == "")//Freq empty ???
    {
     comport.MEM_CLR_Set();VDelay(CMD_Del);
     continue;
    }

   comport.VFO_MEM_Switch(0);                                   //In VFO-Modus schalten     
   comport.VFO_AB_Switch(0) ;                                   //VFO A      

   cstr=replist.GetItemText(row,2);                             //Frequency
   strcpy(Fs,(LPCTSTR)cstr); 
   ModFstr(Fs,Fdef_s);
   comport.F_Set(Fs);                                              

   cstr=replist.GetItemText(row,3);                             //Mode
   strcpy(Ms,(LPCTSTR)cstr); 
   ModMstr(Ms);Mn=Mact_n;                                                    

   cstr=replist.GetItemText(row,4);                             //Filter
   strcpy(str,(LPCTSTR)cstr);
   if (_strcmpi(str,FIarr_s[3]) == 0) FIn=0;//NORMAL
   if (_strcmpi(str,FIarr_s[4]) == 0) FIn=1;//NARROW
   if (_strcmpi(str,FIarr_s[5]) == 0) FIn=2;//WIDE

   comport.M_Set(Mn,FIn);

   cstr=replist.GetItemText(row,5);                             //SIM/DUP
   strcpy(str,(LPCTSTR)cstr);
   if (_strcmpi(str,DUParr_s[3]) == 0) DUPn=0;//SIM
   if (_strcmpi(str,DUParr_s[4]) == 0) DUPn=1;//-DUP
   if (_strcmpi(str,DUParr_s[5]) == 0) DUPn=2;//+DUP
   comport.DUP_Switch(DUPn);

   cstr=replist.GetItemText(row,6);                             //TEXT
   strcpy(MEMtxt_s,(LPCTSTR)cstr);

   comport.VFO_EQUAL_Switch();                                  //VFO A=B
   comport.MEM_ToNum_Set(memnum);

   if (IBRad_Adr_n == 0x70)//IC-7000
    {
     comport.MEM_Set_7000(membank,memnum,Fs,Mn,FIn,DUPn,MEMtxt_s);
    }
  }
 //-----------------------
 comport.VFO_MEM_Switch(0);
 comport.VFO_AB_Switch(0);
 comport.F_Set(Fs_org);
 comport.M_Set(Mn_org,FIn_org);
    
 comport.Close();
 TaMsgBox(AppName,msg01,2);  
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
{"-","N","W","NORMAL","NARROW","WIDE  "};
FilterIndex: 0=Normal, 1=Narrow, 2=Wide

{"S","-","+","SIM","-DUP","+DUP"};
*/
