// R_ICOM.H : Specs for Radios with ICOM CI-V - Bus
// G. TAMM, DF9ZO 2003-
//--------------------
#pragma once
#include "stdafx.h"
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ALLE String-Laengenangeben inklusive termnierende \0
const int    IBRad_SoM              =0xFE,
             IBRad_EoM              =0xFD,
			 	 IBRad_PcAdr            =0xE0,
             IBRad_OK               =0xFB, //251
             IBRad_NOTOK            =0xFA, //250
             IBRad_COLL             =0xFC; //252

extern int 	 IBRad_Adr_n;                  //ICOM-Adresse numerisch
extern int 	 IBRad_Da_n;                   //ICOM-Data 4/5
extern int   IBRad_Tr_n;                   //ICOM-Transceive 0/1
extern int   IBRad_FI_HW[];                //Array SubCmds f. HW-Filter
extern int   IBRad_FI_SW[];                //Array SubCmds f. SW-Filter
//-----------------------------------------------------------------------------
extern char  IBRad_ini01[],IBRad_ini02[],IBRad_ini03[],IBRad_ini04[],IBRad_ini05[],
             IBRad_ini06[],IBRad_ini07[],IBRad_ini08[],IBRad_ini09[],IBRad_ini10[],
             IBRad_ini11[],IBRad_ini12[],IBRad_ini13[],IBRad_ini14[],IBRad_ini15[],
             IBRad_ini16[],IBRad_ini17[],IBRad_ini18[],IBRad_ini19[],IBRad_ini20[],
             IBRad_ini21[],IBRad_ini22[],IBRad_ini23[],IBRad_ini24[],IBRad_ini25[],
             IBRad_ini26[],IBRad_ini27[],IBRad_ini28[],IBRad_ini29[],IBRad_ini30[],
             IBRad_ini31[],IBRad_ini32[],IBRad_ini33[],IBRad_ini34[],IBRad_ini35[],
             IBRad_ini36[],IBRad_ini37[],IBRad_ini38[],IBRad_ini39[],IBRad_ini40[],
             IBRad_ini41[],IBRad_ini42[],IBRad_ini43[],IBRad_ini44[];

extern char  IBRad_FI_HW_ini[18][20];      //HW-Filter
extern char  IBRad_FI_SW_ini[60][20];      //SW-Filter
//IBData+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
const int    IBRad_Max              =4;    //Max. Anzahl ICOM-Radios mit CI-V Bus

struct IBRadios
{
 char        Name[50];                 //Bez. Radio
 //ICOM CI-V - Bus------------------
 char        IB_Adr_s[3];              //Adresse (String, hex)
 int 	       IB_Da_n;                  //Datalength (4 oder 5) 
 //COM------------------------------
 int 	       COMport;                  //COM1-COM20
 int 	       COMbaud;                  //Baudrate
 int         COMdata;                  //Databit
 int 	       COMpari;                  //Parity
 int         COMstop;                  //Stopbit
 int         COMprot;                  //Protocol
 //Radio-basics---------------------
 char        Fdef_s    [13];           //Frequenz def. d. Radios
 char 	    Fmin_s    [13];           //Min. Frequenz d. Radios
 char 	    Fmax_s    [13];           //Max. Frequenz d. Radios
 char	       SmConv_s  [250];          //S-Meter Conversion-File
 int 	       SQL_SwHw;                 //0=Software / 1=Hardware
 int         FI_SwHw;                  //0=HW-Filter, 1=DSP-Filter
 int         ANTmax;                   //Max. schaltb. Antennen
 int         ATTmax;                   //Max. schaltb. Attenuators
 int         PAMPmax;                  //Max. schaltb. PreAmps
 int         MICgain;                  //Mic-Gain
 int         COMPlev;                  //Compr.-Level
 int         RoofFi_n;                 //Roofing-Filter
 //REMOTE---------------------------
 char 	    RE_Fact_s [13];           //F akt.
 char 	    RE_SFact_s[13];           //F-Step
 char 	    RE_OFact_s[13];           //F-Offset
 int         RE_Mact_n;                //Modeindex akt.
 int         RE_FIact_n;               //FilterIndex: 0=Normal, 1=Narrow, 2=Wide
 //SCAN-----------------------------
 char        SC_LoF_s  [13];           //Freq. low
 char        SC_HiF_s  [13];           //Freq. high
 char        SC_SFact_s[13];           //F-Step
 int         SC_Mact_n;                //Modeindex
 int         SC_FIact_n;               //FilterIndex:   0=Normal, 1=Narrow, 2=Wide
 int         SC_StepDel;
 int         SC_StopMo;                //Mode Scanstop: 0=Mode1,  1=Mode2,  2=Mode3
 int         SC_M2Del;
 int         SC_M3Lev;
 int         SC_WrSpec;
 int         SC_LtSpec;
 //TX-SSB---------------------------
 int         TXSSBbw;                  //TX SSB-BW (0=w, 1=m, 2=n)
 int         TXSSBbw_wilo;
 int         TXSSBbw_wihi;
 int         TXSSBbw_milo;
 int         TXSSBbw_mihi;
 int         TXSSBbw_nalo;
 int         TXSSBbw_nahi;
 //FILTERS--------------------------
 char        IB_FI_HW_s[18][3];        //HW-Filter SubCmds (Strings)
 char        IB_FI_SW_s[60][7];        //SW-Filter Values  (Strings) 
};
extern       IBRadios RADIOS[IBRad_Max];
//IBModes++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
struct IBModes
{
 static const int Mmax  =12;
 static const int Mlen_s=7;

 int  m_n  [Mmax];
 char m_s  [Mmax][Mlen_s];
 int  ibcmd[Mmax];

 int MnFromIBcmd(int IBcmd);
 int IBcmdFromMn(int moind);
};
extern IBModes MODES;
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
ICOM CI-V - Bus: 8 Databit / 1 Stopbit / NO Parity / NO Protocol

*/