// R_ICOM.CPP : Specs for Radios with ICOM CI-V - Bus
// G. TAMM, DF9ZO 2003-
//--------------------
#include "stdafx.h"
#include "R_ICOMdata.H"
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int  IBRad_Adr_n        =0;
int  IBRad_Da_n         =0;
int  IBRad_Tr_n         =1;  
int  IBRad_FI_HW[18];
int  IBRad_FI_SW[60];
//-----------------------------------------------------------------------------
char IBRad_ini01[]            ="RadioName",
     //ICOM CI-V - Bus--------
     IBRad_ini02[]            ="IB_Adr",
     IBRad_ini03[]            ="IB_Data",
     //COM--------------------
     IBRad_ini04[]            ="COMport",
     IBRad_ini05[]            ="COMbaud",
     IBRad_ini06[]            ="COMdata",
     IBRad_ini07[]            ="COMpari",
     IBRad_ini08[]            ="COMstop",
     IBRad_ini09[]            ="COMprot", 
     //Radio-basics-----------
     IBRad_ini10[]            ="Fdef", 
     IBRad_ini11[]            ="Fmin",
     IBRad_ini12[]            ="Fmax",
     IBRad_ini13[]            ="SM_Conv",
     IBRad_ini14[]            ="SQL_SwHw",
     IBRad_ini15[]            ="FI_SwHw",
     IBRad_ini16[]            ="ANT_max",
     IBRad_ini17[]            ="ATT_max", 
     IBRad_ini18[]            ="PAMP_max",
     IBRad_ini19[]            ="MICgain",
     IBRad_ini20[]            ="COMPlev",
     //REMOTE-----------------
     IBRad_ini21[]            ="RE_F",
     IBRad_ini22[]            ="RE_SF",
     IBRad_ini23[]            ="RE_OF",  
     IBRad_ini24[]            ="RE_M",
     IBRad_ini25[]            ="RE_FI",     
     //SCAN-------------------
     IBRad_ini26[]            ="SC_Flo",  
     IBRad_ini27[]            ="SC_Fhi",  
     IBRad_ini28[]            ="SC_SF",
     IBRad_ini29[]            ="SC_M",
     IBRad_ini30[]            ="SC_FI",
     IBRad_ini31[]            ="SC_StepDel",
     IBRad_ini32[]            ="SC_StopMode",
     IBRad_ini33[]            ="SC_M2Del",
     IBRad_ini34[]            ="SC_M3Lev",
     IBRad_ini35[]            ="SC_SpecWr",
     IBRad_ini36[]            ="SC_SpecLt", 
     //TX-SSB-----------------
     IBRad_ini37[]            ="TXSSBbw",
     IBRad_ini38[]            ="TXSSBbw_wilo",
     IBRad_ini39[]            ="TXSSBbw_wihi",
     IBRad_ini40[]            ="TXSSBbw_milo",
     IBRad_ini41[]            ="TXSSBbw_mihi",
     IBRad_ini42[]            ="TXSSBbw_nalo",
     IBRad_ini43[]            ="TXSSBbw_nahi",
     //New-------------------- 
     IBRad_ini44[]            ="RoofingFi";

char IBRad_FI_HW_ini[18][20]  ={"FI_HW_SSBno__","FI_HW_SSBna__","FI_HW_SSBwi__", //00
								        "FI_HW_FMno___","FI_HW_FMna___","FI_HW_FMwi___", //03
     			  				        "FI_HW_FMWno__","FI_HW_FMWna__","FI_HW_FMWwi__", //06
     			  				        "FI_HW_AMno___","FI_HW_AMna___","FI_HW_AMwi___", //09
     			  				        "FI_HW_CWno___","FI_HW_CWna___","FI_HW_CWwi___", //12
     			  				        "FI_HW_RTTYno_","FI_HW_RTTYna_","FI_HW_RTTYwi_"};
char IBRad_FI_SW_ini[60][20]  ={"FI_SW_SSBbwlo____","FI_SW_SSBbwhi____","FI_SW_SSBdefno___","FI_SW_SSBdefna___","FI_SW_SSBdefwi___", //00
                                "FI_SW_SSBbwlo___l","FI_SW_SSBbwhi___l","FI_SW_SSBdefno__l","FI_SW_SSBdefna__l","FI_SW_SSBdefwi__l",
                                "FI_SW_FMbwlo_____","FI_SW_FMbwhi_____","FI_SW_FMdefno____","FI_SW_FMdefna____","FI_SW_FMdefwi____", //10
                                "FI_SW_FMbwlo____l","FI_SW_FMbwhi____l","FI_SW_FMdefno___l","FI_SW_FMdefna___l","FI_SW_FMdefwi___l",
                                "FI_SW_FMWbwlo____","FI_SW_FMWbwhi____","FI_SW_FMWdefno___","FI_SW_FMWdefna___","FI_SW_FMWdefwi___", //20  
                                "FI_SW_FMWbwlo___l","FI_SW_FMWbwhi___l","FI_SW_FMWdefno__l","FI_SW_FMWdefna__l","FI_SW_FMWdefwi__l",
                                "FI_SW_AMbwlo_____","FI_SW_AMbwhi_____","FI_SW_AMdefno____","FI_SW_AMdefna____","FI_SW_AMdefwi____", //30   
                                "FI_SW_AMbwlo____l","FI_SW_AMbwhi____l","FI_SW_AMdefno___l","FI_SW_AMdefna___l","FI_SW_AMdefwi___l",
                                "FI_SW_CWbwlo_____","FI_SW_CWbwhi_____","FI_SW_CWdefno____","FI_SW_CWdefna____","FI_SW_CWdefwi____", //40 
                                "FI_SW_CWbwlo____l","FI_SW_CWbwhi____l","FI_SW_CWdefno___l","FI_SW_CWdefna___l","FI_SW_CWdefwi___l",
                                "FI_SW_RTTYbwlo___","FI_SW_RTTYbwhi___","FI_SW_RTTYdefno__","FI_SW_RTTYdefna__","FI_SW_RTTYdefwi__", //50
                                "FI_SW_RTTYbwlo__l","FI_SW_RTTYbwhi__l","FI_SW_RTTYdefno_l","FI_SW_RTTYdefna_l","FI_SW_RTTYdefwi_l"};
//IBData+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IBRadios/*IBData*/ RADIOS[IBRad_Max]=
{
//Radio 1****************************
{"IC-7000 HF-UHF",				          //Titel
 //ICOM CI-V - Bus-
 "70",5,                                //ICOM-Adr. (String, hex), Datalength (4 oder 5)
 //COM-------------                    
 1,8,4,4,0,3,                           //COM, Baud, Databit, Pari, Stop, Prot
 //Radio-basics----
 "145.350,000",                         //F def.
 ".030,000","440.000,000",              //Fmin, Fmax
 "SMC_IC7000.SMC",0,                    //SQL_SH, S-M Konversion
 1,                                     //DSP/HW-Filter
 0,                                     //Max. schaltb. Antennen
 1,                                     //Max. schaltb. Attenuators
 1,                                     //Max. schaltb. PreAmps
 128,                                   //Mic-Gain
 128,                                   //Compr.-Level
 2,                                     //Roofing-Filter
 //REMOTE----------
 "145.350,000",                         //F act.
 ".025,000",".600,000",                 //F-Step, F-Offset
 2,0,                                   //Modeindex, FilterIndex
 //SCAN------------
 "145.000,000","145.975,000",           //F low/high
 ".025,000",                            //F-Step
 2,0,                                   //Modeindex, FilterIndex
 50,                                    //Step-Delay
 2,                                     //Mode Scanstop
 1000,100,                              //M2Del, M3Lev
 1,1,                                   //Write Spec, Longterm Spec
 //TX-SSB----------
 0,                                     //TX SSB-BW
 0,3,0,3,0,3,     
 //FILTERS---------
 {"","","",                             //HW-Filter  SSB  Normal,Narrow,Wide
  "","","",                             //           FM
  "","","",                             //           FMW
  "","","",                             //           AM
  "","","",                             //           CW
  "","",""},                            //           RTTY
 {"50" ,"3600" ,"2400" ,"1800","3000"  ,//SW-Filter  SSB BW-low,BW-high,Def-Normal(2),Def-Narrow(3),Def-Wide(1)
  "0"  ,"40"   ,"28"   ,"22"  ,"34"    ,//
  ""   ,""     ,"10000","7000","15000" ,//           FM
  ""   ,""     ,""     ,""    ,""      ,//
  "0"  ,""     ,""     ,""    ,"280000",//           FMW
  ""   ,""     ,""     ,""    ,""      ,//
  "200","10000","6000" ,"3000","9000"  ,//           AM
  "0"  ,"49"   ,"29"   ,"14"  ,"44"    ,//
  "50" ,"3600" ,"500"  ,"250" ,"1200"  ,//           CW
  "0"  ,"40"   ,"9"    ,"4"   ,"16"    ,//
  "50" ,"2700" ,"500"  ,"250" ,"2400"  ,//           RTTY
  "0"  ,"31"   ,"9"    ,"4"   ,"28"    }
},
//Radio 2****************************
{"IC-746 HF",
 //ICOM CI-V - Bus-
 "56",5,
 //COM-------------                     
 1,8,4,4,0,3,                     
 //Radio-basics----
 "145.350,000",
 ".030,000","174.000,000",
 "SMC_IC746.SMC",0,
 0,
 1,
 1,
 1,
 128,                                
 128,
 2,                                    
 //REMOTE----------
 "145.350,000",
 ".025,000",".600,000",
 2,0,
 //SCAN------------
 "","",
 ".001,000",
 4,0, 
 50,
 2,
 1000,100,
 1,1,
 //TX-SSB----------
 0,
 0,3,0,3,0,3,                 
 //FILTERS---------
 {"1","2","" , 
  "1","2","" , 
  "" ,"" ,"" , 
  "1","2","" ,
  "1","2","" ,
  "1","2","" },
 {"","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","",""}
},
//Radio 3****************************
{"IC-706MK2G HF-UHF",
 //ICOM CI-V - Bus-
 "58",5,
 //COM-------------                     
 1,8,4,4,0,3,                    
 //Radio-basics---- 
 "145.350,000",
 ".030,000","470.000,000",
 "SMC_IC706.SMC",0,
 0,
 0,
 1,
 1,
 128,                                
 128,
 2,                                    
 //REMOTE----------
 "145.350,000",
 ".025,000",".600,000",
 2,0,
 //SCAN------------
 "","",
 ".001,000",
 4,0, 
 50,
 2,
 1000,100,
 1,1,
 //TX-SSB----------
 0,
 0,3,0,3,0,3,            
 //FILTERS---------
 {"1","2","" , 
  "1","2","" , 
  "" ,"" ,"" , 
  "1","2","" ,
  "2","3","1", 
  "2","3","1"},
 {"","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","","",
  "","","","",""}                 
},
//Radio 4****************************
{"IC-7700 HF",				             
 //ICOM CI-V - Bus-
 "74",5,                             
 //COM-------------                  
 1,8,4,4,0,3,                        
 //Radio-basics----
 "10.000,000",                       
 ".030,000","54.000,000",            
 "SMC_IC7700.SMC",0,                
 1,                                
 4,                               
 4,                                
 3,                                 
 128,                               
 128,
 2,                                                                
 //REMOTE----------
 "10.000,000",                      
 ".025,000",".600,000",            
 2,0,                               
 //SCAN------------
 "145.000,000","145.975,000",       
 ".025,000",                       
 2,0,                               
 50,                               
 2,                                
 1000,100,                          
 1,1,                               
 //TX-SSB----------
 0,                                
 0,3,0,3,0,3,    
 //FILTERS---------
 {"","","",                          
  "","","",                         
  "","","",                          
  "","","",                         
  "","","",                          
  "","",""},                         
 {"50" ,"3600" ,"2400","1800","3000",
  "0"  ,"40"   ,"28"  ,"22"  ,"34"  ,
  ""   ,""     ,""    ,""    ,""    ,
  ""   ,""     ,""    ,""    ,""    ,
  ""   ,""     ,""    ,""    ,""    ,
  ""   ,""     ,""    ,""    ,""    ,
  "200","10000","6000","3000","9000",
  "0"  ,"49"   ,"29"  ,"14"  ,"44"  ,
  "50" ,"3600" ,"500" ,"250" ,"1200",
  "0"  ,"40"   ,"9"   ,"4"   ,"16"  ,
  "50" ,"2700" ,"500" ,"250" ,"2400",
  "0"  ,"31"   ,"9"   ,"4"   ,"28"  }
}
};
//IBModes++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IBModes MODES=
{
{0       ,1       ,2       ,3       ,4       ,5       ,6       ,7       ,8       ,9       ,10      ,11      },
{"LSB   ","USB   ","AM    ","CW    ","RTTY  ","FM    ","FMW   ","CW-R  ","RTTY-R","PSK   ","PSK-R ","SKIP  "},
{0x00    ,0x01    ,0x02    ,0x03    ,0x04    ,0x05    ,0x06    ,0x07    ,0x08    ,0x12    ,0x13    ,0x30    }
};

int IBModes::MnFromIBcmd(int IBcmd)
{
 if (IBcmd == 0x12) IBcmd= 9;
 if (IBcmd == 0x13) IBcmd=10;
 if (IBcmd == 0x30) IBcmd=11;
 
 return m_n[IBcmd];
}

int IBModes::IBcmdFromMn(int moind)
{
 return ibcmd[moind];
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
