// R_DLG.CPP : Radio-Dlgs
// G. TAMM, DF9ZO 2007
//--------------------
#include "stdafx.h"
#include "R_DLG.H"
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MODE_Dlg *modedlg=0;
CW_Dlg   *cwdlg  =0;
//IBRAD_Dlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IBRAD_Dlg::IBRAD_Dlg(CWnd* pParent /*=NULL*/)
	       : CDialog(IBRAD_Dlg::IDD, pParent)
             
{
	//{{AFX_DATA_INIT(IBRAD_Dlg)
	m_icdata     = 0;
	m_filter     = 0;
   m_sql        = 0;
	m_name       = _T("");
	m_icadr      = _T("");
	m_smconv     = _T("");
	m_minf       = _T("");
	m_maxf       = _T("");
	m_deff       = _T("");
   m_ant        = _T("");
   m_att        = _T("");
   m_pamp       = _T("");
	m_ssb_hw_no  = _T("");
	m_ssb_hw_na  = _T("");
	m_ssb_hw_wi  = _T("");
	m_fm_hw_no   = _T("");
	m_fm_hw_na   = _T("");
	m_fm_hw_wi   = _T("");
	m_fmw_hw_no  = _T("");
	m_fmw_hw_na  = _T("");
	m_fmw_hw_wi  = _T("");
	m_am_hw_no   = _T("");
	m_am_hw_na   = _T("");
	m_am_hw_wi   = _T("");
	m_cw_hw_no   = _T("");
	m_cw_hw_na   = _T("");
	m_cw_hw_wi   = _T("");
	m_rtty_hw_no = _T("");
	m_rtty_hw_na = _T("");
	m_rtty_hw_wi = _T("");
	//}}AFX_DATA_INIT
}

void IBRAD_Dlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(IBRAD_Dlg)
    DDX_Radio(pDX, IDC_RADIO_IB_DLG_BU0_ICDATA, m_icdata);
    DDX_Radio(pDX, IDC_RADIO_IB_DLG_BU0_FI,     m_filter);
    DDX_Radio(pDX, IDC_RADIO_IB_DLG_RB0_SQL,    m_sql);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_NAME,    m_name);
    DDV_MaxChars(pDX, m_name, 49);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_ICADR,   m_icadr);
    DDV_MaxChars(pDX, m_icadr, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_SMC,     m_smconv);
    DDV_MaxChars(pDX, m_smconv, 19);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_MINF,    m_minf);
    DDV_MaxChars(pDX, m_minf, 12);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_MAXF,    m_maxf);
    DDV_MaxChars(pDX, m_maxf, 12);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_DEFF,    m_deff);
    DDV_MaxChars(pDX, m_deff, 12);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_ANT,     m_ant);
	 DDV_MaxChars(pDX, m_ant, 1);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_ATT,     m_att);
	 DDV_MaxChars(pDX, m_att, 1);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED_PAMP,    m_pamp);
	 DDV_MaxChars(pDX, m_pamp, 1);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED01_HW,    m_ssb_hw_no);
    DDV_MaxChars(pDX, m_ssb_hw_no, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED02_HW,    m_ssb_hw_na);
    DDV_MaxChars(pDX, m_ssb_hw_na, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED03_HW,    m_ssb_hw_wi);
    DDV_MaxChars(pDX, m_ssb_hw_wi, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED04_HW,    m_fm_hw_no);
    DDV_MaxChars(pDX, m_fm_hw_no, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED05_HW,    m_fm_hw_na);
    DDV_MaxChars(pDX, m_fm_hw_na, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED06_HW,    m_fm_hw_wi);
    DDV_MaxChars(pDX, m_fm_hw_wi, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED07_HW,    m_fmw_hw_no);
    DDV_MaxChars(pDX, m_fmw_hw_no, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED08_HW,    m_fmw_hw_na);
    DDV_MaxChars(pDX, m_fmw_hw_na, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED09_HW,    m_fmw_hw_wi);
    DDV_MaxChars(pDX, m_fmw_hw_wi, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED10_HW,    m_am_hw_no);
    DDV_MaxChars(pDX, m_am_hw_no, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED11_HW,    m_am_hw_na);
    DDV_MaxChars(pDX, m_am_hw_na, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED12_HW,    m_am_hw_wi);
    DDV_MaxChars(pDX, m_am_hw_wi, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED13_HW,    m_cw_hw_no);
    DDV_MaxChars(pDX, m_cw_hw_no, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED14_HW,    m_cw_hw_na);
    DDV_MaxChars(pDX, m_cw_hw_na, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED15_HW,    m_cw_hw_wi);
    DDV_MaxChars(pDX, m_cw_hw_wi, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED16_HW,    m_rtty_hw_no);
    DDV_MaxChars(pDX, m_rtty_hw_no, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED17_HW,    m_rtty_hw_na);
    DDV_MaxChars(pDX, m_rtty_hw_na, 2);
    DDX_Text(pDX,  IDC_RADIO_IB_DLG_ED18_HW,    m_rtty_hw_wi);
    DDV_MaxChars(pDX, m_rtty_hw_wi, 2);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(IBRAD_Dlg, CDialog)
	//{{AFX_MSG_MAP(IBRAD_Dlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL IBRAD_Dlg::OnInitDialog() 
{
 CComboBox* pCB;
 CString    str("",50);
 char       tmpstr[10];
 int        x;

 CDialog::OnInitDialog();
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 _itoa(Radio_Num+1,tmpstr,10);
 str="RADIO (ICOM CI-V) - Settings   (RADIO ";str+=tmpstr;str+=")";
 SetWindowText(str);

 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMPORT);
 for (x=0;x<20;x++) {pCB->AddString(COMX_s[x]);}
 pCB->SetCurSel(RADIOS[Radio_Num].COMport);
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMBAUD);
 for (x=0;x<12;x++) {pCB->AddString(BAUD_s[x]);}
 pCB->SetCurSel(RADIOS[Radio_Num].COMbaud);
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMDATA);
 for (x=0;x<5;x++)  {pCB->AddString(DATA_s[x]);}
 pCB->SetCurSel(RADIOS[Radio_Num].COMdata);
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMSTOP);
 for (x=0;x<3;x++)  {pCB->AddString(STOP_s[x]);}
 pCB->SetCurSel(RADIOS[Radio_Num].COMstop); 
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMPARI);
 for (x=0;x<5;x++)  {pCB->AddString(PARI_s[x]);}
 pCB->SetCurSel(RADIOS[Radio_Num].COMpari);
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMPROT);
 for (x=0;x<4;x++)  {pCB->AddString(PROT_s[x]);}
 pCB->SetCurSel(RADIOS[Radio_Num].COMprot);

 GetDlgItem(IDOK)->SetFocus();
 return FALSE;// return TRUE unless you set the focus to a control 
}

void IBRAD_Dlg::OnOK() 
{
 CComboBox* pCB;

 if (!UpdateData(TRUE)) return;

 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMPORT);
 RADIOS[Radio_Num].COMport=pCB->GetCurSel();
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMBAUD);
 RADIOS[Radio_Num].COMbaud=pCB->GetCurSel();	
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMDATA);
 RADIOS[Radio_Num].COMdata=pCB->GetCurSel();
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMSTOP);
 RADIOS[Radio_Num].COMstop=pCB->GetCurSel();
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMPARI);
 RADIOS[Radio_Num].COMpari=pCB->GetCurSel(); 
 pCB=(CComboBox*) GetDlgItem(IDC_RADIO_IB_DLG_CB_COMPROT);
 RADIOS[Radio_Num].COMprot=pCB->GetCurSel();

 CDialog::OnOK();
}
//-----------------------------------------------------------------------------
void IBRAD_Dlg::TransferToDlg(int radio)
{
 int  adr;
 char str[50];

 m_name  =RADIOS[radio].Name; 
 m_minf  =RADIOS[radio].Fmin_s;
 m_maxf  =RADIOS[radio].Fmax_s;
 m_deff  =RADIOS[radio].Fdef_s;
 m_smconv=RADIOS[radio].SmConv_s;
 m_sql   =RADIOS[radio].SQL_SwHw;        
 m_filter=RADIOS[radio].FI_SwHw;        
 _itoa(RADIOS[radio].ANTmax ,str,10);m_ant =str;
 adr=IB_HexStrToInt(RADIOS[radio].IB_Adr_s);
 _itoa(RADIOS[radio].ATTmax,str,10);m_att =str;
 _itoa(RADIOS[radio].PAMPmax,str,10);m_pamp=str;
 //---------------------------
 m_icadr =RADIOS[radio].IB_Adr_s;
 if (RADIOS[radio].IB_Da_n   == 4) m_icdata=0;else m_icdata=1;
 //---------------------------
 m_ssb_hw_no =RADIOS[radio].IB_FI_HW_s[ 0];
 m_ssb_hw_na =RADIOS[radio].IB_FI_HW_s[ 1];
 m_ssb_hw_wi =RADIOS[radio].IB_FI_HW_s[ 2];
 m_fm_hw_no  =RADIOS[radio].IB_FI_HW_s[ 3];
 m_fm_hw_na  =RADIOS[radio].IB_FI_HW_s[ 4];
 m_fm_hw_wi  =RADIOS[radio].IB_FI_HW_s[ 5];
 m_fmw_hw_no =RADIOS[radio].IB_FI_HW_s[ 6];
 m_fmw_hw_na =RADIOS[radio].IB_FI_HW_s[ 7];
 m_fmw_hw_wi =RADIOS[radio].IB_FI_HW_s[ 8];
 m_am_hw_no  =RADIOS[radio].IB_FI_HW_s[ 9];
 m_am_hw_na  =RADIOS[radio].IB_FI_HW_s[10];
 m_am_hw_wi  =RADIOS[radio].IB_FI_HW_s[11];
 m_cw_hw_no  =RADIOS[radio].IB_FI_HW_s[12];
 m_cw_hw_na  =RADIOS[radio].IB_FI_HW_s[13];
 m_cw_hw_wi  =RADIOS[radio].IB_FI_HW_s[14];
 m_rtty_hw_no=RADIOS[radio].IB_FI_HW_s[15];
 m_rtty_hw_na=RADIOS[radio].IB_FI_HW_s[16];
 m_rtty_hw_wi=RADIOS[radio].IB_FI_HW_s[17];
}

void IBRAD_Dlg::TransferFrDlg(int radio)
{
 strcpy(RADIOS[radio].Name,LPCTSTR(m_name));
 strcpy(RADIOS[radio].Fmin_s,LPCTSTR(m_minf));
 strcpy(RADIOS[radio].Fmax_s,LPCTSTR(m_maxf));
 strcpy(RADIOS[radio].Fdef_s,LPCTSTR(m_deff)); 
 strcpy(RADIOS[radio].SmConv_s,LPCTSTR(m_smconv));
 RADIOS[radio].SQL_SwHw=m_sql;      //if (m_sql    == 0) RADIOS[radio].SQL_SwHw =0;else RADIOS[radio].SQL_SwHw =1;
 RADIOS[radio].FI_SwHw =m_filter;   //if (m_filter == 0) RADIOS[radio].FI_SwHw=1;else RADIOS[radio].FI_SwHw=0;
 RADIOS[radio].ANTmax  =CStrToInt(m_ant);
 RADIOS[radio].ATTmax  =CStrToInt(m_att);
 RADIOS[radio].PAMPmax =CStrToInt(m_pamp);
 //------------------------------------------
 strcpy(RADIOS[radio].IB_Adr_s,LPCTSTR(m_icadr));
 if (m_icdata == 0) RADIOS[radio].IB_Da_n  =4;else RADIOS[radio].IB_Da_n  =5;
 //------------------------------------------
 strcpy(RADIOS[radio].IB_FI_HW_s[ 0],LPCTSTR(m_ssb_hw_no));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 1],LPCTSTR(m_ssb_hw_na));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 2],LPCTSTR(m_ssb_hw_wi));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 3],LPCTSTR(m_fm_hw_no ));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 4],LPCTSTR(m_fm_hw_na ));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 5],LPCTSTR(m_fm_hw_wi ));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 6],LPCTSTR(m_fmw_hw_no));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 7],LPCTSTR(m_fmw_hw_na));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 8],LPCTSTR(m_fmw_hw_wi));
 strcpy(RADIOS[radio].IB_FI_HW_s[ 9],LPCTSTR(m_am_hw_no ));
 strcpy(RADIOS[radio].IB_FI_HW_s[10],LPCTSTR(m_am_hw_na ));
 strcpy(RADIOS[radio].IB_FI_HW_s[11],LPCTSTR(m_am_hw_wi ));
 strcpy(RADIOS[radio].IB_FI_HW_s[12],LPCTSTR(m_cw_hw_no ));
 strcpy(RADIOS[radio].IB_FI_HW_s[13],LPCTSTR(m_cw_hw_na ));
 strcpy(RADIOS[radio].IB_FI_HW_s[14],LPCTSTR(m_cw_hw_wi ));
 strcpy(RADIOS[radio].IB_FI_HW_s[15],LPCTSTR(m_rtty_hw_no ));
 strcpy(RADIOS[radio].IB_FI_HW_s[16],LPCTSTR(m_rtty_hw_na ));
 strcpy(RADIOS[radio].IB_FI_HW_s[17],LPCTSTR(m_rtty_hw_wi ));
}
//FSET_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(FSET_Dlg, CDialog)

FSET_Dlg::FSET_Dlg(CWnd* pParent /*=NULL*/)
	      : CDialog(FSET_Dlg::IDD, pParent)         
         , m_f(_T(""))
{
}

FSET_Dlg::~FSET_Dlg()
{
}

void FSET_Dlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   DDX_CBString(pDX, IDC_FSET_CB01, m_f);
   DDV_MaxChars(pDX, m_f, 50);//s. COM::RadioComplete_Get
   DDX_Control(pDX, IDC_FSET_CB01, cb);
}

BEGIN_MESSAGE_MAP(FSET_Dlg, CDialog)   
   ON_BN_CLICKED(IDC_FSET_CLRMP,  &FSET_Dlg::OnClrMP)
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL FSET_Dlg::OnInitDialog()
{
 CString cstr;
 char    str[100];
 int     x,limax;

 CDialog::OnInitDialog();

 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 limax=CoBoStrLi.size();
 for (x=1;x < limax+1;x++)
  {
   List_GetElemAt(CoBoStrLi,cstr,x);
   strcpy(str,(LPCTSTR)cstr);
   cb.AddString(str);
  }
 cb.LimitText(12);
 cb.SetFocus();

 return TRUE;// return TRUE unless you set the focus to a control
             // EXCEPTION: OCX Property Pages should return FALSE
}
//-----------------------------------------------------------------------------
void FSET_Dlg::OnOK()
{
 //Add your specialized code here
 CDialog::OnOK();
}
//-----------------------------------------------------------------------------
void FSET_Dlg::OnClrMP()
{
 List_RemAllElem(CoBoStrLi);
 cb.ResetContent();
}
//FSTEP_Dlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(FSTEP_Dlg, CDialog)
FSTEP_Dlg::FSTEP_Dlg(CWnd* pParent /*=NULL*/)
	       : CDialog(FSTEP_Dlg::IDD, pParent)
          , m_cb0_str   (_T("Radio F-STEP"))            
          , m_cb1_str   (_T("SW F-STEP"))    
          , m_cb2_str   (_T("SW F-OFFS"))
          , m_cbssb_str (_T(""))
          , m_cbam_str  (_T(""))
          , m_cbfm_str  (_T(""))
          , m_cbfmw_str (_T(""))
          , m_cbdata_str(_T("")) 
{
}

FSTEP_Dlg::~FSTEP_Dlg()
{
}

void FSTEP_Dlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   DDX_CBString(pDX, IDD_FSTEP_CB0,     m_cb0_str);
   DDV_MaxChars(pDX, m_cb0_str, 12);
   DDX_CBString(pDX, IDD_FSTEP_CB1,     m_cb1_str);
   DDV_MaxChars(pDX, m_cb1_str, 12);
   DDX_CBString(pDX, IDD_FSTEP_CB2,     m_cb2_str);
   DDV_MaxChars(pDX, m_cb2_str, 12);
   DDX_CBString(pDX, IDD_FSTEP_CB_SSB,  m_cbssb_str);
   DDV_MaxChars(pDX, m_cbssb_str, 12);
   DDX_CBString(pDX, IDD_FSTEP_CB_AM,   m_cbam_str);
   DDV_MaxChars(pDX, m_cbam_str, 12);
   DDX_CBString(pDX, IDD_FSTEP_CB_FM,   m_cbfm_str);
   DDV_MaxChars(pDX, m_cbfm_str, 12);
   DDX_CBString(pDX, IDD_FSTEP_CB_FMW,  m_cbfmw_str);
   DDV_MaxChars(pDX, m_cbfmw_str, 12);
   DDX_CBString(pDX, IDD_FSTEP_CB_DATA, m_cbdata_str);
   DDV_MaxChars(pDX, m_cbdata_str, 12);   
}
BEGIN_MESSAGE_MAP(FSTEP_Dlg, CDialog)
   ON_BN_CLICKED(IDOK, &FSTEP_Dlg::OnOK)
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL FSTEP_Dlg::OnInitDialog()
{
 CDialog::OnInitDialog();

 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 GetDlgItem(IDOK)->SetFocus();
 return FALSE;// return TRUE unless you set the focus to a control
}

void FSTEP_Dlg::OnOK()
{
 CComboBox* pCB;
 int        fstep;

 if (!UpdateData(TRUE)) return;
 //ComboBox0------------------F-Step HW (Radio)
 pCB=(CComboBox*) GetDlgItem(IDD_FSTEP_CB0);
 SF_HW_act_n=pCB->GetCurSel();
 fstep=SF_HW_act_n;if (fstep == 10) fstep=0x10;
 comport.FSTEP_HW_Set(fstep);

 CDialog::OnOK();//OnOK();
}
//-----------------------------------------------------------------------------
void FSTEP_Dlg::TransferToDlg()
{
 char actstr[RStrLf];

 strcpy(actstr,SF_HW_s[SF_HW_act_n])         ;m_cb0_str=actstr;
 strcpy(actstr,SFact_s)  ;StrTrLe(actstr,' ');m_cb1_str=actstr;
 strcpy(actstr,OFact_s)  ;StrTrLe(actstr,' ');m_cb2_str=actstr;

 strcpy(actstr,SF_SSB_s) ;StrTrLe(actstr,' ');m_cbssb_str=actstr;
 strcpy(actstr,SF_AM_s)  ;StrTrLe(actstr,' ');m_cbam_str=actstr;
 strcpy(actstr,SF_FM_s)  ;StrTrLe(actstr,' ');m_cbfm_str=actstr;
 strcpy(actstr,SF_FMW_s) ;StrTrLe(actstr,' ');m_cbfmw_str=actstr;
 strcpy(actstr,SF_DATA_s);StrTrLe(actstr,' ');m_cbdata_str=actstr; 
}

void FSTEP_Dlg::TransferFrDlg()
{
 if (m_cb1_str != "")
  {
   strcpy(SFact_s,LPCTSTR(m_cb1_str));
   ModFstr(SFact_s,SFdef_s);SFact_n=FstrToFnum(SFact_s);
  }
 if (m_cb2_str != "")
  {
   strcpy(OFact_s,LPCTSTR(m_cb2_str));
   ModFstr(OFact_s,OFdef_s);OFact_n=FstrToFnum(OFact_s);
  }

 if (m_cbssb_str != "")
  {
   strcpy(SF_SSB_s,LPCTSTR(m_cbssb_str));
   ModFstr(SF_SSB_s,SFdef_s);SF_SSB_n=FstrToFnum(SF_SSB_s);
  }
 if (m_cbfm_str != "")
  {
   strcpy(SF_FM_s,LPCTSTR(m_cbfm_str));
   ModFstr(SF_FM_s,SFdef_s);SF_FM_n=FstrToFnum(SF_FM_s);
  }
 if (m_cbfmw_str != "")
  {
   strcpy(SF_FMW_s,LPCTSTR(m_cbfmw_str));
   ModFstr(SF_FMW_s,SFdef_s);SF_FMW_n=FstrToFnum(SF_FMW_s);
  }
 if (m_cbam_str != "")
  {
   strcpy(SF_AM_s,LPCTSTR(m_cbam_str));
   ModFstr(SF_AM_s,SFdef_s);SF_AM_n=FstrToFnum(SF_AM_s);
  }
 if (m_cbdata_str != "")
  {
   strcpy(SF_DATA_s,LPCTSTR(m_cbdata_str));
   ModFstr(SF_DATA_s,SFdef_s);SF_DATA_n=FstrToFnum(SF_DATA_s);
  }
}
//MODE_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(MODE_Dlg, CDialog)

MODE_Dlg::MODE_Dlg(CWnd* pParent /*=NULL*/)
	      : CDialog(MODE_Dlg::IDD, pParent)
{
}

MODE_Dlg::~MODE_Dlg()
{
}

BEGIN_MESSAGE_MAP(MODE_Dlg, CDialog)
   ON_MESSAGE(WM_MODEDLG_MOFICHANGE,MSG_MoFiChange)
   
   ON_COMMAND(IDC_MODE_BU_LSB,      On_Mode)
   ON_COMMAND(IDC_MODE_BU_USB,      On_Mode)
   ON_COMMAND(IDC_MODE_BU_AM ,      On_Mode)
   ON_COMMAND(IDC_MODE_BU_CW,       On_Mode)
   ON_COMMAND(IDC_MODE_BU_RTTY,     On_Mode)
   ON_COMMAND(IDC_MODE_BU_FM,       On_Mode)
   ON_COMMAND(IDC_MODE_BU_FMW,      On_Mode)
   ON_COMMAND(IDC_MODE_BU_CWR,      On_Mode)
   ON_COMMAND(IDC_MODE_BU_RTTYR,    On_Mode)
   ON_COMMAND(IDC_MODE_BU_PSK,      On_Mode)
   ON_COMMAND(IDC_MODE_BU_PSKR,     On_Mode)
   ON_COMMAND(IDC_MODE_BU_NORMAL,   On_Filter)
   ON_COMMAND(IDC_MODE_BU_NARROW,   On_Filter)
   ON_COMMAND(IDC_MODE_BU_WIDE,     On_Filter)
   ON_COMMAND(IDC_MODE_BU_DSP,      On_DSP_Sharp_Soft)
   ON_BN_CLICKED(IDC_MODE_BU_BWDEF, OnBWdef)   
   ON_WM_HSCROLL()
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL MODE_Dlg::OnInitDialog()
{
 CDialog::OnInitDialog();

 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 SetSWFilter();
 PtrToModeDlg=this;

 SetWinText();

 return TRUE;// return TRUE unless you set the focus to a control
}
//-----------------------------------------------------------------------------
void MODE_Dlg::PostNcDestroy()
{
 delete this;modedlg=0;PtrToModeDlg=NULL;
}

void MODE_Dlg::OnOK()
{
 DestroyWindow();
}
//-----------------------------------------------------------------------------
void MODE_Dlg::On_Mode()
{
 int res;

 res=GetCurrentMessage()->wParam;    
 switch (res)//see IBModes MODES
  {
   case IDC_MODE_BU_LSB  :Mact_n= 0;break;
   case IDC_MODE_BU_USB  :Mact_n= 1;break;
   case IDC_MODE_BU_AM   :Mact_n= 2;break;
   case IDC_MODE_BU_CW   :Mact_n= 3;break;
   case IDC_MODE_BU_RTTY :Mact_n= 4;break;
   case IDC_MODE_BU_FM   :Mact_n= 5;break;
   case IDC_MODE_BU_FMW  :Mact_n= 6;break;
   case IDC_MODE_BU_CWR  :Mact_n= 7;break;
   case IDC_MODE_BU_RTTYR:Mact_n= 8;break;
   case IDC_MODE_BU_PSK  :Mact_n= 9;break;
   case IDC_MODE_BU_PSKR :Mact_n=10;break; 
  }
 strcpy(Mact_s,Marr_s[Mact_n]);

 if (IBRad_Adr_n == 0x70 && Mact_n == 6)//IC-7000, FMW 
  {
   FIact_n=2;strcpy(FIact_s,FIarr_s[FIact_n]);
  }

 res=comport.M_Set(Mact_n,FIact_n);
 if (res && remdisp != NULL) remdisp->UpdateStatusDisp(1,0,0,0);

 IB_FISWFromTable(Radio_Num);SetSWFilter();
 SetWinText(); 
}

void MODE_Dlg::On_Filter()
{
 int res;

 res=GetCurrentMessage()->wParam;
 if (res == IDC_MODE_BU_NORMAL) FIact_n=0;//Normal DSP 2
 if (res == IDC_MODE_BU_NARROW) FIact_n=1;//Narrow DSP 3   
 if (res == IDC_MODE_BU_WIDE  ) FIact_n=2;//Wide   DSP 1 
 strcpy(FIact_s,FIarr_s[FIact_n]);

 res=comport.M_Set(Mact_n,FIact_n);
 if (res && remdisp != NULL) remdisp->UpdateStatusDisp(1,0,0,0);

 IB_FISWFromTable(Radio_Num);SetSWFilter();
 SetWinText(); 
}

void MODE_Dlg::On_DSP_Sharp_Soft()  
{
 FI_SW_Shape++;if (FI_SW_Shape > 1) FI_SW_Shape=0;
 comport.FI_SWshape_Set(FI_SW_Shape);
}

void MODE_Dlg::SetSWFilter()
{
 char str[40],str_tmp[20];
 int  BW=0;
 
 IB_FISWFromTable(Radio_Num);
 FI_SW_BW_lev=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_MODE_SCR_BW);
 pSB->SetScrollRange(0,FI_SW_Fmax_lev);
 comport.FI_SWbw_Ask();
 _itoa(FI_SW_BW_lev,str,16);FI_SW_BW_lev=strtol(str,0,10);
 pSB->SetScrollPos(FI_SW_BW_lev);

 strcpy(str,"BW [Hz]: ");
 BW=IB_FISWlevToBW(FI_SW_BW_lev);

 pST=(CStatic*) GetDlgItem(IDC_MODE_ST_LO);
 _itoa(FI_SW_Fmin,str_tmp,10);pST->SetWindowText(str_tmp);
 pST=(CStatic*) GetDlgItem(IDC_MODE_ST_HI);
 _itoa(FI_SW_Fmax,str_tmp,10);pST->SetWindowText(str_tmp);
 pST=(CStatic*) GetDlgItem(IDC_MODE_ST_ACT);
 _itoa(BW,str_tmp,10);strcat(str,str_tmp);pST->SetWindowText(str); 
}

void MODE_Dlg::SetWinText()
{
 char str[50],str_tmp[10];

 comport.M_Ask();
 pGB=(CStatic*) GetDlgItem(IDC_MODE_GB_MODE);
 strcpy(str,"Mode: ");strcat(str,Mact_s);pGB->SetWindowText(str);
 pGB=(CStatic*) GetDlgItem(IDC_MODE_GB_FILTER);
 strcpy(str,"Filter: ");strcpy(str_tmp,FIarr_s[FIact_n+3]);
 strcat(str,str_tmp);pGB->SetWindowText(str);
}

LRESULT MODE_Dlg::MSG_MoFiChange(WPARAM wParam,LPARAM lParam)
{
 SetWinText();
 SetSWFilter();
 return 0L;
}
//-----------------------------------------------------------------------------
void MODE_Dlg::OnBWdef()
{
 pSB=(CScrollBar*) GetDlgItem(IDC_MODE_SCR_BW);
 if (FIact_n == 0) FI_SW_BW_lev=FI_SW_BW2def_lev;//Normal
 if (FIact_n == 1) FI_SW_BW_lev=FI_SW_BW3def_lev;//Narrow
 if (FIact_n == 2) FI_SW_BW_lev=FI_SW_BW1def_lev;//Wide
 pSB->SetScrollPos(FI_SW_BW_lev);
 comport.FI_SWbwlev_Set(FI_SW_BW_lev);

 SetSWFilter();
}

void MODE_Dlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
 int scr=0,pos=0,posmax;

 pSB=(CScrollBar*) GetDlgItem(IDC_MODE_SCR_BW);
 pos=pScrollBar->GetScrollPos();

 IB_FISWFromTable(Radio_Num);posmax=FI_SW_Fmax_lev;
             
 switch (nSBCode) 
  {
   case SB_LINELEFT     :pos--;  if (pos <      0) pos=0     ;break;//<-
   case SB_LINERIGHT    :pos++;  if (pos > posmax) pos=posmax;break;//->
   case SB_LEFT         :pos=0;break;                               //Pos1
   case SB_RIGHT        :pos=posmax;break;                          //End   
   case SB_THUMBPOSITION: 
   case SB_THUMBTRACK   :pos=nPos;break;
  }
   
 FI_SW_BW_lev=pos;pSB->SetScrollPos(FI_SW_BW_lev);
 comport.FI_SWbwlev_Set(FI_SW_BW_lev);
 SetSWFilter();        
 	
 CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
//RTTY_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(RTTY_Dlg, CDialog)
RTTY_Dlg::RTTY_Dlg(CWnd* pParent /*=NULL*/)
	     :CDialog(RTTY_Dlg::IDD, pParent)
         , m_MF(0)
         , m_SH(0)
         , m_KP(0)
         , m_RXDEC(0)
         , m_TPF(0)
{
}

RTTY_Dlg::~RTTY_Dlg()
{
}

void RTTY_Dlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);

    DDX_Radio(pDX, IDC_RTTY_MF_RB0,    m_MF);
    DDX_Radio(pDX, IDC_RTTY_SH_RB0,    m_SH);
    DDX_Radio(pDX, IDC_RTTY_KP_RB0,    m_KP);
    DDX_Radio(pDX, IDC_RTTY_RXDEC_RB0, m_RXDEC);
    DDX_Radio(pDX, IDC_RTTY_TPF_RB0,   m_TPF);
}

BEGIN_MESSAGE_MAP(RTTY_Dlg, CDialog)
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL RTTY_Dlg::OnInitDialog()
{
 CDialog::OnInitDialog();

 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 GetDlgItem(IDOK)->SetFocus();
 return FALSE;// return TRUE unless you set the focus to a control
}
//STOPMODE_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STOPMODE_Dlg::STOPMODE_Dlg(CWnd* pParent /*=NULL*/)
	         : CDialog(STOPMODE_Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(STOPMODE_Dlg)
	m_mo = -1;
	m_ed00 = _T("");
	m_ed01 = _T("");
	//}}AFX_DATA_INIT
}

void STOPMODE_Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(STOPMODE_Dlg)
	DDX_Radio(pDX, IDC_STOPMODE_BU00, m_mo);
	DDX_Text(pDX, IDC_STOPMODE_ED00,  m_ed00);
	DDV_MaxChars(pDX, m_ed00, 5);
	DDX_Text(pDX, IDC_STOPMODE_ED01,  m_ed01);
	DDV_MaxChars(pDX, m_ed01, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(STOPMODE_Dlg, CDialog)
	//{{AFX_MSG_MAP(STOPMODE_Dlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL STOPMODE_Dlg::OnInitDialog() 
{
 CDialog::OnInitDialog();
 GetDlgItem(IDOK)->SetFocus();
 return FALSE;// return TRUE unless you set the focus to a control
}

void STOPMODE_Dlg::OnOK() 
{
 if (!UpdateData(TRUE)) return;
	
 CDialog::OnOK();
}
//GENOPTIONS_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(GENOPTIONS_Dlg, CDialog)
GENOPTIONS_Dlg::GENOPTIONS_Dlg(CWnd* pParent /*=NULL*/)
	            : CDialog(GENOPTIONS_Dlg::IDD, pParent)
                 , m_sm_sel(0)
                 , m_sqlsm_mode(0)
                 , m_cmd_conf(0)
                 , m_com_poll_mode(FALSE)
                 , m_sqlsm_poll_iv(_T("40"))
                 , m_com_poll_iv(_T("40"))
                 , m_cmd_del(_T("5"))
{
}

GENOPTIONS_Dlg::~GENOPTIONS_Dlg()
{
}

void GENOPTIONS_Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
   DDX_Radio   (pDX, IDC_GENOPTIONS_RB1, m_sm_sel);
   DDX_Radio   (pDX, IDC_GENOPTIONS_RB3, m_sqlsm_mode);
   DDX_Check   (pDX, IDC_GENOPTIONS_CB1, m_cmd_conf);
   DDX_Radio   (pDX, IDC_GENOPTIONS_RB5, m_com_poll_mode);
   DDX_Text    (pDX, IDC_GENOPTIONS_ED1, m_sqlsm_poll_iv);
   DDV_MaxChars(pDX, m_sqlsm_poll_iv, 4);
   DDX_Text    (pDX, IDC_GENOPTIONS_ED2, m_com_poll_iv);
	DDV_MaxChars(pDX, m_com_poll_iv, 4);
   DDX_Text    (pDX, IDC_GENOPTIONS_ED3, m_cmd_del);
	DDV_MaxChars(pDX, m_cmd_del, 4);
}

BEGIN_MESSAGE_MAP(GENOPTIONS_Dlg, CDialog)
END_MESSAGE_MAP()
//TUNE_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(TUNE_Dlg, CDialog)
TUNE_Dlg::TUNE_Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(TUNE_Dlg::IDD, pParent)
    , m_vfoa    (_T(""))
    , m_vfobplus(_T(""))
    , m_txpwr   (_T(""))
{
}

TUNE_Dlg::~TUNE_Dlg()
{
}

void TUNE_Dlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_TUNE_ED_VFOA,     m_vfoa);
    DDV_MaxChars(pDX, m_vfoa, 12);
    DDX_Text(pDX, IDC_TUNE_ED_VFOBPLUS, m_vfobplus);
    DDV_MaxChars(pDX, m_vfobplus, 2);
    DDX_Text(pDX, IDC_TUNE_ED_TXPWR,    m_txpwr);
	DDV_MaxChars(pDX, m_txpwr, 3);
}
BEGIN_MESSAGE_MAP(TUNE_Dlg, CDialog)
END_MESSAGE_MAP()
//MIC_Dlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(MIC_Dlg, CDialog)
MIC_Dlg::MIC_Dlg(CWnd* pParent /*=NULL*/)
	    : CDialog(MIC_Dlg::IDD, pParent)
        , m_ssbbw(0)
        , m_wilo(0)
        , m_wihi(0)
        , m_milo(0)
        , m_mihi(0)
        , m_nalo(0)
        , m_nahi(0)
{
}

MIC_Dlg::~MIC_Dlg()
{
}

void MIC_Dlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Radio(pDX, IDC_MIC_RB_WIDE, m_ssbbw);
    DDX_Radio(pDX, IDC_MIC_RB_00,   m_wilo);
    DDX_Radio(pDX, IDC_MIC_RB_10,   m_wihi);
    DDX_Radio(pDX, IDC_MIC_RB_20,   m_milo);
    DDX_Radio(pDX, IDC_MIC_RB_30,   m_mihi);
    DDX_Radio(pDX, IDC_MIC_RB_40,   m_nalo);
    DDX_Radio(pDX, IDC_MIC_RB_50,   m_nahi);
}

BEGIN_MESSAGE_MAP(MIC_Dlg, CDialog)
    ON_BN_CLICKED(IDC_MIC_BU_MICGAINDEF, OnMICGAINDEF)
    ON_BN_CLICKED(IDC_MIC_BU_COMPLEVDEF, OnCOMPLEVDEF)
    ON_BN_CLICKED(IDC_MIC_BU_COMPONOFF,  OnCOMPONOFF)
    ON_WM_HSCROLL()
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL MIC_Dlg::OnInitDialog()
{
 char str[10]="0";

 CDialog::OnInitDialog();

 m_hAccel=NULL;
 m_hAccel=LoadAccelerators(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_MICACCEL));
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 MIClev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_MICGAIN);
 pSB->SetScrollRange(0,255);
 comport.MIClev_Ask();
 pSB->SetScrollPos(MIClev_n);
 pST=(CStatic*) GetDlgItem(IDC_MIC_ST_MICGAIN);
 pST->SetWindowText(_itoa(MIClev_n*100/255,str,10));

 COMPlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_COMPLEV);
 pSB->SetScrollRange(0,255);
 comport.COMPlev_Ask();
 pSB->SetScrollPos(COMPlev_n);
 pST=(CStatic*) GetDlgItem(IDC_MIC_ST_COMPLEV);
 pST->SetWindowText(_itoa(COMPlev_n*100/255,str,10));
 
 return TRUE;  // return TRUE unless you set the focus to a control
}
//-----------------------------------------------------------------------------
BOOL MIC_Dlg::PreTranslateMessage(MSG* pMsg)
{
 if(!(m_hAccel && ::TranslateAccelerator(m_hWnd, m_hAccel, pMsg)))
   return CDialog::PreTranslateMessage(pMsg);else return TRUE;
	
 return CDialog::PreTranslateMessage(pMsg);
}
//-----------------------------------------------------------------------------
void MIC_Dlg::OnOK()
{
 pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_MICGAIN);
 MIClev_n=pSB->GetScrollPos();RADIOS[Radio_Num].MICgain=MIClev_n;

 pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_COMPLEV);
 COMPlev_n=pSB->GetScrollPos();RADIOS[Radio_Num].COMPlev=COMPlev_n;

 CDialog::OnOK();
}
//-----------------------------------------------------------------------------
void MIC_Dlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
 char str[10]="0";
 int  scr=0,pos=0,posmax=255;

 if (nSBCode > 9) return;

 switch (pScrollBar->GetDlgCtrlID())
  {
   case IDC_MIC_SB_MICGAIN :scr=0;pos=pScrollBar->GetScrollPos();break;
   case IDC_MIC_SB_COMPLEV :scr=1;pos=pScrollBar->GetScrollPos();break;
  }

 switch (nSBCode) 
  {
   case SB_TOP           :pos=0;break;                               //Pos1
   case SB_BOTTOM        :pos=posmax;break;                          //End

   case SB_PAGEUP        :pos+=10;if (pos > posmax) pos=posmax;break;//Bild nach oben
   case SB_PAGEDOWN      :pos-=10;if (pos <      0) pos=0     ;break;//Bild nach unten
 
   case SB_LINERIGHT     :pos++;if (pos > posmax) pos=posmax;break;  //->
   case SB_LINELEFT      :pos--;if (pos <      0) pos=0     ;break;  //<-
   
   case SB_THUMBPOSITION : 
   case SB_THUMBTRACK    :pos=nPos;break;
  }

 switch (scr) 
  {     
   case 0 :pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_MICGAIN);
           MIClev_n=pos;pSB->SetScrollPos(MIClev_n);
           comport.MIClev_Set(MIClev_n);
           pST=(CStatic*) GetDlgItem(IDC_MIC_ST_MICGAIN);
           pST->SetWindowText(_itoa(MIClev_n*100/255,str,10));
           break;
   case 1 :pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_COMPLEV);
           COMPlev_n=pos;pSB->SetScrollPos(COMPlev_n);
           comport.COMPlev_Set(COMPlev_n);
           pST=(CStatic*) GetDlgItem(IDC_MIC_ST_COMPLEV);
           pST->SetWindowText(_itoa(COMPlev_n*100/255,str,10));
           break;
  }	
 CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
//-----------------------------------------------------------------------------
void MIC_Dlg::OnMICGAINDEF()
{
 char str[10]="0";

 pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_MICGAIN);
 MIClev_n=128;pSB->SetScrollPos(MIClev_n);
 comport.MIClev_Set(MIClev_n);
 pST=(CStatic*) GetDlgItem(IDC_MIC_ST_MICGAIN);
 pST->SetWindowText(_itoa(MIClev_n*100/255,str,10));
}

void MIC_Dlg::OnCOMPLEVDEF()
{
 char str[10]="0";

 pSB=(CScrollBar*) GetDlgItem(IDC_MIC_SB_COMPLEV);
 COMPlev_n=128;/*Default=5*/pSB->SetScrollPos(COMPlev_n);
 comport.COMPlev_Set(COMPlev_n);
 pST=(CStatic*) GetDlgItem(IDC_MIC_ST_COMPLEV);
 pST->SetWindowText(_itoa(COMPlev_n*100/255,str,10));
}

void MIC_Dlg::OnCOMPONOFF()
{
 COMPsw++;if (COMPsw > 1) COMPsw=0;
 comport.COMP_Switch(COMPsw);
}
//CW_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(CW_Dlg, CDialog)
CW_Dlg::CW_Dlg(CWnd* pParent /*=NULL*/)
	   : CDialog(CW_Dlg::IDD, pParent)
{
}

CW_Dlg::~CW_Dlg()
{
}

BEGIN_MESSAGE_MAP(CW_Dlg, CDialog)
    ON_WM_HSCROLL()
    ON_BN_CLICKED(IDC_CWDLG_BU_APF,         OnAPF)
    ON_BN_CLICKED(IDC_CWDLG_BU_KEYSTRAIGHT, OnKEYTYPE)
    ON_BN_CLICKED(IDC_CWDLG_BU_KEYBUG,      OnKEYTYPE)
    ON_BN_CLICKED(IDC_CWDLG_BU_KEYELEC,     OnKEYTYPE)      
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL CW_Dlg::PreTranslateMessage(MSG* pMsg)
{
 if(!(m_hAccel && ::TranslateAccelerator(m_hWnd, m_hAccel, pMsg)))
   return CDialog::PreTranslateMessage(pMsg);else return TRUE;
	
 return CDialog::PreTranslateMessage(pMsg);
}
//-----------------------------------------------------------------------------
void CW_Dlg::PostNcDestroy()
{
 delete this;cwdlg=0;
}

void CW_Dlg::OnOK()
{
 DestroyWindow();
}
//-----------------------------------------------------------------------------
BOOL CW_Dlg::OnInitDialog()
{
 char str[10]="0";

 CDialog::OnInitDialog();

 m_hAccel=NULL;
 //m_hAccel=LoadAccelerators(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_CWACCEL));
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 CWSPEED_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_CWDLG_SB_CWSPEED);
 pSB->SetScrollRange(0,255);
 comport.CWSPEED_Ask();
 pSB->SetScrollPos(CWSPEED_n);

 APFlev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_CWDLG_SB_APF);
 pSB->SetScrollRange(0,255);
 comport.APFlev_Ask();
 pSB->SetScrollPos(APFlev_n);
 
 return TRUE;  // return TRUE unless you set the focus to a control
}
//-----------------------------------------------------------------------------
void CW_Dlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
 int scr=0,pos=0,posmax;

 if (nSBCode > 9) return;

 switch (pScrollBar->GetDlgCtrlID())
  {
   case IDC_CWDLG_SB_CWSPEED:scr=0 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_CWDLG_SB_APF    :scr=1 ;pos=pScrollBar->GetScrollPos();break;
  }

 if (scr >= 0 && scr < 2) posmax=255;
 //if (scr == 9) {IB_FI_SW(Radio_Num);posmax=FI_SW_Fmax_lev;}             
 switch (nSBCode) 
  {
   case SB_PAGEUP       :pos+=10;if (pos > posmax) pos=posmax;break;//Bild nach oben
   case SB_PAGEDOWN     :pos-=10;if (pos <      0) pos=0     ;break;//Bild nach unten
        
   case SB_LINELEFT     :pos--;  if (pos <      0) pos=0     ;break;//<-
   case SB_LINERIGHT    :pos++;  if (pos > posmax) pos=posmax;break;//->
   case SB_LEFT         :pos=0;break;                               //Pos1
   case SB_RIGHT        :pos=posmax;break;                          //End   
   case SB_THUMBPOSITION: 
   case SB_THUMBTRACK   :pos=nPos;break;
  }
   
 switch (scr) 
  {
   case 0 :pSB=(CScrollBar*) GetDlgItem(IDC_CWDLG_SB_CWSPEED);
           CWSPEED_n=pos;pSB->SetScrollPos(CWSPEED_n);
           comport.CWSPEED_Set(CWSPEED_n);
           break;
   case 1 :pSB=(CScrollBar*) GetDlgItem(IDC_CWDLG_SB_APF);
           APFlev_n=pos;pSB->SetScrollPos(APFlev_n);
           comport.APFlev_Set(APFlev_n);       
           break;   
  }		
 CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
//-----------------------------------------------------------------------------
void CW_Dlg::OnAPF()
{
 TaMsgBox(AppName,msg00,2);return;
 
 APFsw++;if (APFsw > 4) APFsw=0;
 comport.APF_Switch(APFsw);
}
//-----------------------------------------------------------------------------
void CW_Dlg::OnKEYTYPE()
{
 int keytype,res;

 res=GetCurrentMessage()->wParam;    
 switch (res)
  {
   case IDC_CWDLG_BU_KEYSTRAIGHT:keytype=0;break;
   case IDC_CWDLG_BU_KEYBUG     :keytype=1;break;
   case IDC_CWDLG_BU_KEYELEC    :keytype=2;break;   
  }
 comport.CWKeyType_Set(keytype);
}
//MNF_Dlg++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(MNF_Dlg, CDialog)
MNF_Dlg::MNF_Dlg(CWnd* pParent /*=NULL*/)
	    : CDialog(MNF_Dlg::IDD, pParent)
{
}

MNF_Dlg::~MNF_Dlg()
{
}

void MNF_Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(MNF_Dlg, CDialog)
    ON_WM_HSCROLL()
    ON_BN_CLICKED(IDC_MFNDLG_BU01, OnMNF1_Switch)
    ON_BN_CLICKED(IDC_MFNDLG_BU02, OnMNF2_Switch)
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL MNF_Dlg::PreTranslateMessage(MSG* pMsg)
{
 if(!(m_hAccel && ::TranslateAccelerator(m_hWnd, m_hAccel, pMsg)))
   return CDialog::PreTranslateMessage(pMsg);else return TRUE;
	
 return CDialog::PreTranslateMessage(pMsg);
}
//-----------------------------------------------------------------------------
BOOL MNF_Dlg::OnInitDialog()
{
 CDialog::OnInitDialog();

 m_hAccel=NULL;
 //m_hAccel=LoadAccelerators(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_MNFACCEL));
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 MNF1lev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_MFNDLG_SB01);
 pSB->SetScrollRange(0,255);
 comport.MNF1_Ask();
 pSB->SetScrollPos(MNF1lev_n);

 MNF2lev_n=0;
 pSB=(CScrollBar*) GetDlgItem(IDC_MFNDLG_SB02);
 pSB->SetScrollRange(0,255);
 comport.MNF2_Ask();
 pSB->SetScrollPos(MNF2lev_n);
 
 return TRUE;  // return TRUE unless you set the focus to a control
}
//-----------------------------------------------------------------------------
void MNF_Dlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
 int scr=0,pos=0,posmax;

 if (nSBCode > 9) return;

 switch (pScrollBar->GetDlgCtrlID())
  {
   case IDC_MFNDLG_SB01:scr=0 ;pos=pScrollBar->GetScrollPos();break;
   case IDC_MFNDLG_SB02:scr=1 ;pos=pScrollBar->GetScrollPos();break;
  }

 if (scr >= 0 && scr < 2) posmax=255;
 //if (scr == 9) {IB_FI_SW(Radio_Num);posmax=FI_SW_Fmax_lev;}             
 switch (nSBCode) 
  {
   case SB_PAGEUP       :pos+=10;if (pos > posmax) pos=posmax;break;//Bild nach oben
   case SB_PAGEDOWN     :pos-=10;if (pos <      0) pos=0     ;break;//Bild nach unten
        
   case SB_LINELEFT     :pos--;  if (pos <      0) pos=0     ;break;//<-
   case SB_LINERIGHT    :pos++;  if (pos > posmax) pos=posmax;break;//->
   case SB_LEFT         :pos=0;break;                               //Pos1
   case SB_RIGHT        :pos=posmax;break;                          //End   
   case SB_THUMBPOSITION: 
   case SB_THUMBTRACK   :pos=nPos;break;
  }
   
 switch (scr) 
  {
   case 0 :pSB=(CScrollBar*) GetDlgItem(IDC_MFNDLG_SB01);
           MNF1lev_n=pos;pSB->SetScrollPos(MNF1lev_n);
           comport.MNF1_Set(MNF1lev_n);
           break;
   case 1 :pSB=(CScrollBar*) GetDlgItem(IDC_MFNDLG_SB02);
           MNF2lev_n=pos;pSB->SetScrollPos(MNF2lev_n);
           comport.MNF2_Set(MNF2lev_n);      
           break;   
  }		
 CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
//-----------------------------------------------------------------------------
void MNF_Dlg::OnMNF1_Switch()
{
 MNF1sw++;if (MNF1sw > 1) MNF1sw=0;
 if (MNF1sw == 1) 
  {
   pSB=(CScrollBar*) GetDlgItem(IDC_MFNDLG_SB01);
   pSB->SetFocus();
  }
 comport.MNF1_Switch(MNF1sw);
}

void MNF_Dlg::OnMNF2_Switch()
{ 
 MNF2sw++;if (MNF2sw > 1) MNF2sw=0;
 if (MNF2sw == 1) 
  {
   pSB=(CScrollBar*) GetDlgItem(IDC_MFNDLG_SB02);
   pSB->SetFocus();
  }
 comport.MNF2_Switch(MNF2sw);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++






