// R_COM.H : RS232-Klasse
// G. TAMM, DF9ZO 1999-2007
//-------------------------
#pragma once
//--------------------
#include "R_VAR.H"
#include "R_RLIB.H"
//--------------------
/*
 COMX= 0 COM1
 COMX= 1 COM2
 COMX= 2 COM3
 -
 COMX=19 COM20

 BAUD=0  75
 BAUD=1  150
 BAUD=2  300
 BAUD=3  600
 BAUD=4  1200
 BAUD=5  2400
 BAUD=6  4800
 BAUD=7  9600
 BAUD=8  19200
 BAUD=9  38400
 BAUD=10 57600
 BAUD=11 115200

 DATA=0  4
 DATA=1  5
 DATA=2  6
 DATA=3  7
 DATA=4  8

 STOP=0	1
 STOP=1	1.5
 STOP=2	2

 PARI=0	ODD
 PARI=1	EVEN
 PARI=2	MARK
 PARI=3	SPACE
 PARI=4	NO

 PROT=0	RTS/CTS
 PROT=1	DTR/DSR
 PROT=2	Xon/Xoff
 PROT=3	NO
*/
//+Globale Variablen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern const char COMX_s[20][7];
extern const char BAUD_s[12][7];
extern const int  BAUD_n[12];
extern const char DATA_s[5] [2];
extern const int  DATA_n[5];
extern const char STOP_s[3] [4];
extern const char PARI_s[5] [6];
extern const char PROT_s[4] [9];

extern int        COMAvail[];//0=Port NOT available, 1=Port available
//+Funktionen++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void COMTest_Single(int comport);
//Testet Verfuegbarkeit eines bestimmten Ports
void COMTest_Complete(int shmsg=1);
//Testet Verfuegbarkeit aller Ports
//COM-Klasse+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class COM
{
 public:
   int  PortIsActive;			//0=NOT active, 1=active
   int  ErrorNum;
   int  LineStatus;
   int  oldMSR[4],actMSR[4];	//0=RLSD, 1=RING, 2=CTS, 3=DSR
   int  RLSD,RING,CTS,DSR;
   char PortName[5];
   char ErrTxt[100];
   //Standardkonstruktor
   COM();
   //Destruktor
   ~COM();
   //Methoden
   void ShComError(void);
   int  Open(int comx=2,int baud=9600,int data=8,int stop=1,
			 int pari=4,int prot=2,
			 int rxbuf=5000,int txbuf=1000);
   int  Close(void);
   //-----------------------
   int ReadChar(void);
   //-----------------------
   int WriteChar(int ch);
   int WriteStr(char *src,int mode);
   //Sendet NUR, wenn TXbuf ausreichend f. kompletten String
   //Sendet terminierendes '\0' NICHT MIT
   //mode=0 -> nur src  mode=1 -> src+CR(13)  mode=2 -> src+CR(13)+LF(10)
   //-----------------------
   int RXBufFree(void);
   int RXBufUsed(void);
   int TXBufFree(void);
   int TXBufUsed(void);
   //-----------------------
   int ClrRXBuf(void);
   int ClrTXBuf(void);
   //-----------------------
   void SetDTR(void);
   void ResDTR(void);
   void SetRTS(void);
   void ResRTS(void);
   //-----------------------
   int  ReadMSR(void);// 1=(oldMSR != actMSR)  0=(oldMSR == actMSR)
   //-----------------------
   //int Break(long milliseconds=300);
   //int SoftwareOverrunError(int clear=UNCHANGED);
   //int ParityError(int clear=UNCHANGED);
   //int BreakDetect(int clear=UNCHANGED);
   //int FramingError(int clear=UNCHANGED);
   //int HardwareOverrunError(int clear=UNCHANGED);
   //Radiofunktionen+++++++++++++++++++++++++++++++
   int  F_Ask();
   //Fragt Frequenz von Radio ab
   int  F_Set(char *freqstr);
   //Sendet NUR, wenn TXbuf ausreichend f. komplette Zeichenfolge
   //Erwartet normgerechten freqstr mit fuehrenden Nullen
   void RXBufferToFstr(int arrmaxind);
   //Macht normgerechten Fstr aus RX-Buffer
   //-----------------------
   int  M_Ask();
   //Fragt Mode von Radio ab
   int  M_Set(int moind,int fiind);
   //moind = Indexierung Modes
   void RXBufferToMoFi(int mo_ind,int fi_ind);
   //Macht Mode- und FilterIndex aus RX-Buffer
   //-----------------------
   int  FSTEP_HW_Set(int stepind);
   //Setzt Tuning Step Radio
   //-----------------------
   int  ROOF_Ask();
   int  ROOF_Switch(int roof);

   int  ANT_Ask();
   int  ANT_Switch(int ant);

   int  ATT_Ask();
   int  ATT_Switch(int att);

   int  PAMP_Ask();
   int  PAMP_Switch(int pamp);
   //-----------------------
   int  AGC_Ask();
   int  AGC_Switch(int agc);
   //-----------------------
   int  VFO_AB_Switch(int vfo);
   //0=VFO A, 1= VFO B
   int  VFO_EQUAL_Switch();
   //Gleicht VFOs an
   int  VFO_SPLIT_Switch(int split);
   //0=Normal, 1=Split
   int  VFO_MEM_Switch(int vm);
   //0=VFO, 1=MEM
   int  DUP_Switch(int dup);
   //-----------------------
   int  ANF_Ask();
   int  ANF_Switch(int anf);
   //Schaltet ANF um

   int  MNF1_Switch(int mnf);
   int  MNF1_Ask();
   int  MNF1_Set(int mnf1_n);
   int  MNF2_Switch(int mnf);
   int  MNF2_Ask();
   int  MNF2_Set(int mnf2_n);
   //-----------------------
   int  NR_Ask();
   int  NR_Switch(int nr);
   //Schaltet NR um
   int  NRlev_Ask();
   int  NRlev_Set(int nrlev_n);
   //Setzt NR-Level
   //-----------------------
   int  NB_Ask();
   int  NB_Switch(int nb);
   //Schaltet NB um
   int  NBlev_Ask();
   int  NBlev_Set(int nblev_n);
   //Setzt NB-Level
   int  NBwid_Ask();
   int  NBwid_Set(int nbwid_n);
   //Setzt NB-Width
   //-----------------------
   int  SQLoc_SW_Ask(); 
   //Erfragt SQL-Zustand via Radio-SW
   int  SQLoc_HW_Ask();
   //Erfragt SQL-Zustand via Radio-HW 
   int  SQLlev_Ask();
   //Erfragt SQL-Level
   int  SQLlev_Set(int sqllev_n);
   //Setzt Squelch-Level
   //-----------------------
   int  SMlev_Ask();
   //S-Meter
   //-----------------------
   int  AFlev_Ask();
   int  AFlev_Set(int af_n);
   //-----------------------
   int  RFlev_Ask();
   int  RFlev_Set(int rf_n);
   //-----------------------
   int  PopUpFI_Set (int subcmd);
   int  PopUpPBT_Set(int subcmd);
   //-----------------------
   int  PBTH_Ask();
   int  PBTHlev_Set(int pbth_n);
   int  PBTL_Ask();
   int  PBTLlev_Set(int pbtl_n);
   //-----------------------
   int  FI_SWbw_Ask();
   int  FI_SWbwlev_Set(int bw_n);
   int  FI_SWshape_Set(int shape);
   //0=sharp, 1=soft
   //-----------------------
   int  CWSPEED_Ask();
   //Fragt Keyer-Speed ab;
   int  CWSPEED_Set(int cwspeed_n);
   //Setzt Keyer-Speed: 0-255
   int  APFlev_Ask();
   int  APFlev_Set(int apf_n);
   int  APF_Switch(int apf);
   //-----------------------
   int  TXPWR_Ask();
   //Fragt eingestellte Sendeleistung ab;
   int  TXPWR_Set(int txpwr_n);//Respond OK
   //Setzt Sendeleistung: 0-255 (27=10W, 53=20 W) 
   //-----------------------
   int  RTTY_MF_Ask();
   int  RTTY_MF_Set(int mf);
   int  RTTY_SH_Ask();
   int  RTTY_SH_Set(int sh);
   int  RTTY_KP_Ask();
   int  RTTY_KP_Set(int kp);
   int  RTTY_RXDEC_Ask();
   int  RTTY_RXDEC_Set(int rxdec);
   int  RTTY_TPF_Ask();
   int  RTTY_TPF_Set(int tpf);
   //-----------------------
   int  MEM_Ask(int bank,int memnum);
   //bank=1(A)-5(E), memnum 1-99
   int  MEM_Set_7000(int bank,int memnum,char *freqstr,int moind,int fiind,int dup,char *memtxt);
   //Speicher schreiben: 0x1A  0x00
   //Abhaengig von Typ    
   int  MEM_FromVFO_Set();
   //Speicher schreiben: 0x09
   //Universell 
   int  MEM_BANK_Set(int bank);
   //Setzt Bank
   int  MEM_ToNum_Set(int memnum);
   //Setzt memnum
   int  MEM_CLR_Set();
   //Loescht Radio-Memory
   //-----------------------
   int  MIClev_Ask();
   int  MIClev_Set(int mic_n);
   int  COMPlev_Ask();
   int  COMPlev_Set(int comp_n);
   int  COMP_Switch(int comp);
   int  TXSSBbw_Set(int bw);
   //0=wide, 1=mid, 2=nar
   int  TXSSBwimilow_Set();
   //-----------------------
   int  TRANSCEIVE_Set(int trx_n);
   int  CWKeyType_Set(int keytype);
   //0=Straight, 1=Bug, 2=ELEC-Key
   //-----------------------
   int  AnnounceWithVoice();
   //-----------------------
   int  RadioComplete_Get(CString& cstr);
   int  RadioComplete_Set(CString  cstr);
   //-----------------------
   int TestCmd(int subcmd);
   //Funktion zum Test
   void SendNOTOK();
   //Erzeugt Rueckgabe NOT OK
   //----------------------------------------------
   int GetCOM_RES(int retexp);
   int AskCOM_SPEC(int retexp);
   int AskCOM_IDLE();
   int ReadCOM();
   //Fragt auf Events Radio ab
   //return-Werte: s. R_Com.cpp
   //Radiofunktionen Ende++++++++++++++++++++++++++
 public:
   int RXb[100];  //RX-Buffer f. Radio
 private:
   HANDLE hCom;
   DCB  dcb,olddcb;
   int  ComCOMX,ComDATA,ComSTOP,ComBAUD,ComPARI,ComPROT;
   int  RXbuf,TXbuf;
   char errtxt1[10],errtxt2[10],errtxt3[10];
   int  tx_le,TXstr[100]; //Sendestring
   //int RXb[100];//Buffer f. Radio
   int RXc;       //Counter f. Buffer
};
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern COM comport; 
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
SetRTS;  {RTS to log. low=+12V  ready to send    }
ResRTS;  {RTS to log. high=-12V NOT ready to send}
SetDTR;  {DTR to log. low=+12V }
ResDTR;  {DTR to log. high=-12V}
RTS and DTR are log. low when COM is opened
*/
