// R_COM.CPP : RS232-Klasse
// G. TAMM, DF9ZO 1999-2007
//-------------------------
#include "stdafx.h"
#include "R_COM.H"
//+Globale Variablen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
COM comport;
//-----------------------------------------------------------------------------
const char COMX_s[20][7]        ={"COM 1","COM 2","COM 3","COM 4","COM 5",
                                  "COM 6","COM 7","COM 8","COM 9","COM 10",
                                  "COM 11","COM 12","COM 13","COM 14","COM 15",
                                  "COM 16","COM 17","COM 18","COM 19","COM 20"};
const char BAUD_s[12][7]        ={"75","150","300","600",
                                  "1200","2400","4800","9600",
                                  "19200","38400","57600","115200"};
const int  BAUD_n[12]           ={75,150,300,600,
                                  1200,2400,4800,9600,
                                  19200,38400,57600,115200};
const char DATA_s[5][2]         ={"4","5","6","7","8"};
const int  DATA_n[5]            ={4,5,6,7,8};
const char STOP_s[3][4]         ={"1","1.5","2"};
const char PARI_s[5][6]         ={"ODD","EVEN","MARK","SPACE","NO"};
const char PROT_s[4][9]         ={"RTS/CTS","DTR/DSR","Xon/Xoff","NO"};

int        COMAvail[20]         ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
//+Funktionen++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void COMTest_Single(int comport)
{
 char   portstr[7];
 HANDLE hCom;

 COMAvail[comport]=0;
 wsprintf(portstr,"COM%d",comport+1);
 hCom=INVALID_HANDLE_VALUE;
 hCom=CreateFile(portstr,GENERIC_READ | GENERIC_WRITE,
                 0,NULL,OPEN_EXISTING,0,NULL);
 if (hCom != INVALID_HANDLE_VALUE)
  {
   COMAvail[comport]=1;CloseHandle(hCom);
  }
}

void COMTest_Complete(int shmsg)
{
 int    x;
 char   portstr[7],str[1000],yes[]="Available",no[]="NOT available",
        nl[]="\n",dop[]=": ";
 HANDLE hCom;

 for (x=0;x < 20;x++)
  {
   COMAvail[x]=0;
   wsprintf(portstr,"COM%d",x+1);
   hCom=INVALID_HANDLE_VALUE;
   hCom=CreateFile(portstr,GENERIC_READ | GENERIC_WRITE,
                   0,NULL,OPEN_EXISTING,0,NULL);
   if (hCom != INVALID_HANDLE_VALUE)
    {
     COMAvail[x]=1;CloseHandle(hCom);
    }
  }
 //---------------------------------------------------------
 strcpy(str,COMX_s[0]);strcat(str,"\t");strcat(str,dop);
 if (COMAvail[0]) strcat(str,yes);else strcat(str,no);
 for (x=1;x < 20;x++)
  {
   strcat(str,nl);strcat(str,COMX_s[x]);strcat(str,"\t");strcat(str,dop);
   if (COMAvail[x]) strcat(str,yes);else strcat(str,no);
  }
 if (shmsg) TaMsgBox("COM-Ports",str,2);
}
//COM-Klasse+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
COM::COM()
{
 ComCOMX=ComBAUD=ComDATA=ComSTOP=ComPARI=ComPROT=-1;
 hCom=INVALID_HANDLE_VALUE;
 RXbuf=10000;TXbuf=10000;
 PortIsActive=0;
 oldMSR[0]=oldMSR[1]=oldMSR[2]=oldMSR[3]=-99;
 actMSR[0]=actMSR[1]=actMSR[2]=actMSR[3]=0;
 ErrTxt[0]='\0';PortName[0]='\0';
 strcpy(errtxt1,"OPEN");strcpy(errtxt2,"CLOSE");strcpy(errtxt3,"WRITE");
}
//-----------------------------------------------------------------------------
COM::~COM()
{
 if (hCom != INVALID_HANDLE_VALUE)
  {
   ClrRXBuf();ClrTXBuf();
   Close();
  }
}
//-----------------------------------------------------------------------------
void COM::ShComError(void)
{
 /*
 LPTSTR lpMsgBuf;

 ErrorNum=GetLastError();
 //-----------------
 FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    				NULL,GetLastError(),
    				MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),// Default language
    				(LPTSTR) &lpMsgBuf,0,NULL);
 MessageBox(NULL,lpMsgBuf,"COM-ERROR",MB_OK | MB_ICONSTOP | MB_TASKMODAL);
 //-----------------
 LocalFree(lpMsgBuf);*/
 ::MessageBox(NULL,ErrTxt,"COM-ERROR",MB_OK | MB_ICONSTOP | MB_TASKMODAL);
}
//-----------------------------------------------------------------------------
int COM::Open(int comx,int baud,int data,int stop,int pari,int prot,
					   int rxbuf,int txbuf)
{
 int res;

 ComCOMX=comx;ComBAUD=baud;ComDATA=data;ComSTOP=stop;
 ComPARI=pari;ComPROT=prot;RXbuf=rxbuf;TXbuf=txbuf;
 wsprintf(PortName,"COM%d",ComCOMX+1);
 hCom=INVALID_HANDLE_VALUE;
 //--------------------------------------------------
 hCom=CreateFile(PortName,
 				 GENERIC_READ | GENERIC_WRITE,
                 0,//comm devices must be opened w/exclusive-access
    			 NULL,//no security attrs
                 OPEN_EXISTING,//comm devices must use OPEN_EXISTING
                 0,//not overlapped I/O
    			 NULL);//hTemplate must be NULL for comm devices
 if (hCom == INVALID_HANDLE_VALUE)
  {
   strcpy(ErrTxt,errtxt1);strcat(ErrTxt,"(1)");
   ShComError();return 0;
  }
 //-Alte DCB speichern-------------------------------
 res=GetCommState(hCom,&olddcb);
 if (res == 0)
  {
   strcpy(ErrTxt,errtxt1);strcat(ErrTxt,"(2)");
   ShComError();hCom=INVALID_HANDLE_VALUE;return 0;
  }
 //-Neue DCB setzen----------------------------------
 dcb.BaudRate=BAUD_n[ComBAUD];
 dcb.ByteSize=DATA_n[ComDATA];
 switch (ComPARI)
  {
   case 0:dcb.Parity=ODDPARITY;break;
   case 1:dcb.Parity=EVENPARITY;break;
   case 2:dcb.Parity=MARKPARITY;break;
   case 3:dcb.Parity=SPACEPARITY;break;
   case 4:dcb.Parity=NOPARITY;break;
   default:dcb.Parity=NOPARITY;break;
  }
 switch (ComSTOP)
  {
   case 0:dcb.StopBits=ONESTOPBIT;break;
   case 1:dcb.StopBits=ONE5STOPBITS;break;
   case 2:dcb.StopBits=TWOSTOPBITS;break;
   default:dcb.StopBits=ONESTOPBIT;break;
  }
// fOutxCtsFlow , fRtsControl / fOutxDsrFlow , fDtrControl / fOutX , fInX
  switch (ComPROT)
  {
   case 0:// RTS/CTS
          dcb.fRtsControl=RTS_CONTROL_HANDSHAKE;dcb.fOutxCtsFlow=TRUE;
          dcb.fDtrControl=DTR_CONTROL_DISABLE;dcb.fOutxDsrFlow=FALSE;
  		  dcb.fInX=dcb.fOutX=FALSE;
	  	  break;
   case 1:// DTR/DSR
          dcb.fRtsControl=RTS_CONTROL_DISABLE;dcb.fOutxCtsFlow=FALSE;
          dcb.fDtrControl=DTR_CONTROL_HANDSHAKE;dcb.fOutxDsrFlow=TRUE;
  		  dcb.fInX=dcb.fOutX=FALSE;
	  	  break;
   case 2:// Xon/Xoff
          dcb.fRtsControl=RTS_CONTROL_DISABLE;dcb.fOutxCtsFlow=FALSE;
		  dcb.fDtrControl=DTR_CONTROL_DISABLE;dcb.fOutxDsrFlow=FALSE;
          dcb.fInX=dcb.fOutX=TRUE;
          break;
   case 3:// NO
   		 dcb.fOutxCtsFlow=dcb.fRtsControl=0;
         dcb.fOutxDsrFlow=dcb.fDtrControl=0;
         dcb.fOutX=dcb.fInX=0;
	  	 break;
  }
 dcb.fNull=0;//Kein null stripping
 res=SetCommState(hCom,&dcb);
 if (res == 0)
  {
   strcpy(ErrTxt,errtxt1);strcat(ErrTxt,"(3)");
   ShComError();hCom=INVALID_HANDLE_VALUE;return 0;
  }
 //--------------------------------------------------
 res=SetupComm(hCom,RXbuf,TXbuf);
 if (res == 0)
  {
   strcpy(ErrTxt,errtxt1);strcat(ErrTxt,"(4)");
   ShComError();hCom=INVALID_HANDLE_VALUE;return 0;
  }
 //--------------------------------------------------
 ClrTXBuf();ClrRXBuf();
 PortIsActive=1;
 return 1;
}
//-----------------------------------------------------------------------------
int COM::Close(void)
{
 int res;

 if (hCom == INVALID_HANDLE_VALUE) return 0;
 FlushFileBuffers(hCom);//TXBuf senden
 ClrRXBuf();ClrTXBuf();
 //-Alte DCB setzen-------------------------
 res=SetCommState(hCom,&olddcb);
 if (res == 0)
  {
   strcpy(ErrTxt,errtxt2);strcat(ErrTxt,"(1)");
   ShComError();return 0;
  } 
 //-Port schliessen-------------------------
 res=CloseHandle(hCom);
 if (res == 0)
  {
   strcpy(ErrTxt,errtxt2);strcat(ErrTxt,"(2)");
   ShComError();hCom=INVALID_HANDLE_VALUE;
   return 0;
  }else
  {
   hCom=INVALID_HANDLE_VALUE;
   PortIsActive=0;
   return 1;
  }
}
//-----------------------------------------------------------------------------
int COM::ClrRXBuf(void)
{
 int res;

 res=PurgeComm(hCom,PURGE_RXABORT);PurgeComm(hCom,PURGE_RXCLEAR);
 if (res == 0)
  {
   strcpy(ErrTxt,"ClrRXBuf");ShComError();return 0;
  }
 return 1;
}

int COM::ClrTXBuf(void)
{
 int res;

 res=PurgeComm(hCom,PURGE_TXABORT);PurgeComm(hCom,PURGE_TXCLEAR);
 if (res == 0)
  {
   strcpy(ErrTxt,"ClrTXBuf");ShComError();return 0;
  }
 return 1;
}
//-----------------------------------------------------------------------------
void COM::SetDTR()
{
 int res;

 res=EscapeCommFunction(hCom,SETDTR);
 if (res == 0) {strcpy(ErrTxt,"SETDTR");ShComError();}
}

void COM::ResDTR()
{
 int res;

 res=EscapeCommFunction(hCom,CLRDTR);
 if (res == 0) {strcpy(ErrTxt,"CLRDTR");ShComError();}
}

void COM::SetRTS()
{
 int res;

 res=EscapeCommFunction(hCom,SETRTS);
 if (res == 0) {strcpy(ErrTxt,"SETRTS");ShComError();}
}

void COM::ResRTS()
{
 int res;

 res=EscapeCommFunction(hCom,CLRRTS);
 if (res == 0) {strcpy(ErrTxt,"CLRRTS");ShComError();}
}
//-----------------------------------------------------------------------------
int COM::ReadMSR(void)
{
 int res;
 unsigned long MSR;

 res=GetCommModemStatus(hCom,&MSR);
 if (res == 0) {strcpy(ErrTxt,"ReadMSR");ShComError();return 0;}
 //-------------------------------------------------------------
 if (MSR & MS_RLSD_ON) RLSD=1;else RLSD=0;actMSR[0]=RLSD;
 if (MSR & MS_RING_ON) RING=1;else RING=0;actMSR[1]=RING;
 if (MSR & MS_CTS_ON)  CTS=1;else CTS=0;actMSR[2]=CTS;
 if (MSR & MS_DSR_ON)  DSR=1;else DSR=0;actMSR[3]=DSR;
 //-------------------------------------------------------------
 if (actMSR[0]!=oldMSR[0] || actMSR[1]!=oldMSR[1] ||
 	  actMSR[2]!=oldMSR[2] || actMSR[3]!=oldMSR[3])
  {
   oldMSR[0]=actMSR[0];oldMSR[1]=actMSR[1];oldMSR[2]=actMSR[2];oldMSR[3]=actMSR[3];
   return 1;
  }else return 0;
}
//-----------------------------------------------------------------------------
int COM::RXBufFree(void)
{
 COMSTAT comstat;
 DWORD err;

 ClearCommError(hCom,&err,&comstat);
 return RXbuf-comstat.cbInQue;
}

int COM::RXBufUsed(void)
{
 COMSTAT comstat;
 DWORD err;

 ClearCommError(hCom,&err,&comstat);
 return comstat.cbInQue;
}

int COM::TXBufFree(void)
{
 COMSTAT comstat;
 DWORD err;

 ClearCommError(hCom,&err,&comstat);
 return TXbuf-comstat.cbOutQue;
}

int COM::TXBufUsed(void)
{
 COMSTAT comstat;
 DWORD err;

 ClearCommError(hCom,&err,&comstat);
 return comstat.cbOutQue;
}
//-----------------------------------------------------------------------------
int COM::ReadChar(void)
{
 COMSTAT comstat;
 DWORD err,read;
 unsigned char ch;// !!!

 ClearCommError(hCom,&err,&comstat);
 if (comstat.cbInQue == 0) return -1;
 //----------------------------------
 ReadFile(hCom,&ch,1,&read,NULL);
 if (read == 1) return ch;else
  {
   strcpy(ErrTxt,"Read");ShComError();
   return -2;
  }
}
//-----------------------------------------------------------------------------
int COM::WriteChar(int ch)
{
 COMSTAT comstat;
 DWORD err,written;

 ClearCommError(hCom,&err,&comstat);
 if (TXbuf-comstat.cbOutQue < 2)
  {
   strcpy(ErrTxt,errtxt3);strcat(ErrTxt,"(1)");
   ShComError();return -1;
  }
 //----------------------------------
 WriteFile(hCom,&ch,1,&written,NULL);
 if (written==1) return 1;else
  {
   strcpy(ErrTxt,errtxt3);strcat(ErrTxt,"(2)");
   ShComError();return -2;
  }
}

int COM::WriteStr(char *src,int mode)
{
 COMSTAT comstat;
 DWORD x,err,written,le;

 le=(DWORD)strlen(src);
 if (mode == 1) {src[le]=13;src[le+1]=0;le+=1;}
 if (mode == 2) {src[le]=13;src[le+1]=10;src[le+2]=0;le+=2;}
 ClearCommError(hCom,&err,&comstat);
 if (TXbuf-comstat.cbOutQue < le+1)
  {
   strcpy(ErrTxt,errtxt3);strcat(ErrTxt,"(3)");
   ShComError();return -1;
  }
 //----------------------------------
 for (x=0;x<le;x++)
  {
   WriteFile(hCom,&/*(unsigned char)*/src[x],1,&written,NULL);
   if (written != 1)
    {
     strcpy(ErrTxt,errtxt3);strcat(ErrTxt,"(4)");
     ShComError();return -2;
    }
  }
 return le;
} 
//+Radiofunktionen+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
int COM::F_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x03;
 TXstr[5]=IBRad_EoM;tx_le=6;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x03);
}

int COM::F_Set(char *freqstr)
{  
 char fstr[13];
 int  x,dest[5];
  
 strcpy(fstr,freqstr);
 IB_FreqToSend(dest,fstr);
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x05;
 for (x=5;x < IBRad_Da_n+5;x++) TXstr[x]=dest[x-5];
 TXstr[x]=IBRad_EoM;tx_le=6+IBRad_Da_n;         
 
 for (x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

void COM::RXBufferToFstr(int arrmaxind)
{
 int  x;
 char str[10];

 if (IBRad_Da_n == 4)
  {
   Fact_s[0]='0';Fact_s[1]='0';
  }else
  {
   IB_HexToDecStr(str,RXb[arrmaxind  ]);Fact_s[0]=str[0];Fact_s[1]=str[1];
  }
 IB_HexToDecStr  (str,RXb[arrmaxind-1]);Fact_s[2]=str[0];Fact_s[3]=str[1];
 IB_HexToDecStr  (str,RXb[arrmaxind-2]);Fact_s[4]=str[0];Fact_s[5]=str[1];
 IB_HexToDecStr  (str,RXb[arrmaxind-3]);Fact_s[6]=str[0];Fact_s[7]=str[1];
 IB_HexToDecStr  (str,RXb[arrmaxind-4]);Fact_s[8]=str[0];Fact_s[9]=str[1];
 Fact_s[10]=0;
 StrInsChPos(Fact_s,'.',4);StrInsChPos(Fact_s,',',8);
 x=0;while (Fact_s[x] == '0') {Fact_s[x]=' ';x++;}
 Fact_n=FstrToFnum(Fact_s);
}
//-----------------------------------------------------------------------------
int COM::M_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x04;
 TXstr[5]=IBRad_EoM;tx_le=6;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(0x04);
}

int COM::M_Set(int moind,int fiind)
{
 int x,le=0;

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x06;
 TXstr[5]=MODES.IBcmdFromMn(moind);le=1;
 //TXstr[5]=0x5;TXstr[6]=0x2;le=2;break;// FMN

 if (FI_SwHw == 0)//HW-Filter
  {
   if (moind == 0 || moind == 1) x=0;else x=3*(moind-1);
   if (IBRad_FI_HW[x+fiind] > -1) {TXstr[6]=IBRad_FI_HW[x+fiind];le=2;}
   TXstr[5+le]=IBRad_EoM;le=6+le;
  }else            //SW-Filter 
  {
   if (fiind == 0) TXstr[6]=2;
   if (fiind == 1) TXstr[6]=3;
   if (fiind == 2) TXstr[6]=1;
   TXstr[7]=IBRad_EoM;le=7;
  }

 for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);
}

void COM::RXBufferToMoFi(int mo_ind,int fi_ind)
{
 int x;

 Mact_n=MODES.MnFromIBcmd(RXb[mo_ind]);
  
 FIact_n=0;
 if (FI_SwHw == 0)//HW-Filter
  {
   if (Mact_n < 6)
    {
     if (Mact_n == 0 || Mact_n == 1) x=0;else x=3*(Mact_n-1);
     if (IBRad_FI_HW[x  ] > -1 && RXb[fi_ind] == IBRad_FI_HW[x  ]) FIact_n=0;
     if (IBRad_FI_HW[x+1] > -1 && RXb[fi_ind] == IBRad_FI_HW[x+1]) FIact_n=1;
     if (IBRad_FI_HW[x+2] > -1 && RXb[fi_ind] == IBRad_FI_HW[x+2]) FIact_n=2;
    }
  }else           //SW-Filter 
  {
   if (RXb[fi_ind] == 1) FIact_n=2;//wide
   if (RXb[fi_ind] == 2) FIact_n=0;//normal
   if (RXb[fi_ind] == 3) FIact_n=1;//narrow   
  }

 strcpy(Mact_s,Marr_s[Mact_n]);strcpy(FIact_s,FIarr_s[FIact_n]);
}
//-----------------------------------------------------------------------------
int COM::FSTEP_HW_Set(int stepind)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x10;TXstr[5]=stepind;
 TXstr[6]=IBRad_EoM;tx_le=7;   
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}
//-----------------------------------------------------------------------------
int COM::ROOF_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x09;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);

 return GetCOM_RES(0x1A); 
}
 
int COM::ROOF_Switch(int roof)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x09;TXstr[6]=roof;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::ANT_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x12;
 TXstr[5]=IBRad_EoM;tx_le=6;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x12); 
}

int COM::ANT_Switch(int ant)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x12;TXstr[5]=ant;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::ATT_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x11;
 TXstr[5]=IBRad_EoM;tx_le=6;          
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x11); 
}

int COM::ATT_Switch(int att)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x11;
 TXstr[5]=IB_ATTcmdFromATTn(att);
 TXstr[6]=IBRad_EoM;tx_le=7;          
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

int COM::PAMP_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x2;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x16); 
}

int COM::PAMP_Switch(int pamp)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x2;
 /*TXstr[6]=pamp;*/TXstr[6]=IB_PAMPcmdFromPAMPn(pamp);
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}
//-----------------------------------------------------------------------------
int COM::AGC_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x12;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x16); 
}

int COM::AGC_Switch(int agc)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x12;TXstr[6]=agc;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK); 
}
//-----------------------------------------------------------------------------
int COM::VFO_AB_Switch(int vfo)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x07;
 if (vfo == 0) TXstr[5]=0x00;else TXstr[5]=0x01;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}

int COM::VFO_EQUAL_Switch()//Radio specific 7800
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x07;TXstr[5]=0xA0;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::VFO_SPLIT_Switch(int split)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x0F;TXstr[5]=split;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::VFO_MEM_Switch(int vm)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (vm == 0) TXstr[4]=0x07;else TXstr[4]=0x08;//MEM
 TXstr[5]=IBRad_EoM;tx_le=6;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}

int COM::DUP_Switch(int dup)//Radio specific 7700,7800
{
 if (IBRad_Adr_n == 0x74 ||                  //IC-7700
     IBRad_Adr_n == 0x6A)                    //IC-7800
     return 0;   

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x0F;
 if (dup == 0) TXstr[5]=0x10;
 if (dup == 1) TXstr[5]=0x11;
 if (dup == 2) TXstr[5]=0x12;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}
//-----------------------------------------------------------------------------
int COM::ANF_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x41;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x16);    
}

int COM::ANF_Switch(int anf)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x41;TXstr[6]=anf;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::MNF1_Switch(int mnf)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x48;TXstr[6]=mnf;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::MNF1_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0D;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14);  
}

int COM::MNF1_Set(int mnf1_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0D;
 IB_DecToBCD(TXstr[6],TXstr[7],mnf1_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::MNF2_Switch(int mnf)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x51;TXstr[6]=mnf;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);    
}

int COM::MNF2_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x1A;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14);   
}

int COM::MNF2_Set(int mnf2_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x1A;
 IB_DecToBCD(TXstr[6],TXstr[7],mnf2_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK);  
}
//-----------------------------------------------------------------------------
int COM::NR_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x40;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x16);    
}

int COM::NR_Switch(int nr)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x40;TXstr[6]=nr;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}

int COM::NRlev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x06;
 TXstr[6]=IBRad_EoM;tx_le=7;   

 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14);     
}

int COM::NRlev_Set(int nrlev_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x06;
 IB_DecToBCD(TXstr[6],TXstr[7],nrlev_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}
//-----------------------------------------------------------------------------
int COM::NB_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x22;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x16);    
}

int COM::NB_Switch(int nb)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x22;TXstr[6]=nb;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);    
}

int COM::NBlev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x12;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14);     
}

int COM::NBlev_Set(int nblev_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x12;
 IB_DecToBCD(TXstr[6],TXstr[7],nblev_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK);     
}

int COM::NBwid_Ask()//Radio specific
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x13;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x85;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800      
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x86;  
  }
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x1A);  
}

int COM::NBwid_Set(int nbwid_n)//Radio specific
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x13;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x85;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800      
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x86;  
  } 
 IB_DecToBCD(TXstr[8],TXstr[9],nbwid_n);
 TXstr[10]=IBRad_EoM;tx_le=11;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK);   
}
//-----------------------------------------------------------------------------
int COM::SQLoc_SW_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x15;TXstr[5]=0x1;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x15);
}

int COM::SQLoc_HW_Ask()
{
 if (ReadMSR()) SQL_oc=RING;
 return SQL_oc;
}

int COM::SQLlev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x3;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14);
}

int COM::SQLlev_Set(int sqllev_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x03;
 IB_DecToBCD(TXstr[6],TXstr[7],sqllev_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}
//-----------------------------------------------------------------------------
int COM::SMlev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x15;TXstr[5]=0x2;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x15);
}
//-----------------------------------------------------------------------------
int COM::AFlev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x01;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14); 
}

int COM::AFlev_Set(int af_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x01;
 IB_DecToBCD(TXstr[6],TXstr[7],af_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}
//-----------------------------------------------------------------------------
int COM::RFlev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x02;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14); 
}

int COM::RFlev_Set(int rf_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x02;
 IB_DecToBCD(TXstr[6],TXstr[7],rf_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}
//-----------------------------------------------------------------------------
int COM::PopUpFI_Set(int subcmd) 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x27;
 TXstr[8]=subcmd;
 TXstr[9]=IBRad_EoM;tx_le=10;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);
}

int COM::PopUpPBT_Set(int subcmd)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x26;
 TXstr[8]=subcmd;
 TXstr[9]=IBRad_EoM;tx_le=10;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);
}
//-----------------------------------------------------------------------------
int COM::PBTH_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x07;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14); 
}

int COM::PBTHlev_Set(int pbth_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x07;
 IB_DecToBCD(TXstr[6],TXstr[7],pbth_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

int COM::PBTL_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x08;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14); 
}

int COM::PBTLlev_Set(int pbtl_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x08;
 IB_DecToBCD(TXstr[6],TXstr[7],pbtl_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}
//-----------------------------------------------------------------------------
int COM::FI_SWbw_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x03;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x1A); 
}

int COM::FI_SWbwlev_Set(int bw_n)
{
 char str[6]="0x",
      tmpstr[6];
 
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x03;
 _itoa(bw_n,tmpstr,10);strcat(str,tmpstr);
 TXstr[6]=strtol(str,0,16);   
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

int COM::FI_SWshape_Set(int shape)//Radio specific
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000
  {
   TXstr[4]=0x1A;TXstr[5]=0x07;TXstr[6]=shape;
  }
 if (IBRad_Adr_n == 0x74 ||                  //IC-7700
     IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0x08;TXstr[6]=shape;
  }   
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);	 
} 
//-----------------------------------------------------------------------------
int COM::CWSPEED_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0C;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(0x14);
}

int COM::CWSPEED_Set(int cwspeed_n)
{
 int cwspeed_l,cwspeed_h;

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 TXstr[4]=0x14;TXstr[5]=0x0C;
 IB_DecToBCD(cwspeed_l,cwspeed_h,cwspeed_n);
 TXstr[6]=cwspeed_l;TXstr[7]=cwspeed_h;
 TXstr[8]=IBRad_EoM;tx_le=9;

 /*TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x13;
 IB_DecToBCD(cwspeed_l,cwspeed_h,cwspeed_n);
 TXstr[8]=cwspeed_l;TXstr[9]=cwspeed_h;
 TXstr[10]=IBRad_EoM;tx_le=11;*/
  
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK);
}
//-----------------------------------------------------------------------------
int COM::APFlev_Ask()//Radio specific 
{
 if (IBRad_Adr_n == 0x70) return 0;//IC-7000

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 if (IBRad_Adr_n == 0x74 ||        //IC-7700  
     IBRad_Adr_n == 0x6A)          //IC-7800
  {
   TXstr[4]=0x14;TXstr[5]=0x05;
   TXstr[6]=IBRad_EoM;tx_le=7;
  }

 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(0x14);
}

int COM::APFlev_Set(int apf_n)//Radio specific 
{
 int apf_l,apf_h;

 if (IBRad_Adr_n == 0x70) return 0;//IC-7000

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 if (IBRad_Adr_n == 0x74 ||        //IC-7700  
     IBRad_Adr_n == 0x6A)          //IC-7800
  {
   TXstr[4]=0x14;TXstr[5]=0x05;
   IB_DecToBCD(apf_l,apf_h,apf_n);
   TXstr[6]=apf_l;TXstr[7]=apf_h;
   TXstr[8]=IBRad_EoM;tx_le=9;
  }

 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK); 
}

int COM::APF_Switch(int apf)//Radio specific 
{
 if (IBRad_Adr_n == 0x70) return 0;//IC-7000

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 if (IBRad_Adr_n == 0x74 ||        //IC-7700  
     IBRad_Adr_n == 0x6A)          //IC-7800
  {
   TXstr[4]=0x16;TXstr[5]=0x32;TXstr[6]=apf;
  } 
 TXstr[7]=IBRad_EoM;tx_le=8;

 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK);
}
//-----------------------------------------------------------------------------
int COM::TXPWR_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 TXstr[4]=0x14;TXstr[5]=0x0A;
 TXstr[6]=IBRad_EoM;tx_le=7;
  
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14); 
}

int COM::TXPWR_Set(int txpwr_n)
{
 int txpwr_l,txpwr_h;

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0A;
 IB_DecToBCD(txpwr_l,txpwr_h,txpwr_n);
 TXstr[6]=txpwr_l;TXstr[7]=txpwr_h;
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}
//-----------------------------------------------------------------------------
int COM::RTTY_MF_Ask()//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x10;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x75;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x78;
  }
 TXstr[8]=IBRad_EoM;tx_le=9; 
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x1A); 
}

int COM::RTTY_MF_Set(int mf)//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x10;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x75;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x78;
  }
 TXstr[8]=mf;TXstr[9]=IBRad_EoM;tx_le=10;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}

int COM::RTTY_SH_Ask()//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x11;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x76;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x79;
  }
 TXstr[8]=IBRad_EoM;tx_le=9; 

 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x1A); 
}

int COM::RTTY_SH_Set(int sh)//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x11;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x11;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x76;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x79;
  }
 TXstr[8]=sh;TXstr[9]=IBRad_EoM;tx_le=10;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK); 
}

int COM::RTTY_KP_Ask()//Radio specific
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x12;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x77;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x80;
  }
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(0x1A);
}

int COM::RTTY_KP_Set(int kp)//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x12;
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x77;
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x80;
  } 
 TXstr[8]=kp;TXstr[9]=IBRad_EoM;tx_le=10;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}

int COM::RTTY_RXDEC_Ask()//Radio specific
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x01;TXstr[7]=0x07;   
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x01;TXstr[7]=0x42;  
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x01;TXstr[7]=0x46;  
  } 
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x1A); 
}

int COM::RTTY_RXDEC_Set(int rxdec)//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x01;TXstr[7]=0x07;   
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x01;TXstr[7]=0x42;  
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x01;TXstr[7]=0x46;  
  } 
 TXstr[8]=rxdec;TXstr[9]=IBRad_EoM;tx_le=10;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}

int COM::RTTY_TPF_Ask()//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 TXstr[4]=0x16;TXstr[5]=0X4F;
 TXstr[6]=IBRad_EoM;tx_le=7;

 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x16);

 /*TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x09;
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x1A);*/ 
}

int COM::RTTY_TPF_Set(int tpf)//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 TXstr[4]=0x16;TXstr[5]=0X4F;
 TXstr[6]=tpf;
 TXstr[7]=IBRad_EoM;tx_le=8;
 /*TXstr[4]=0x1A;TXstr[5]=0X05;TXstr[6]=0x00;TXstr[7]=0x09;
 TXstr[8]=tpf;
 TXstr[9]=IBRad_EoM;tx_le=10;*/
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}
//-----------------------------------------------------------------------------
int COM::MEM_Ask(int bank,int memnum)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x00;
 TXstr[6]=bank;
 IB_DecToBCD(TXstr[7],TXstr[8],memnum);
 TXstr[9]=IBRad_EoM;tx_le=10+1;

 for (int x=0;x < tx_le;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x1A);  
}

int COM::MEM_Set_7000(int bank,int memnum,char *freqstr,int moind,int fiind,int dup,char *memtxt)
{
 int  x,y,strle,le=0;
 char fstr[13],memtxt_tmp[10];
 int  dest[5];

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x00;
 //--------------------------
 TXstr[6]=bank;                                         //MEM-Bank
 IB_DecToBCD(TXstr[7],TXstr[8],memnum);                 //MEM-Nr.
 TXstr[9]=0;                                            //Split ???
 strcpy(fstr,freqstr);                                  //VFO A: F
 IB_FreqToSend(dest,fstr);
 for (x=10,y=0;y < 5;x++,y++) TXstr[x]=dest[y];

 TXstr[15]=MODES.IBcmdFromMn(moind);                    //VFO A: Mode

 switch (fiind)                                         //VFO A: Filter
  {
   case  0:TXstr[16]=0x2;break;
   case  1:TXstr[16]=0x3;break;
   case  2:TXstr[16]=0x1;break;
   default:TXstr[16]=0x1;break;
  }
 if (moind == 6) TXstr[16]=0x1;//FMW muss immer mit fiind=2 laufen !!!  
 switch (dup)                                           //VFO A: DUP
  {
   case  0:TXstr[17]=0; break;
   case  1:TXstr[17]=16;break;
   case  2:TXstr[17]=32;break;
   default:TXstr[17]=0; break;
  } 
 TXstr[18]=0x00;//???
 TXstr[19]=0x08;//???
 TXstr[20]=133;//???
 TXstr[21]=0x00;//???
 TXstr[22]=0x08;//???
 TXstr[23]=133;//???
 TXstr[24]=0x00;//???
 TXstr[25]=0x00;//???
 TXstr[26]=35;//???
 for (x=27,y=10;x < 35;x++,y++) TXstr[x]=TXstr[y];      //VFO B: wie VFO A
 for (x=35,y=18;x < 44;x++,y++) TXstr[x]=TXstr[y];      //???
 for (x=44;x < 53;x++) TXstr[x]=0x61;
 strle=(int)strlen(memtxt);                             //TXT
 if (strle < 9) StrFiRi(memtxt,' ',9);
 for (x=44,y=0;x < 53;x++,y++) 
  {
   _itoa((int)memtxt[y],memtxt_tmp,16);
   TXstr[x]=IB_HexStrToInt(memtxt_tmp);
  }                            
 //--------------------------
 TXstr[53]=IBRad_EoM;le=54+1;

 for (x=0;x < le;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);
}

int COM::MEM_FromVFO_Set()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x09;
 TXstr[5]=IBRad_EoM;tx_le=6;   
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);  
}

int COM::MEM_BANK_Set(int bank)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x08;TXstr[5]=0xA0;TXstr[6]=bank;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);
}

int COM::MEM_ToNum_Set(int memnum)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x08;
 IB_DecToBCD(TXstr[5],TXstr[6],memnum);
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);
}

int COM::MEM_CLR_Set()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x0B;
 TXstr[5]=IBRad_EoM;tx_le=6;   
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);   
}
//-----------------------------------------------------------------------------
int COM::MIClev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0B;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14); 
}

int COM::MIClev_Set(int mic_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0B;
 IB_DecToBCD(TXstr[6],TXstr[7],mic_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

int COM::COMPlev_Ask()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0E;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(0x14); 
}

int COM::COMPlev_Set(int comp_n)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x14;TXstr[5]=0x0E;
 IB_DecToBCD(TXstr[6],TXstr[7],comp_n);
 TXstr[8]=IBRad_EoM;tx_le=9;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
 return GetCOM_RES(IBRad_OK);
}

int COM::COMP_Switch(int comp)
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x16;TXstr[5]=0x44;TXstr[6]=comp;
 TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

int COM::TXSSBbw_Set(int bw)//Radio specific
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0x06;
  }
 if (IBRad_Adr_n == 0x74 ||                  //IC-7700
     IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0x07;
  }
 TXstr[6]=bw;TXstr[7]=IBRad_EoM;tx_le=8;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

int COM::TXSSBwimilow_Set()//Radio specific
{
 int x,le;

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;

 if (IBRad_Adr_n == 0x70)                    //IC-7000 
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x03;//SSB TX-bw wide low edge
   TXstr[8]=TXSSBbw_wilo_n;TXstr[9]=IBRad_EoM;le=10; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);//GetCOM_RES(0x1A);
 
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x04;//SSB TX-bw wide high edge
   TXstr[8]=TXSSBbw_wihi_n;TXstr[9]=IBRad_EoM;le=10; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);

   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x05;//SSB TX-bw middle low edge
   TXstr[8]=TXSSBbw_milo_n;TXstr[9]=IBRad_EoM;le=10; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);

   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x06;//SSB TX-bw middle high edge
   TXstr[8]=TXSSBbw_mihi_n;TXstr[9]=IBRad_EoM;le=10; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);

   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x07;//SSB TX-bw narrow low edge
   TXstr[8]=TXSSBbw_nalo_n;TXstr[9]=IBRad_EoM;le=10; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);

   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x08;//SSB TX-bw narrow high edge
   TXstr[8]=TXSSBbw_nahi_n;TXstr[9]=IBRad_EoM;le=10; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]); 
   GetCOM_RES(IBRad_OK);
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x19;//SSB TX-bw wide
   TXstr[8]=TXSSBbw_wihi_n;TXstr[9]=TXSSBbw_wilo_n;TXstr[10]=IBRad_EoM;le=11; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);
 
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x20;//SSB TX-bw middle
   TXstr[8]=TXSSBbw_mihi_n;TXstr[9]=TXSSBbw_milo_n;TXstr[10]=IBRad_EoM;le=11; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);

   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x21;//SSB TX-bw narrow
   TXstr[8]=TXSSBbw_nahi_n;TXstr[9]=TXSSBbw_nalo_n;TXstr[10]=IBRad_EoM;le=11; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);
  }  
 if (IBRad_Adr_n == 0x6A)                    //IC-7800 
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x13;//SSB TX-bw wide
   TXstr[8]=TXSSBbw_wihi_n;TXstr[9]=TXSSBbw_wilo_n;TXstr[10]=IBRad_EoM;le=11; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);
 
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x14;//SSB TX-bw middle
   TXstr[8]=TXSSBbw_mihi_n;TXstr[9]=TXSSBbw_milo_n;TXstr[10]=IBRad_EoM;le=11; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);

   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x15;//SSB TX-bw narrow
   TXstr[8]=TXSSBbw_nahi_n;TXstr[9]=TXSSBbw_nalo_n;TXstr[10]=IBRad_EoM;le=11; 
   for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
   GetCOM_RES(IBRad_OK);
  }
 return 0;//Nur zur Vollst.
}
//-----------------------------------------------------------------------------
int COM::TRANSCEIVE_Set(int trx_n)//Radio specific 
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 if (IBRad_Adr_n == 0x70)                    //IC-7000
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x92;TXstr[8]=trx_n;
   TXstr[9]=IBRad_EoM;tx_le=10;
  }
 if (IBRad_Adr_n == 0x66)                    //IC-7400
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x36;TXstr[7]=trx_n;
   TXstr[8]=IBRad_EoM;tx_le=9;   
  }
 if (IBRad_Adr_n == 0x74)                    //IC-7700
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x00;TXstr[7]=0x95;TXstr[8]=trx_n;
   TXstr[9]=IBRad_EoM;tx_le=10;
  }   
 if (IBRad_Adr_n == 0x6A)                    //IC-7800
  {
   TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x01;TXstr[8]=trx_n;
   TXstr[9]=IBRad_EoM;tx_le=10;
  }   
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}

int COM::CWKeyType_Set(int keytype)
//0=Straight, 1=Bug, 2=ELEC-Key
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x1A;TXstr[5]=0x05;TXstr[6]=0x01;TXstr[7]=0x04;TXstr[8]=keytype;
 TXstr[9]=IBRad_EoM;tx_le=10;

 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK); 
}
//-----------------------------------------------------------------------------
int COM::AnnounceWithVoice()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x13;TXstr[5]=0x00;
 TXstr[6]=IBRad_EoM;tx_le=7;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);
}
//-----------------------------------------------------------------------------
//0123456789a123456789b123456789c
//1295.350,000#00#0#0#0#0#0#0#0#000#
//F,Mo(13),Fi(16),ANT(18),ROOF(20),PAMP(22),ATT(24),DUP(26),SPLIT(28),SQLlev(30) 
int COM::RadioComplete_Get(CString& cstr)
{
 char str[100],tr='#';

 cstr=Fact_s;cstr+=tr;

 _itoa(Mact_n,str,10);
 if (strlen(str) == 1) {str[1]=str[0];str[0]='0';str[2]=0;}
 cstr+=str;cstr+=tr;

 _itoa(FIact_n,str,10);cstr+=str;cstr+=tr;

 ANTsw=0;ANT_Ask();
 _itoa(ANTsw,str,10);cstr+=str;cstr+=tr;

 ROOFsw=0;ROOF_Ask();
 _itoa(ROOFsw,str,10);cstr+=str;cstr+=tr;

 PAMPsw=0;PAMP_Ask();
 _itoa(PAMPsw,str,10);cstr+=str;cstr+=tr;

 ATTsw=0;ATT_Ask();
 _itoa(ATTsw,str,10);cstr+=str;cstr+=tr;

 _itoa(DUPsw,str,10);cstr+=str;cstr+=tr;

 _itoa(VFOspl,str,10);cstr+=str;cstr+=tr;

 SQLlev_n=0;SQLlev_Ask();
 _itoa(SQLlev_n,str,10);
 if (strlen(str) < 3) StrFiLe(str,'0',3);
 cstr+=str;cstr+=tr;

 return 1;
}

int COM::RadioComplete_Set(CString  cstr)
{
 char str[100],tr='#';
 int  pos;

 strcpy(str,(LPCTSTR)cstr);
 pos=StrChPos(str,tr,0);
 str[0]=str[pos+1];str[1]=str[pos+2];str[2]=0;
 Mact_n=atoi(str);strcpy(Mact_s,Marr_s[Mact_n]);

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+4];str[1]=0;
 FIact_n=atoi(str);
 M_Set(Mact_n,FIact_n);

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+6];str[1]=0;
 ANTsw=atoi(str);
 ANT_Switch(ANTsw);

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+8];str[1]=0;
 ROOFsw=atoi(str);
 ROOF_Switch(ROOFsw);

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+10];str[1]=0;
 PAMPsw=atoi(str);
 PAMP_Switch(PAMPsw); 

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+12];str[1]=0;
 ATTsw=atoi(str);
 ATT_Switch(ATTsw);

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+14];str[1]=0;
 DUPsw=atoi(str);
 DUP_Switch(DUPsw);

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+16];str[1]=0;
 VFOspl=atoi(str);
 VFO_SPLIT_Switch(VFOspl);

 strcpy(str,(LPCTSTR)cstr);
 str[0]=str[pos+18];str[1]=str[pos+19];str[2]=str[pos+20];str[3]=0;
 SQLlev_n=atoi(str);
 SQLlev_Set(SQLlev_n);
 
 return 1;
}
//-----------------------------------------------------------------------------
int COM::TestCmd(int subcmd)
{
 int x,le=0;

 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x13;TXstr[5]=0x00;
 TXstr[6]=IBRad_EoM;le=7;
 
 for (x=0;x < le+1;x++) WriteChar(TXstr[x]);
 return GetCOM_RES(IBRad_OK);//Anpassen je nach CMD
}

void COM::SendNOTOK()
{
 TXstr[0]=IBRad_SoM;TXstr[1]=IBRad_SoM;
 TXstr[2]=IBRad_Adr_n;TXstr[3]=IBRad_PcAdr;
 TXstr[4]=0x5C;//******
 TXstr[5]=IBRad_EoM;tx_le=6;
 
 for (int x=0;x < tx_le+1;x++) WriteChar(TXstr[x]); 
}
//*****************************************************************************
/* Siehe auch AskCOM_Idle + AskCOM_Spec (class RemDlg)

Rueckgabewerte allgemein
 -1   =KEINE chars in COM-RX-Buffer
 -2   =Schleife OHNE Ergebnis
 -3   =TIME OUT

Rueckgabewerte fr ICOM CI-V - Bus
 -100     =Wrong ICOM-Data  (i.e. wrong adress)        
 -101     =Return cmd (transmitted to radio)           
 
 IB_COLL  =Collision on ICOM-Bus                       
 IB_OK    =ICOM-Data OK                               
 IB_NOTOK =ICOM-Data NOT OK                          

 0x03     =Frequenz ausgelesen                       
 0x04     =Mode ausgelesen                           
 0x14     =Diverses (s. Tabelle)
 0x15     =Diverses (s. Tabelle)                     
           z.B. SQL     ausgelesen                          
 0x16     =Diverses (s. Tabelle)                      
           z.B. S-Meter ausgelesen                          
 0x1A     =Diverses (s. Tabelle)        
*/

int COM::GetCOM_RES(int retexp)
{
 int res;

 COM_IsPolling=1;
 //VDelay(CMD_Del);//Give Radio some ms to respond TEST
 res=comport.AskCOM_SPEC(retexp);
 if (res == retexp) {/*NBeep();*/return 1;}else return 0;
}

int COM::AskCOM_SPEC(int retexp)
{
 const int     wait=200/*100*/,msgshowtime=1000;
 unsigned long EndT;
 int           res;
 
 COM_IsPolling=1;
 EndT=GetTickCount()+wait;
 res=-1;//ACHTUNG res -> while

 do
  {
   res=comport.ReadCOM();
   switch (res)
    {
     case IBRad_OK   :res=IBRad_OK;   break;
     case IBRad_NOTOK:res=IBRad_NOTOK;break;
     case IBRad_COLL :res=IBRad_COLL; break;

     case          0x03:res=0x03;         break;
     case          0x04:res=0x04;         break;
     case          0x11:res=0x11;         break;
     case          0x12:res=0x12;         break;
     case          0x14:res=0x14;         break;
     case          0x15:res=0x15;         break;
     case          0x16:res=0x16;         break;
     case          0x1A:res=0x1A;         break;

     case          -100:res=-100;         break;//Wrong ICOM-Data (i.e. wrong adress) 
     case          -101:res=-101;         break;//Return cmd (transmitted to radio)  
     
     default           :res=-3;           break;
    }
   if (GetTickCount() > EndT) {res=-3;break;}//TIME OUT 
  }while (res != retexp);

 if (res == -3 && CMD_Conf == 1)//TIME OUT 
  {
   if (_TaMsgWin_ == 0) MyMsgWin((CFrameWnd*)this,IB_msg00,IB_msg04,msgshowtime,0,0,500,100);
  }

 COM_IsPolling=0;
 return res;
}

int COM::AskCOM_IDLE()
{
 int res,msgshowtime=300;

 COM_IsPolling=1;
 res=comport.ReadCOM();
 switch (res)
  {
   case IBRad_OK   :if (CMD_Conf)
                       { 
                        if (_TaMsgWin_ == 0) MyMsgWin((CFrameWnd*)this,IB_msg00,IB_msg02,msgshowtime,0,0,200,150);   		                
                       }
                      res=IBRad_OK;
                      break;
   case IBRad_NOTOK:if (CMD_Conf) 
                       {
                        if (_TaMsgWin_ == 0) MyMsgWin((CFrameWnd*)this,IB_msg00,IB_msg03,msgshowtime,0,0,200,150);   		                
                       }
                      res=IBRad_NOTOK;
                      break;
   case IBRad_COLL :if (CMD_Conf) 
                       {
                        if (_TaMsgWin_ == 0) MyMsgWin((CFrameWnd*)this,IB_msg00,IB_msg01,msgshowtime,0,0,200,150);
                       }
                      res=IBRad_COLL;break;

   case          0x03:if (PtrToRemDisp != NULL) PtrToRemDisp->PostMessage(WM_REMDISP_FREQCHANGE);
                      res=0x03;break;
   case          0x04:RemDisp_UPD=1;
                      if (PtrToRemDisp != NULL) PtrToRemDisp->PostMessage(WM_REMDISP_MOFICHANGE);
                      if (PtrToModeDlg != NULL) PtrToModeDlg->PostMessage(WM_MODEDLG_MOFICHANGE);                      
                      res=0x04;break;
   case          0x12:res=0x12;break;
   case          0x14:res=0x14;break;
   case          0x15:RemDisp_UPD=4;//RemDisp_UPD=1;
                      if (SM_sel) SetSMstr(SMlev_n,1);else SetSMstr(SMlev_n,0);
                      //if (PtrToRemDisp != NULL) PtrToRemDisp->PostMessage(WM_REMDISP_MOFICHANGE);
                      if (PtrToRemDisp != NULL) PtrToRemDisp->PostMessage(WM_REMDISP_SQLSMCHANGE);  
                      res=0x15;break;
   case          0x16:res=0x16;break;   
   case          0x1A:res=0x1A;break;

   case            -1:res=-1;break;  // KEINE chars in COM-RX-Buffer
   case            -2:res=-2;break;  // Schleife OHNE Ergebnis
   case            -3:if (CMD_Conf) 
                       {
                        if (_TaMsgWin_ == 0) MyMsgWin((CFrameWnd*)this,IB_msg00,IB_msg04,msgshowtime,0,0,500,100);
                       }
                      res=-3;break;  // TIME OUT
   case          -100:res=-100;break;//Wrong ICOM-Data (i.e. wrong adress) 
   case          -101:res=-101;break;//Return cmd (transmitted to radio)
   
   default           :res=-3;break;
  }

 COM_IsPolling=0;
 return res;
}

int COM::ReadCOM()
{
 const int     wait=100;//wait=100
 unsigned long ActT,EndT;
 int           read;

 if (RXBufUsed() == 0) return -1;//-----------------------------Buffer leer

 RXc=-1;RXb[0]=-1;EndT=GetTickCount()+wait;
 for (;;)
  {
   read=ReadChar();ActT=GetTickCount();
   if (read == 0xFC) {ClrRXBuf();return IBRad_COLL;}//----------Collision on ICOM-Bus
   if (ActT > EndT) return -3;//--------------------------------TIME OUT
   if (read != IBRad_SoM && RXc == -1) continue;
   if (read == IBRad_SoM)
    {
     if (RXc == -1) {RXc=0;RXb[0]=IBRad_SoM;EndT=GetTickCount()+wait;continue;}
     if (RXc ==  0) {RXc=1;RXb[1]=IBRad_SoM;continue;}
    }
   if (read > -1 ) {RXc++;RXb[RXc]=read;}
   if (read == IBRad_EoM || RXc == 99) break;//EoM || 99=Bufferende
  }//end for
 //------------------------------------------------------------------------------------------------
 if (RXb[0]==IBRad_SoM && RXb[1]==IBRad_SoM && RXb[2]==IBRad_Adr_n && RXb[RXc]==IBRad_EoM)
  {
   return -101;//NBeep();
  }
 //------------------------------------------------------------------------------------------------
 if (RXb[0]==IBRad_SoM && RXb[1]==IBRad_SoM && RXb[3]==IBRad_Adr_n && RXb[RXc]==IBRad_EoM)
  {
   if (RXb[RXc-1]==0xFB)//-------------------------------------Data OK  
    {
     return IBRad_OK;
    }
   if (RXb[RXc-1]==0xFA)//-------------------------------------Data NOT OK 
    {
     return IBRad_NOTOK;
    }
   if (RXb[4] == 0x15)//---------------------------------------0x15		                  
    {
     if (RXb[5] == 0x01)                         //SQL-Zustand                               
      {
	   if (RXb[6] == 0) SQL_oc=0;else SQL_oc=1;         
       return 0x15;
      }
     if (RXb[5] == 0x02)                         //S-Meter
      {
       if (RXb[7] == IBRad_EoM)
        {
         SMlev_n=IB_BCDtoDec(0,RXb[6]);
         return 0x15;
        }
       if (RXb[7] != IBRad_EoM && RXb[8] == IBRad_EoM)
        {
         SMlev_n=IB_BCDtoDec(RXb[6],RXb[7]);
         return 0x15;
        }
      }
    }

   if (RXb[4] == 0x00 || RXb[4] == 0x03)//---------------------------FREQUENZ 0x00/0x03
    {
     RXBufferToFstr(9);return 0x03;
    }
   if (RXb[4] == 0x01 || RXb[4] == 0x04)//---------------------------MODE, FILTER 0x01/0x04
    {
     RXBufferToMoFi(5,6);return 0x04;
    }
     
   if (RXb[4] == 0x11)//---------------------------------------------0x11
    {
     IB_ATTsnFromIBcmd(RXb[5]);return 0x11;             //ATT 
    }
   if (RXb[4] == 0x12)//---------------------------------------------0x12
    {
     ANTsw=RXb[5];return 0x12;                          //ANT
    }
   if (RXb[4] == 0x14)//---------------------------------------------0x14
    {
     if (RXb[5] == 0x01)                                //AF-Level                               
      {
       AFlev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }      
     if (RXb[5] == 0x02)                                //RF-Level                               
      {
       RFlev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }      
     if (RXb[5] == 0x03)                                //SQL-Level                               
      {
       SQLlev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x05)                                //APF-Level                               
      {
       APFlev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x06)                                //NR-Level                                     
      {
       NRlev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x07)                                //PBT-Innenregler                               
      {
       PBTH_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x08)                                //PBT-Aussenregler                               
      {
       PBTL_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x0A)                                //RF-Power                               
      {
       TXPWR_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x0B)                                //MIC-Gain                               
      {
       MIClev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x0C)                                //KEY-Speed                               
      {
       CWSPEED_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }

     if (RXb[5] == 0x0D)                                //MNF1-Level                               
      {
       MNF1lev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x0E)                                //COMP-Level                               
      {
       COMPlev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x12)                                //NB_lev                               
      {
       NBlev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }
     if (RXb[5] == 0x1A)                                //MNF2-Level                               
      {
       MNF2lev_n=IB_BCDtoDec(RXb[6],RXb[7]);return 0x14;
      }       
    }
   if (RXb[4] == 0x16)//---------------------------------------------0x16		                  
    {
     if (RXb[5] == 0x02)                                //PAMP                                
      {
       IB_PAMPsnFromIBcmd(RXb[6]);/*PAMPsw=RXb[6];*/return 0x16;
      }
     if (RXb[5] == 0x12)                                //AGC                                
      {
       AGCsw=RXb[6];return 0x16;
      }
     if (RXb[5] == 0x22)                                //NB                                
      {
       NBsw=RXb[6];return 0x16;
      }
     if (RXb[5] == 0x40)                                //NR                                
      {
       NRsw=RXb[6];return 0x16;
      }
     if (RXb[5] == 0x41)                                //ANF                                
      {
       ANFsw=RXb[6];return 0x16;
      }
     if (RXb[5]==0x4F)                                  //RTTY_TPF
      {
       RTTY_TPFsw_n=RXb[6];return 0x16;
      }
    }
   if (RXb[4] == 0x1A && RXb[5] == 0x00)//---------------------------0x1A,0x00
    {
     RXBufferToFstr(14);// Fact_s   Fact_n
     return 0x1A;
    }
   if (RXb[4] == 0x1A && RXb[5] == 0x03)//---------------------------0x1A,0x03
    {
     FI_SW_BW_lev=RXb[6];return 0x1A;
    }
   if (RXb[4] == 0x1A && RXb[5] == 0x09)//---------------------------0x1A,0x09
    {
     ROOFsw=RXb[6];return 0x1A;                         //Roofing-Filter            
    }
   if (RXb[4] == 0x1A && RXb[5] == 0x05)//---------------------------0x1A,0x05
    {
     if (RXb[6]==0x00)//---------------------------------------------0x1A,0x05,0x00
      {
       if (RXb[7]==0x01)                                //TXPWR
        {
         TXPWR_n=IB_BCDtoDec(RXb[8],RXb[9]);return 0x1A;
        }
       if (RXb[7]==0x09)                                //RTTY_TPF
        {
         RTTY_TPFsw_n=RXb[8];return 0x1A;
        }
       if (RXb[7]==0x10 || RXb[7]==0x75 || RXb[7]==0x78)//RTTY_MF
        {
         RTTY_MFsw_n=RXb[8];return 0x1A;
        }
       if (RXb[7]==0x11 || RXb[7]==0x76 || RXb[7]==0x79)//RTTY_SH
        {
         RTTY_SHsw_n=RXb[8];return 0x1A;
        }
       if (RXb[7]==0x12 || RXb[7]==0x77 || RXb[7]==0x80)//RTTY_KP
        {
         RTTY_KPsw_n=RXb[8];return 0x1A;
        }
       if (RXb[7]==0x13)                                //CWSPEED
        {
         CWSPEED_n=IB_BCDtoDec(RXb[8],RXb[9]);return 0x1A;
        }
       if (RXb[7]==0x92)                                //CI-V Transceive
        {
         IBRad_Tr_n=RXb[8];return 0x1A;
        }
      }
     if (RXb[6]==0x01)//---------------------------------------------0x1A,0x05,0x01
      {
       if (RXb[7]==0x07 || RXb[7]==0x42 || RXb[7]==0x46)//RTTY_RXDEC
        {
         RTTY_RXDECsw_n=RXb[8];return 0x1A;
        }
       if (RXb[7]==0x13)                                //NB-Width
        {
         NBwid_n=IB_BCDtoDec(RXb[8],RXb[9]);return 0x1A;
        }
       if (RXb[7]==0x14)                                //NR-Level
        {
         NRlev_n=IB_BCDtoDec(0,RXb[8]);
         NRlev_n=(NRlev_n*255)/15;
         return 0x1A;
        }
      }
	}
  }else return -100;//Ung. ICOM-Daten: z.B. falsche Adresse
 
 return -2;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
