// R_CWKB.H : Remote f. Radio
// G. TAMM, DF9ZO 2008
//--------------------
#include "stdafx.h"
#include "R_CWKB.H"
#include "TaICOM.h"
//Globals++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CWKB_Dlg *cwkbdlg=0;
CWDisp   * cwdisp=0;
//CWKB_Dlg+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNAMIC(CWKB_Dlg, CDialog)

CWKB_Dlg::CWKB_Dlg(CWnd* pParent /*=NULL*/)
	     :CDialog(CWKB_Dlg::IDD, pParent)        
        , m_dotlen(0)
{
}

CWKB_Dlg::~CWKB_Dlg()
{
}

void CWKB_Dlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   DDX_Slider(pDX, IDC_CWBKDLG_DOTLEN, m_dotlen);
}

BEGIN_MESSAGE_MAP(CWKB_Dlg, CDialog)
   ON_MESSAGE(WM_CWKBDLG_OK,MSG_CWKDlg_OK)

   ON_BN_CLICKED(IDOK, OnOK)
   
   ON_NOTIFY    (NM_RELEASEDCAPTURE, IDC_CWBKDLG_DOTLEN, &CWKB_Dlg::OnReleasedCapture_Slider)
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL CWKB_Dlg::OnInitDialog()
{
 CSliderCtrl* pSL;

 CDialog::OnInitDialog();

 m_hAccel=NULL;
 //m_hAccel=LoadAccelerators(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_CWKBACCEL));
 SetIcon(::LoadIcon(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDR_MAINFRAME)),TRUE);

 pSL=(CSliderCtrl*) GetDlgItem(IDC_CWBKDLG_DOTLEN);
 pSL->SetRangeMin(CW_SpeedMin);
 pSL->SetRangeMax(CW_SpeedMax);
 pSL->SetLineSize(1);pSL->SetPageSize(10);
 pSL->SetPos(CW_Speed);
 
 CW_Calc();
 CW_KbStr[0]=0;
 PtrToCWKBDlg=this;
 comport.ResDTR();

 return TRUE;// return TRUE unless you set the focus to a control
}
//-----------------------------------------------------------------------------
BOOL CWKB_Dlg::PreTranslateMessage(MSG* pMsg)
{
 if(!(m_hAccel && ::TranslateAccelerator(m_hWnd, m_hAccel, pMsg)))
   return CDialog::PreTranslateMessage(pMsg);else return TRUE;

 return CDialog::PreTranslateMessage(pMsg);
 //return=Nonzero if the message was translated and should not be dispatched
 //return=0       if the message was not translated and should be dispatched
}
/*
BOOL CPreTransTestDlg::PreTranslateMessage(MSG* pMsg) 
{
 if(pMsg->message == WM_CHAR)
  {
   ch=(char)pMsg->wParam;
   ch=ChUp(ch);
   res=CW_IsValidChar(ch);
   if (res > -1 && res < 49) On_CWCHAR(ch);
  }

 if(pMsg->message == WM_KEYDOWN)
  {
   if(pMsg->wParam == VK_RETURN) pMsg->wParam=VK_TAB;
  }	
 return CDialog::PreTranslateMessage(pMsg);
}
*/
//-----------------------------------------------------------------------------
LRESULT CWKB_Dlg::MSG_CWKDlg_OK(WPARAM wParam,LPARAM lParam)
{
 OnOK();
 return 0L;
}

void CWKB_Dlg::OnOK()
{
 CSliderCtrl* pSL;

 if (CW_TXing) return;
 UpdateData(TRUE);
 pSL=(CSliderCtrl*) GetDlgItem(IDC_CWBKDLG_DOTLEN);
 m_dotlen=pSL->GetPos();CW_Speed=m_dotlen;
 CW_Calc();

 DestroyWindow();
 //OnOK();Crash
}

void CWKB_Dlg::PostNcDestroy()
{
 delete this;cwkbdlg=0;PtrToCWKBDlg=NULL;
 //CDialog::PostNcDestroy();Crash
}
//-----------------------------------------------------------------------------
void CWKB_Dlg::OnReleasedCapture_Slider(NMHDR *pNMHDR, LRESULT *pResult)
{
 CSliderCtrl* pSL;

 if (CW_TXing || CW_SpeedTest) return;
 CW_SpeedTest=1;
 UpdateData(TRUE);
 pSL=(CSliderCtrl*) GetDlgItem(IDC_CWBKDLG_DOTLEN);
 m_dotlen=pSL->GetPos();CW_Speed=m_dotlen;
 CW_Calc();
 if (PtrToCWDisp != NULL) PtrToCWDisp->SendMessage(WM_CWDISP_SPEEDTEST);
 CW_SpeedTest=0;

 *pResult = 0;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//CWDisp+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IMPLEMENT_DYNCREATE(CWDisp, CFrameWnd)

CWDisp::CWDisp()
{
 FirstRun=1;
 CW_Calc();
 CW_KbStr[0]=0;
 comport.ResDTR();
}

CWDisp::~CWDisp()
{
 if (PtrToCWKBDlg != NULL) PtrToCWKBDlg->SendMessage(WM_CWKBDLG_OK);

 DestroyWindow();
 cwdisp=0;PtrToCWDisp=0; 
}

BEGIN_MESSAGE_MAP(CWDisp, CFrameWnd)
   ON_MESSAGE(WM_CWDISP_SPEEDTEST,MSG_CWDisp_SpeedTest)

   ON_WM_PAINT()
   ON_WM_CHAR()
   ON_WM_KEYDOWN()

   ON_COMMAND(ID_CWDISP_PTEXT1, On_PTEXT_F1)
   ON_COMMAND(ID_CWDISP_PTEXT2, On_PTEXT_F2)
   ON_COMMAND(ID_CWDISP_PTEXT3, On_PTEXT_F3)
   ON_COMMAND(ID_CWDISP_PTEXT4, On_PTEXT_F4)
   ON_COMMAND(ID_CWDISP_PTEXT5, On_PTEXT_F5)
   ON_COMMAND(ID_CWDISP_PTEXT6, On_PTEXT_F6)
   ON_COMMAND(ID_CWDISP_PTEXT7, On_PTEXT_F7)
   ON_COMMAND(ID_CWDISP_PTEXT8, On_PTEXT_F8)   
END_MESSAGE_MAP()
//-----------------------------------------------------------------------------
BOOL CWDisp::PreCreateWindow(CREATESTRUCT& cs)
{
 cs.style|=WS_OVERLAPPEDWINDOW | WS_VISIBLE;
 cs.style=cs.style ^ WS_MAXIMIZEBOX;cs.style=cs.style ^ WS_MINIMIZEBOX;
   
 cs.x=Win_XIOpos+2;cs.y=Win_YIOpos+2;  
 cs.cx=603;cs.cy=400;

 m_hAccel=NULL;
 LoadAccelTable(MAKEINTRESOURCE(IDR_CWDISPACCEL));

 PtrToCWDisp=this;

 return CFrameWnd::PreCreateWindow(cs);
}//Feld=Feld and not Flag
//-----------------------------------------------------------------------------
void CWDisp::OnPaint()
{
 TEXTMETRIC metric;
 CPaintDC   dc(this); 
 //CBrush     Brush,*oldbrush;
 CRect      rect;
 CSize      size;
 CString    cstr("",200),
            DispStr,DispStr_CW;
 char       tmpstr[100]="";
 int        x,y,z,SchrH,SchrH_2,SchrB/*,CharB*/;

 GetClientRect(rect);
 dc.GetTextMetrics(&metric);
 SchrH  =metric.tmHeight+metric.tmExternalLeading;
 SchrH_2=SchrH+SchrH;
 SchrB  =metric.tmAveCharWidth+metric.tmOverhang;

 if (FirstRun)
  {
   FirstRun=0;
  }
 
 VERIFY(font.CreateFont(
   fontH,                     // nHeight
   0,                         // nWidth
   0,                         // nEscapement
   0,                         // nOrientation
   FW_MEDIUM,                 // nWeight
   FALSE,                     // bItalic
   FALSE,                     // bUnderline
   0,                         // cStrikeOut
   ANSI_FIXED_FONT,           // nCharSet
   OUT_DEFAULT_PRECIS,        // nOutPrecision
   CLIP_DEFAULT_PRECIS,       // nClipPrecision
   DEFAULT_QUALITY,           // nQuality
   DEFAULT_PITCH | FF_MODERN, // nPitchAndFamily
   _T("Terminal")));          // lpszFacename

 oldfont=(CFont*)dc.SelectObject(&font);
 x=0;y=0;
 dc.SetBkMode(TRANSPARENT);
 dc.SetTextColor(blue);
 DispStr="Valid Characters:";dc.TextOut(0,y,DispStr);y+=SchrH;
 dc.SetTextColor(green); 
 DispStr="[a-z][0-9][.,:;?-=()/+]";dc.TextOut(0,y,DispStr);y+=SchrH; 
 DispStr="[*]    : ERROR (........) [#]: SK (...-.-  )";    dc.TextOut(0,y,DispStr);y+=SchrH; 
 DispStr="[SPACE]: Pause between words";                    dc.TextOut(0,y,DispStr);y+=SchrH;
 DispStr="[DEL]  : Del. Char-Buffer [BACK]: Del. last Char";dc.TextOut(0,y,DispStr);y+=SchrH;

 dc.SetTextColor(blue);
 DispStr="Predefined Texts (TaICOM.ini):";dc.TextOut(0,y,DispStr);y+=SchrH;
 dc.SetTextColor(green);  
 if (CWStr_ini[0][0] != 0) {DispStr="[F1]: ";DispStr+=CWStr_ini[0];dc.TextOut(0,y,DispStr);y+=SchrH;}
 if (CWStr_ini[1][0] != 0) {DispStr="[F2]: ";DispStr+=CWStr_ini[1];dc.TextOut(0,y,DispStr);y+=SchrH;}    
 if (CWStr_ini[2][0] != 0) {DispStr="[F3]: ";DispStr+=CWStr_ini[2];dc.TextOut(0,y,DispStr);y+=SchrH;}
 if (CWStr_ini[3][0] != 0) {DispStr="[F4]: ";DispStr+=CWStr_ini[3];dc.TextOut(0,y,DispStr);y+=SchrH;}
 if (CWStr_ini[4][0] != 0) {DispStr="[F5]: ";DispStr+=CWStr_ini[4];dc.TextOut(0,y,DispStr);y+=SchrH;}
 if (CWStr_ini[5][0] != 0) {DispStr="[F6]: ";DispStr+=CWStr_ini[5];dc.TextOut(0,y,DispStr);y+=SchrH;}
 if (CWStr_ini[6][0] != 0) {DispStr="[F7]: ";DispStr+=CWStr_ini[6];dc.TextOut(0,y,DispStr);y+=SchrH;}
 if (CWStr_ini[7][0] != 0) {DispStr="[F8]: ";DispStr+=CWStr_ini[7];dc.TextOut(0,y,DispStr);y+=SchrH;}

 y+=SchrH;
 dc.SetTextColor(blue);
 DispStr="Keyboard-Buffer: ";dc.TextOut(0,y,DispStr);y+=SchrH_2;
 dc.SetTextColor(black);
 DispStr=CW_KbStr;dc.TextOut(0,y,DispStr);y+=SchrH_2;

 if (CW_KbStr[0] != 0)
  {
   dc.SetTextColor(red);
   DispStr=CW_KbStr[0];DispStr+="        ";
   z=CW_IsValidChar(CW_KbStr[0]);
   DispStr_CW=CW_Chars_CW[z];
   DispStr+=DispStr_CW;
   dc.TextOut(0,y,DispStr);//y+=SchrH;     
  } 

 dc.SelectObject(&oldfont);
 font.DeleteObject();
}
//-----------------------------------------------------------------------------
void CWDisp::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
 int  le,res;

 nChar=ChUp(nChar);
 le=strlen(CW_KbStr);
 res=CW_IsValidChar(nChar);
 if (le < 199 && res > -1)
  {
   CW_KbStr[le]=(char)nChar;CW_KbStr[le+1]='\0';le++;
   Invalidate();
   Operate();
  } 

 CFrameWnd::OnChar(nChar, nRepCnt, nFlags);
}

void CWDisp::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
 int le;

 switch (nChar)
  {
   case VK_DELETE :CW_KbStr[0]=0;Invalidate();
                   break;
   case VK_BACK   :le=strlen(CW_KbStr);
	                if (le > 1) {CW_KbStr[le-1]='\0';Invalidate();}
                   break; 
 /*case VK_SPACE  :le=strlen(CW_KbStr);
                   CW_KbStr[le]=' ';CW_KbStr[le+1]='\0';
                   Invalidate();
                   Operate();    
                   break; */ 
   default        :break;
  }	 

 CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}
//-----------------------------------------------------------------------------
void CWDisp::On_PTEXT_F1() {DoPTEXT(1);}
void CWDisp::On_PTEXT_F2() {DoPTEXT(2);}
void CWDisp::On_PTEXT_F3() {DoPTEXT(3);}
void CWDisp::On_PTEXT_F4() {DoPTEXT(4);}
void CWDisp::On_PTEXT_F5() {DoPTEXT(5);}
void CWDisp::On_PTEXT_F6() {DoPTEXT(6);}
void CWDisp::On_PTEXT_F7() {DoPTEXT(7);}
void CWDisp::On_PTEXT_F8() {DoPTEXT(8);}

void CWDisp::DoPTEXT(int num)
{
 int le,x;

 //TaMsgBox(AppName,CWStr_ini[num-1],2);SetFocus();return;//Test
 strcpy(CWStr,CWStr_ini[num-1]);
 if (CWStr[0] == 0) return;

 le=strlen(CWStr);
 for (x=0;x < le;x++) CWStr[x]=ChUp(CWStr[x]); 
 le=strlen(CW_KbStr);
 if (le > 150) return;

 strcat(CW_KbStr,CWStr);
 Invalidate();
 Operate();
}
//-----------------------------------------------------------------------------
LRESULT CWDisp::MSG_CWDisp_SpeedTest(WPARAM wParam,LPARAM lParam)
{
 char         cwstr[]="TEST";
 int          le,x;

 le=strlen(cwstr); 
 for (x=0;x < le;x++)
  {
   CW_KbStr[0]=cwstr[x];CW_KbStr[1]=0;
   TxCW(CW_KbStr[0]);   
  }
  
 return 0L;
}

void CWDisp::Operate()
{
 int le;

 if (CW_TXing || CW_SpeedTest) return;
 CW_TXing=1;
 do 
  {
   TxCW(CW_KbStr[0]);
   Invalidate(TRUE);
   StrDelChPos(CW_KbStr,0);
   KeepWindowsAlive();//Neuer Buchstabe ???
   le=strlen(CW_KbStr);   
  } while (le > 0);
 CW_TXing=0; 
}

void CWDisp::TxCW(char ch)
{
 char     cwstr[200];
 int      le,x;

 x=CW_IsValidChar(ch);
 strcpy(cwstr,CW_Chars_CW[x]);
 le=strlen(cwstr);

 if (CW_SpeedTest)
  {
   for (x=0;x < le;x++)
    {            
     if (cwstr[x] == '.') VBeep(CW_Pitch,CW_DOT);
     if (cwstr[x] == '-') VBeep(CW_Pitch,CW_DASH);
     VDelay(CW_B_CHARCOMP);   
    }
   VDelay(CW_B_CHAR);  
  }else
  {
   for (x=0;x < le;x++)
    {
     if (cwstr[x] == '.') {comport.SetDTR();VDelay(CW_DOT) ;comport.ResDTR();}
     if (cwstr[x] == '-') {comport.SetDTR();VDelay(CW_DASH);comport.ResDTR();}
     VDelay(CW_B_CHARCOMP);
    }
   VDelay(CW_B_CHAR); 
  }
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
void CWDisp::TxCW(char ch)

*/








