$regfile = "m8def.dat"

$hwstack = 40
$swstack = 32
$framesize = 40

$crystal = 16000000
$baud = 9600


'Konfiguriere I2C-Bus
Config Scl = Portc.5
Config Sda = Portc.4

'Konstanten I2C-Addressen
Const Wr = &B10100000
Const Rd = &B10100001

I2cinit


'Konfiguriere PORT C
Config Pinc.3 = Output                                      'Kanal 1
Config Pinc.2 = Output                                      'Kanal 2
Config Pinc.1 = Input                                       'Taste

Kanal1 Alias Portc.3
Kanal2 Alias Portc.2
Taste Alias Pinc.1

'Hier wird die Zeitbasis festgelegt
'aktuell etwa 1ms / 1kHz
On Ovf0 Uba_zg0                                             'Interrupt-Routine fr Timer0 berlauf
Config Timer0 = Timer , Prescale = 1024                     'Takt: Quarz/1024=15625Hz
Timer0 = 240


Declare Sub Schreibe_bitmuster(laenge As Long , Byval Startposition As Integer)
Declare Sub Schreibe_eeprom(byval Adresse As Integer , Byval Wert As Byte)
Declare Function Lese_eeprom(byval Adresse As Integer) As Byte
Declare Sub Schreibe_eeprom_long(byval Adresse As Integer , Byval Wert As Long)
Declare Function Lese_eeprom_long(byval Adresse As Integer) As Long
Declare Sub Kanal_meister(byval Welcherkanal As Byte , Wert As Byte)

'Allgemeine Variablen
Dim Temp1 As Long At $60

'Bitmuster-Kopf Kanal 1 und 2
Dim Startbed_k1 As Byte At $64 , Startbed_k2 As Byte At $65
Dim Dauer_startbedingung As Long At $66
Dim Verzoegerung_k1 As Long At $6a , Verzoegerung_k2 As Long At $6e
Dim Dauer_null(4) As Long At $72 , Dauer_eins(4) As Long At $82
Dim Wiederholungen As Long At $92 , Laenge_k1 As Long At $96 , Laenge_k2 As Long At $9a
'Bitmuster Kanal 1 und 2
'Dim Bimu_k1(256) As Byte at $9e , Bimu_k2(256) As Byte at $19e
Dim Bimu_k1(256) As Byte , Bimu_k2(256) As Byte

'Allgemeine Variablen
Dim Temp2 As Byte , Temp3 As Long
Dim I As Integer , Bis As Integer , Zaehler As Integer , Zaehler2 As Integer
Dim Gedrueckt As Byte , Neuladen As Byte , Laeuft As Byte
Dim Prfsum As Long , Prfsum_tmp As Long
Dim Wdh_tmp As Long

'$dbg
Reset Kanal1
Reset Kanal2

'Rcksetzen wenn Taste beim Einschalten gedrckt ist
If Taste = 1 Then
   'Kanal 1 und 2 einschalten
   Set Kanal1
   Set Kanal2

   For I = 0 To 1023
       Schreibe_eeprom I , 255
   Next
   'Schreibe Kopf
   '10     = Startbedingung Kanal 1
   '11     = Startbedingung Kanal 2
   '12     = n.v.
   '13-16   = Wiederholungen
   '17-20  = Dauer Startbedingung
   '21-24 = Startverzgerung Kanal 1
   '25-28 = Startverzgerung Kanal 2
   '29-32 = Dauer "Null" Kanal 1
   '33-36 = Dauer "Null" Kanal 2
   '37-40 = Dauer "Eins" Kanal 1
   '41-44 = Dauer "Eins" Kanal 2
   '45-48 = Lnge Kanal 1
   '49-52 = Lnge Kanal 2
   'Byte-Werte
   Restore Datentabelle1
   For I = 10 To 12
       Read Temp2
       Schreibe_eeprom I , Temp2
   Next
   'Long-Werte
   Restore Datentabelle2
   For I = 13 To 49 Step 4
       Read Temp3
       Schreibe_eeprom_long I , Temp3
   Next
   'Schreibe Bitmuster Kanal 1
   Restore Datentabelle3
   For I = 256 To 278
       Read Temp2
       Schreibe_eeprom I , Temp2
       'Schreibe Bitmuster Kanal 2
       Zaehler = I + 256
       Schreibe_eeprom Zaehler , Temp2
   Next

   'Blinken wenn Fertig
   Reset Kanal1
   Reset Kanal2
   Waitms 100
   Set Kanal1
   Set Kanal2
   Waitms 100
   Reset Kanal1
   Reset Kanal2
   Waitms 100
   Set Kanal1
   Set Kanal2
   Waitms 100
End If

'Warte bis Taste in Ruhestellung
Zaehler = 0
While Zaehler < 5000
   If Taste = 0 Then Incr Zaehler
Wend


'Lade Daten (Kopf)
Gosub Ladekopf
'Lade Bitmuster
Gosub Ladebitmuster

Neustart:
Reset Kanal1
Reset Kanal2
Print Chr(12) ; "PBMG-1 von E.Mueller, 2008"
Print ""
Print "Programmierung nur mit Programm PBMG1 moeglich !"
Neuladen = 0
Laeuft = 0
Gedrueckt = 0
Do
   Select Case Inkey()
      Case Chr(200) : Goto Daten_empfangen
      Case Chr(205) : Goto Daten_senden
      'Case Chr(12) : Goto Neustart
   End Select
   'Neuladen
   If Neuladen = 1 Then
      Neuladen = 0
      Gosub Ladekopf
      Gosub Ladebitmuster
      Reset Kanal1
      Reset Kanal2
      If Laeuft = 1 Then
         Timer0 = 240
         Enable Interrupts
         Enable Timer0
      End If
   End If
   'Frage Taste ab
   If Taste = 1 Then Incr Zaehler Else Zaehler = 0
   If Zaehler > 5000 Then
      Zaehler = 0
      Gedrueckt = 1
   End If
   If Gedrueckt = 1 Then
      If Taste = 0 Then Incr Zaehler2 Else Zaehler2 = 0
      If Zaehler2 > 5000 Then
         Zaehler2 = 0
         Gedrueckt = 0
         Neuladen = 0
         If Laeuft = 0 Then
            Timer0 = 240
            Enable Interrupts
            Enable Timer0
            Laeuft = 1
            Wdh_tmp = 0
         Else
            Disable Interrupts
            Disable Timer0
            Laeuft = 0
            Neuladen = 1
         End If
      End If
   End If
Loop


Uba_zg0:
'   Dbg
   Timer0 = 240
   'Los gehts
   If Dauer_startbedingung > -1 Then
      Kanal_meister 1 , Startbed_k1
      Kanal_meister 2 , Startbed_k2
      Decr Dauer_startbedingung
   Else
      'Kanal 1
      If Verzoegerung_k1 > 0 Then
         Decr Verzoegerung_k1
      Else
         If Laenge_k1 > -1 Then
            Kanal_meister 1 , Bimu_k1(laenge_k1)
            If Bimu_k1(laenge_k1) = 1 Then
               If Dauer_eins(1) = 0 Then
                  Decr Laenge_k1
                  Dauer_eins(1) = Dauer_eins(2)
               Else
                  Decr Dauer_eins(1)
               End If
            Else
               If Dauer_null(1) = 0 Then
                  Decr Laenge_k1
                  Dauer_null(1) = Dauer_null(2)
               Else
                  Decr Dauer_null(1)
               End If
            End If
         End If
      End If
      'Kanal 2
      If Verzoegerung_k2 > 0 Then
         Decr Verzoegerung_k2
      Else
         If Laenge_k2 > -1 Then
            Kanal_meister 2 , Bimu_k2(laenge_k2)
            If Bimu_k2(laenge_k2) = 1 Then
               If Dauer_eins(3) = 0 Then
                  Decr Laenge_k2
                  Dauer_eins(3) = Dauer_eins(4)
               Else
                  Decr Dauer_eins(3)
               End If
            Else
               If Dauer_null(3) = 0 Then
                  Decr Laenge_k2
                  Dauer_null(3) = Dauer_null(4)
               Else
                  Decr Dauer_null(3)
               End If
            End If
         End If
      End If
      'Alles abgearbeitet?
      If Laenge_k1 <= 0 Then
         If Laenge_k2 <= 0 Then
            Disable Interrupts
            Disable Timer0
            Neuladen = 1
            If Wiederholungen > 0 Then
               Incr Wdh_tmp
               If Wdh_tmp >= Wiederholungen Then Laeuft = 0
            End If
         End If
      End If
   End If
Return


Daten_senden:
'--- UBA ausschalten
Disable Interrupts
Disable Timer0
'Lade Daten (Kopf)
Gosub Ladekopf
'---

Print Chr(200);
Prfsum_tmp = 0
For I = $64 To $9d
    Temp2 = Inp(i)
    Prfsum_tmp = Prfsum_tmp + Temp2
    Print Chr(temp2);
    'Falls erforderlich
    Gosub I_plus_4
Next
Prfsum = Prfsum_tmp / 42

If Laenge_k1 = 0 Then
   Print Chr(201);
Else
   Prfsum_tmp = 0
   For I = Laenge_k1 To 1 Step -1
       Temp2 = Bimu_k1(i)
       Prfsum_tmp = Prfsum_tmp + Temp2
       Print Chr(temp2);
   Next
End If
If Laenge_k1 > 0 Then
   Temp1 = Prfsum_tmp / Laenge_k1
   Prfsum = Prfsum + Temp1
End If

If Laenge_k2 = 0 Then
   Print Chr(201);
Else
   Prfsum_tmp = 0
   For I = Laenge_k2 To 1 Step -1
       Temp2 = Bimu_k2(i)
       Prfsum_tmp = Prfsum_tmp + Temp2
       Print Chr(temp2);
   Next
End If
If Laenge_k2 > 0 Then
   Temp1 = Prfsum_tmp / Laenge_k2
   Prfsum = Prfsum + Temp1
End If

Print Chr(202) ; Str(prfsum) ; Chr(203);

Goto Neustart


Daten_empfangen:
'--- UBA ausschalten
Disable Interrupts
Disable Timer0
'---

Prfsum_tmp = 0
For I = $64 To $9d
    Inputbin Temp2
    Out I , Temp2
    Prfsum_tmp = Prfsum_tmp + Temp2
    'Falls erforderlich
    Gosub I_plus_4
Next
Prfsum = Prfsum_tmp / 42

If Laenge_k1 = 0 Then
   Inputbin Temp2
Else
   Prfsum_tmp = 0
   For I = Laenge_k1 To 1 Step -1
       Inputbin Temp2
       Bimu_k1(i) = Temp2
       Prfsum_tmp = Prfsum_tmp + Temp2
   Next
End If
If Laenge_k1 > 0 Then
   Temp1 = Prfsum_tmp / Laenge_k1
   Prfsum = Prfsum + Temp1
End If

If Laenge_k2 = 0 Then
   Inputbin Temp2
Else
   Prfsum_tmp = 0
   For I = Laenge_k2 To 1 Step -1
       Inputbin Temp2
       Bimu_k2(i) = Temp2
       Prfsum_tmp = Prfsum_tmp + Temp2
   Next
End If
If Laenge_k2 > 0 Then
   Temp1 = Prfsum_tmp / Laenge_k2
   Prfsum = Prfsum + Temp1
End If

Print Chr(202) ; Str(prfsum) ; Chr(203);

Gosub Schreibekopf
Gosub Schreibebitmuster

Print Chr(206);

Dauer_null(2) = Dauer_null(1)                               'K1
Dauer_null(4) = Dauer_null(3)                               'K2
Dauer_eins(2) = Dauer_eins(1)                               'K1
Dauer_eins(4) = Dauer_eins(3)                               'K2

Goto Neustart


I_plus_4:
'Dbg
Select Case I
   Case $75 : I = I + 4
   Case $7d : I = I + 4
   Case $85 : I = I + 4
   Case $8d : I = I + 4
End Select
Return


Ladekopf:
'Dbg
'Lade Daten (Kopf)
Startbed_k1 = Lese_eeprom(10)
Startbed_k2 = Lese_eeprom(11)
Wiederholungen = Lese_eeprom_long(13)
Dauer_startbedingung = Lese_eeprom_long(17)
Verzoegerung_k1 = Lese_eeprom_long(21)
Verzoegerung_k2 = Lese_eeprom_long(25)
Dauer_null(1) = Lese_eeprom_long(29)                        'K1
Dauer_null(2) = Dauer_null(1)                               'K1
Dauer_null(3) = Lese_eeprom_long(33)                        'K2
Dauer_null(4) = Dauer_null(3)                               'K2
Dauer_eins(1) = Lese_eeprom_long(37)                        'K1
Dauer_eins(2) = Dauer_eins(1)                               'K1
Dauer_eins(3) = Lese_eeprom_long(41)                        'K2
Dauer_eins(4) = Dauer_eins(3)                               'K2
Laenge_k1 = Lese_eeprom_long(45)
Laenge_k2 = Lese_eeprom_long(49)
Return

Schreibekopf:
'Dbg
'Schreibe Daten (Kopf)
Schreibe_eeprom 10 , Startbed_k1
Schreibe_eeprom 11 , Startbed_k2
Schreibe_eeprom_long 13 , Wiederholungen
Schreibe_eeprom_long 17 , Dauer_startbedingung
Schreibe_eeprom_long 21 , Verzoegerung_k1
Schreibe_eeprom_long 25 , Verzoegerung_k2
Schreibe_eeprom_long 29 , Dauer_null(1)                     'K1
Schreibe_eeprom_long 33 , Dauer_null(3)                     'K2
Schreibe_eeprom_long 37 , Dauer_eins(1)                     'K1
Schreibe_eeprom_long 41 , Dauer_eins(3)                     'K2
Schreibe_eeprom_long 45 , Laenge_k1
Schreibe_eeprom_long 49 , Laenge_k2
Return

Ladebitmuster:
'Dbg
'Lade Bitmuster Kanal 1
If Laenge_k1 > 0 Then
   Bis = 255 + Laenge_k1
   Zaehler = Laenge_k1
   For I = 256 To Bis
       Bimu_k1(zaehler) = Lese_eeprom(i)
       Decr Zaehler
   Next
End If
'Lade Bitmuster Kanal 2
If Laenge_k2 > 0 Then
   Bis = 511 + Laenge_k2
   Zaehler = Laenge_k2
   For I = 512 To Bis
       Bimu_k2(zaehler) = Lese_eeprom(i)
       Decr Zaehler
   Next
End If
Return

Schreibebitmuster:
'Dbg
'Schreibe Bitmuster Kanal 1
If Laenge_k1 > 0 Then
   Bis = 255 + Laenge_k1
   Zaehler = Laenge_k1
   For I = 256 To Bis
       Schreibe_eeprom I , Bimu_k1(zaehler)
       Decr Zaehler
   Next
End If
'Schreibe Bitmuster Kanal 2
If Laenge_k2 > 0 Then
   Bis = 511 + Laenge_k2
   Zaehler = Laenge_k2
   For I = 512 To Bis
       Schreibe_eeprom I , Bimu_k2(zaehler)
       Decr Zaehler
   Next
End If
Return


End



Sub Kanal_meister(byval Welcherkanal As Byte , Wert As Byte)
'    Dbg
    If Wert = 1 Then
       If Welcherkanal = 1 Then
          Set Kanal1
       Else
          Set Kanal2
       End If
    Else
       If Welcherkanal = 1 Then
          Reset Kanal1
       Else
          Reset Kanal2
       End If
    End If
End Sub

Sub Schreibe_eeprom_long(byval Adresse As Integer , Byval Wert As Long)
'    dbg
    Local Sel_temp As Byte , Sel_adr As Integer
    Temp1 = Wert
    Sel_temp = Inp($63)
    Sel_adr = Adresse
    Schreibe_eeprom Sel_adr , Sel_temp
    Sel_temp = Inp($62)
    Incr Sel_adr
    Schreibe_eeprom Sel_adr , Sel_temp
    Sel_temp = Inp($61)
    Incr Sel_adr
    Schreibe_eeprom Sel_adr , Sel_temp
    Sel_temp = Inp($60)
    Incr Sel_adr
    Schreibe_eeprom Sel_adr , Sel_temp
End Sub

Function Lese_eeprom_long(byval Adresse As Integer) As Long
'    dbg
    Local Lel_temp As Byte , Lel_adr As Integer
    Temp1 = 0
    Lel_adr = Adresse
    Lel_temp = Lese_eeprom(lel_adr)
    Out $63 , Lel_temp
    Lel_adr = Adresse + 1
    Lel_temp = Lese_eeprom(lel_adr)
    Out $62 , Lel_temp
    Lel_adr = Adresse + 2
    Lel_temp = Lese_eeprom(lel_adr)
    Out $61 , Lel_temp
    Lel_adr = Adresse + 3
    Lel_temp = Lese_eeprom(lel_adr)
    Out $60 , Lel_temp
    Lese_eeprom_long = Temp1
End Function

Sub Schreibe_eeprom(byval Adresse As Integer , Byval Wert As Byte)
'    dbg
    Local Se_temp As Byte , Se_adrh As Byte , Se_adrl As Byte
    Se_adrh = High(adresse)
    Se_adrh = Se_adrh And &H07
    Shift Se_adrh , Left , 1
    Se_adrh = Se_adrh + Wr
    Se_adrl = Low(adresse)
    Se_temp = Wert
    I2cstart                                                'Startbedingung
    I2cwbyte Se_adrh                                        'Schreibe sogenannte "Slave"-Addresse
    I2cwbyte Se_adrl                                        'Schreibe EEPROM-Adresse
    I2cwbyte Se_temp                                        'Schreibe Wert
    I2cstop                                                 'Stopbedingung
    Waitms 5
    'Print Str(adresse) + ":" + Str(se_temp)
End Sub

Function Lese_eeprom(byval Adresse As Integer) As Byte
'    dbg
    Local Le_temp As Byte , Le_adrh As Byte , Le_adrl As Byte
    Le_adrh = High(adresse)
    Le_adrh = Le_adrh And &H07
    Shift Le_adrh , Left , 1
    Le_adrh = Le_adrh + Wr
    Le_adrl = Low(adresse)
    I2cstart                                                'Startbedingung
    I2cwbyte Le_adrh                                        'Schreibe sogenannte "Slave"-Addresse
    I2cwbyte Le_adrl                                        'Schreibe EEPROM-Adresse
    I2cstart                                                'Startbedingung wiederholen
    I2cwbyte Rd                                             'Schreibe/Lese sogenannte "Slave"-Addresse
    I2crbyte Le_temp , Nack                                 'Lese Byte
    I2cstop
    Lese_eeprom = Le_temp
End Function


Datentabelle1:
Data 0 , 0 , 255
Datentabelle2:
Data 0& , 1000& , 0& , 0& , 250& , 250& , 250& , 250& , 23& , 23&
Datentabelle3:
Data 1 , 0 , 1 , 0 , 1 , 0 , 0 , 1 , 1 , 0 , 1 , 1 , 0 , 1 , 1 , 0 , 0 , 1 , 0 , 1 , 0 , 1 , 0