'*******************************************************************************
' KLINGEL - TRFFNER - AUTOMAT /reloaded/ mit ATtiny25/45/85
' V1.1 Julien Thomas
'*******************************************************************************
'
$regfile = "attiny25.dat"
$crystal = 16000
' ^^^^ Hinweise zu den Fusebits beachten!!!
'
' ------------------------------------------------------------------------------
' HARDWAREBESCHREIBUNG
' ------------------------------------------------------------------------------
' Chip  : AVR ATtiny25/45/85
' Fuses : CLKSEL 3,2,1,0 = 0,1,0,0 (interner Taktoszillator 128 kHz aktiviert)
'         CKDIV8 = 0 (Teiler durch 8 aktiviert = Prozessortakt 16 kHz)
' PB0-2 : MOSI, MISO, SCK (ISP-exklusiv)
' PB1   : Auf Masse gelegt + Dauerklingeln --> Rcksetzen Default-Klingelcode
' PB3   : Eingang Klingelsignal (auf 5V begrenzte 50-Hz-Impulse)
' PB4   : Ausgang Relaistreiber (High = Ein, Low = Aus)
' PB5   : RESET (nur mit Pullup beschaltet)
'
'
' ------------------------------------------------------------------------------
' VARIABLE UND KONSTANTEN
' ------------------------------------------------------------------------------
Dim A As Byte
Dim B As Byte
Dim I As Byte
Dim Z As Byte
Klingel Alias Pinb.3
Relais Alias Portb.4
Const Schritte = 6                              '6 Schritte
Const Punkt = 85                                'komplementre Bitmuster fr
Const Strich = 171                              'Speicherung der Punkte/Striche
'
'
' ------------------------------------------------------------------------------
' INITIALISIERUNG
' ------------------------------------------------------------------------------
Main:
 Ddrb = &B00010000
Portb = &B00000010
Wait 1
If Pinb.1 = 1 Then Goto Codepruefung            'Jumper offen = Normalbetrieb
'
'
' ------------------------------------------------------------------------------
' CODE ZURCKSETZEN, WENN RESET-MODUS (J1 GESETZT)
' ------------------------------------------------------------------------------
Z = Punkt                                       'Default
For I = 1 To Schritte                           'Nr. 1 bis Anzahl Schritte
Writeeeprom Z , I
Waitms 10
Next I
Gosub Codeecho
End
'
'
' ------------------------------------------------------------------------------
' CODE PRFEN, WENN NORMALBETRIEB (J1 OFFEN)
' ------------------------------------------------------------------------------
Codepruefung:
Gosub Warte_auf_pause                           '1. langes Klingeln abwarten
For I = 1 To Schritte                           'Kl. Nr. 1 bis Anzahl Schritte
        Gosub Warte_auf_pause                   'einlesen
        Readeeprom A , I
        If A <> Z Then End                      'wenn ungleich -> Endlosschleife
Next
Gosub Warte_auf_klingel
Relais = 1
Wait 5
Relais = 0
'
'
' ------------------------------------------------------------------------------
' CODE SPEICHERN
' ------------------------------------------------------------------------------
Codeeingabe:
Gosub Warte_auf_pause
For I = 1 To Schritte                           'Kl. Nr. 1 bis Anzahl Schritte
Gosub Warte_auf_pause                           'einlesen, Ergebnis in Z
Writeeeprom Z , I
Next
'
Wait 1
Gosub Warte_auf_klingel                         'Auf neue Energie warten...
Gosub Codeecho                                  'Wiederholung des Codes
End
'
'
' ------------------------------------------------------------------------------
' Unterprogramme zur Auswertung des Klingelsignals
' ------------------------------------------------------------------------------
'
' Auf Pause warten / Klingeldauer auswerten  - Rckgabewert Z (Punkt/Strich)
Warte_auf_pause:
A = 0
Z = Punkt
'
While Klingel = 0 : Wend                        'Signal abwarten
'
Wap1:
While Klingel = 1                               'Positive Halbwelle
Delay                                           'entprellen
Wend                                            'und abwarten
Incr A                                          'Perioden zhlen
If A > 25 Then Z = Strich                       'mehr als 25 Zyklen = Strich
'
B = 0
While Klingel = 0                               'neg. Halbwelle durchmessen
        Delay                                   'wenn Pause grer
        Incr B                                  'als 50 ms
        If B > 50 Then Exit While               'Knopf losgelassen
Wend
'
If B < 50 Then Goto Wap1
Return
'
'
' Auf Klingeln warten / Pause abwarten
Warte_auf_klingel:
While Klingel = 0 : Delay : Wend
Return
'
'
' ------------------------------------------------------------------------------
' Unterprogramm zur Kontrolle des Klingelcodes
' ------------------------------------------------------------------------------
Codeecho:
Wait 1
For I = 1 To Schritte
        Readeeprom Z , I
        Relais = 1
        If Z = Strich Then Waitms 900
        If Z = Punkt Then Waitms 200
        Relais = 0
        Waitms 400
        Next I
Return
'
'
' ------------------------------------------------------------------------------
'
