/*----------------------------------------------------------------------------------------
|
| TR2200GX with Silabs Si570 LO control firmware
|
| Author: Wulf-Gerd Traving, DL1FAC 2008
|
|-----------------------------------------------------------------------------------------
| License:
| This program is free software; you can redistribute it and/or modify it under
| the terms of the GNU General Public License as published by the Free Software
| Foundation; either version 2 of the License, or (at your option) any later
| version.
| This program is distributed in the hope that it will be useful, but
|
| WITHOUT ANY WARRANTY;
|
| without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
| PURPOSE. See the GNU General Public License for more details.
|
| You should have received a copy of the GNU General Public License along with
| this program; if not, write to the Free Software Foundation, Inc., 51
| Franklin St, Fifth Floor, Boston, MA 02110, USA
|
| http://www.gnu.de/gpl-ger.html
`-----------------------------------------------------------------------------------------*/

/* CPU frequency */
#define F_CPU 8000000UL


// original fuses: 0xff, 0x5D, 0xE1 (no Reset, no self programming, no debug wire, spi download on, brown out 2.7V, PLL clock)
// now: 0xff, 0xdd, 0xe2 (internal 8MHz clock and enable RESET PB5 to allow serial reprogramming)

// IF frequency (negative offset during receive)
#define ZF 10700000l

/*
I/O connects
Port B0 - (SDA) PTT active low input
     B1 - SDA I2C to Si570
	  B2 - (SCL) ADC1 analog input 0...2.5V channel/frequency dial
	  B3 - SCL I2C to Si570
	  B4 - High=Channel Mode, Low=VFO Mode
	  B5 - (RESET) (may be SQL or REV input later)
*/

#define CHANVFO (PINB & 0x10)
#define REVERSE (PINB & 0x20)
#define PTT (PINB & 0x01)

// check for freq updates every nn ms
#define UPDATEINTERVAL 5l
// scan next channel every 1s, that is every nn UPDATEINTERVAL
#define SCANINTERVAL (1000l/UPDATEINTERVAL)
// hold scan for 10s, if signal detected
#define HOLDINTERVAL (20000l/UPDATEINTERVAL)
