;FT817_FT857 automatische Auswahl der Bnder ber die Band Data Buchse 

;----------processor type-		
			list	p=18f252


;---------include files
#include P18F252.inc  ;standard include file


;Configuration bits 
    CONFIG      OSC = hs            ; xt 10 MHz 
    CONFIG      PWRT = on           ; power up timer on 
    CONFIG      BOR = on            ; brown out detect off 
    CONFIG      WDT = off           ; watchdog off 
    CONFIG      LVP = off           ; lvp off 
	CONFIG		BORV = 27			;brown out voltage: 2,7 V 

;----------ersetzungen
#define		ctcss_in					PORTB, 0	;ctcss input

#define		hysterese_ein_aus				PORTB, 1	;bei low: hysterese aus

;#define		ctcss_da_plus				PORTB, 1	;ctcss erkennung output positive logik
#define		ctcss_da_plus1				PORTA, 1	;ctcss erkennung output positive logik
#define		ctcss_da_minus				PORTA, 2	;ctcss erkennung output negative logik
#define		_1750hz_da_plus				PORTA, 3	;1750hz erkennung output positive logik
#define		_1750hz_da_minus			PORTA, 4	;1750hz erkennung output negative logik
#define		ctcss_led					PORTA, 5	;wird ctcss ton gesendet geht dieser pin auf high, output



#define		ctcss_senden				PORTA, 0	;ctcss ton senden wenn low, input

;;;;;;;;;;;;eeprom
;;;;;;;;;;;default werte fr dauernde ton dekodierung (1750Hz)
			org 	0xf00000            ; Adresse des EEPROM fr den Brenner 


			;Adresse  0     1     2     3      4  	5	   6	 7
	       	de 		 0xab, 0x05, 0x7f, 0x05, 0x08, 0x08, 0x02, 0x02
			
			;tmr0l_lowerlimit_1750hz EEPROM ADRESSE 0
			;tmr0h_lowerlimit_1750hz EEPROM ADRESSE 1

			;tmr0l_upperlimit_1750hz EEPROM ADRESSE 2
			;tmr0h_upperlimit_1750hz EEPROM ADRESSE 3
			;maxwert				 EEPROM ADRESSE 4				
			;maxwert_1750hz			 EEPROM ADRESSE 5
			;minwert				 EEPROM ADRESSE 6
			;minwert_1750hz			 EEPROM ADRESSE 7
;;;;;;;;;;;;;;;;;;;;;;;
			
		
;------------Allgemeine Register-------
		cblock	0x000

tmr0l_lowerlimit		;frequenzgrenzen 16bit vom timer0. untere 8 bit
tmr0h_lowerlimit		;obere 8 bit

tmr0l_upperlimit		;frequenzgrenzen 16bit vom timer0. untere 8 bit
tmr0h_upperlimit		;obere 8 bit

tmr0l_temp				;sichern der tmr0 werte nach empfang von 8 wellenzgen
tmr0h_temp

tmr0l_lowerlimit_1750hz		;frequenzgrenzen 16bit vom timer0. untere 8 bit
tmr0h_lowerlimit_1750hz		;obere 8 bit fr 1750hz ton

tmr0l_upperlimit_1750hz		;frequenzgrenzen 16bit vom timer0. untere 8 bit
tmr0h_upperlimit_1750hz		;obere 8 bit fr 1750hz ton



hbyteX					;register fr 16bit verleichsroutinen im call compare
hbyteY
lbyteX
lbyteY
compare16bit			;ergebnisregister der 16bit vergleichsoperationen

timer_erfolgszaehler		; hlt die werte wie oft tmr1 beim auswerten gepasst hat
timer_erfolgszaehler_1750hz		; hlt die werte wie oft tmr1 beim auswerten gepasst hat fr 1750hz ton

hauptzaehler			;bestimmt durchlufe der hauptschleife, bis wann ctcss abgeschaltet wird, weil kein
						;irupt erfolgte

minwert					;so oft muss ein signal mindestens als richtig erkannt werden, damit es ausgegeben wird
maxwert					;so oft darf ein signal (nachdem es als richtig erkannt wurde) schlecht sien, bis es ausgegeben wird  
minwert_1750hz			;dto fr die zweite qrg
maxwert_1750hz

test_tonauswahl		;zwischeregister fr schalterstellungen zur auswahl der zu dekodierenden tne

loop_timer1				;timer for delay routines
loop_timer2				;timer for delay routines

ACC_H				;register fr dds
ACC_M				;register fr dds
ACC_L				;register fr dds
FREQ_H				;register fr dds
FREQ_M				;register fr dds
FREQ_L				;register fr dds
		endc


;--------Start Hauptprogramm
		org	0x000
		goto	init

		org	0x008	;high interrupt priority level
		goto  ctcss_decode
		;decision which ctcss tone is present
		;the interrupt starts with a rising edge on portb, 0. 16 halfcycles of the ctcss tone are measured, which means, that 
		;8 complete ctcss cycles are measured. 			
		;on every halfcycle the timer1 is incremented and the result is written to registers
		;after the 16 halfcycles it is decided if the the time via tmr0 meets the desired ctcss tone and if 10 from the
		;15 halfcylces have the right timer1 numbers. The first halfcycle is not used with tmr1, because there is a unknown  
		;delay in measuring this halfcycle because of the start of the irupt service routine. the tmr0 prescaler is set to 8 so
		;tmr0 rolls over every 2048 cycles (=  0.8192S). tmr0 is set to 16 bit mode 
		;for eg. 81,6mS the tmr0 count has to be 40800 (prescaler set to divide by 2)
		;and for 78,4mS the count has to be 39200. (these are the edges for detecting an ctcss 100Hz tone with 4% accuracy)
		;for ctcss 100 Hz this means, that the measuring period (16 bit  mode tmr0, prescaler switched to 2) 
		;has to be beetwen 81,6mS (98Hz) und 78,4mS (102Hz) and that 14 halfcycles have to be beetwen 5,1mS (98Hz) and 4,9mS
		;(102Hz). for that the timer1 has to be beetwen 5100 und 4900, because this timer is incremented every instruction cycle by 1
		;a instruction cycle is 4Mhz/4 = 1MHz = 1 S
		;after the tone is detected as valid you know that the frequency of the tone is beetwen 98 and 102 Hz and that the tone
		;quality is ok because 10 from 15 measuring periodes of the halfcycles were ok to.

		;if tmr0 rolls over you know, that it could not be an valid ctcss tone, because the measuring period was to long
		;the measured frequency was lower than 61 Hz; so exit from the isr
		
ctcss_decode
		;rising edge portb, 0 is detected; start timer0 with prescaler 256 and timer1
		;first halfcycle of the ctcss tone; irupt after 3 - 4 cycles
	
;=======start empfang 1. welle	
		
		clrf TMR0H
		clrf TMR0L	;nop
		bsf		T0CON, TMR0ON		;start timer0
halbwelle1
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no1_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no1_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle1			;nein, immer noch high
		

		;ja, nchste halbwelle (nr. 2)
halbwelle2
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no2_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no2_tmr0
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle2			;nein noch low	
;==============1. welle ampfangen


;=============start empfang 2. welle		
		;ja, nchste halbwelle (nr. 3)
halbwelle3
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no3_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no3_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle3			;nein, immer noch high

		;ja, nchste halbwelle (nr. 4)
halbwelle4
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no4_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no4_tmr0
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle4			;nein noch low
;==============2. welle ampfangen

;=============start empfang 3. welle		
		;ja, nchste halbwelle (nr. 5)
halbwelle5
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no5_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no5_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle5			;nein, immer noch high

		;ja, nchste halbwelle (nr. 6)
halbwelle6
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no6_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no6_tmr0
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle6			;nein noch low
;==============3. welle ampfangen

;=============start empfang 4. welle		
		;ja, nchste halbwelle (nr. 7)
halbwelle7
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no7_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no7_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle7			;nein, immer noch high

		;ja, nchste halbwelle (nr. 8)
halbwelle8
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no8_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no8_tmr0
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle8			;nein noch low
;==============4. welle ampfangen

;=============start empfang 5. welle		
		;ja, nchste halbwelle (nr. 9)
halbwelle9
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no9_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no9_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle9			;nein, immer noch high

		;ja, nchste halbwelle (nr. 10)
halbwelle10
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no10_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no10_tmr0
no10_tmr1		
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle10			;nein noch low
;==============5. welle ampfangen

;=============start empfang 6. welle		
		;ja, nchste halbwelle (nr. 11)
halbwelle11
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no11_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no11_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle11			;nein, immer noch high

		;ja, nchste halbwelle (nr. 12)
halbwelle12
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no12_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no12_tmr0
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle12			;nein noch low
;==============6. welle ampfangen

;=============start empfang 7. welle		
		;ja, nchste halbwelle (nr. 13)
halbwelle13
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no13_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no13_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle13			;nein, immer noch high

		;ja, nchste halbwelle (nr. 14)
halbwelle14
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no14_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no14_tmr0
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle14			;nein noch low
;==============7. welle ampfangen

;=============start empfang 8. welle		
		;ja, nchste halbwelle (nr. 15)
halbwelle15
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no15_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no15_tmr0
		btfsc	ctcss_in			;warte auf fallende flanke, fllt flanke?	
		goto	halbwelle15			;nein, immer noch high

		;ja, nchste halbwelle (nr. 16)
halbwelle16
		btfss	INTCON, TMR0IF		;berlauf tmr0 d.h. tone < 61 Hz (gibt es nicht als ctcss)
		goto	no16_tmr0					;nein
		goto	exit_int			;ja, berlauf: schmarrn gehrt
no16_tmr0
		btfss	ctcss_in			;warte auf steigende flanke, steigt flanke?	
		goto	halbwelle16			;nein noch low
;==============8. welle ampfangen
	;sichern der letzten timer1 werte von halbwelle nr. 16 und des tmr0 wertes fr die ganzen 8 werten
		bcf		T0CON, TMR0ON		;stop tmr0	
		movff	TMR0L, tmr0l_temp
		movff	TMR0H, tmr0h_temp		;tmr0 sichern

;===========Auswertungen
;test: passt tmr0, wenn nein, dann wars kein gltiger ton
	;untere frequenzgre ist immer der hhere wert
	;obere frequenzgre ist immer der niedrigere zhlerwert
test_untere_grenze_tmr0			;untere frequenzgrenze (grerer wert)
		movff	tmr0l_temp, lbyteX		;tmr0 ergebnis in rechenregister umkopieren
		movff	tmr0h_temp,	hbyteX		

		movff	tmr0l_lowerlimit, lbyteY	;fr den ctcss ton vorgegebene Freqenzgrenze in 	 
		movff	tmr0h_lowerlimit, hbyteY	;rechenregister kopieren
		call	compare						;aufruf der 16bit berechnung
		;	compare16bit	
							;ergebnis anschauen, das gemessene ergebnis muss
							;insgesamt innerhalb der vorgegebenen bandbreite liegen
							;das gemessene ergebnis muss gleich oder grer dem kleineren
							;vorgegebenen wert und gleich oder kleiner dem grerenen
							;vorgegebenen wert sein.

							;compare16bit:b'00000001' X und Y werte sind gleich
							;compare16bit:b'00000010' X wert ist grer als Y wert
							;compare16bit:b'00000100' Y wert ist grer als X wert
			;----------test auf untere grenze
		btfss	compare16bit, 0		;gleich gro?
		goto	test_auf_groeer_kleiner1		;nein, nchster test		
		goto	exit_int_erfolg1			;ja, passt						

test_auf_groeer_kleiner1
		btfss	compare16bit, 1		;ist y grer als x
		goto	test_obere_grenze_tmr0		;ja, dannschauen ob unterhalb des max
		goto	exit_int1			;nein, dann passts net
		
test_obere_grenze_tmr0
		movff	tmr0l_temp, lbyteX		;tmr0 ergebnis in rechenregister umkopieren
		movff	tmr0h_temp,	hbyteX		
		movff	tmr0l_upperlimit, lbyteY	;fr den ctcss ton vorgegebene Freqenzgrenze in 	 
		movff	tmr0h_upperlimit, hbyteY	;rechenregister kopieren
		call	compare						;aufruf der 16bit berechnung
		btfss	compare16bit, 0				;gleich gro?
		goto	test_auf_groeer_kleiner2	;nein, dann nchster test				
		goto	exit_int_erfolg1			;ja, passt

test_auf_groeer_kleiner2
		btfss	compare16bit, 1		;ist x grer als y
		goto	exit_int1	;nein, dann passts net	
		goto	exit_int_erfolg1			;ja, dann passts



exit_int1	
;timer erfoglszaehler wird bei erfolgreicher tonerekennung auf 1 gesetzt
;wird kein ton erkannt wird geschaut welchen wert dieser zaehler hat,
;hat er 1 wird der irupt ohne nderungen der portpins verlassen und der zaehler auf 0 gesetzt
;ist er schon 0, werden die portpins ganz normal ausgeschaltet
			btfss	hysterese_ein_aus				;bei low: keine hysterese
			goto	misserfolg						;low	
			movlw	0x00
			subwf	timer_erfolgszaehler, 0			;ist timer_erfoglszaehler 0
			btfss	STATUS, Z					
			goto	daher2							;nein, dann verringern und raus ohne portnderungen
			goto	misserfolg						;ja, dann misserfolg
daher2		decf	timer_erfolgszaehler, 1
			goto	test_1750hz_ton_da
misserfolg	;bcf		ctcss_da_plus
			bcf		ctcss_da_plus1
			bsf		ctcss_da_minus
			goto 	test_1750hz_ton_da


exit_int_erfolg1			
			btfss	hysterese_ein_aus				;bei low: keine hysterese
			goto	und_raus					;low	

			incf	timer_erfolgszaehler, 1		;erfolgreiche tonerkennung
			incf	maxwert, 0						;1 grer als zhler maximal sein darf
			subwf	timer_erfolgszaehler, 0		;hat der zaehler den maximal erlaubten wert erreicht?
			btfss	STATUS, Z					
			goto	daher					;nein, also einfach ausgeben
			movf	maxwert, 0					;ja, dann wieder zurcksetzen auf maximal erlaubten wert
			movwf	timer_erfolgszaehler
daher		movf	minwert, 0				;war das sig oft genug gut?
			subwf	timer_erfolgszaehler, 0
			btfsc 	STATUS, C			
			goto	daher_setzen		;ja, mindestens so oft gut wie in minwert gefordert
			goto	test_1750hz_ton_da	;nein nich nicht oft genug gut
daher_setzen
			movf	maxwert, 0						;neu24.6.
			movwf	timer_erfolgszaehler		;neu24.6.		
			;bsf		ctcss_da_plus		;gltiger ctcss ton wurde erkannt
und_raus	bsf		ctcss_da_plus1		;jetzt 1750HZ testen	
			bcf		ctcss_da_minus
			goto	test_1750hz_ton_da




;;;;;;;;;;;;;;;;;;;;1750hz ton testen

;test: passt tmr0, wenn nein, dann wars kein gltiger ton
	;untere frequenzgre ist immer der hhere wert
	;obere frequenzgre ist immer der niedrigere zhlerwert
test_1750hz_ton_da
test_untere_grenze_tmr0_1750hz			;untere frequenzgrenze (grerer wert)
		movff	tmr0l_temp, lbyteX		;tmr0 ergebnis in rechenregister umkopieren
		movff	tmr0h_temp,	hbyteX		

		movff	tmr0l_lowerlimit_1750hz, lbyteY	;fr den ctcss ton vorgegebene Freqenzgrenze in 	 
		movff	tmr0h_lowerlimit_1750hz, hbyteY	;rechenregister kopieren
		call	compare						;aufruf der 16bit berechnung
		;	compare16bit	
							;ergebnis anschauen, das gemessene ergebnis muss
							;insgesamt innerhalb der vorgegebenen bandbreite liegen
							;das gemessene ergebnis muss gleich oder grer dem kleineren
							;vorgegebenen wert und gleich oder kleiner dem grerenen
							;vorgegebenen wert sein.

							;compare16bit:b'00000001' X und Y werte sind gleich
							;compare16bit:b'00000010' X wert ist grer als Y wert
							;compare16bit:b'00000100' Y wert ist grer als X wert
			;----------test auf untere grenze
		btfss	compare16bit, 0		;gleich gro?
		goto	test_auf_groeer_kleiner1_1750hz		;nein, nchster test		
		goto	exit_int_erfolg2			;ja, passt						

test_auf_groeer_kleiner1_1750hz
		btfss	compare16bit, 1		;ist y grer als x
		goto	test_obere_grenze_tmr0_1750hz		;ja, dannschauen ob unterhalb des max
		goto	exit_int2			;nein, dann passts net
		
test_obere_grenze_tmr0_1750hz
		movff	tmr0l_temp, lbyteX		;tmr0 ergebnis in rechenregister umkopieren
		movff	tmr0h_temp,	hbyteX		
		movff	tmr0l_upperlimit_1750hz, lbyteY	;fr den ctcss ton vorgegebene Freqenzgrenze in 	 
		movff	tmr0h_upperlimit_1750hz, hbyteY	;rechenregister kopieren
		call	compare						;aufruf der 16bit berechnung
		btfss	compare16bit, 0				;gleich gro?
		goto	test_auf_groeer_kleiner2_1750hz	;nein, dann nchster test				
		goto	exit_int_erfolg2			;ja, passt

test_auf_groeer_kleiner2_1750hz
		btfss	compare16bit, 1		;ist x grer als y
		goto	exit_int2	;nein, dann passts net	
		goto	exit_int_erfolg2			;ja, dann passts



;1750Hz auswerten



;--------ende auswertungen

exit_int2	
;timer erfoglszaehler wird bei erfolgreicher tonerekennung auf 1 gesetzt
;wird kein ton erkannt wird geschaut welchen wert dieser zaehler hat,
;hat er 1 wird der irupt ohne nderungen der portpins verlassen und der zaehler auf 0 gesetzt
;ist er schon 0, werden die portpins ganz normal ausgeschaltet
			btfss	hysterese_ein_aus				;bei low: keine hysterese
			goto	misserfolg2						;low	

			movlw	0x00
			subwf	timer_erfolgszaehler_1750hz, 0			;ist timer_erfoglszaehler 0
			btfss	STATUS, Z					
			goto	daher22							;nein, dann verringern und raus ohne portnderungen
			goto	misserfolg2						;ja, dann misserfolg
daher22		decf	timer_erfolgszaehler_1750hz, 1
			goto	int_ende
misserfolg2	bcf		_1750hz_da_plus				;1750hz wurde nicht erkannt
			bsf		_1750hz_da_minus
			goto 	int_ende


exit_int_erfolg2
			btfss	hysterese_ein_aus				;bei low: keine hysterese
			goto	und_raus_1750hz					;low	

			incf	timer_erfolgszaehler_1750hz, 1		;erfolgreiche tonerkennung
			incf	maxwert_1750hz, 0						;1 grer als zhler maximal sein darf
			subwf	timer_erfolgszaehler_1750hz, 0		;hat der zaehler den maximal erlaubten wert erreicht?
			btfss	STATUS, Z					
			goto	daher33					;nein, also einfach ausgeben
			movf	maxwert_1750hz, 0					;ja, dann wieder zurcksetzen auf maximal erlaubten wert
			movwf	timer_erfolgszaehler_1750hz


daher33		movf	minwert_1750hz, 0				;war das sig oft genug gut?
			subwf	timer_erfolgszaehler_1750hz, 0
			btfsc 	STATUS, C			
			goto	daher_setzen_1750hz		;ja, mindestens so oft gut wie in minwert gefordert
			goto	int_ende	;nein nich nicht oft genug gut


daher_setzen_1750hz
			movf	maxwert_1750hz, 0						;neu24.6.
			movwf	timer_erfolgszaehler_1750hz		;neu24.6.		

und_raus_1750hz
			bsf		_1750hz_da_plus		;gltiger 1750hz ton wurde erkannt
			bcf		_1750hz_da_minus
			goto	int_ende





exit_int	;bcf		ctcss_da_plus		;kein gltiger ton , weil berlufe der timer 	
			bcf		ctcss_da_plus1
			bsf		ctcss_da_minus
			bcf		_1750hz_da_plus
			bsf		_1750hz_da_minus
			clrf	timer_erfolgszaehler
			clrf	timer_erfolgszaehler_1750hz
			goto	int_ende			;d.h. die frequenz ist zu niedrig
									;2. mglichkeit: vergleiche haben keinen gltigen ton ergeben





int_ende	bcf		T0CON, TMR0ON	;stop tmr0
			clrf	TMR0L			;lsche tmr0
			clrf	TMR0H			;lsche tmr0		
			bcf		INTCON, TMR0IF		;lsche tmr0 interrupt flag bit
			
			movlw	d'100'			;re-init vom200mS Zaehler fr die Hauptschleife
			movwf	hauptzaehler		
				

			bcf		INTCON, INT0IF	;lsche interrupt0 flag bit, erlaube weitere tmr0 interrupts
			retfie			FAST					






;-----------------mainprogramm
			;----init after power up
init		movlw	b'00010000'			;interrupts erlaubt bei int0 (portb, 0),peripheral irupts verboten 
			movwf	INTCON				;irupts noch ausgeschaltet (bit7 ist noch 0)
			movlw	b'01000000'			;portb pullups ein, interrupt bei steigender flanke
			movwf	INTCON2

			movlw	b'00000010'			;tmr0 is set to 16bit mode, prescaler 1:8, internal clock as clock source		
			movwf	T0CON				;tmr0 starts, when bit7 is set and stopps with bit7 == 0
			
			movlw	0x07
			movwf	ADCON1			;port a digital, kein ad wandler aktiv
			movlw	b'00010001'		;alle outputs Achtug porta4 open drain und input, porta0: input
			movwf	TRISA
			movlw	b'11111111'		;port b inputs, (nur gltig wenn portb1 als ausgabe vorgesehen wird:bis auf portb1: output
			movwf	TRISB			
			movlw	b'00000000'		;port c outputs 
			movwf	TRISC
			clrf	PORTA
			clrf	PORTB
			clrf	PORTC
			
			;bcf		ctcss_da_plus
			bcf		ctcss_da_plus1
			bsf		ctcss_da_minus
			bcf		_1750hz_da_plus
			bsf		_1750hz_da_minus
			bcf		ctcss_led
			movlw	0x80			;portc (ctcss tonausgabe) auf 2.5 Volt zentrieren
			movwf	PORTC
			;register vorinitialisieren
			movlw	d'100'
			movwf	hauptzaehler				;muss auch jedes mal im irupt gesetzt werden
			;----------------------------
			clrf	timer_erfolgszaehler	;erfolgszaehler auf 0 setzen	
			clrf	timer_erfolgszaehler_1750hz	;erfolgszaehler auf 0 setzen	
			

;			btfsc	min_max_aendern		;ist port b1 high oder low
;			goto	groeerer_wert		;high (offen)
;			goto	kleinerer_wert		;low (geschlossen)
			
;groeerer_wert
;			movlw 	0x20
;			movwf	maxwert					;so oft darf ein sig schlecht sein, bis es als solches ausgegeben wird
;			movwf	maxwert_1750hz
;			movlw	0x02
;			movwf	minwert					;so oft muss ein sig mindestens gut sein zur ausgabe
;			movwf	minwert_1750hz
;			goto	on_power_up

;kleinerer_wert	
;			movlw 	0x06
;			movwf	maxwert					;so oft darf ein sig schlecht sein, bis es als solches ausgegeben wird
;			movwf	maxwert_1750hz
;			movlw	0x02
;			movwf	minwert					;so oft muss ein sig mindestens gut sein zur ausgabe
;			movwf	minwert_1750hz

;;;;;;;;;;;bei power up: wenn ctcss_senden auf low ist:
;;;;;;;;;;;einlesen der schiebschalterstellungen, entscheiden welcher ton dauernd decodiert werden soll
;;;;;;;;;;entsprechende werte ins eeprom schreiben
;;;;;;;;;;und warten bis der taster wieder losgelassen wurdem dann weitermachen mit eeprom_read 	
;;;;;;;;;selbiges fuer PORTA, 4: fr einstellungen der Hysterese

on_power_up
			btfsc	ctcss_senden			;taster gedrckt	
			goto	weitermachen_nach_powerup		;nein	
			movlw	0xff						;ja, signalisieren ber 5V an portc
			movwf	PORTC
			call	einlesen_fuer_tonerkennung	;ja
			call	eeprom_schreiben
nochnicht	btfss	ctcss_senden			;ist taster noch gedrckt
			goto	nochnicht				;ja
			call	wait_8ms				;nein, debounce
			btfss	ctcss_senden			;ist taster wirklich noch gedrckt
			goto	nochnicht				;ja
			movlw	0x80					;nein, weitermachen und port c zurck auf 2,5V
			movwf	PORTC
			goto	jetzt_weitermachen		;dadurch wird bewirkt, dass
				;bei power up nur entweder die ctcss dekodierung programmiert oder die hysterese
				;programmiert werden kann
;;;;;;;;;;;;;;;;PORTA, 4 testen und hysterese progammieren im eeprom
weitermachen_nach_powerup
			btfsc 	PORTA, 4				;taster gedrckt
			goto	jetzt_weitermachen		;nein
			movlw	0x33					;ja, signalisieren ber 1 V an port c 
			movwf	PORTC
			call	einlesen_fuer_tonerkennung	;ja
			call	eeprom_schreiben_hysterese
nochnicht_1	btfss	PORTA, 4			;ist taster noch gedrckt
			goto	nochnicht_1				;ja
			call	wait_8ms				;nein, debounce
			btfss	PORTA, 4			;ist taster wirklich noch gedrckt
			goto	nochnicht_1				;ja
			movlw	0x80					;nein, portc wieder auf 2,5 V setzen
			movwf	PORTC
			


;;;;;;;;;;;;;;;;;1750hz ton testen automatisch und immer
;;;;;;;;;;;entsprechende registerwerte; werte knnen angepasst werden, je nachdem welcher ton immer
;;;;;;;;;;;;;detektiert werden soll (zustzlich zu den tnen via schiebeschalter) 

jetzt_weitermachen
			movlw	b'00000001'		;alle outputs Achtug porta4 open drain und input, porta0: input
			movwf	TRISA			;porta, 4 als output schalten
			clrf	PORTA
			call	eeprom_read		
	
;;;;;;;;;;;;;;;;;;;;;;;;ende 1750hz ton register vorinitialisieren



			bsf		INTCON, GIE			;einschalten des erlaubten portb0 irupts
										;ab jetzt irupts
;----------------mainloop
;---------------warte auf irupt
;kommt nach 100ms keiner, dann liegt auch kein ctcss ton an, weil keine steigende ctcss flanke
;erkannt wurde: folge: ausschalten des portpins (ctcss_da_plus), der ctcss erkennung beschreibt
start

;----------tonauswahl ber portb, 2 bis 7 mit schaltern
			movff	PORTB, test_tonauswahl	;portb abspeichern
			rrncf	test_tonauswahl, 1		;nach rechts schieben 2 mal
			rrncf	test_tonauswahl, 1
			bcf		test_tonauswahl, 6		;oberste bits lschen
			bcf		test_tonauswahl, 7
			
			
			;entscheidungen
entscheidung_67.0hz
			movlw		b'00000000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_69.3hz	;passt nicht				
			goto		_67.0hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_69.3hz
			movlw		b'00000001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_71.9hz	;passt nicht				
			goto		_69.3hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_71.9hz
			movlw		b'00000010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_74.4hz	;passt nicht				
			goto		_71.9hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_74.4hz
			movlw		b'00000011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_77.0hz	;passt nicht				
			goto		_74.4hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_77.0hz
			movlw		b'00000100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_79.7hz	;passt nicht				
			goto		_77.0hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_79.7hz
			movlw		b'00000101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_82.5hz	;passt nicht				
			goto		_79.7hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_82.5hz
			movlw		b'00000110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_85.4hz	;passt nicht				
			goto		_82.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_85.4hz
			movlw		b'00000111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_88.5hz	;passt nicht				
			goto		_85.4hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_88.5hz
			movlw		b'00001000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_91.5hz	;passt nicht				
			goto		_88.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_91.5hz
			movlw		b'00001001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_94.8hz	;passt nicht				
			goto		_91.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_94.8hz
			movlw		b'00001010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_97.4hz	;passt nicht				
			goto		_94.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_97.4hz
			movlw		b'00001011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_100.0hz	;passt nicht				
			goto		_97.4hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_100.0hz
			movlw		b'00001100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_103.5hz	;passt nicht				
			goto		_100.0hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_103.5hz
			movlw		b'00001101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_107.2hz	;passt nicht				
			goto		_103.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_107.2hz
			movlw		b'00001110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_110.9hz	;passt nicht				
			goto		_107.2hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_110.9hz
			movlw		b'00001111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_114.8hz	;passt nicht				
			goto		_110.9hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_114.8hz
			movlw		b'00010000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_118.8hz	;passt nicht				
			goto		_114.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_118.8hz
			movlw		b'00010001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_123.0hz	;passt nicht				
			goto		_118.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_123.0hz
			movlw		b'00010010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_127.3hz	;passt nicht				
			goto		_123.0hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_127.3hz
			movlw		b'00010011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_131.8hz	;passt nicht				
			goto		_127.3hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_131.8hz
			movlw		b'00010100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_136.5hz	;passt nicht				
			goto		_131.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_136.5hz
			movlw		b'00010101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_141.3hz	;passt nicht				
			goto		_136.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_141.3hz
			movlw		b'00010110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_146.2hz	;passt nicht				
			goto		_141.3hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_146.2hz
			movlw		b'00010111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_151.4hz	;passt nicht				
			goto		_146.2hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_151.4hz
			movlw		b'00011000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_156.7hz	;passt nicht				
			goto		_151.4hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_156.7hz
			movlw		b'00011001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_159.8hz	;passt nicht				
			goto		_156.7hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_159.8hz
			movlw		b'00011010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_162.2hz	;passt nicht				
			goto		_159.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_162.2hz
			movlw		b'00011011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_165.5hz	;passt nicht				
			goto		_162.2hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_165.5hz
			movlw		b'00011100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_167.9hz	;passt nicht				
			goto		_165.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_167.9hz
			movlw		b'00011101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_171.3hz	;passt nicht				
			goto		_167.9hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_171.3hz
			movlw		b'00011110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_173.8hz	;passt nicht				
			goto		_171.3hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_173.8hz
			movlw		b'00011111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_177.3hz	;passt nicht				
			goto		_173.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_177.3hz
			movlw		b'00100000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_179.9hz	;passt nicht				
			goto		_177.3hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_179.9hz
			movlw		b'00100001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_183.5hz	;passt nicht				
			goto		_179.9hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_183.5hz
			movlw		b'00100010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_186.2hz	;passt nicht				
			goto		_183.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_186.2hz
			movlw		b'00100011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_189.9hz	;passt nicht				
			goto		_186.2hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_189.9hz
			movlw		b'00100100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_192.8hz	;passt nicht				
			goto		_189.9hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_192.8hz
			movlw		b'00100101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_196.6hz	;passt nicht				
			goto		_192.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_196.6hz
			movlw		b'00100110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_199.5hz	;passt nicht				
			goto		_196.6hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_199.5hz
			movlw		b'00100111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_203.5hz	;passt nicht				
			goto		_199.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_203.5hz
			movlw		b'00101000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_206.5hz	;passt nicht				
			goto		_203.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_206.5hz
			movlw		b'00101001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_210.7hz	;passt nicht				
			goto		_206.5hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_210.7hz
			movlw		b'00101010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_218.1hz	;passt nicht				
			goto		_210.7hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_218.1hz
			movlw		b'00101011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_225.7hz	;passt nicht				
			goto		_218.1hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_225.7hz
			movlw		b'00101100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_229.1hz	;passt nicht				
			goto		_225.7hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_229.1hz
			movlw		b'00101101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_233.6hz	;passt nicht				
			goto		_229.1hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_233.6hz
			movlw		b'00101110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_241.8hz	;passt nicht				
			goto		_233.6hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_241.8hz
			movlw		b'00101111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_250.3hz	;passt nicht				
			goto		_241.8hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_250.3hz
			movlw		b'00110000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_254.1hz	;passt nicht				
			goto		_250.3hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_254.1hz
			movlw		b'00110001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_1000hz	;passt nicht				
			goto		_254.1hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_1000hz
			movlw		b'00110010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_1250hz	;passt nicht				
			goto		_1000hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_1250hz
			movlw		b'00110011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_1500hz	;passt nicht				
			goto		_1250hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_1500hz
			movlw		b'00110100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_1750hz	;passt nicht				
			goto		_1500hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_1750hz
			movlw		b'00110101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_2000hz	;passt nicht				
			goto		_1750hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_2000hz
			movlw		b'00110110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_2250hz	;passt nicht				
			goto		_2000hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_2250hz
			movlw		b'00110111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_2500hz	;passt nicht				
			goto		_2250hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_2500hz
			movlw		b'00111000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_2750hz	;passt nicht				
			goto		_2500hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_2750hz
			movlw		b'00111001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_3000hz	;passt nicht				
			goto		_2750hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_3000hz
			movlw		b'00111010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_3250hz	;passt nicht				
			goto		_3000hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_3250hz
			movlw		b'00111011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_3500hz	;passt nicht				
			goto		_3250hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_3500hz
			movlw		b'00111100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_3750hz	;passt nicht				
			goto		_3500hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_3750hz
			movlw		b'00111101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_4000hz	;passt nicht				
			goto		_3750hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_4000hz
			movlw		b'00111110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_4250hz	;passt nicht				
			goto		_4000hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_4250hz
			movlw		b'00111111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		bremspause			;passt nicht, kein schalter passt, wir haben misst gemessen				
			goto		_4250hz_passt		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen


;ende entscheidungen


;start werte vergeben auf grund der entscheidungen (tonauswahl)
;und port a entsprechend einschalten (binaere codierung des Tons)

;67.0hz ctcss ton
_67.0hz_passt
			movlw	0xfa					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x93
			movwf	tmr0h_lowerlimit

			movlw	0x9a					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x8f
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x65
			movwf	FREQ_L
			movlw	0x28
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;69.3hz ctcss ton
_69.3hz_passt
			movlw	0x11					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x8f
			movwf	tmr0h_lowerlimit

			movlw	0xd5					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x8a
			movwf	tmr0h_upperlimit
				;register fr dds tonerzeuguzng initialisieren
			movlw	0xc8
			movwf	FREQ_L
			movlw	0x29
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;71.9hz ctcss ton
_71.9hz_passt
			movlw	0xe5					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x89
			movwf	tmr0h_lowerlimit

			movlw	0xd0					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x85
			movwf	tmr0h_upperlimit
				;register fr dds tonerzeuguzng initialisieren
			movlw	0x5a
			movwf	FREQ_L
			movlw	0x2b
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	
;74.4hz ctcss ton
_74.4hz_passt
			movlw	0x42					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x85
			movwf	tmr0h_lowerlimit

			movlw	0x51					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x81
			movwf	tmr0h_upperlimit
				;register fr dds tonerzeuguzng initialisieren
			movlw	0xdc
			movwf	FREQ_L
			movlw	0x2c
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;77.0hz ctcss ton
_77.0hz_passt
			movlw	0xc2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x80
			movwf	tmr0h_lowerlimit

			movlw	0xf3					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x7c
			movwf	tmr0h_upperlimit
				;register fr dds tonerzeuguzng initialisieren
			movlw	0x6d
			movwf	FREQ_L
			movlw	0x2e
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;79.7hz ctcss ton
_79.7hz_passt
			movlw	0x66					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x7c
			movwf	tmr0h_lowerlimit

			movlw	0xb8					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x78
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x0e
			movwf	FREQ_L
			movlw	0x30
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;82.5hz ctcss ton
_82.5hz_passt
			movlw	0x2d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x78
			movwf	tmr0h_lowerlimit

			movlw	0x9f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x74
			movwf	tmr0h_upperlimit
				;register fr dds tonerzeuguzng initialisieren
			movlw	0xbe
			movwf	FREQ_L
			movlw	0x31
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;85.4hz ctcss ton
_85.4hz_passt
			movlw	0x18					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x74
			movwf	tmr0h_lowerlimit

			movlw	0xa9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x70
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x7e
			movwf	FREQ_L
			movlw	0x33
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;88.5hz ctcss ton
_88.5hz_passt
			movlw	0x07					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x70
			movwf	tmr0h_lowerlimit

			movlw	0xb7					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x6c
			movwf	tmr0h_upperlimit
			;register fr dds tonerzeuguzng initialisieren
			movlw	0x5c
			movwf	FREQ_L
			movlw	0x35
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;91.5hz ctcss ton
_91.5hz_passt
			movlw	0x5b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x6c
			movwf	tmr0h_lowerlimit

			movlw	0x26					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x69
			movwf	tmr0h_upperlimit
				;register fr dds tonerzeuguzng initialisieren
			movlw	0x2b
			movwf	FREQ_L
			movlw	0x37
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;94.8hz ctcss ton
_94.8hz_passt
			movlw	0x95					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x68
			movwf	tmr0h_lowerlimit

			movlw	0x7d					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x65
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x28
			movwf	FREQ_L
			movlw	0x39
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;97.4hz ctcss ton
_97.4hz_passt
			movlw	0x47					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x65
			movwf	tmr0h_lowerlimit

			movlw	0x45					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x63
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xba
			movwf	FREQ_L
			movlw	0x3a
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;100hz ctcss ton
_100.0hz_passt
			movlw	0x25					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x63
			movwf	tmr0h_lowerlimit

			movlw	0x36					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x60
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x4b
			movwf	FREQ_L
			movlw	0x3c
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;103.5hz ctcss ton
_103.5hz_passt
			movlw	0xcb					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x5f
			movwf	tmr0h_lowerlimit

			movlw	0xf5					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x5c
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x67
			movwf	FREQ_L
			movlw	0x3e
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;107.2hz ctcss ton
_107.2hz_passt
			movlw	0x7d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x5c
			movwf	tmr0h_lowerlimit

			movlw	0xc0					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x59
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xa2
			movwf	FREQ_L
			movlw	0x40
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;110.9hz ctcss ton
_110.9hz_passt
			movlw	0x67					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x59
			movwf	tmr0h_lowerlimit

			movlw	0xc1					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x56
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xdd
			movwf	FREQ_L
			movlw	0x42
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;114.8hz ctcss ton
_114.8hz_passt
			movlw	0x5d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x56
			movwf	tmr0h_lowerlimit

			movlw	0xcf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x53
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x37
			movwf	FREQ_L
			movlw	0x45
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;118.8hz ctcss ton
_118.8hz_passt
			movlw	0x75					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x53
			movwf	tmr0h_lowerlimit

			movlw	0xfc					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x50
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xa1
			movwf	FREQ_L
			movlw	0x47
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;123.0hz ctcss ton
_123.0hz_passt
			movlw	0x9b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x50
			movwf	tmr0h_lowerlimit

			movlw	0x38					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x4e
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x29
			movwf	FREQ_L
			movlw	0x4a
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;127.3hz ctcss ton
_127.3hz_passt
			movlw	0xe2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x4d
			movwf	tmr0h_lowerlimit

			movlw	0x94					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x4b
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xc1
			movwf	FREQ_L
			movlw	0x4c
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;131.8hz ctcss ton
_131.8hz_passt
			movlw	0x39					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x4b
			movwf	tmr0h_lowerlimit

			movlw	0xff					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x48
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x77
			movwf	FREQ_L
			movlw	0x4f
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;136.5hz ctcss ton
_136.5hz_passt
			movlw	0xa2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x48
			movwf	tmr0h_lowerlimit

			movlw	0x7c					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x46
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x4d
			movwf	FREQ_L
			movlw	0x52
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;141.3hz ctcss ton
_141.3hz_passt
			movlw	0x2b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x46
			movwf	tmr0h_lowerlimit

			movlw	0x17					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x44
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x32
			movwf	FREQ_L
			movlw	0x55
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;146.2hz ctcss ton
_146.2hz_passt
			movlw	0xd1					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x43
			movwf	tmr0h_lowerlimit

			movlw	0xcf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x41
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x26
			movwf	FREQ_L
			movlw	0x58
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;151.4hz ctcss ton
_151.4hz_passt
			movlw	0x7d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x41
			movwf	tmr0h_lowerlimit

			movlw	0x8c					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3f
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x49
			movwf	FREQ_L
			movlw	0x5b
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;156.7hz ctcss ton
_156.7hz_passt
			movlw	0x46					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3f
			movwf	tmr0h_lowerlimit

			movlw	0xd3					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3d
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x7b
			movwf	FREQ_L
			movlw	0x5e
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;159.8hz ctcss ton
_159.8hz_passt
			movlw	0xbb					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3d
			movwf	tmr0h_lowerlimit

			movlw	0xaf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3c
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x59
			movwf	FREQ_L
			movlw	0x60
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;162.2hz ctcss ton
_162.2hz_passt
			movlw	0x93					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3c
			movwf	tmr0h_lowerlimit

			movlw	0xba					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3b
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xcc
			movwf	FREQ_L
			movlw	0x61
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;165.5hz ctcss ton
_165.5hz_passt
			movlw	0x9b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3b
			movwf	tmr0h_lowerlimit

			movlw	0xb6					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3a
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xc9
			movwf	FREQ_L
			movlw	0x63
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;167.9hz ctcss ton
_167.9hz_passt
			movlw	0xa2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3a
			movwf	tmr0h_lowerlimit

			movlw	0x96					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x39
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x3b
			movwf	FREQ_L
			movlw	0x65
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;171.3hz ctcss ton
_171.3hz_passt
			movlw	0x78					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x39
			movwf	tmr0h_lowerlimit

			movlw	0xab					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x38
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x48
			movwf	FREQ_L
			movlw	0x67
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;173.8hz ctcss ton
_173.8hz_passt
			movlw	0x96					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x38
			movwf	tmr0h_lowerlimit

			movlw	0xbe					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x37
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xca
			movwf	FREQ_L
			movlw	0x68
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;177.3hz ctcss ton
_177.3hz_passt
			movlw	0xa3					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x37
			movwf	tmr0h_lowerlimit

			movlw	0xb2					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x36
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xe6
			movwf	FREQ_L
			movlw	0x6a
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;179.9hz ctcss ton
_179.9hz_passt
			movlw	0x9d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x36
			movwf	tmr0h_lowerlimit

			movlw	0xda					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x35
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x78
			movwf	FREQ_L
			movlw	0x6c
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;183.5hz ctcss ton
_183.5hz_passt
			movlw	0xa6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x35
			movwf	tmr0h_lowerlimit

			movlw	0xd9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x34
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xa3
			movwf	FREQ_L
			movlw	0x6e
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;186.2hz ctcss ton
_186.2hz_passt
			movlw	0xc4					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x34
			movwf	tmr0h_lowerlimit

			movlw	0x15					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x34
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x44
			movwf	FREQ_L
			movlw	0x70
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;189.9hz ctcss ton
_189.9hz_passt
			movlw	0xf2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x33
			movwf	tmr0h_lowerlimit

			movlw	0x11					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x33
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x7f
			movwf	FREQ_L
			movlw	0x72
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;192.8hz ctcss ton
_192.8hz_passt
			movlw	0xf6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x32
			movwf	tmr0h_lowerlimit

			movlw	0x3f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x32
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x3f
			movwf	FREQ_L
			movlw	0x74
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;196.6hz ctcss ton
_196.6hz_passt
			movlw	0x2d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x32
			movwf	tmr0h_lowerlimit

			movlw	0x53					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x31
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x89
			movwf	FREQ_L
			movlw	0x76
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;199.5hz ctcss ton
_199.5hz_passt
			movlw	0x3f					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x31
			movwf	tmr0h_lowerlimit

			movlw	0x8f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x30
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x49
			movwf	FREQ_L
			movlw	0x78
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;203.5hz ctcss ton
_203.5hz_passt
			movlw	0x7a					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x30
			movwf	tmr0h_lowerlimit

			movlw	0xb3					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2f
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xb2
			movwf	FREQ_L
			movlw	0x7a
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;206.5hz ctcss ton
_206.5hz_passt
			movlw	0x0a					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2f
			movwf	tmr0h_lowerlimit

			movlw	0xea					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2e
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x81
			movwf	FREQ_L
			movlw	0x7c
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;210.7hz ctcss ton
_210.7hz_passt
			movlw	0xd2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2e
			movwf	tmr0h_lowerlimit

			movlw	0xa9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2d
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x0a
			movwf	FREQ_L
			movlw	0x7f
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;218.1hz ctcss ton
_218.1hz_passt
			movlw	0x76					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2d
			movwf	tmr0h_lowerlimit

			movlw	0x1d					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2c
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x80
			movwf	FREQ_L
			movlw	0x83
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;225.7hz ctcss ton
_225.7hz_passt
			movlw	0xee					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2b
			movwf	tmr0h_lowerlimit

			movlw	0xf7					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2a
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x15
			movwf	FREQ_L
			movlw	0x88
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;229.1hz ctcss ton
_229.1hz_passt
			movlw	0xe6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2a
			movwf	tmr0h_lowerlimit

			movlw	0x49					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2a
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x22
			movwf	FREQ_L
			movlw	0x8a
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;233.6hz ctcss ton
_233.6hz_passt
			movlw	0x25					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2a
			movwf	tmr0h_lowerlimit

			movlw	0x2f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x29
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xd8
			movwf	FREQ_L
			movlw	0x8c
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;241.8hz ctcss ton
_241.8hz_passt
			movlw	0x01					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x29
			movwf	tmr0h_lowerlimit

			movlw	0xca					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x27
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xca
			movwf	FREQ_L
			movlw	0x91
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;250.3hz ctcss ton
_250.3hz_passt
			movlw	0x9d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x27
			movwf	tmr0h_lowerlimit

			movlw	0xbe					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x26
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xea
			movwf	FREQ_L
			movlw	0x96
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;254.1hz ctcss ton
_254.1hz_passt
			movlw	0xab					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x26
			movwf	tmr0h_lowerlimit

			movlw	0xdd					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x25
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x34
			movwf	FREQ_L
			movlw	0x99
			movwf	FREQ_M
			movlw	0x00
			movwf	FREQ_H

			goto	bremspause	

;1000hz ton
_1000hz_passt
			movlw	0xeb					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x09
			movwf	tmr0h_lowerlimit

			movlw	0x9f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x09
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xee
			movwf	FREQ_L
			movlw	0xa5
			movwf	FREQ_M
			movlw	0x02
			movwf	FREQ_H

			goto	bremspause	

;1250hz ton
_1250hz_passt
			movlw	0xef					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x07
			movwf	tmr0h_lowerlimit

			movlw	0xb2					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x07
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xaa
			movwf	FREQ_L
			movlw	0xf1
			movwf	FREQ_M
			movlw	0x02
			movwf	FREQ_H

			goto	bremspause	

;1500hz ton
_1500hz_passt
			movlw	0x9d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x06
			movwf	tmr0h_lowerlimit

			movlw	0x6a					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x06
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x66
			movwf	FREQ_L
			movlw	0x88
			movwf	FREQ_M
			movlw	0x03
			movwf	FREQ_H

			goto	bremspause	

;1750hz ton
_1750hz_passt
			movlw	0xab					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x05
			movwf	tmr0h_lowerlimit

			movlw	0x7f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x05
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x21
			movwf	FREQ_L
			movlw	0x1f
			movwf	FREQ_M
			movlw	0x04
			movwf	FREQ_H

			goto	bremspause	

;2000hz ton
_2000hz_passt
			movlw	0xf6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x04
			movwf	tmr0h_lowerlimit

			movlw	0xcf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x04
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xdd
			movwf	FREQ_L
			movlw	0xb5
			movwf	FREQ_M
			movlw	0x04
			movwf	FREQ_H

			goto	bremspause	

;2250hz ton
_2250hz_passt
			movlw	0x69					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x04
			movwf	tmr0h_lowerlimit

			movlw	0x46					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x04
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x98
			movwf	FREQ_L
			movlw	0x4c
			movwf	FREQ_M
			movlw	0x05
			movwf	FREQ_H

			goto	bremspause	

;2500hz ton
_2500hz_passt
			movlw	0xf8					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0xd9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x03
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x54
			movwf	FREQ_L
			movlw	0xe3
			movwf	FREQ_M
			movlw	0x05
			movwf	FREQ_H

			goto	bremspause	

;2750hz ton
_2750hz_passt
			movlw	0x9b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0x7f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x03
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x10
			movwf	FREQ_L
			movlw	0x7a
			movwf	FREQ_M
			movlw	0x06
			movwf	FREQ_H

			goto	bremspause	

;3000hz ton
_3000hz_passt
			movlw	0x4f					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0x35					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x03
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xcb
			movwf	FREQ_L
			movlw	0x10
			movwf	FREQ_M
			movlw	0x07
			movwf	FREQ_H

			goto	bremspause	

;3250hz ton
_3250hz_passt
			movlw	0x0d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0xf5					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x87
			movwf	FREQ_L
			movlw	0xa7
			movwf	FREQ_M
			movlw	0x07
			movwf	FREQ_H

			goto	bremspause	

;3500hz ton
_3500hz_passt
			movlw	0xd6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0xbf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x42
			movwf	FREQ_L
			movlw	0x3e
			movwf	FREQ_M
			movlw	0x08
			movwf	FREQ_H

			goto	bremspause	

;3750hz ton
_3750hz_passt
			movlw	0xa5					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0x90					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xfe
			movwf	FREQ_L
			movlw	0xd4
			movwf	FREQ_M
			movlw	0x08
			movwf	FREQ_H

			goto	bremspause	

;4000hz ton
_4000hz_passt
			movlw	0x7b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0x67					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0xba
			movwf	FREQ_L
			movlw	0x6b
			movwf	FREQ_M
			movlw	0x09
			movwf	FREQ_H

			goto	bremspause	

;4250hz ton
_4250hz_passt
			movlw	0x56					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0x43					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
		;register fr dds tonerzeuguzng initialisieren
			movlw	0x75
			movwf	FREQ_L
			movlw	0x02
			movwf	FREQ_M
			movlw	0x0a
			movwf	FREQ_H

			goto	bremspause	


;----ende tonauswahl

			


bremspause
			;test, ob ctcss ton gesendet werden soll
			;irupts whrenddessen verbieten
			btfsc	ctcss_senden		;ton senden (taster an porta, 0)
			goto	bremspause1			;nein, nicht gedrckt
			call	wait_8ms			;ja, debounce
			btfsc	ctcss_senden		;ton senden?
			goto	bremspause1			;nein, doch nicht gedrckt
			bcf		INTCON, GIE			;ja, taster doch gedrckt;verbiete interrupts whrend des sendens 	
			goto	start_ctcss_dds		;

bremspause1	call	wait_1ms
			decfsz	hauptzaehler, 1					
			goto	start				;noch keine 100mS rum ohne irupt
			movlw	d'100'				;100mS ohne interrupt, kein ctcss da, ausschalten
			movwf	hauptzaehler			;neu init vom 100mS zaehler
			clrf	timer_erfolgszaehler
			clrf	timer_erfolgszaehler_1750hz
			;bcf		ctcss_da_plus			;100mS ohne interrupt, kein ctcss da, ausschalten
			bcf		ctcss_da_plus1
			bsf		ctcss_da_minus
			bcf		_1750hz_da_plus
			bsf		_1750hz_da_minus
			goto	start


;-------------dds ton senden
start_ctcss_dds
			;bcf		ctcss_da_plus			;falls vorher ton erkannt wurde diesen pin ausschalten
			bcf		ctcss_da_plus1
			bsf		ctcss_da_minus
			bcf		_1750hz_da_plus
			bsf		_1750hz_da_minus
			bsf		ctcss_led
			movlw	d'100'				;reenable 100ms zaehler 
			movwf	hauptzaehler	
			clrf            ACC_H		;dds akku leeren
            clrf            ACC_M
            clrf            ACC_L

;;;;;;;;;;;;;DDS Loop (NCO: numerical controlled oscillator);DDS Loop needs exactly and always 23 cycles
;;;;;;;;;;;;;;do not change this loop!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
                
NCOLoop         ; is key pressed?
                btfsc           ctcss_senden                 	;yes 1 / 2) bei tonausgabe immer 2 zyklen
                goto            stop_tone               ;no 2)interessiert bei tonausgabe nicht

AddFreq
                ; add freq value to phase accumulator
                ; 24bit
                movf            FREQ_L,w                ; 1
                addwf         	ACC_L, f                ; 1

                movf            FREQ_M,w                ; 1
                btfsc           STATUS,C                ; 1 / 2)in sum always 3 cycles
                incfsz          FREQ_M,w                ; 1 / 2)
                addwf           ACC_M,f                 ; 1

                movf            FREQ_H,w                ; 1
                btfsc           STATUS,C                ; 1 / 2)zusammen immer 3 zyklen
                incfsz          FREQ_H,w                ; 1 / 2)
                addwf           ACC_H,f                 ; 1
                
LookupSine
                movf            ACC_H,w                 ; 1
;                
				;sine table read (256 entries)
				movwf 			TBLPTRL					;1	;low adress of table location = one of the 256 entries
				movlw			0x1c					;1
				movwf			TBLPTRH					;1	;high adress of tablelocation (start adress)
				TBLRD*									;2
				movf			TABLAT, 0				;1	(6 in 18f252)
	
				
Output
                movwf           PORTC                   ; 1
Again
                goto            NCOLoop                 ; 2

;;;;;;;;;;;;;;;;;;;end dds

stop_tone		call			wait_8ms			;debounce
				btfss			ctcss_senden		
				goto			NCOLoop
				clrf            ACC_H
                clrf            ACC_M
                clrf            ACC_L
 				movlw			0x80	
				movwf			PORTC                   
          		bcf				ctcss_led
				bsf				INTCON, GIE			;reenable irupts
				goto			bremspause1

			

;-------------===========SUBROUTINEN==============
;----------------16bit arithmetic
		;Routine comparing two unsigned 16-bit numbers:
		;Written by Martin Viteznik, jsem () einstein ddot cz
		;this routine compares two unsigned 16-bit values,
		;X and Y. The H-byte is hbyte(X|y) etc. :-)

		;input: first number in hbyteX and lbyteX		
		;input: second number in hbyteY and lbyteY 	
		;result in	compare16bit:	bit 0 = high: equal
		;							bit	1 = high: first number is greater
		;							bit 2 = high: second number is greater
		

compare		movf hbyteX,0
			subwf hbyteY,0
			btfss STATUS,C	;X>Y..zc,X<Y..zC,X=Y..ZC
		    goto Xisgreater	;result: X>Y
			btfss STATUS,Z
		    goto Yisgreater	;result: Y>X
			movf lbyteX,0
			subwf lbyteY,0
			btfss STATUS,C	;X>Y..zc,X<Y..zC,X=Y..ZC
		    goto Xisgreater ;result: X>Y
			btfss STATUS,Z
	    	goto Yisgreater	;result: Y>X
			goto XequY	;result: X=Y

XequY		movlw	b'00000001'
			movwf	compare16bit
			return

Xisgreater	movlw	b'00000010'
			movwf	compare16bit
			return

Yisgreater	movlw	b'00000100'
			movwf	compare16bit
			return



;==================PAUSEN======================
; *****************************************************************************
; *                                                                           *
; * Purpose:  Wait for a specified number of milliseconds.                    *
; *                                                                           *
; *           Entry point wait_128ms:  Wait for 128 msec                      *
; *           Entry point wait_64ms :  Wait for 64 msec                       *
; *           Entry point wait_32ms :  Wait for 32 msec                       *
; *           Entry point wait_16ms :  Wait for 16 msec                       *
; *           Entry point wait_8ms  :  Wait for 8 msec                        *
; *                                                                           *
; *   Input:  None                                                            *
; *                                                                           *
; *  Output:  None                                                            *
; *                                                                           *
; *****************************************************************************
;
;wait_128ms  ; ****** Entry point ******    
;				movlw	  	0xff              ; Set up outer loop 
;				movwf  	 	loop_timer1            ;   counter to 255 (at 4mhz)
;				goto   	 	outer_loop        ; Go to wait loops
;wait_64ms  ; ****** Entry point ******     
;				movlw   	0x80              ; Set up outer loop
;				movwf   	loop_timer1            ;   counter to 128 (at 4mhz)
;				goto    	outer_loop        ; Go to wait loops
wait_32ms   ; ****** Entry point ******    
				movlw   	d'160'              ; Set up outer loop
				movwf   	loop_timer1            ;   counter to 64 (at 4mhz)
				goto    	outer_loop        ; Go to wait loops
wait_16ms   ; ****** Entry point ******    
				movlw   	d'80'              ; Set up outer loop
				movwf   	loop_timer1            ;   counter to 32 (at 4mhz) 
				goto    	outer_loop        ; Go to wait loops
wait_8ms   ; ****** Entry point ******     
				movlw   	d'40'              ; Set up outer loop
				movwf   	loop_timer1            ;   counter to 16 (at 4mhz)
				goto 		outer_loop	  ; Fall through into wait loops
wait_1ms   ; ****** Entry point ******     
				movlw   	d'5'              ; Set up outer loop
				movwf   	loop_timer1            ;   counter to 2 (at 4mhz)
				goto		outer_loop


		
; Wait loops used by other wait routines
;  - 1 microsecond per instruction (with a 4 MHz microprocessor crystal)
;  - 0.4 microsecond per instruction (with a 10 MHz microprocessor crystal)	
;  - 510 instructions per inner loop
;  - (Timer1 * 514) instructions (.514 msec) per outer loop (at 4 MHZ)
;  - (Timer1 * 514) instructions (.2056 msec) per outer loop (at 10 MHZ)
;  - Round off to .5 ms per outer loop (at 4 mhz)
;  - Round off to .2 ms per outer loop (at 10 mhz)
outer_loop                        
				movlw   	0xff              ; Set up inner loop counter
				movwf   	loop_timer2            ;   to 255
inner_loop
				decfsz  	loop_timer2, 1          ; Decrement inner loop counter
				goto    	inner_loop        ; If inner loop counter not down to zero, 
					  ;   then go back to inner loop again
				decfsz  	loop_timer1, 1          ; Yes, Decrement outer loop counter
				goto  		outer_loop        ; If outer loop counter not down to zero,
					  ;   then go back to outer loop again
				return                    ; Yes, return to caller
;--------------ende pausen

;;;;;;;;;;;;;;;eeprom lesen
eeprom_read		
			
			movlw	0x00
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	tmr0l_lowerlimit_1750hz

			movlw	0x01
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	tmr0h_lowerlimit_1750hz

			movlw	0x02
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	tmr0l_upperlimit_1750hz

			movlw	0x03
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	tmr0h_upperlimit_1750hz

			movlw	0x04
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	maxwert

			movlw	0x05
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	maxwert_1750hz

			movlw	0x06
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	minwert

			movlw	0x07
			movwf	EEADR
			bcf		EECON1, EEPGD
			bcf		EECON1, CFGS
			bsf		EECON1, RD
			movf	EEDATA, W
			movwf	minwert_1750hz
			
			return
			

;;;;;;;;;;;;;;;;eeprom beschreiben
einlesen_fuer_tonerkennung


				;----------tonauswahl ber portb, 2 bis 7 mit schaltern
			movff	PORTB, test_tonauswahl	;portb abspeichern
			rrncf	test_tonauswahl, 1		;nach rechts schieben 2 mal
			rrncf	test_tonauswahl, 1
			bcf		test_tonauswahl, 6		;oberste bits lschen
			bcf		test_tonauswahl, 7
			
						;entscheidungen
entscheidung_eeprom_67.0hz
			movlw		b'00000000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_69.3hz	;passt nicht				
			goto		_67.0hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_69.3hz
			movlw		b'00000001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_71.9hz	;passt nicht				
			goto		_69.3hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_71.9hz
			movlw		b'00000010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_74.4hz	;passt nicht				
			goto		_71.9hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_74.4hz
			movlw		b'00000011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_77.0hz	;passt nicht				
			goto		_74.4hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_77.0hz
			movlw		b'00000100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_79.7hz	;passt nicht				
			goto		_77.0hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_79.7hz
			movlw		b'00000101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_82.5hz	;passt nicht				
			goto		_79.7hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_82.5hz
			movlw		b'00000110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_85.4hz	;passt nicht				
			goto		_82.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_85.4hz
			movlw		b'00000111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_88.5hz	;passt nicht				
			goto		_85.4hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_88.5hz
			movlw		b'00001000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_91.5hz	;passt nicht				
			goto		_88.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_91.5hz
			movlw		b'00001001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_94.8hz	;passt nicht				
			goto		_91.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_94.8hz
			movlw		b'00001010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_97.4hz	;passt nicht				
			goto		_94.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_97.4hz
			movlw		b'00001011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_100.0hz	;passt nicht				
			goto		_97.4hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_100.0hz
			movlw		b'00001100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_103.5hz	;passt nicht				
			goto		_100.0hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_103.5hz
			movlw		b'00001101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_107.2hz	;passt nicht				
			goto		_103.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_107.2hz
			movlw		b'00001110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_110.9hz	;passt nicht				
			goto		_107.2hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_110.9hz
			movlw		b'00001111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_114.8hz	;passt nicht				
			goto		_110.9hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_114.8hz
			movlw		b'00010000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_118.8hz	;passt nicht				
			goto		_114.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_118.8hz
			movlw		b'00010001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_123.0hz	;passt nicht				
			goto		_118.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_123.0hz
			movlw		b'00010010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_127.3hz	;passt nicht				
			goto		_123.0hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_127.3hz
			movlw		b'00010011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_131.8hz	;passt nicht				
			goto		_127.3hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_131.8hz
			movlw		b'00010100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_136.5hz	;passt nicht				
			goto		_131.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_136.5hz
			movlw		b'00010101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_141.3hz	;passt nicht				
			goto		_136.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_141.3hz
			movlw		b'00010110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_146.2hz	;passt nicht				
			goto		_141.3hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_146.2hz
			movlw		b'00010111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_151.4hz	;passt nicht				
			goto		_146.2hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_151.4hz
			movlw		b'00011000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_156.7hz	;passt nicht				
			goto		_151.4hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_156.7hz
			movlw		b'00011001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_159.8hz	;passt nicht				
			goto		_156.7hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_159.8hz
			movlw		b'00011010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_162.2hz	;passt nicht				
			goto		_159.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_162.2hz
			movlw		b'00011011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_165.5hz	;passt nicht				
			goto		_162.2hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_165.5hz
			movlw		b'00011100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_167.9hz	;passt nicht				
			goto		_165.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_167.9hz
			movlw		b'00011101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_171.3hz	;passt nicht				
			goto		_167.9hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_171.3hz
			movlw		b'00011110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_173.8hz	;passt nicht				
			goto		_171.3hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_173.8hz
			movlw		b'00011111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_177.3hz	;passt nicht				
			goto		_173.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_177.3hz
			movlw		b'00100000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_179.9hz	;passt nicht				
			goto		_177.3hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_179.9hz
			movlw		b'00100001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_183.5hz	;passt nicht				
			goto		_179.9hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_183.5hz
			movlw		b'00100010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_186.2hz	;passt nicht				
			goto		_183.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_186.2hz
			movlw		b'00100011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_189.9hz	;passt nicht				
			goto		_186.2hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_189.9hz
			movlw		b'00100100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_192.8hz	;passt nicht				
			goto		_189.9hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_192.8hz
			movlw		b'00100101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_196.6hz	;passt nicht				
			goto		_192.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_196.6hz
			movlw		b'00100110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_199.5hz	;passt nicht				
			goto		_196.6hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_199.5hz
			movlw		b'00100111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_203.5hz	;passt nicht				
			goto		_199.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_203.5hz
			movlw		b'00101000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_206.5hz	;passt nicht				
			goto		_203.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_206.5hz
			movlw		b'00101001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_210.7hz	;passt nicht				
			goto		_206.5hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_210.7hz
			movlw		b'00101010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_218.1hz	;passt nicht				
			goto		_210.7hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_218.1hz
			movlw		b'00101011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_225.7hz	;passt nicht				
			goto		_218.1hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_225.7hz
			movlw		b'00101100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_229.1hz	;passt nicht				
			goto		_225.7hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_229.1hz
			movlw		b'00101101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_233.6hz	;passt nicht				
			goto		_229.1hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_233.6hz
			movlw		b'00101110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_241.8hz	;passt nicht				
			goto		_233.6hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_241.8hz
			movlw		b'00101111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_250.3hz	;passt nicht				
			goto		_241.8hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_250.3hz
			movlw		b'00110000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_254.1hz	;passt nicht				
			goto		_250.3hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_254.1hz
			movlw		b'00110001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_1000hz	;passt nicht				
			goto		_254.1hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_1000hz
			movlw		b'00110010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_1250hz	;passt nicht				
			goto		_1000hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_1250hz
			movlw		b'00110011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_1500hz	;passt nicht				
			goto		_1250hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_1500hz
			movlw		b'00110100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_1750hz	;passt nicht				
			goto		_1500hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_1750hz
			movlw		b'00110101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_2000hz	;passt nicht				
			goto		_1750hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_2000hz
			movlw		b'00110110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_2250hz	;passt nicht				
			goto		_2000hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_2250hz
			movlw		b'00110111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_2500hz	;passt nicht				
			goto		_2250hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_2500hz
			movlw		b'00111000'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_2750hz	;passt nicht				
			goto		_2500hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_2750hz
			movlw		b'00111001'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_3000hz	;passt nicht				
			goto		_2750hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_3000hz
			movlw		b'00111010'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_3250hz	;passt nicht				
			goto		_3000hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_3250hz
			movlw		b'00111011'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_3500hz	;passt nicht				
			goto		_3250hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_3500hz
			movlw		b'00111100'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_3750hz	;passt nicht				
			goto		_3500hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_3750hz
			movlw		b'00111101'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_4000hz	;passt nicht				
			goto		_3750hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_4000hz
			movlw		b'00111110'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			goto		entscheidung_eeprom_4250hz	;passt nicht				
			goto		_4000hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

entscheidung_eeprom_4250hz
			movlw		b'00111111'			;schalterstellungen testen; sind in bit 0 bis bit 5
			cpfseq		test_tonauswahl		;schauen ob schalter passt
			return							;passt nicht, kein schalter passt, wir haben misst gemessen				
			goto		_4250hz_passt_eeprom		;passt, dort dann kurz interrupts verbieten, bis werte in den registern stehen

;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;





;67.0hz ctcss ton
_67.0hz_passt_eeprom
			movlw	0xfa					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x93
			movwf	tmr0h_lowerlimit

			movlw	0x9a					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x8f
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'2'
			movwf	maxwert
			movwf	maxwert_1750hz


			return	 	

;69.3hz ctcss ton
_69.3hz_passt_eeprom
			movlw	0x11					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x8f
			movwf	tmr0h_lowerlimit

			movlw	0xd5					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x8a
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'4'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;71.9hz ctcss ton
_71.9hz_passt_eeprom
			movlw	0xe5					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x89
			movwf	tmr0h_lowerlimit

			movlw	0xd0					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x85
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'6'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	
;74.4hz ctcss ton
_74.4hz_passt_eeprom
			movlw	0x42					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x85
			movwf	tmr0h_lowerlimit

			movlw	0x51					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x81
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'8'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;77.0hz ctcss ton
_77.0hz_passt_eeprom
			movlw	0xc2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x80
			movwf	tmr0h_lowerlimit

			movlw	0xf3					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x7c
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'12'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;79.7hz ctcss ton
_79.7hz_passt_eeprom
			movlw	0x66					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x7c
			movwf	tmr0h_lowerlimit

			movlw	0xb8					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x78
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'16'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;82.5hz ctcss ton
_82.5hz_passt_eeprom
			movlw	0x2d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x78
			movwf	tmr0h_lowerlimit

			movlw	0x9f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x74
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'20'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;85.4hz ctcss ton
_85.4hz_passt_eeprom
			movlw	0x18					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x74
			movwf	tmr0h_lowerlimit

			movlw	0xa9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x70
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'25'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;88.5hz ctcss ton
_88.5hz_passt_eeprom
			movlw	0x07					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x70
			movwf	tmr0h_lowerlimit

			movlw	0xb7					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x6c
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'30'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;91.5hz ctcss ton
_91.5hz_passt_eeprom
			movlw	0x5b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x6c
			movwf	tmr0h_lowerlimit

			movlw	0x26					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x69
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'35'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;94.8hz ctcss ton
_94.8hz_passt_eeprom
			movlw	0x95					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x68
			movwf	tmr0h_lowerlimit

			movlw	0x7d					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x65
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'40'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;97.4hz ctcss ton
_97.4hz_passt_eeprom
			movlw	0x47					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x65
			movwf	tmr0h_lowerlimit

			movlw	0x45					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x63
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'45'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;100hz ctcss ton
_100.0hz_passt_eeprom
			movlw	0x25					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x63
			movwf	tmr0h_lowerlimit

			movlw	0x36					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x60
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'50'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;103.5hz ctcss ton
_103.5hz_passt_eeprom
			movlw	0xcb					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x5f
			movwf	tmr0h_lowerlimit

			movlw	0xf5					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x5c
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'55'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;107.2hz ctcss ton
_107.2hz_passt_eeprom
			movlw	0x7d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x5c
			movwf	tmr0h_lowerlimit

			movlw	0xc0					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x59
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'60'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;110.9hz ctcss ton
_110.9hz_passt_eeprom
			movlw	0x67					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x59
			movwf	tmr0h_lowerlimit

			movlw	0xc1					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x56
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'70'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;114.8hz ctcss ton
_114.8hz_passt_eeprom
			movlw	0x5d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x56
			movwf	tmr0h_lowerlimit

			movlw	0xcf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x53
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'80'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;118.8hz ctcss ton
_118.8hz_passt_eeprom
			movlw	0x75					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x53
			movwf	tmr0h_lowerlimit

			movlw	0xfc					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x50
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'90'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;123.0hz ctcss ton
_123.0hz_passt_eeprom
			movlw	0x9b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x50
			movwf	tmr0h_lowerlimit

			movlw	0x38					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x4e
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'100'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;127.3hz ctcss ton
_127.3hz_passt_eeprom
			movlw	0xe2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x4d
			movwf	tmr0h_lowerlimit

			movlw	0x94					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x4b
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'120'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;131.8hz ctcss ton
_131.8hz_passt_eeprom
			movlw	0x39					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x4b
			movwf	tmr0h_lowerlimit

			movlw	0xff					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x48
			movwf	tmr0h_upperlimit

			movlw	d'0'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'160'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;136.5hz ctcss ton
_136.5hz_passt_eeprom
			movlw	0xa2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x48
			movwf	tmr0h_lowerlimit

			movlw	0x7c					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x46
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'2'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;141.3hz ctcss ton
_141.3hz_passt_eeprom
			movlw	0x2b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x46
			movwf	tmr0h_lowerlimit

			movlw	0x17					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x44
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'4'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;146.2hz ctcss ton
_146.2hz_passt_eeprom
			movlw	0xd1					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x43
			movwf	tmr0h_lowerlimit

			movlw	0xcf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x41
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'6'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;151.4hz ctcss ton
_151.4hz_passt_eeprom
			movlw	0x7d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x41
			movwf	tmr0h_lowerlimit

			movlw	0x8c					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3f
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'8'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;156.7hz ctcss ton
_156.7hz_passt_eeprom
			movlw	0x46					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3f
			movwf	tmr0h_lowerlimit

			movlw	0xd3					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3d
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'12'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;159.8hz ctcss ton
_159.8hz_passt_eeprom
			movlw	0xbb					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3d
			movwf	tmr0h_lowerlimit

			movlw	0xaf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3c
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'16'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;162.2hz ctcss ton
_162.2hz_passt_eeprom
			movlw	0x93					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3c
			movwf	tmr0h_lowerlimit

			movlw	0xba					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3b
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'20'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;165.5hz ctcss ton
_165.5hz_passt_eeprom
			movlw	0x9b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3b
			movwf	tmr0h_lowerlimit

			movlw	0xb6					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x3a
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'25'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;167.9hz ctcss ton
_167.9hz_passt_eeprom
			movlw	0xa2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x3a
			movwf	tmr0h_lowerlimit

			movlw	0x96					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x39
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'30'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;171.3hz ctcss ton
_171.3hz_passt_eeprom
			movlw	0x78					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x39
			movwf	tmr0h_lowerlimit

			movlw	0xab					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x38
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'35'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;173.8hz ctcss ton
_173.8hz_passt_eeprom
			movlw	0x96					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x38
			movwf	tmr0h_lowerlimit

			movlw	0xbe					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x37
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'40'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;177.3hz ctcss ton
_177.3hz_passt_eeprom
			movlw	0xa3					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x37
			movwf	tmr0h_lowerlimit

			movlw	0xb2					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x36
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'45'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;179.9hz ctcss ton
_179.9hz_passt_eeprom
			movlw	0x9d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x36
			movwf	tmr0h_lowerlimit

			movlw	0xda					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x35
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'50'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;183.5hz ctcss ton
_183.5hz_passt_eeprom
			movlw	0xa6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x35
			movwf	tmr0h_lowerlimit

			movlw	0xd9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x34
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'55'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;186.2hz ctcss ton
_186.2hz_passt_eeprom
			movlw	0xc4					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x34
			movwf	tmr0h_lowerlimit

			movlw	0x15					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x34
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'60'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;189.9hz ctcss ton
_189.9hz_passt_eeprom
			movlw	0xf2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x33
			movwf	tmr0h_lowerlimit

			movlw	0x11					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x33
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'70'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;192.8hz ctcss ton
_192.8hz_passt_eeprom
			movlw	0xf6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x32
			movwf	tmr0h_lowerlimit

			movlw	0x3f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x32
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'80'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;196.6hz ctcss ton
_196.6hz_passt_eeprom
			movlw	0x2d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x32
			movwf	tmr0h_lowerlimit

			movlw	0x53					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x31
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'90'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;199.5hz ctcss ton
_199.5hz_passt_eeprom
			movlw	0x3f					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x31
			movwf	tmr0h_lowerlimit

			movlw	0x8f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x30
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'100'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;203.5hz ctcss ton
_203.5hz_passt_eeprom
			movlw	0x7a					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x30
			movwf	tmr0h_lowerlimit

			movlw	0xb3					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2f
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'120'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;206.5hz ctcss ton
_206.5hz_passt_eeprom
			movlw	0x0a					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2f
			movwf	tmr0h_lowerlimit

			movlw	0xea					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2e
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'160'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;210.7hz ctcss ton
_210.7hz_passt_eeprom
			movlw	0xd2					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2e
			movwf	tmr0h_lowerlimit

			movlw	0xa9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2d
			movwf	tmr0h_upperlimit

			movlw	d'2'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'200'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;218.1hz ctcss ton
_218.1hz_passt_eeprom
			movlw	0x76					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2d
			movwf	tmr0h_lowerlimit

			movlw	0x1d					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2c
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'4'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;225.7hz ctcss ton
_225.7hz_passt_eeprom
			movlw	0xee					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2b
			movwf	tmr0h_lowerlimit

			movlw	0xf7					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2a
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'6'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;229.1hz ctcss ton
_229.1hz_passt_eeprom
			movlw	0xe6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2a
			movwf	tmr0h_lowerlimit

			movlw	0x49					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x2a
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'8'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;233.6hz ctcss ton
_233.6hz_passt_eeprom
			movlw	0x25					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x2a
			movwf	tmr0h_lowerlimit

			movlw	0x2f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x29
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'12'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;241.8hz ctcss ton
_241.8hz_passt_eeprom
			movlw	0x01					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x29
			movwf	tmr0h_lowerlimit

			movlw	0xca					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x27
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'16'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;250.3hz ctcss ton
_250.3hz_passt_eeprom
			movlw	0x9d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x27
			movwf	tmr0h_lowerlimit

			movlw	0xbe					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x26
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'20'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;254.1hz ctcss ton
_254.1hz_passt_eeprom
			movlw	0xab					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x26
			movwf	tmr0h_lowerlimit

			movlw	0xdd					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x25
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'25'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;1000hz ton
_1000hz_passt_eeprom
			movlw	0xeb					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x09
			movwf	tmr0h_lowerlimit

			movlw	0x9f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x09
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'30'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;1250hz ton
_1250hz_passt_eeprom
			movlw	0xef					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x07
			movwf	tmr0h_lowerlimit

			movlw	0xb2					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x07
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'35'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;1500hz ton
_1500hz_passt_eeprom
			movlw	0x9d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x06
			movwf	tmr0h_lowerlimit

			movlw	0x6a					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x06
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'40'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;1750hz ton
_1750hz_passt_eeprom
			movlw	0xab					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x05
			movwf	tmr0h_lowerlimit

			movlw	0x7f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x05
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'45'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;2000hz ton
_2000hz_passt_eeprom
			movlw	0xf6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x04
			movwf	tmr0h_lowerlimit

			movlw	0xcf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x04
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'50'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;2250hz ton
_2250hz_passt_eeprom
			movlw	0x69					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x04
			movwf	tmr0h_lowerlimit

			movlw	0x46					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x04
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'55'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;2500hz ton
_2500hz_passt_eeprom
			movlw	0xf8					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0xd9					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x03
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'60'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;2750hz ton
_2750hz_passt_eeprom
			movlw	0x9b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0x7f					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x03
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'70'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;3000hz ton
_3000hz_passt_eeprom
			movlw	0x4f					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0x35					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x03
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'80'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;3250hz ton
_3250hz_passt_eeprom
			movlw	0x0d					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x03
			movwf	tmr0h_lowerlimit

			movlw	0xf5					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
	
			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'90'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;3500hz ton
_3500hz_passt_eeprom
			movlw	0xd6					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0xbf					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit

			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'100'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;3750hz ton
_3750hz_passt_eeprom
			movlw	0xa5					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0x90					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
	
			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'120'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;4000hz ton
_4000hz_passt_eeprom
			movlw	0x7b					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0x67					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
		
			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'160'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 	

;4250hz ton
_4250hz_passt_eeprom
			movlw	0x56					;untere qrg grenze vom tmr0 (16bit), grerer wert
			movwf	tmr0l_lowerlimit
			movlw	0x02
			movwf	tmr0h_lowerlimit

			movlw	0x43					;obere qrg grenze vom tmr0 (16bit), kleinerer wert
			movwf	tmr0l_upperlimit
			movlw	0x02
			movwf	tmr0h_upperlimit
	
			movlw	d'4'
			movwf	minwert
			movwf	minwert_1750hz
			movlw	d'200'
			movwf	maxwert
			movwf	maxwert_1750hz

			return	 

	


;werte in zwischenregister schreiben und goto eeprom_schreiben, dann return

eeprom_schreiben
			movlw		0x00
			movwf		EEADR
			movf		tmr0l_lowerlimit, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch4
			btfsc		EECON1, WR
			goto		schreibe_noch4
			bcf			EECON1, WREN

			movlw		0x01
			movwf		EEADR
			movf		tmr0h_lowerlimit, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch5
			btfsc		EECON1, WR
			goto		schreibe_noch5
			bcf			EECON1, WREN

			movlw		0x02
			movwf		EEADR
			movf		tmr0l_upperlimit, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch6
			btfsc		EECON1, WR
			goto		schreibe_noch6
			bcf			EECON1, WREN

			movlw		0x03
			movwf		EEADR
			movf		tmr0h_upperlimit, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch7
			btfsc		EECON1, WR
			goto		schreibe_noch7
			bcf			EECON1, WREN

			return


;;;;;;;;;;;;;;;;eeprom werte schreiben fr min und maxwerte der hysterese
eeprom_schreiben_hysterese
			movlw		0x04
			movwf		EEADR
			movf		maxwert, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch8
			btfsc		EECON1, WR
			goto		schreibe_noch8
			bcf			EECON1, WREN

			movlw		0x05
			movwf		EEADR
			movf		maxwert_1750hz, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch9
			btfsc		EECON1, WR
			goto		schreibe_noch9
			bcf			EECON1, WREN

			movlw		0x06
			movwf		EEADR
			movf		minwert, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch10
			btfsc		EECON1, WR
			goto		schreibe_noch10
			bcf			EECON1, WREN

			movlw		0x07
			movwf		EEADR
			movf		minwert_1750hz, 0
			movwf		EEDATA
			bcf			EECON1, EEPGD
			bcf			EECON1, CFGS
			bsf			EECON1, WREN
			bcf			INTCON, GIE
			movlw		0x55
			movwf		EECON2
			movlw		0xaa
			movwf		EECON2
			bsf			EECON1, WR
schreibe_noch11
			btfsc		EECON1, WR
			goto		schreibe_noch11
			bcf			EECON1, WREN
			
			return
;-------------------muss am ende des programms stehen
;**************************************************
;
;       SINE Frequency Table with 256 entries
;       copy and paste from SineDDS MatLab script
;		starts at adress 7c00 (7c value: TBLPTRH, offset
;		value: TBLPTRL
;		
;**************************************************
				org		0x001c00
                ;org 0x007c00						; TBLPTRH : holds 7c, TBLPTRL: holds table adress (0 - 255)

				db              0x80,0x83,0x86,0x89,0x8c,0x8f,0x92,0x95 ;table adress 0 - 255
                db              0x98,0x9c,0x9f,0xa2,0xa5,0xa8,0xab,0xae
                db              0xb0,0xb3,0xb6,0xb9,0xbc,0xbf,0xc1,0xc4
                db              0xc7,0xc9,0xcc,0xce,0xd1,0xd3,0xd5,0xd8
                db              0xda,0xdc,0xde,0xe0,0xe2,0xe4,0xe6,0xe8
                db              0xea,0xec,0xed,0xef,0xf0,0xf2,0xf3,0xf5
                db              0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfc
                db              0xfd,0xfe,0xfe,0xff,0xff,0xff,0xff,0xff
                db              0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xfe
                db              0xfd,0xfc,0xfc,0xfb,0xfa,0xf9,0xf8,0xf7
                db              0xf6,0xf5,0xf3,0xf2,0xf0,0xef,0xed,0xec
                db              0xea,0xe8,0xe6,0xe4,0xe2,0xe0,0xde,0xdc
                db              0xda,0xd8,0xd5,0xd3,0xd1,0xce,0xcc,0xc9
                db              0xc7,0xc4,0xc1,0xbf,0xbc,0xb9,0xb6,0xb3
                db              0xb0,0xae,0xab,0xa8,0xa5,0xa2,0x9f,0x9c
                db              0x98,0x95,0x92,0x8f,0x8c,0x89,0x86,0x83
                db              0x80,0x7c,0x79,0x76,0x73,0x70,0x6d,0x6a
                db              0x67,0x63,0x60,0x5d,0x5a,0x57,0x54,0x51
                db              0x4f,0x4c,0x49,0x46,0x43,0x40,0x3e,0x3b
                db              0x38,0x36,0x33,0x31,0x2e,0x2c,0x2a,0x27
                db              0x25,0x23,0x21,0x1f,0x1d,0x1b,0x19,0x17
                db              0x15,0x13,0x12,0x10,0x0f,0x0d,0x0c,0x0a
                db              0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x03
                db              0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00
                db              0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01
                db              0x02,0x03,0x03,0x04,0x05,0x06,0x07,0x08
                db              0x09,0x0a,0x0c,0x0d,0x0f,0x10,0x12,0x13
                db              0x15,0x17,0x19,0x1b,0x1d,0x1f,0x21,0x23
                db              0x25,0x27,0x2a,0x2c,0x2e,0x31,0x33,0x36
                db              0x38,0x3b,0x3e,0x40,0x43,0x46,0x49,0x4c
                db              0x4f,0x51,0x54,0x57,0x5a,0x5d,0x60,0x63
                db              0x67,0x6a,0x6d,0x70,0x73,0x76,0x79,0x7c



		end


