/*
 *    throb.h  --  THROB modem
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#pragma once

#include "../misc/cmplx.h"
#include "../main/trx.h"

#define	SampleRate	8000
#define	DownSample	32

#define	NumTones	11
#define	SymbolLen1	8192
#define	SymbolLen2	4096
#define	SymbolLen4	2048

#define	MaxRxSymLen	(SymbolLen1 / DownSample)

#define	FilterFFTLen	8192

struct throb {
	/// length of the symbol at 8000 samples / sec
	int				symlen;
	/// phase accumulator for receiver
	unsigned int	phaseacc;
	/// frequency bins after the signal has been shifted to zero
	int			   *freqs;

	/// RX related stuff
	struct filter  *rxfilter;
	struct filter  *syncfilt;

	cmplx          *rxtone[NumTones];
	/// number of tones is 9 for Throb and 11 for ThrobX
	int				nTones;

	/// Character table
	int				nChars;
	unsigned char  *pCharSet;
	unsigned char  *pTonePairs;
	int				nSymIdle;
	int				nSymSpace;
	int				nCharLast;

	// Decimated sample of the last symbol, cyclic buffer
	cmplx			symbol[MaxRxSymLen];
	// Active pointer into the cyclic buffer
	int				symptr;

	int				syncbuf[MaxRxSymLen];
	/// result of the syncbuf
	int				dispbuf[MaxRxSymLen];

	/// Counts down decimated samples of the currently received symbol.
	/// There is maximum MaxRxSymLen decimated samples in a symbol (256), therefore it may be shifted
	/// << 16 to gain precission
	int				rxcntr;

	// length of the decimated symbol
	int				rxsymlen;
	BOOL			bShift;
	BOOL			bWaitSync;

	/*
	 * TX related stuff
	 */
	int				preamble;
	int            *txpulse;
	BOOL			bStopping;
};

/* in throb.c */
extern void throb_init(Trx *trx);

/* in throbrx.c */
extern int throb_rxprocess(Trx *trx, short *buf, int len);

/* in throbtx.c */
extern int throb_txprocess(Trx *trx);

extern void throb_flip_syms(Trx *trx);
extern void throb_reset_syms(Trx *trx);
