/*
 *    rtty.h  --  RTTY modem
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#pragma once

#include "../main/trx.h"
#include "../misc/cmplx.h"

#define	SampleRate	8000
#define	MaxSymLen	1024

typedef enum {
	RTTY_RX_STATE_IDLE = 0,
	RTTY_RX_STATE_START,
	RTTY_RX_STATE_DATA,
	RTTY_RX_STATE_PARITY,
	RTTY_RX_STATE_STOP,
	RTTY_RX_STATE_STOP2
} rtty_rx_state_t;

typedef enum {
	RTTY_PARITY_NONE = 0,
	RTTY_PARITY_EVEN,
	RTTY_PARITY_ODD,
	RTTY_PARITY_ZERO,
	RTTY_PARITY_ONE
} parity_t;

struct rtty {
	/*
	 * Common stuff
	 */
	int					shift;
	int					symbollen;
	int					nbits;
	parity_t			parity;
	int					stoplen;
	int					msb;

	unsigned long		phaseacc;
	unsigned long		phaseacc2;

	/*
	 * RX related stuff
	 */
	struct filter      *rxfilter;
	struct filter      *rxfilter2;
	struct filter	   *rxbitfir;

	int					pipe[MaxSymLen];
	unsigned int		pipeptr;

	int					bbfilter[MaxSymLen];
	int					symbuf[177*7];
	int					symbufpos;
	int					symbuflen;
	int					symbufsz;
	BOOL				bFramingError;
	unsigned int		filterptr;

	rtty_rx_state_t		rxstate;

	int					counter;
	int					bitcntr;
	int					rxdata;

	cmplx				prevsample;

	/// BAUDOT_LETS or BAUDOT_FIGS
	int					nBaudotRxMode;
	int					nBaudotTxMode;
	BOOL				bUnshiftOnSpace;

	/// TX related
	int					preamble;
};

/* in rtty.c */
extern void		rtty_init(Trx *trx);

/* in rttyrx.c */
extern int		rtty_rxprocess(Trx *trx, short *buf, int len);

/* in rttytx.c */
extern int		rtty_txprocess(Trx *trx);
