#include "coeff.h"

/* Linux PSK31 modem driver for soundcard -- Filter coefficients
 *
 * these FIR coefs are those used by G0TJZ in his TMC320C50 code
 *
 * Hansi Reiser, DL9RDZ, 20 April 1998
 */

#define	USE_NEW_FILTER

/* 64-tap raised-cosine FIR*/
float psk31_fir1c[64] = {
	0.000000f,
	0.000038f,
	0.000150f,
	0.000336f,
	0.000595f,
	0.000922f,
	0.001317f,
	0.001773f,
	0.002288f,
	0.002856f,
	0.003472f,
	0.004130f,
	0.004823f,
	0.005545f,
	0.006288f,
	0.007047f,
	0.007812f,
	0.008578f,
	0.009337f,
	0.010080f,
	0.010802f,
	0.011495f,
	0.012153f,
	0.012769f,
	0.013337f,
	0.013852f,
	0.014308f,
	0.014703f,
	0.015030f,
	0.015289f,
	0.015475f,
	0.015587f,
	0.015625f,
	0.015587f,
	0.015475f,
	0.015289f,
	0.015030f,
	0.014703f,
	0.014308f,
	0.013852f,
	0.013337f,
	0.012769f,
	0.012153f,
	0.011495f,
	0.010802f,
	0.010080f,
	0.009337f,
	0.008578f,
	0.007813f,
	0.007047f,
	0.006288f,
	0.005545f,
	0.004823f,
	0.004130f,
	0.003472f,
	0.002856f,
	0.002288f,
	0.001773f,
	0.001317f,
	0.000922f,
	0.000595f,
	0.000336f,
	0.000150f,
	0.000038f,
};

/* 4-bit receive filter for 31.25 baud BPSK
 * Designed by G3PLX, version 2
 */
#ifndef	USE_NEW_FILTER

float psk31_fir2c[64] = {
	-0.00044789f,
	-0.00063167f,
	-0.00100256f,
	-0.00156531f,
	-0.00232266f,
	-0.00327063f,
	-0.00439342f,
	-0.00565850f,
	-0.00701253f,
	-0.00837907f,
	-0.00965823f,
	-0.01072878f,
	-0.01145278f,
	-0.01168246f,
	-0.01126911f,
	-0.01007335f,
	-0.00797606f,
	-0.00488924f,
	-0.00076591f,
	0.00439171f,
	0.01052660f,
	0.01752432f,
	0.02521404f,
	0.03337329f,
	0.04173643f,
	0.05000649f,
	0.05786981f,
	0.06501264f,
	0.07113857f,
	0.07598566f,
	0.07934199f,
	0.08105860f,
	0.08105860f,
	0.07934199f,
	0.07598566f,
	0.07113857f,
	0.06501264f,
	0.05786981f,
	0.05000649f,
	0.04173643f,
	0.03337329f,
	0.02521404f,
	0.01752432f,
	0.01052660f,
	0.00439171f,
	-0.00076591f,
	-0.00488924f,
	-0.00797606f,
	-0.01007335f,
	-0.01126911f,
	-0.01168246f,
	-0.01145278f,
	-0.01072878f,
	-0.00965823f,
	-0.00837907f,
	-0.00701253f,
	-0.00565850f,
	-0.00439342f,
	-0.00327063f,
	-0.00232266f,
	-0.00156531f,
	-0.00100256f,
	-0.00063167f,
	-0.00044789f,
};

#else

float psk31_fir2c[64] = {
	0.000625000f,
	0.000820912f,
	0.001374651f,
	0.002188141f,
	0.003110600f,
	0.003956273f,
	0.004526787f,
	0.004635947f,
	0.004134515f,
	0.002932456f,
	0.001016352f,
	-0.001539947f,
	-0.004572751f,
	-0.007834665f,
	-0.011009254f,
	-0.013733305f,
	-0.015625000f,
	-0.016315775f,
	-0.015483216f,
	-0.012882186f,
	-0.008371423f,
	-0.001933193f,
	0.006315933f,
	0.016124399f,
	0.027115485f,
	0.038807198f,
	0.050640928f,
	0.062016866f,
	0.072333574f,
	0.081028710f,
	0.087617820f,
	0.091728168f,
	0.093125000f,
	0.091728168f,
	0.087617820f,
	0.081028710f,
	0.072333574f,
	0.062016866f,
	0.050640928f,
	0.038807198f,
	0.027115485f,
	0.016124399f,
	0.006315933f,
	-0.001933193f,
	-0.008371423f,
	-0.012882186f,
	-0.015483216f,
	-0.016315775f,
	-0.015625000f,
	-0.013733305f,
	-0.011009254f,
	-0.007834665f,
	-0.004572751f,
	-0.001539947f,
	0.001016352f,
	0.002932456f,
	0.004134515f,
	0.004635947f,
	0.004526787f,
	0.003956273f,
	0.003110600f,
	0.002188141f,
	0.001374651f,
	0.000820912f
};

#endif

float syncfilt[16] = {
	-0.097545161f,
	-0.093796555f,
	-0.086443400f,
	-0.075768274f,
	-0.062181416f,
	-0.046204960f,
	-0.028452874f,
	-0.009607360f,
	0.009607360f,
	0.028452874f,
	0.046204960f,
	0.062181416f,
	0.075768274f,
	0.086443400f,
	0.093796555f,
	0.097545161f
};
