#pragma once

// IIR low pass filter for integration (averaging) purposes
// Overshoot is about 1% for Feedback=0.5, and about 1e-6 for Feedback=0.1
// Weight is 1 / PeakingTime

template <class Type> class LowPass3_Filter
{ 
public:
	Type Out1, Out2, Output;

	template <class InpType, class WeightType>
    void Process(InpType Inp, WeightType Weight, WeightType Feedback = 0.1)
	{ 
		Weight *= 2.0;
		Type DiffI1 = Inp;  DiffI1 -= Out1;
		Type Diff12 = Out1; Diff12 -= Out2;
		Type Diff23 = Out2; Diff23 -= Output;
		DiffI1 *= Weight;   Out1   += DiffI1;
		Diff12 *= Weight;   Out2   += Diff12;
		Diff23 *= Weight;   Output += Diff23;
		Diff23 *= Feedback; Out2   += Diff23;
	}

	template <class LevelType>
    void operator = (LevelType Level)
	{ 
		Out1=(Type)Level; 
		Out2=(Type)Level; 
		Output=(Type)Level; 
	}
	
	template <class LevelType>
    void Set(LevelType Level=0)
    { 
		Out1=Level; 
		Out2=Level; 
		Output=Level; 
	}
};

class AvgFilter
{
public:
    void Process(int inp)
	{
		Output = 0;
		m_aBuf[m_iPos ++] = inp;
		if (m_iPos == 4)
			m_iPos = 0;
		for (UINT i = 0; i < 4; ++ i)
			Output += m_aBuf[i];
	}

    void operator=(int level)
	{
		m_iPos = 0;
		for (UINT i = 0; i < 4; ++ i)
			m_aBuf[4] = 0;
		Output = level;
	}

    void Set(int level)
	{
		m_iPos = 0;
		for (UINT i = 0; i < 4; ++ i)
			m_aBuf[4] = 0;
		Output = level;
	}

	int		Output;

protected:
	int		m_aBuf[4];
	int		m_iPos;
};
