#include "winsupport.h"

BOOL GetPocketDigiDir(TCHAR *szPath)
{

#ifdef WIN32_PLATFORM_PSPC

	if (! SHGetSpecialFolderPath(0l, szPath, CSIDL_PERSONAL, TRUE))
		return FALSE;
	_tcscat(szPath, _T("\\PocketDigi"));
	CreateDirectory(szPath, 0);
	return TRUE;

#else WIN32_PLATFORM_PSPC

	HKEY	hKey;
	DWORD	dwType = REG_SZ;
	DWORD	dwSize = MAX_PATH;
	BOOL	bRes   = FALSE;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders"), 
			0, KEY_READ, &hKey) != ERROR_SUCCESS)
		return FALSE;

	bRes = RegQueryValueEx(hKey, _T("Personal"),  0, &dwType, (LPBYTE)szPath, &dwSize) == ERROR_SUCCESS;
	RegCloseKey(hKey);

	if (bRes) {
		_tcscat(szPath, _T("\\PocketDigi"));
		CreateDirectory(szPath, 0);
	}

	return bRes;

#endif /* WIN32_PLATFORM_PSPC */
}

void CenterWindowOnWindow(HWND hWnd, HWND hOther)
{
	RECT rcP,rc;
	if (hOther == 0)
		return;
	GetWindowRect(hOther, &rcP);
	GetWindowRect(hWnd, &rc);
	rcP.right	-= rcP.left;
	rcP.bottom	-= rcP.top;
	rc.right	-= rc.left;
	rc.bottom	-= rc.top;
	SetWindowPos(hWnd, NULL, (rcP.right/2)-(rc.right/2), (rcP.bottom/2)-(rc.bottom/2), 0, 0, SWP_NOSIZE);
}

void CenterWindowOnDesktop(HWND hWnd)
{
	CenterWindowOnWindow(hWnd, GetDesktopWindow());
}

void CenterWindowOnParent(HWND hWnd)
{
/*
	RECT rcThis, rcParent;
	HWND hParent = GetParent(hWnd);
	if (hParent == 0)
		return;
	GetWindowRect(hWnd,		&rcThis);
	GetWindowRect(hParent,	&rcParent);
	SetWindowPos(hWnd, HWND_TOP, (rcP.right/2)-(rc.right/2), (rcP.bottom/2)-(rc.bottom/2), 0, 0, SWP_NOSIZE);
*/
}
