#include "fixedpoint.h"


int iatan2(int y, int x)
{
    int result = 0;
    int y2;

    if ((x | y) == 0) return 0;

    if (y < 0) { result += -32768; y  = -y, x  = -x; }
    if (x < 0) { result +=  16384; y2 =  y; y  = -x; x  = y2; }
    if (y > x) { result +=   8192; y2 =  y; y -=  x; x += y2; }

    if ((y << 1) > x)
    {
            result += 4836; /* atan(1/2) * 32768/M_PI */
            y2 = y;
            y = (y << 1) - x;
            x = (x << 1) + y2;
    }
#if 1
    if ((y << 2) > x)
    {
            result += 2555; /* atan(1/4) * 32768/M_PI */
            y2 = y;
            y = (y << 2) - x;
            x = (x << 2) + y2;
    }
#if 1
    if ((y << 3) > x)
    {
            result += 1297; /* atan(1/8) * 32768/M_PI */
            y2 = y;
            y = (y << 3) - x;
            x = (x << 3) + y2;
    }
#if 1
    if ((y << 4) > x)
    {
            result += 651; /* atan(1/16) * 32768/M_PI */
            y2 = y;
            y = (y << 4) - x;
            x = (x << 4) + y2;
    }
#if 1
    if ((y << 5) > x)
    {
            result += 326; /* atan(1/32) * 32768/M_PI */
            y2 = y;
            y = (y << 5) - x;
            x = (x << 5) + y2;
    }
    return result + 10427 * y / x; /* up to atan(1/32) */
#else
    return result + 10417 * y / x; /* up to atan(1/16) */
#endif
#else
    return result + 10377 * y / x; /* up to atan(1/8) */
#endif
#else
    return result + 10221 * y / x; /* up to atan(1/4) */
#endif
#else
    return result +  9672 * y / x; /* up to atan(1/2) */
#endif
}


/**
 * Jim Shima http://www.dspguru.com/comp.dsp/tricks/alg/fxdatan2.htm
 * Fast arctan2
 *
int fixatan2(int y, int x)
{
	int abs_y = y;
	int r, angle;

	if (x == 0)
	{
		if (y == 0)
			return 0;
		else
			return ((y < 0) ? -0x00400000L : 0x00400000L);
	}
	
	if (y < 0)
		abs_y = -y;

	if (x >= 0) {
		r = fixdiv(x - abs_y, x + abs_y);
		angle = FIX90 - fixmul(FIX90, r);
	} else {
		r = fixdiv(x + abs_y, abs_y - x);
		angle = FIX270 - fixmul(FIX90, r);
	}
	if (y < 0)
		return -angle;
	return angle;
}
*/