/* 
 * Waterfall Spectrum Analyzer Widget
 * Copyright (C) 2001 Tomi Manninen <oh2bns@sral.fi>
 *
 * Based on the Spectrum Widget by Thomas Sailer <sailer@ife.ee.ethz.ch>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __WATERFALL_H__
#define __WATERFALL_H__

#include <windows.h>
#include <windowsx.h>

#include "main.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern const TBYTE WIN32CLASS_WATERFALL[];

typedef struct _Waterfall		Waterfall;

typedef enum {
	WATERFALL_MODE_NORMAL,
	WATERFALL_MODE_SPECTRUM,
	WATERFALL_MODE_SCOPE,
	WATERFALL_MODE_SPECTRUM_PEAK
} wf_mode_t;

typedef enum {
	WATERFALL_MAG_0,
	WATERFALL_MAG_1,
	WATERFALL_MAG_2,
	WATERFALL_MAG_4
} wf_mag_t;

typedef enum {
	WATERFALL_SPEED_HALF,
	WATERFALL_SPEED_NORMAL,
	WATERFALL_SPEED_DOUBLE,
	WATERFALL_SPEED_TRIPLE,
} wf_speed_t;

typedef struct {
/// WATERFALL_MAG_1 : WATERFALL_FFTLEN_1 (2048 points, 4Hz resolution) etc
	wf_mag_t	magnification;
	wf_mode_t	mode;
/// Overlap of consecutive FFT batches (in sampling points)
	wf_speed_t	speed;
	BOOL		direction;

	int			iDecibelsThreshold;
	int			iDecibelsRange;
	BOOL		bAVC;
} wf_config_t;

#define	WATERFALL_FFTLEN_0		1024
#define	WATERFALL_FFTLEN_1		2048
#define	WATERFALL_FFTLEN_2		(WATERFALL_FFTLEN_1 * 2)
#define	WATERFALL_FFTLEN_4		(WATERFALL_FFTLEN_1 * 4)
#define	WATERFALL_FFTLEN_MAX	WATERFALL_FFTLEN_4

/*
#define	WATERFALL_FFTLEN_0		1000
#define	WATERFALL_FFTLEN_1		2000
#define	WATERFALL_FFTLEN_2		(WATERFALL_FFTLEN_1 * 2)
#define	WATERFALL_FFTLEN_4		(WATERFALL_FFTLEN_1 * 4)
#define	WATERFALL_FFTLEN_MAX	WATERFALL_FFTLEN_4
*/

/*
 * These are only defaults now.
 */
#define WATERFALL_DEFAULT_WIDTH		512
#define WATERFALL_DEFAULT_HEIGHT	96

struct _Waterfall 
{
	HWND		hWnd;
	HFONT		hFont;
	HBITMAP		hBitmap;
	HDC			hBitmapDC;
	UCHAR*		pBitmapBits;

	/* markers */
	int pointer;
	int width;
	BOOL centerline;

	int		nStartFreq;
	int		nStartIdx;

	// size of pixbuf must be multiple of fftlen/2 and
	// big enough to hold the window data
	COLORREF   *pixbuf;
	int			pixbufsize;
	int			pixbufptr;

	int 	   *loudbuf;
	int			iAverage;
	int			nAverages;
	int			iMaxAmp;

	short  *inbuf;
	int	    inptr;

	int		fftlen;
	double *fft_window;
    
	short  *specbuf;
	short  *peakbuf;

	COLORREF *aColorTable;
	int       nColorTableLen;

	BOOL	ruler_cursor_set;
	BOOL	ruler_drag;
	int  	ruler_ref_f;
	int		ruler_ref_x;
	int		ruler_update_cntr;

	wf_config_t config;

	BOOL	bMouseButtonDown;
	int		nMouseMode;
	POINT	MousePrevPos;
};

extern ATOM		waterfall_register_class(HINSTANCE hInstance);
extern Waterfall*	waterfall_new();
extern void		waterfall_free(Waterfall *wf);

BOOL			waterfall_init(Waterfall *wf);
BOOL			waterfall_create(Waterfall *wf, DWORD dwStyle,
	int x, int y, int nWidth, int nHeight, HWND hWndParent, HANDLE hInstance);
void			waterfall_destroy(Waterfall *wf);

/// Load waterfall configuration from the registry
/// If the registry is empty, add default values
extern void		waterfall_load(Waterfall *wf);
/// Set default waterfall configuration
extern void		waterfall_load_defaults(Waterfall *wf);
/// Store waterfall configuration in the registry
extern void		waterfall_store(Waterfall *wf);

void			waterfall_update_menu(Waterfall *wf, HMENU hMenu);

void			waterfall_set_magnification(Waterfall *wf, wf_mag_t mag, BOOL bUpdateUI);
void			waterfall_set_data(Waterfall *wf, short *data, int len);

void			waterfall_draw_ruler(Waterfall *wf, HDC hDC);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WATERFALL_H__ */
