#pragma once

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "trx.h"

typedef struct _TrxCtrl TrxCtrl;

typedef enum {
	TRXCTRL_NONE = 0,
	TRXCTRL_TONE,
	TRXCTRL_COM,
	TRXCTRL_ATS3_BELL202,
	TRXCTRL_ATS3_MANCHESTER,
} trxctrl_t;

typedef enum {
	TRXCTRL_RTS = 1,
	TRXCTRL_DTR = 2,
};

struct _TrxCtrl
{
	// Configuration
	trxctrl_t		nType;
	int				nCOM;
	int				nMaskDtrRts;

	int				nAts3Preamble;
	int				nAts3Postamble;
	int				nAts3FreqOffset;

	// Runtime
	HANDLE			hCOM;
	// Number of modulation bits for current mode
	int				nAts3Bits;
};

// Singelton instance is defined in trxsetup.c
extern TrxCtrl	g_TrxCtrl;

/// Initialize 
extern BOOL trxctrl_init(TrxCtrl *pCtrl);
/// Destroy
extern void trxctrl_destroy(TrxCtrl *pCtrl);

extern BOOL trxctrl_edit();

/// Load transceiver control settings from registry.
/// If the registry is empty, add default values
extern void trxctrl_load(TrxCtrl *pCtrl);
/// Set default transceiver control settings
extern void trxctrl_load_defaults(TrxCtrl *pCtrl);
/// Store transceiver control settings in the registry
extern void trxctrl_store(TrxCtrl *pCtrl);

extern void trxctrl_ptt(TrxCtrl *pCtrl, BOOL bOn);

extern void trxctrl_ats3_start_bpsk(TrxCtrl *pCtrl, SndModem *pModem, int offset);
extern void trxctrl_ats3_start_mfsk(TrxCtrl *pCtrl, SndModem *pModem, int offset, int tonespacing);
extern void trxctrl_ats3_sendtone(TrxCtrl *pCtrl, SndModem *pModem, int tone, int length);
extern void trxctrl_ats3_endtx(TrxCtrl *pCtrl, SndModem *pModem);

extern BOOL trxctrl_ats3_command(TrxCtrl *pCtrl, SndModem *pModem, int nCommand, UCHAR *pData, int nLen);

#ifdef __cplusplus
}
#endif /* __cplusplus */
