#include <windows.h>
#include <commdlg.h>
#include <commctrl.h>
#include <tchar.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#ifdef WIN32_PLATFORM_PSPC
#include "Aygshell.h"
#endif /* WIN32_PLATFORM_PSPC */

#include "main.h"
#include "trxctrl.h"
#include "sndmodem.h"
#include "dlggen.h"

TrxCtrl	g_TrxCtrl;

BOOL trxctrl_init(TrxCtrl *pCtrl)
{
	memset(pCtrl, 0, sizeof(TrxCtrl));
	trxctrl_load(pCtrl);
	return TRUE;
}

void trxctrl_destroy(TrxCtrl *pCtrl)
{
	CloseHandle(pCtrl->hCOM);
	memset(pCtrl, 0, sizeof(TrxCtrl));
}

void trxctrl_load(TrxCtrl *pCtrl)
{
	HKEY  hKey   = 0;
	DWORD dwType = REG_DWORD;
	DWORD dwSize = 4;

	trxctrl_load_defaults(pCtrl);

	if (RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\TrxCtrl"), 0,
		KEY_ENUMERATE_SUB_KEYS | KEY_QUERY_VALUE | KEY_READ, &hKey) != ERROR_SUCCESS)
		return;

	dwType = REG_DWORD; dwSize = 4;
	RegQueryValueEx(hKey, _T("Type"), 0, &dwType, (LPBYTE)&pCtrl->nType, &dwSize);
	dwType = REG_DWORD; dwSize = 4;
	RegQueryValueEx(hKey, _T("COM"),  0, &dwType, (LPBYTE)&pCtrl->nCOM,  &dwSize);
	dwType = REG_DWORD; dwSize = 4;
	RegQueryValueEx(hKey, _T("Ats3FreqOffset"),  0, &dwType, (LPBYTE)&pCtrl->nAts3FreqOffset, &dwSize);
	dwType = REG_DWORD; dwSize = 4;
	RegQueryValueEx(hKey, _T("Ats3Preamble"),    0, &dwType, (LPBYTE)&pCtrl->nAts3Preamble, &dwSize);
	dwType = REG_DWORD; dwSize = 4;
	RegQueryValueEx(hKey, _T("Ats3Postamble"),   0, &dwType, (LPBYTE)&pCtrl->nAts3Postamble, &dwSize);

	RegCloseKey(hKey);

	if (pCtrl->nType > TRXCTRL_ATS3_MANCHESTER)
		pCtrl->nType = TRXCTRL_NONE;
	if (pCtrl->nCOM < 1 || pCtrl->nCOM > 9)
		pCtrl->nCOM = 1;
}

void trxctrl_load_defaults(TrxCtrl *pCtrl)
{
	pCtrl->nType = TRXCTRL_NONE;
	pCtrl->nCOM = 1;
	pCtrl->nAts3Preamble   = 500;
	pCtrl->nAts3Postamble  = 20;
	pCtrl->nAts3FreqOffset =  /* CW BFO */ /* 573 */ 577 << FREQ_FRAC_BITS;
}

void trxctrl_store(TrxCtrl *pCtrl)
{
	HKEY  hKey = 0;
	DWORD dwDisposition = 0;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\TrxCtrl"), 0, 0,
		REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &hKey, &dwDisposition) != ERROR_SUCCESS)
		return;

	RegSetValueEx(hKey, _T("Type"),	0, REG_DWORD, (LPBYTE)&pCtrl->nType, 4);
	RegSetValueEx(hKey, _T("COM"),  0, REG_DWORD, (LPBYTE)&pCtrl->nCOM,  4);
	RegSetValueEx(hKey, _T("Ats3FreqOffset"), 0, REG_DWORD, (LPBYTE)&pCtrl->nAts3FreqOffset, 4);
	RegSetValueEx(hKey, _T("Ats3Preamble"),	  0, REG_DWORD, (LPBYTE)&pCtrl->nAts3Preamble,   4);
	RegSetValueEx(hKey, _T("Ats3Postamble"),  0, REG_DWORD, (LPBYTE)&pCtrl->nAts3Postamble,  4);

	RegCloseKey(hKey);
}

#define ID_TRXCTRL_NONE	101
#define ID_COMBO_COM	200
#define ID_ATS_TONE_LABEL		201
#define ID_ATS_TONE_EDIT		202
#define ID_ATS_TONE_SPIN		202
#define ID_ATS_TEST				203

extern SndModem	s_SndModem;

INT_PTR CALLBACK trxctrl_dlgproc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int res;
	
	if (uMsg == WM_INITDIALOG) {
		HWND   hWndRadio = GetDlgItem(hwnd, ID_TRXCTRL_NONE + g_TrxCtrl.nType);
		HWND   hWndCombo = GetDlgItem(hwnd, ID_COMBO_COM);
		HWND   hWndTone	 = GetDlgItem(hwnd, ID_ATS_TONE_EDIT);
		TCHAR  buf[128];
		int    i;
		int    nItems = 0;
		int    iFound = 0;
		HANDLE hCOM;
		SendMessage(hWndRadio, BM_SETCHECK, BST_CHECKED, 0);
		EnableWindow(hWndCombo, SendMessage(GetDlgItem(hwnd, ID_TRXCTRL_NONE + TRXCTRL_COM), BM_GETCHECK, 0, 0));
		EnableWindow(GetDlgItem(hwnd, ID_ATS_TONE_EDIT),
			SendMessage(GetDlgItem(hwnd, ID_TRXCTRL_NONE + TRXCTRL_ATS3_BELL202),	 BM_GETCHECK, 0, 0) ||
			SendMessage(GetDlgItem(hwnd, ID_TRXCTRL_NONE + TRXCTRL_ATS3_MANCHESTER), BM_GETCHECK, 0, 0));
		for (i = 1; i < 10; ++ i) {
			_stprintf(buf, _T("COM%d:"), i);
			hCOM = CreateFile(buf, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, 0);
			if (hCOM != INVALID_HANDLE_VALUE) {
				CloseHandle(hCOM);
				if (g_TrxCtrl.nCOM == i)
					iFound = nItems;
				++ nItems;
				SendMessage(hWndCombo, CB_ADDSTRING, 0, (LPARAM)buf);
			}
		}
		SendMessage(hWndCombo, CB_SETCURSEL, iFound, 0);
		{
			TCHAR buf[80];
			TCHAR *ptr = buf;
			_stprintf(buf, _T("%8.2f"), (double)g_TrxCtrl.nAts3FreqOffset / (double)FREQ_FRAC_VALUE);
			while (*ptr == ' ')
				++ ptr;
			SetWindowText(hWndTone, ptr);
		}
	} else if (uMsg == WM_COMMAND) {
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL || LOWORD(wParam) == ID_ATS_TEST) {
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == ID_ATS_TEST) {
				HWND   hCombo = GetDlgItem(hwnd, ID_COMBO_COM);
				HWND   hEdit  = GetDlgItem(hwnd, ID_ATS_TONE_EDIT);
				TCHAR  buf[80];
				int    i;
				for (i = TRXCTRL_NONE; i <= TRXCTRL_ATS3_MANCHESTER; ++ i)
					if (SendMessage(GetDlgItem(hwnd, ID_TRXCTRL_NONE + i), BM_GETCHECK, 0, 0))
						g_TrxCtrl.nType = i;
				i = SendMessage(hCombo, CB_GETCURSEL, 0, 0);
				SendMessage(hCombo, CB_GETLBTEXT, i, (LPARAM)buf);
				g_TrxCtrl.nCOM = buf[3] - '1' + 1;
				{
					TCHAR *ptr = buf;
					TCHAR *ptr2;
					TCHAR *err = 0;
					double dOffset = 0;
					GetWindowText(hEdit, buf, 80);
					while (*ptr == ' ' || *ptr == '\t')
						++ ptr;
					ptr2 = ptr + _tcslen(ptr);
					if (ptr2 > ptr) {
						do {
							-- ptr2;
						} while (ptr2 > ptr && (*ptr2 == ' ' || *ptr2 == '\t'));
						*ptr2 = 0;
						dOffset = _tcstod(buf, &err);
					}
					if (err == 0 || *err != 0 || dOffset < 200.0 || dOffset > 2000.0) {
						MessageBox(hwnd, _T("Invalid ATS3 offset.\r\nTone about 600Hz is expected."), 
							_T("PocketDigi error"), MB_ICONERROR | MB_OK);
						return 0;
					}
					g_TrxCtrl.nAts3FreqOffset = (int)(dOffset * 16 + 0.5);
				}
				if (LOWORD(wParam) == ID_ATS_TEST) {
					UCHAR pdgi[] = { 0x16, 0x0c, 0x0e, 0x04 }; // pdgi
					trxctrl_ats3_command(&g_TrxCtrl, &s_SndModem, 1 /* morse echo */, pdgi, 4);
					return 0;
				}
			}
            EndDialog(hwnd, LOWORD(wParam) == IDOK);
            return 0;
		} else if (LOWORD(wParam) >= ID_TRXCTRL_NONE && LOWORD(wParam) <= ID_TRXCTRL_NONE + TRXCTRL_ATS3_MANCHESTER) {
			EnableWindow(GetDlgItem(hwnd, ID_COMBO_COM), SendMessage(GetDlgItem(hwnd, ID_TRXCTRL_NONE + TRXCTRL_COM), BM_GETCHECK, 0, 0));
			EnableWindow(GetDlgItem(hwnd, ID_ATS_TONE_EDIT),
				SendMessage(GetDlgItem(hwnd, ID_TRXCTRL_NONE + TRXCTRL_ATS3_BELL202),	 BM_GETCHECK, 0, 0) ||
				SendMessage(GetDlgItem(hwnd, ID_TRXCTRL_NONE + TRXCTRL_ATS3_MANCHESTER), BM_GETCHECK, 0, 0));
		}
	}

	res = dlggen_dlgproc(hwnd, uMsg, wParam, lParam);
	if (res >= 0)
		return res;

    return FALSE;
}

BOOL trxctrl_edit()
{
	DlgTemplate tmpl;
	int x = 5;
	int y = 5;
	int linewidth  = 130;
	int lineheight = 12;
	int lineinc    = 14;

	dlggen_create(&tmpl, _T("Transceiver Control Setup"), DLGGEN_WINDOW_STYLE,
		CW_USEDEFAULT, CW_USEDEFAULT, 137, 170, _T("Tahoma"), 8);

	dlggen_add_button(&tmpl, _T("No control (VOX)"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_AUTORADIOBUTTON,
		0, x, y, linewidth, lineheight, ID_TRXCTRL_NONE);
	y += lineinc;
	dlggen_add_button(&tmpl, _T("PTT by tone"), WS_CHILD | WS_VISIBLE | WS_DISABLED | WS_TABSTOP | BS_AUTORADIOBUTTON,
		0, x, y, linewidth, lineheight, ID_TRXCTRL_NONE + TRXCTRL_TONE);
	y += lineinc;
	dlggen_add_button(&tmpl, _T("PTT by COM (DTR,RTS)"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_AUTORADIOBUTTON,
		0, x, y, linewidth, lineheight, ID_TRXCTRL_NONE + TRXCTRL_COM);
	y += lineinc;
	dlggen_add_combobox(&tmpl, _T(""), WS_CHILD|WS_VISIBLE|WS_TABSTOP|WS_VSCROLL|CBS_DROPDOWNLIST,
		0, x + 20, y, 50, 100, ID_COMBO_COM);
	y += lineinc;
	dlggen_add_button(&tmpl, _T("ATS3/BELL202"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_AUTORADIOBUTTON,
		0, x, y, linewidth - 30, lineheight, ID_TRXCTRL_NONE + TRXCTRL_ATS3_BELL202);
	dlggen_add_button(&tmpl, _T("Test"), WS_CHILD | WS_VISIBLE | WS_TABSTOP,
		0, x + linewidth - 25, y, 30, lineheight, ID_ATS_TEST);
	y += lineinc;
	dlggen_add_button(&tmpl, _T("ATS3/MANCHESTER"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | BS_AUTORADIOBUTTON,
		0, x, y, linewidth, lineheight, ID_TRXCTRL_NONE + TRXCTRL_ATS3_MANCHESTER);
	y += lineinc;
	dlggen_add_static(&tmpl, _T("Offset [Hz]:"), WS_CHILD | WS_VISIBLE, 0,
		x + 20, y + 2, 45, lineheight, ID_ATS_TONE_LABEL);
	dlggen_add_edit_box(&tmpl, _T(""), DLGGEN_ENTRY_STYLE | ES_RIGHT, DLGGEN_ENTRY_STYLE_EX,
		x + 65, y, 40, lineheight, ID_ATS_TONE_EDIT);
/*
	dlggen_add_edit_box(&tmpl, _T(""), DLGGEN_ENTRY_STYLE, DLGGEN_ENTRY_STYLE_EX,
		x, y, linewidth - 20, lineheight, ID_ATS_TONE_EDIT);
	dlggen_add_component(&tmpl, UPDOWN_CLASS, _T(""), 
		WS_VISIBLE | UDS_AUTOBUDDY | UDS_ALIGNRIGHT | UDS_ARROWKEYS | UDS_SETBUDDYINT, 0,
		linewidth - 20, y, 20, lineheight, ID_ATS_TONE_SPIN);
*/
	y += lineinc;

	dlggen_add_okcancel(&tmpl);
	tmpl.nEntries      = 1;
	tmpl.nEntryFirstID = ID_ATS_TONE_EDIT;
	return dlggen_dialog_box(&tmpl, g_hInst, s_hWndMain, trxctrl_dlgproc) == IDOK;
}

void trxctrl_ptt(TrxCtrl *pCtrl, BOOL bOn)
{
	if (pCtrl->nType != TRXCTRL_COM)
		return;

	if (bOn) {
		if (pCtrl->hCOM == 0) {
			TCHAR  buf[128];
			_stprintf(buf, _T("COM%d:"), pCtrl->nCOM);

			pCtrl->hCOM = CreateFile(buf, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
			if (pCtrl->hCOM == INVALID_HANDLE_VALUE) {
				MessageBox(0, _T("Cannot open serial line"), _T("PocketDigi Error"), MB_OK);
				pCtrl->hCOM = 0;
			} else {
				DCB	dcb;
				long errors;
				GetCommState(pCtrl->hCOM, &dcb);
				dcb.BaudRate			= CBR_1200;
				dcb.ByteSize			= 8;
				dcb.Parity				= NOPARITY;
				dcb.StopBits			= ONESTOPBIT;
				dcb.fOutxCtsFlow		= FALSE;
				dcb.fOutxDsrFlow		= FALSE;
				dcb.fDsrSensitivity		= FALSE;
				dcb.fTXContinueOnXoff	= FALSE;
				dcb.fInX				= 0;
				dcb.fOutX				= 0;
				dcb.fDtrControl			= DTR_CONTROL_DISABLE;
				dcb.fRtsControl			= RTS_CONTROL_DISABLE;
				dcb.fAbortOnError		= FALSE;
				if (! SetCommState(pCtrl->hCOM, &dcb))
					MessageBox(0, _T("Cannot SetCommState"), _T("PocketDigi Error"), MB_OK);
				if (! ClearCommError(pCtrl->hCOM, &errors, 0))
					MessageBox(0, _T("Cannot ClearCommError"), _T("Error"), MB_OK);
				if (! EscapeCommFunction(pCtrl->hCOM, SETDTR))
					MessageBox(0, _T("Cannot EscapeCommFunction(SETDTR)"), _T("Error"), MB_OK);
				EscapeCommFunction(pCtrl->hCOM, SETRTS);
			}
		}
	} else {
		EscapeCommFunction(pCtrl->hCOM, CLRDTR);
		EscapeCommFunction(pCtrl->hCOM, CLRRTS);
		CloseHandle(pCtrl->hCOM);
		pCtrl->hCOM = 0;
	}
}

void trxctrl_ats3_start_bpsk(TrxCtrl *pCtrl, SndModem *pModem, int offset)
{
	UCHAR data[2];
	int f, g;
	offset -= pCtrl->nAts3FreqOffset;
	if (offset < 0)
		offset += (10000 << FREQ_FRAC_BITS);
	f = (offset + (1 << (FREQ_FRAC_BITS - 1))) >> FREQ_FRAC_BITS;
	if (f >= 10000)
		f = 0;
	g = f % 100;
	data[0] = ((g / 10) << 4) + (g % 10);
	g = f / 100;
	data[1] = ((g / 10) << 4) + (g % 10);

	pCtrl->nAts3Bits = 3;
	if (pCtrl->nType == TRXCTRL_ATS3_MANCHESTER) {
		sndmodem_write_manchester_pause(pModem, pCtrl->nAts3Preamble);
		sndmodem_write_manchester_frame(pModem, 4 /* command */, data, 2);
		sndmodem_write_manchester_pause(pModem, 8); // at least two idle symbols
	} else {
		sndmodem_write_bell202_pause(pModem, pCtrl->nAts3Preamble);
		sndmodem_write_bell202_frame(pModem, 4 /* command */, data, 2);
		sndmodem_write_bell202_pause(pModem, 5);
	}
}

static int ATS3_TONE_SPACING[] =
{
	 125, //   7.8125
	 128, //   8.000
	 172, //  10.766
	 250, //  15.625
	 256, //  16.000
	 345, //  21.533
	 500, //  31.250
	1000, //  62.500
	2000, // 125.000
	2720, // 170.000
	3200, // 200.000
};

void trxctrl_ats3_start_mfsk(TrxCtrl *pCtrl, SndModem *pModem, int offset, int tonespacing)
{
	UCHAR data[3];
	int i, f, g;

	offset -= pCtrl->nAts3FreqOffset;
	if (offset < 0)
		offset += (10000 << FREQ_FRAC_BITS);
	f = (offset + (1 << (FREQ_FRAC_BITS - 1))) >> FREQ_FRAC_BITS;
	if (f >= 10000)
		f = 0;
	g = f % 100;
	data[0] = ((g / 10) << 4) + (g % 10);
	g = f / 100;
	data[1] = ((g / 10) << 4) + (g % 10);

	data[2] = 0;
	for (i = 0; i < sizeof(ATS3_TONE_SPACING) / sizeof(int); ++ i)
		if (tonespacing == ATS3_TONE_SPACING[i]) {
			data[2] = i;
			break;
		}

	pCtrl->nAts3Bits = 6;
	if (pCtrl->nType == TRXCTRL_ATS3_MANCHESTER) {
		sndmodem_write_manchester_pause(pModem, pCtrl->nAts3Preamble);
		sndmodem_write_manchester_frame(pModem, 5 /* command */, data, 3);
		sndmodem_write_manchester_pause(pModem, 8); // at least two symbols
	} else {
		sndmodem_write_bell202_pause(pModem, pCtrl->nAts3Preamble);
		sndmodem_write_bell202_frame(pModem, 5 /* command */, data, 3);
		sndmodem_write_bell202_pause(pModem, 5);
	}
}

void trxctrl_ats3_sendtone(TrxCtrl *pCtrl, SndModem *pModem, int iTone, int length)
{
	if (pCtrl->nType == TRXCTRL_ATS3_MANCHESTER) {
		sndmodem_write_manchester_async(pModem, (1 << (pCtrl->nAts3Bits - 1)) | iTone, pCtrl->nAts3Bits); // symbol, 160 thirds
		sndmodem_write_manchester_pause(pModem, length - ((pCtrl->nAts3Bits + 2) << 2));
	} else {
		sndmodem_write_bell202_async(pModem, (1 << (pCtrl->nAts3Bits - 1)) | iTone, pCtrl->nAts3Bits); // symbol, 160 thirds
		sndmodem_write_bell202_pause_thirds(pModem, length * 3 - 160);
	}
}

void trxctrl_ats3_endtx(TrxCtrl *pCtrl, SndModem *pModem)
{
	if (pCtrl->nType == TRXCTRL_ATS3_MANCHESTER) {
		sndmodem_write_manchester_pause(pModem, 20);   // wait a bit before sending TX stop
		sndmodem_write_manchester_async(pModem, 0, pCtrl->nAts3Bits); // stop TX
		sndmodem_write_manchester_pause(pModem, 20);   // wait a bit before sending TX stop
		sndmodem_write_manchester_async(pModem, 0, pCtrl->nAts3Bits); // again to be sure it falls off
		sndmodem_write_manchester_pause(pModem, pCtrl->nAts3Postamble);
	} else {
		sndmodem_write_bell202_pause(pModem, 20);   // wait a bit before sending TX stop
		sndmodem_write_bell202_async(pModem, 0, pCtrl->nAts3Bits); // stop TX
		sndmodem_write_bell202_pause(pModem, 20);   // wait a bit before sending TX stop
		sndmodem_write_bell202_async(pModem, 0, pCtrl->nAts3Bits); // again to be sure it falls off
		sndmodem_write_bell202_pause(pModem, pCtrl->nAts3Postamble);
	}
	sndmodem_tx_flush(pModem);
	pCtrl->nAts3Bits = 0;
}

BOOL trxctrl_ats3_command(TrxCtrl *pCtrl, SndModem *pModem, int nCommand, UCHAR *pData, int nLen)
{
	if (pModem->hWaveOut != 0)
		return FALSE;

	s_bEnableMenuUpdate = FALSE;
	sndmodem_stop_recording(pModem, TRUE);
	sndmodem_start_playing(pModem, TRUE);
	if (pCtrl->nType == TRXCTRL_ATS3_MANCHESTER) {
		sndmodem_write_manchester_pause(pModem, pCtrl->nAts3Preamble);
		sndmodem_write_manchester_frame(pModem, nCommand, pData, nLen);
		sndmodem_write_manchester_pause(pModem, pCtrl->nAts3Postamble);
	} else {
		sndmodem_write_bell202_pause(pModem, pCtrl->nAts3Preamble);
		sndmodem_write_bell202_frame(pModem, nCommand, pData, nLen);
		sndmodem_write_bell202_pause(pModem, pCtrl->nAts3Postamble);
	}
	sndmodem_tx_flush(pModem);
	return TRUE;
}
