/*
 *    trx.h  --  Modem engine
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
                                                                                
#ifndef	_TRX_H
#define	_TRX_H

#ifdef __cplusplus
extern "C" {
#endif 

#include <windows.h>
#include <windowsx.h>

#include "log.h"

// #define USE_RXVIEW

#ifdef USE_RXVIEW
#include "rxview.h"
#endif /* USE_RXVIEW */

typedef struct _SndModem SndModem;
typedef struct _QsoInfo  QsoInfo;

/* special character for switching to rx - (R) .. registered */
#ifdef _WIN32_WCE
#define	TRX_RX_CMD	  174
#define TRX_CLEAR_CMD 169
#else
#define	TRX_RX_CMD	  -82
#define TRX_CLEAR_CMD -87
#endif

/* ---------------------------------------------------------------------- */

typedef enum {
	MODE_BPSK31 = 0,
	MODE_QPSK31,
	MODE_PSK63,
	MODE_RTTY,
	MODE_CW,
	MODE_MFSK16,
	MODE_THROB,
	MODE_THROBX,
	MODE_FELDHELL,
	MODE_OLIVIA,
	MODE_CONTESTIA,
	MODE_RTTYM,
	MODE_AX25,
	MODE_MFSK8,
	MODE_MT63,
	MODE_FMHELL,
	MODE_THROBX4,
} trx_mode_t;

extern TCHAR *trx_mode_names[];
extern TCHAR *submode_throb_names[];
extern TCHAR *submode_olivia_names[];
extern TCHAR *submode_rtty_names[];

typedef enum {
	TRX_STATE_PAUSE = 0,
	TRX_STATE_RX,
	TRX_STATE_TX,
	TRX_STATE_TUNE,
	TRX_STATE_ABORT,
/// Flush TX buffers and wait for Windows driver for confirmation
	TRX_STATE_FLUSH
} trx_state_t;

typedef enum {
	LAYOUT_SINGLELINE,
	LAYOUT_RCV,
	LAYOUT_TRX,
} layout_t;

#define FREQ_FRAC_BITS   4
#define FREQ_FRAC_VALUE 16

extern TCHAR *trx_state_names[];

typedef struct _Trx Trx;

struct _Trx {
	int				nChannelID;
	trx_mode_t		mode;
	int				submode;
	trx_state_t		state;
	Log				log;

//	int samplerate;

	/// AFC is switched on
	BOOL	afcon;
	/// squelch is switched on
	BOOL	squelchon;
	int		iSquelchThreshold;
	// 0 - slow (DX), 1 - normal, 2 - fast (contest) 
	int		nSyncSpeed;

	/// want to stop transmitting
	BOOL	stopflag;
	/// reverse the sideband
	int		reverse;

	int		nRxFrequency;
	int		nTxFrequency;
	BOOL	bTxLock;
	int		bandwidth;

//	float metric;

	int backspaces;
	unsigned char	*txstr;
	unsigned char	*txptr;

	SndModem		*pModem;
	QsoInfo			*pQso;

/*
	float mfsk_squelch;

*/

/*
	int rtty_shift;
	float rtty_baud;
	int rtty_bits;
	int rtty_parity;
	int rtty_stop;
	BOOL rtty_reverse;
	BOOL rtty_msbfirst;
	BOOL rtty_unshift_on_space;
*/

//	float throb_squelch;

//	int psk31_squelch;

/*
	float mt63_squelch;
	int mt63_bandwidth;
	int mt63_interleave;
	BOOL mt63_cwid;
	BOOL mt63_esc;

	char *hell_font;
	BOOL hell_upper;
	float hell_bandwidth;
	float hell_agcattack;
	float hell_agcdecay;
*/

	int	cw_rxspeed;
	int	cw_txspeed;
	int cw_bandwidth;
	int cw_firtaps;

	void	   *modem;

	layout_t	nLayout;
	HWND		hWnd;
#ifdef USE_RXVIEW
	RxView	   *pRxView;
#else /* USE_RXVIEW */
	HWND		hWndReceive;
#endif /* USE_RXVIEW */
	HWND		hWndSend;
	HFONT		hFont;

	UINT		aLineReceived[1024 * 64];
	int			nLineReceivedLen;
	int			iLineReceivedIdx;
	int			nLineOutPos;
	TCHAR		cPrevChar;
	BOOL		bPrevCharEcho;

	//FIXME
	/// number of characters sent from the TX window
	int			nCharsSent;

	void (*txinit) (Trx *trx);
	void (*rxinit) (Trx *trx);

	int (*txprocess) (Trx *trx);
	int (*rxprocess) (Trx *trx, short *buf, int len);

	void (*destructor) (Trx *trx);
};

extern BOOL			trx_register_classes(HINSTANCE hInstance);
extern Trx*			trx_new();
extern void			trx_free(Trx *trx);

extern BOOL			trx_init(Trx *trx);
extern BOOL			trx_initmodem(Trx *trx);
extern BOOL			trx_create(Trx *trx, HWND hWndParent, HANDLE hInstance, SndModem *pModem);
extern void			trx_destroy(Trx *trx);

extern void			trx_put_rx_char(Trx *trx, UINT c);
extern int			trx_get_rx_char(void);

extern int			trx_get_tx_char(Trx *trx);
extern void			trx_put_echo_char(Trx *trx, UINT c);
extern void			trx_send_char(Trx *trx, TCHAR c);
extern void			trx_send_string(Trx *trx, TCHAR *str);

extern void			trx_clearrx(Trx *trx);
extern void			trx_cleartx(Trx *trx);

extern void			trx_set_scope(int *data, int len, BOOL autoscale);
extern void			trx_set_phase(int phase, BOOL highlight);

extern BOOL			trx_layout(Trx *trx, layout_t nLayout, RECT *rect);
extern void			trx_show_channel_context_menu(HWND hWnd, int ptx, int pty, int iChannel);

extern BOOL			trx_txloop(Trx *trx);
extern void			trx_txend(Trx *trx);
extern BOOL			trx_is_sending(Trx *trx);


__inline unsigned int trx_freq2phase(int iFrequency) 
//	{ return (unsigned)((65536.0 * 65536.0) * iFrequency / (SampleRate << FREQ_FRAC_BITS)); }
	{ return 33554 /* 2^32  / (SampleRate << FREQ_FRAC_BITS) = 3354.432 */ * iFrequency; }

#ifdef __cplusplus
}
#endif 

#endif
