#ifndef __STNINFO_H
#define __STNINFO_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "trx.h"

typedef struct _StnInfo		StnInfo;

struct _StnInfo
{
	TCHAR	   *strCall;
	TCHAR	   *strName;
	TCHAR	   *strQth;
	TCHAR	   *strLoc;
	TCHAR	   *strEmail;
};

extern StnInfo		  g_StnInfo;
extern TCHAR*		  g_aStnInfoLabels[];

#define STNINFO_ARRAY ((TCHAR**)&g_StnInfo)
#define STNINFO_LEN   5

extern BOOL stninfo_edit();

/// Load station info from registry.
/// If the registry is empty, add default values
extern void stninfo_load();
/// Set default station info
extern void stninfo_load_defaults();
/// Store station info in the registry
extern void stninfo_store();
/// Free allocated strings
extern void stninfo_destroy();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __MACRO_H */
