/*
 *    stninfo.c  --  Station info
 *
 *    Copyright (C) 2006
 *      Vojtech Bubnik OK1IAK (bubnikv@seznam.cz)
 *
 *    This file is part of PocketDigi.
 *
 *    PocketDigi is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    PocketDigi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <windows.h>
#include <tchar.h>

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#ifdef _WIN32_WCE
#ifdef WIN32_PLATFORM_PSPC
#include "Aygshell.h"
#endif /* WIN32_PLATFORM_PSPC */
#endif /* _WIN32_WCE */

#include "stninfo.h"
#include "dlggen.h"
#include "../resource.h"

extern HINSTANCE	g_hInst;
extern HWND			s_hWndMain;

StnInfo				g_StnInfo;

#define ID_LABEL	101
#define ID_ENTRY	201

TCHAR *g_aStnInfoLabels[] = {
	_T("Call"),
	_T("Name"),
	_T("QTH"),
	_T("Loc"),
	_T("mail")
};

INT_PTR CALLBACK stninfo_dlgproc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int res = dlggen_dlgproc(hwnd, uMsg, wParam, lParam);
	if (res >= 0)
		return res;

	if (uMsg == WM_COMMAND &&
		(LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)) {
		if (LOWORD(wParam) == IDOK) {
			int i;
			for (i = 0; i < STNINFO_LEN; ++ i) {
				HWND hWnd  = GetDlgItem(hwnd, ID_ENTRY + i);
				int  nLen  = GetWindowTextLength(hWnd);
				STNINFO_ARRAY[i] = (TCHAR*)realloc(
					STNINFO_ARRAY[i], (nLen + 1) * sizeof(TCHAR));
				GetWindowText(hWnd, STNINFO_ARRAY[i], nLen + 1);
			}
		}
        EndDialog(hwnd, LOWORD(wParam) == IDOK);
    }

    return FALSE;
}

BOOL stninfo_edit()
{
	DlgTemplate tmpl;
	int         i;

	dlggen_create(&tmpl, _T("Station Info"), DLGGEN_WINDOW_STYLE,
		CW_USEDEFAULT, CW_USEDEFAULT, 110, 90, _T("Tahoma"), 9);
	tmpl.nEntries	   = STNINFO_LEN;
	tmpl.nEntryFirstID = ID_ENTRY;

	for (i = 0; i < STNINFO_LEN; ++ i) {
		dlggen_add_static(&tmpl, g_aStnInfoLabels[i],
			WS_CHILD | WS_VISIBLE | SS_RIGHT, 0, 2, 2 + i * 12, 30, 10, ID_LABEL + i);
		dlggen_add_edit_box(&tmpl, STNINFO_ARRAY[i], DLGGEN_ENTRY_STYLE, DLGGEN_ENTRY_STYLE_EX,
			34, 2 + i * 12, 101, 10, ID_ENTRY + i);
	}

	dlggen_add_okcancel(&tmpl);
	return dlggen_dialog_box(&tmpl, g_hInst, s_hWndMain, stninfo_dlgproc) == IDOK;
}

void stninfo_load()
{
	HKEY  hKeyStnInfo = 0;
	DWORD dwType	  = REG_SZ;
	DWORD dwSize      = 0;
	int   i;

	memset(&g_StnInfo, 0, sizeof(g_StnInfo));

	if (RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\StnInfo"), 0, 
		KEY_ENUMERATE_SUB_KEYS | KEY_QUERY_VALUE | KEY_READ, &hKeyStnInfo) != ERROR_SUCCESS) {
		stninfo_load_defaults();
		return;
	}

	for (i = 0; i < STNINFO_LEN; ++ i) {
		if (RegQueryValueEx(hKeyStnInfo, g_aStnInfoLabels[i], 0, &dwType, 0, &dwSize) == ERROR_SUCCESS) {
			STNINFO_ARRAY[i] = (TCHAR*)malloc(dwSize);
			RegQueryValueEx(hKeyStnInfo, g_aStnInfoLabels[i], 0, &dwType, 
				(LPBYTE)STNINFO_ARRAY[i], &dwSize);
		} else
			STNINFO_ARRAY[i]  = _tcsdup(_T(""));
	}

	RegCloseKey(hKeyStnInfo);
}

void stninfo_load_defaults()
{
	stninfo_destroy();
	g_StnInfo.strCall  = _tcsdup(_T("NOCALL"));
	g_StnInfo.strName  = _tcsdup(_T(""));
	g_StnInfo.strQth   = _tcsdup(_T(""));
	g_StnInfo.strLoc   = _tcsdup(_T(""));
	g_StnInfo.strEmail = _tcsdup(_T(""));
}

void stninfo_store()
{
	HKEY  hKeyStnInfo   = 0;
	DWORD dwDisposition = 0;
	DWORD dwType	    = REG_SZ;
	DWORD dwSize        = 0;
	int   i;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, _T("Software\\OK1IAK\\PocketDigi\\StnInfo"), 0, 0,
		REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &hKeyStnInfo, &dwDisposition) != ERROR_SUCCESS)
		return;

	for (i = 0; i < STNINFO_LEN; ++ i)
		RegSetValueEx(hKeyStnInfo, g_aStnInfoLabels[i], 0, REG_SZ,
			(LPBYTE)(STNINFO_ARRAY[i]), (_tcslen(STNINFO_ARRAY[i]) + 1) * sizeof(TCHAR));

	RegCloseKey(hKeyStnInfo);
}

void stninfo_destroy()
{
	int i;
	for (i = 0; i < STNINFO_LEN; ++ i)
		free(STNINFO_ARRAY[i]);
	memset(&g_StnInfo, 0, sizeof(g_StnInfo));
}
